/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.ChapterAutoNumber;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Header;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.LargeElement;
import com.lowagie.text.Meta;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class Document
implements DocListener,
AutoCloseable {
    private static final String a = Document.a();
    private static final String b = "OpenPDF " + a;
    public static boolean compress = true;
    public static boolean plainRandomAccess = false;
    public static float wmfFontCorrection = 0.86f;
    private List<DocListener> c = new ArrayList<DocListener>();
    protected boolean open;
    protected boolean close;
    protected Rectangle pageSize;
    protected float marginLeft = 0.0f;
    protected float marginRight = 0.0f;
    protected float marginTop = 0.0f;
    protected float marginBottom = 0.0f;
    protected boolean marginMirroring = false;
    protected boolean marginMirroringTopBottom = false;
    protected String javaScript_onLoad = null;
    protected String javaScript_onUnLoad = null;
    protected String htmlStyleClass = null;
    protected int pageN = 0;
    protected HeaderFooter header = null;
    protected HeaderFooter footer = null;
    protected int chapternumber = 0;
    private String d = "dflt";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String a() {
        String string = "UNKNOWN";
        try {
            InputStream inputStream = Document.class.getClassLoader().getResourceAsStream("com/lowagie/text/version.properties");
            Throwable throwable = null;
            try {
                if (inputStream != null) {
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    string = properties.getProperty("bundleVersion", string);
                }
                if (inputStream == null) return string;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (inputStream == null) throw throwable4;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable4;
                    } else {
                        inputStream.close();
                    }
                    throw throwable4;
                }
            }
            inputStream.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    public Document() {
        this(PageSize.A4);
    }

    public Document(Rectangle rectangle) {
        this(rectangle, 36.0f, 36.0f, 36.0f, 36.0f);
    }

    public Document(Rectangle rectangle, float f2, float f3, float f4, float f5) {
        this.pageSize = rectangle;
        this.marginLeft = f2;
        this.marginRight = f3;
        this.marginTop = f4;
        this.marginBottom = f5;
    }

    public void addDocListener(DocListener docListener) {
        this.c.add(docListener);
    }

    public void removeDocListener(DocListener docListener) {
        this.c.remove(docListener);
    }

    @Override
    public boolean add(Element element) {
        if (this.close) {
            throw new DocumentException(MessageLocalization.getComposedMessage("the.document.has.been.closed.you.can.t.add.any.elements"));
        }
        if (!this.open && element.isContent()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("the.document.is.not.open.yet.you.can.only.add.meta.information"));
        }
        boolean bl2 = false;
        if (element instanceof ChapterAutoNumber) {
            this.chapternumber = ((ChapterAutoNumber)element).setAutomaticNumber(this.chapternumber);
        }
        Object object = this.c.iterator();
        while (object.hasNext()) {
            DocListener docListener = object.next();
            bl2 |= docListener.add(element);
        }
        if (element instanceof LargeElement && !(object = (LargeElement)element).isComplete()) {
            object.flushContent();
        }
        return bl2;
    }

    @Override
    public void open() {
        if (!this.close) {
            this.open = true;
        }
        for (DocListener docListener : this.c) {
            docListener.setPageSize(this.pageSize);
            docListener.setMargins(this.marginLeft, this.marginRight, this.marginTop, this.marginBottom);
            docListener.open();
        }
    }

    @Override
    public boolean setPageSize(Rectangle rectangle) {
        this.pageSize = rectangle;
        for (DocListener docListener : this.c) {
            docListener.setPageSize(rectangle);
        }
        return true;
    }

    @Override
    public boolean setMargins(float f2, float f3, float f4, float f5) {
        this.marginLeft = f2;
        this.marginRight = f3;
        this.marginTop = f4;
        this.marginBottom = f5;
        for (DocListener docListener : this.c) {
            docListener.setMargins(f2, f3, f4, f5);
        }
        return true;
    }

    @Override
    public boolean newPage() {
        if (!this.open || this.close) {
            return false;
        }
        for (DocListener docListener : this.c) {
            docListener.newPage();
        }
        return true;
    }

    @Override
    public void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter;
        for (DocListener docListener : this.c) {
            docListener.setHeader(headerFooter);
        }
    }

    @Override
    public void resetHeader() {
        this.header = null;
        for (DocListener docListener : this.c) {
            docListener.resetHeader();
        }
    }

    @Override
    public void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter;
        for (DocListener docListener : this.c) {
            docListener.setFooter(headerFooter);
        }
    }

    @Override
    public void resetFooter() {
        this.footer = null;
        for (DocListener docListener : this.c) {
            docListener.resetFooter();
        }
    }

    @Override
    public void resetPageCount() {
        this.pageN = 0;
        for (DocListener docListener : this.c) {
            docListener.resetPageCount();
        }
    }

    @Override
    public void setPageCount(int n2) {
        this.pageN = n2;
        for (DocListener docListener : this.c) {
            docListener.setPageCount(n2);
        }
    }

    public int getPageNumber() {
        return this.pageN;
    }

    @Override
    public void close() {
        if (!this.close) {
            this.open = false;
            this.close = true;
        }
        for (DocListener docListener : this.c) {
            docListener.close();
        }
    }

    public boolean addHeader(String string, String string2) {
        try {
            return this.add(new Header(string, string2));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addTitle(String string) {
        try {
            return this.add(new Meta(1, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addSubject(String string) {
        try {
            return this.add(new Meta(2, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addKeywords(String string) {
        try {
            return this.add(new Meta(3, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addAuthor(String string) {
        try {
            return this.add(new Meta(4, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addCreator(String string) {
        try {
            return this.add(new Meta(7, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addProducer() {
        return this.addProducer(Document.getVersion());
    }

    public boolean addProducer(String string) {
        return this.add(new Meta(5, string));
    }

    public boolean addCreationDate() {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            return this.add(new Meta(6, simpleDateFormat.format(new Date())));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public float leftMargin() {
        return this.marginLeft;
    }

    public float rightMargin() {
        return this.marginRight;
    }

    public float topMargin() {
        return this.marginTop;
    }

    public float bottomMargin() {
        return this.marginBottom;
    }

    public float left() {
        return this.pageSize.getLeft(this.marginLeft);
    }

    public float right() {
        return this.pageSize.getRight(this.marginRight);
    }

    public float top() {
        return this.pageSize.getTop(this.marginTop);
    }

    public float bottom() {
        return this.pageSize.getBottom(this.marginBottom);
    }

    public float left(float f2) {
        return this.pageSize.getLeft(this.marginLeft + f2);
    }

    public float right(float f2) {
        return this.pageSize.getRight(this.marginRight + f2);
    }

    public float top(float f2) {
        return this.pageSize.getTop(this.marginTop + f2);
    }

    public float bottom(float f2) {
        return this.pageSize.getBottom(this.marginBottom + f2);
    }

    public Rectangle getPageSize() {
        return this.pageSize;
    }

    public boolean isOpen() {
        return this.open;
    }

    public static String getProduct() {
        return "OpenPDF";
    }

    public static String getRelease() {
        return a;
    }

    public static String getVersion() {
        return b;
    }

    public void setJavaScript_onLoad(String string) {
        this.javaScript_onLoad = string;
    }

    public String getJavaScript_onLoad() {
        return this.javaScript_onLoad;
    }

    public void setJavaScript_onUnLoad(String string) {
        this.javaScript_onUnLoad = string;
    }

    public String getJavaScript_onUnLoad() {
        return this.javaScript_onUnLoad;
    }

    public void setHtmlStyleClass(String string) {
        this.htmlStyleClass = string;
    }

    public String getHtmlStyleClass() {
        return this.htmlStyleClass;
    }

    @Override
    public boolean setMarginMirroring(boolean bl2) {
        this.marginMirroring = bl2;
        for (DocListener docListener : this.c) {
            docListener.setMarginMirroring(bl2);
        }
        return true;
    }

    @Override
    public boolean setMarginMirroringTopBottom(boolean bl2) {
        this.marginMirroringTopBottom = bl2;
        for (DocListener docListener : this.c) {
            docListener.setMarginMirroringTopBottom(bl2);
        }
        return true;
    }

    public boolean isMarginMirroring() {
        return this.marginMirroring;
    }

    public void setDocumentLanguage(String string) {
        this.d = string;
    }

    public String getDocumentLanguage() {
        return this.d;
    }
}

