/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.Locale;

public class Font
implements Comparable {
    public static final int COURIER = 0;
    public static final int HELVETICA = 1;
    public static final int TIMES_ROMAN = 2;
    public static final int SYMBOL = 3;
    public static final int ZAPFDINGBATS = 4;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int STRIKETHRU = 8;
    public static final int BOLDITALIC = 3;
    public static final int UNDEFINED = -1;
    public static final int DEFAULTSIZE = 12;
    private int a = -1;
    private float b = -1.0f;
    private int c = -1;
    private Color d = null;
    private BaseFont e = null;

    public Font(Font font) {
        this.a = font.a;
        this.b = font.b;
        this.c = font.c;
        this.d = font.d;
        this.e = font.e;
    }

    public Font(int n2, float f2, int n3, Color color) {
        this.a = n2;
        this.b = f2;
        this.c = n3;
        this.d = color;
    }

    public Font(BaseFont baseFont, float f2, int n2, Color color) {
        this.e = baseFont;
        this.b = f2;
        this.c = n2;
        this.d = color;
    }

    public Font(BaseFont baseFont, float f2, int n2) {
        this(baseFont, f2, n2, null);
    }

    public Font(BaseFont baseFont, float f2) {
        this(baseFont, f2, -1, null);
    }

    public Font(BaseFont baseFont) {
        this(baseFont, -1.0f, -1, null);
    }

    public Font(int n2, float f2, int n3) {
        this(n2, f2, n3, null);
    }

    public Font(int n2, float f2) {
        this(n2, f2, -1, null);
    }

    public Font(int n2) {
        this(n2, -1.0f, -1, null);
    }

    public Font() {
        this(-1, -1.0f, -1, null);
    }

    public int compareTo(Object object) {
        block11: {
            if (object == null) {
                return -1;
            }
            try {
                object = (Font)object;
                if (this.e != null && !this.e.equals(((Font)object).getBaseFont())) {
                    return -2;
                }
                if (this.a != ((Font)object).getFamily()) {
                    return 1;
                }
                if (this.b != ((Font)object).getSize()) {
                    return 2;
                }
                if (this.c != ((Font)object).getStyle()) {
                    return 3;
                }
                if (this.d != null) break block11;
                if (((Font)object).d == null) {
                    return 0;
                }
                return 4;
            }
            catch (ClassCastException classCastException) {
                return -3;
            }
        }
        if (((Font)object).d == null) {
            return 4;
        }
        if (this.d.equals(((Font)object).getColor())) {
            return 0;
        }
        return 4;
    }

    public int getFamily() {
        return this.a;
    }

    public String getFamilyname() {
        String string = "unknown";
        switch (this.getFamily()) {
            case 0: {
                return "Courier";
            }
            case 1: {
                return "Helvetica";
            }
            case 2: {
                return "Times-Roman";
            }
            case 3: {
                return "Symbol";
            }
            case 4: {
                return "ZapfDingbats";
            }
        }
        if (this.e != null) {
            String[][] stringArray = this.e.getFamilyFontName();
            String[][] stringArray2 = stringArray;
            stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String[] stringArray3 = stringArray2[i2];
                if ("0".equals(stringArray3[2])) {
                    return stringArray3[3];
                }
                if ("1033".equals(stringArray3[2])) {
                    string = stringArray3[3];
                }
                if (!"".equals(stringArray3[2])) continue;
                string = stringArray3[3];
            }
        }
        return string;
    }

    public void setFamily(String string) {
        this.a = Font.getFamilyIndex(string);
    }

    public static int getFamilyIndex(String string) {
        if (string.equalsIgnoreCase("Courier")) {
            return 0;
        }
        if (string.equalsIgnoreCase("Helvetica")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Times-Roman")) {
            return 2;
        }
        if (string.equalsIgnoreCase("Symbol")) {
            return 3;
        }
        if (string.equalsIgnoreCase("ZapfDingbats")) {
            return 4;
        }
        return -1;
    }

    public float getSize() {
        return this.b;
    }

    public float getCalculatedSize() {
        float f2 = this.b;
        if (f2 == -1.0f) {
            f2 = 12.0f;
        }
        return f2;
    }

    public float getCalculatedLeading(float f2) {
        return f2 * this.getCalculatedSize();
    }

    public void setSize(float f2) {
        this.b = f2;
    }

    public int getStyle() {
        return this.c;
    }

    public int getCalculatedStyle() {
        int n2 = this.c;
        if (n2 == -1) {
            n2 = 0;
        }
        if (this.e != null) {
            return n2;
        }
        if (this.a == 3 || this.a == 4) {
            return n2;
        }
        return n2 & 0xFFFFFFFC;
    }

    public int getCombinedStyle() {
        return this.getBaseFontStyle() | this.getCalculatedStyle();
    }

    public int getBaseFontStyle() {
        int n2 = 0;
        if (this.e != null) {
            String string = this.e.getPostscriptFontName();
            n2 = Font.getFontStyleFromName(string);
        }
        return n2;
    }

    public static int getFontStyleFromName(String string) {
        string = string.toLowerCase(Locale.ROOT);
        int n2 = 0;
        if (string.contains("bold")) {
            n2 = 1;
        }
        if (string.contains("italic") || string.contains("oblique")) {
            n2 |= 2;
        }
        return n2;
    }

    public boolean isBold() {
        if (this.c == -1) {
            return false;
        }
        return (this.c & 1) == 1;
    }

    public boolean isItalic() {
        if (this.c == -1) {
            return false;
        }
        return (this.c & 2) == 2;
    }

    public boolean isUnderlined() {
        if (this.c == -1) {
            return false;
        }
        return (this.c & 4) == 4;
    }

    public boolean isStrikethru() {
        if (this.c == -1) {
            return false;
        }
        return (this.c & 8) == 8;
    }

    public void setStyle(int n2) {
        this.c = n2;
    }

    public void setStyle(String string) {
        if (this.c == -1) {
            this.c = 0;
        }
        this.c |= Font.getStyleValue(string);
    }

    public static int getStyleValue(String string) {
        int n2 = 0;
        if (string.contains("normal")) {
            n2 = 0;
        }
        if (string.contains("bold")) {
            n2 = 1;
        }
        if (string.contains("italic")) {
            n2 |= 2;
        }
        if (string.contains("oblique")) {
            n2 |= 2;
        }
        if (string.contains("underline")) {
            n2 |= 4;
        }
        if (string.contains("line-through")) {
            n2 |= 8;
        }
        return n2;
    }

    public Color getColor() {
        return this.d;
    }

    public void setColor(Color color) {
        this.d = color;
    }

    public void setColor(int n2, int n3, int n4) {
        this.d = new Color(n2, n3, n4);
    }

    public BaseFont getBaseFont() {
        return this.e;
    }

    public BaseFont getCalculatedBaseFont(boolean bl2) {
        BaseFont baseFont;
        String string;
        if (this.e != null) {
            return this.e;
        }
        int n2 = this.c;
        if (n2 == -1) {
            n2 = 0;
        }
        String string2 = "Cp1252";
        block1 : switch (this.a) {
            case 0: {
                switch (n2 & 3) {
                    case 1: {
                        string = "Courier-Bold";
                        break block1;
                    }
                    case 2: {
                        string = "Courier-Oblique";
                        break block1;
                    }
                    case 3: {
                        string = "Courier-BoldOblique";
                        break block1;
                    }
                }
                string = "Courier";
                break;
            }
            case 2: {
                switch (n2 & 3) {
                    case 1: {
                        string = "Times-Bold";
                        break block1;
                    }
                    case 2: {
                        string = "Times-Italic";
                        break block1;
                    }
                    case 3: {
                        string = "Times-BoldItalic";
                        break block1;
                    }
                }
                string = "Times-Roman";
                break;
            }
            case 3: {
                string = "Symbol";
                if (!bl2) break;
                string2 = "Symbol";
                break;
            }
            case 4: {
                string = "ZapfDingbats";
                if (!bl2) break;
                string2 = "ZapfDingbats";
                break;
            }
            default: {
                switch (n2 & 3) {
                    case 1: {
                        string = "Helvetica-Bold";
                        break block1;
                    }
                    case 2: {
                        string = "Helvetica-Oblique";
                        break block1;
                    }
                    case 3: {
                        string = "Helvetica-BoldOblique";
                        break block1;
                    }
                }
                string = "Helvetica";
            }
        }
        try {
            baseFont = BaseFont.createFont(string, string2, false);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return baseFont;
    }

    public boolean isStandardFont() {
        return this.a == -1 && this.b == -1.0f && this.c == -1 && this.d == null && this.e == null;
    }

    public Font difference(Font font) {
        Color color;
        if (font == null) {
            return this;
        }
        float f2 = font.b;
        if (f2 == -1.0f) {
            f2 = this.b;
        }
        int n2 = -1;
        int n3 = this.c;
        int n4 = font.getStyle();
        if (n3 != -1 || n4 != -1) {
            if (n3 == -1) {
                n3 = 0;
            }
            if (n4 == -1) {
                n4 = 0;
            }
            n2 = n3 | n4;
        }
        if ((color = font.d) == null) {
            color = this.d;
        }
        if (font.e != null) {
            return new Font(font.e, f2, n2, color);
        }
        if (font.getFamily() != -1) {
            return new Font(font.a, f2, n2, color);
        }
        if (this.e != null) {
            if (n2 == n3) {
                return new Font(this.e, f2, n2, color);
            }
            return FontFactory.getFont(this.getFamilyname(), f2, n2, color);
        }
        return new Font(this.a, f2, n2, color);
    }
}

