/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.FontProvider;
import com.lowagie.text.Utilities;
import com.lowagie.text.html.Markup;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FontFactoryImp
implements FontProvider {
    private final Map<String, String> a = new HashMap<String, String>();
    private static final String[] b = new String[]{"3", "1", "1033", "3", "0", "1033", "1", "0", "0", "0", "3", "0"};
    private final Map<String, List<String>> c = new HashMap<String, List<String>>();
    private final ReadWriteLock d = new ReentrantReadWriteLock();
    public String defaultEncoding = "Cp1252";
    public boolean defaultEmbedding = false;

    public FontFactoryImp() {
        this.a.put("Courier".toLowerCase(Locale.ROOT), "Courier");
        this.a.put("Courier-Bold".toLowerCase(Locale.ROOT), "Courier-Bold");
        this.a.put("Courier-Oblique".toLowerCase(Locale.ROOT), "Courier-Oblique");
        this.a.put("Courier-BoldOblique".toLowerCase(Locale.ROOT), "Courier-BoldOblique");
        this.a.put("Helvetica".toLowerCase(Locale.ROOT), "Helvetica");
        this.a.put("Helvetica-Bold".toLowerCase(Locale.ROOT), "Helvetica-Bold");
        this.a.put("Helvetica-Oblique".toLowerCase(Locale.ROOT), "Helvetica-Oblique");
        this.a.put("Helvetica-BoldOblique".toLowerCase(Locale.ROOT), "Helvetica-BoldOblique");
        this.a.put("Symbol".toLowerCase(Locale.ROOT), "Symbol");
        this.a.put("Times-Roman".toLowerCase(Locale.ROOT), "Times-Roman");
        this.a.put("Times-Bold".toLowerCase(Locale.ROOT), "Times-Bold");
        this.a.put("Times-Italic".toLowerCase(Locale.ROOT), "Times-Italic");
        this.a.put("Times-BoldItalic".toLowerCase(Locale.ROOT), "Times-BoldItalic");
        this.a.put("ZapfDingbats".toLowerCase(Locale.ROOT), "ZapfDingbats");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Courier");
        arrayList.add("Courier-Bold");
        arrayList.add("Courier-Oblique");
        arrayList.add("Courier-BoldOblique");
        this.c.put("Courier".toLowerCase(Locale.ROOT), arrayList);
        arrayList = new ArrayList<String>();
        arrayList.add("Helvetica");
        arrayList.add("Helvetica-Bold");
        arrayList.add("Helvetica-Oblique");
        arrayList.add("Helvetica-BoldOblique");
        this.c.put("Helvetica".toLowerCase(Locale.ROOT), arrayList);
        arrayList = new ArrayList<String>();
        arrayList.add("Symbol");
        this.c.put("Symbol".toLowerCase(Locale.ROOT), arrayList);
        arrayList = new ArrayList<String>();
        arrayList.add("Times-Roman");
        arrayList.add("Times-Bold");
        arrayList.add("Times-Italic");
        arrayList.add("Times-BoldItalic");
        this.c.put("Times".toLowerCase(Locale.ROOT), arrayList);
        this.c.put("Times-Roman".toLowerCase(Locale.ROOT), arrayList);
        arrayList = new ArrayList<String>();
        arrayList.add("ZapfDingbats");
        this.c.put("ZapfDingbats".toLowerCase(Locale.ROOT), arrayList);
    }

    @Override
    public Font getFont(String string, String string2, boolean bl2, float f2, int n2, Color color) {
        return this.getFont(string, string2, bl2, f2, n2, color, true);
    }

    public Font getFont(String string, String string2, boolean bl2, float f2, int n2, Color color, boolean bl3) {
        Object object;
        String string3;
        block12: {
            if (string == null) {
                return new Font(-1, f2, n2, color);
            }
            string3 = string.toLowerCase(Locale.ROOT);
            this.d.readLock().lock();
            try {
                object = this.c.get(string3);
                if (object == null) break block12;
                int n3 = n2 == -1 ? 0 : n2;
                object = object.iterator();
                while (object.hasNext()) {
                    String string4 = (String)object.next();
                    int n4 = Font.getFontStyleFromName(string4);
                    if ((n3 & 3) != n4) continue;
                    string = string4;
                    string3 = string.toLowerCase(Locale.ROOT);
                    n2 = n3 ^ n4;
                    break;
                }
            }
            finally {
                this.d.readLock().unlock();
            }
        }
        object = null;
        try {
            try {
                object = BaseFont.createFont(string, string2, bl2, bl3, null, null, true);
            }
            catch (DocumentException documentException) {}
            if (object == null) {
                string = this.a.get(string3);
                if (string == null) {
                    return new Font(-1, f2, n2, color);
                }
                object = BaseFont.createFont(string, string2, bl2, bl3, null, null);
            }
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
        catch (IOException | NullPointerException exception) {
            return new Font(-1, f2, n2, color);
        }
        return new Font((BaseFont)object, f2, n2, color);
    }

    public Font getFont(Properties properties) {
        String string;
        Object object;
        String string2 = null;
        String string3 = this.defaultEncoding;
        boolean bl2 = this.defaultEmbedding;
        float f2 = -1.0f;
        int n2 = 0;
        Color color = null;
        Object object2 = properties.getProperty("style");
        if (object2 != null && ((String)object2).length() > 0) {
            object = Markup.parseAttributes((String)object2);
            if (((Properties)object).isEmpty()) {
                properties.put("style", object2);
            } else {
                string2 = ((Properties)object).getProperty("font-family");
                if (string2 != null) {
                    while (string2.indexOf(44) != -1) {
                        object2 = string2.substring(0, string2.indexOf(44));
                        if (this.isRegistered((String)object2)) {
                            string2 = object2;
                            continue;
                        }
                        String string4 = string2;
                        string2 = string4.substring(string4.indexOf(44) + 1);
                    }
                }
                if ((object2 = ((Properties)object).getProperty("font-size")) != null) {
                    f2 = Markup.parseLength((String)object2);
                }
                if ((object2 = ((Properties)object).getProperty("font-weight")) != null) {
                    n2 = 0 | Font.getStyleValue((String)object2);
                }
                if ((object2 = ((Properties)object).getProperty("font-style")) != null) {
                    n2 |= Font.getStyleValue((String)object2);
                }
                if ((object2 = ((Properties)object).getProperty("color")) != null) {
                    color = Markup.decodeColor((String)object2);
                }
                properties.putAll((Map<?, ?>)object);
                object2 = ((Properties)object).keys();
                while (object2.hasMoreElements()) {
                    string = object2.nextElement();
                    properties.put(string, ((Properties)object).get(string));
                }
            }
        }
        if ((object2 = properties.getProperty("encoding")) != null) {
            string3 = object2;
        }
        if ("true".equals(properties.getProperty("embedded"))) {
            bl2 = true;
        }
        if ((object2 = properties.getProperty("font")) != null) {
            string2 = object2;
        }
        if ((object2 = properties.getProperty("size")) != null) {
            f2 = Markup.parseLength((String)object2);
        }
        if ((object2 = properties.getProperty("style")) != null) {
            n2 |= Font.getStyleValue((String)object2);
        }
        if ((object2 = properties.getProperty("fontstyle")) != null) {
            n2 |= Font.getStyleValue((String)object2);
        }
        object = properties.getProperty("red");
        object2 = properties.getProperty("green");
        string = properties.getProperty("blue");
        if (object != null || object2 != null || string != null) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (object != null) {
                n3 = Integer.parseInt((String)object);
            }
            if (object2 != null) {
                n4 = Integer.parseInt((String)object2);
            }
            if (string != null) {
                n5 = Integer.parseInt(string);
            }
            color = new Color(n3, n4, n5);
        } else {
            object2 = properties.getProperty("color");
            if (object2 != null) {
                color = Markup.decodeColor((String)object2);
            }
        }
        if (string2 == null) {
            return this.getFont(null, string3, bl2, f2, n2, color);
        }
        return this.getFont(string2, string3, bl2, f2, n2, color);
    }

    public Font getFont(String string, String string2, boolean bl2, float f2, int n2) {
        return this.getFont(string, string2, bl2, f2, n2, null);
    }

    public Font getFont(String string, String string2, boolean bl2, float f2) {
        return this.getFont(string, string2, bl2, f2, -1, null);
    }

    public Font getFont(String string, String string2, boolean bl2) {
        return this.getFont(string, string2, bl2, -1.0f, -1, null);
    }

    public Font getFont(String string, String string2, float f2, int n2, Color color) {
        return this.getFont(string, string2, this.defaultEmbedding, f2, n2, color);
    }

    public Font getFont(String string, String string2, float f2, int n2) {
        return this.getFont(string, string2, this.defaultEmbedding, f2, n2, null);
    }

    public Font getFont(String string, String string2, float f2) {
        return this.getFont(string, string2, this.defaultEmbedding, f2, -1, null);
    }

    public Font getFont(String string, float f2, Color color) {
        return this.getFont(string, this.defaultEncoding, this.defaultEmbedding, f2, -1, color);
    }

    public Font getFont(String string, String string2) {
        return this.getFont(string, string2, this.defaultEmbedding, -1.0f, -1, null);
    }

    public Font getFont(String string, float f2, int n2, Color color) {
        return this.getFont(string, this.defaultEncoding, this.defaultEmbedding, f2, n2, color);
    }

    public Font getFont(String string, float f2, int n2) {
        return this.getFont(string, this.defaultEncoding, this.defaultEmbedding, f2, n2, null);
    }

    public Font getFont(String string, float f2) {
        return this.getFont(string, this.defaultEncoding, this.defaultEmbedding, f2, -1, null);
    }

    public Font getFont(String string) {
        return this.getFont(string, this.defaultEncoding, this.defaultEmbedding, -1.0f, -1, null);
    }

    public void registerFamily(String string, String string2, String arrayList) {
        if (arrayList != null) {
            this.a.put(string2, (String)((Object)arrayList));
        }
        this.d.writeLock().lock();
        try {
            arrayList = this.c.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                arrayList.add(string2);
                this.c.put(string, arrayList);
            } else {
                int n2 = string2.length();
                boolean bl2 = false;
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    if (((String)arrayList.get(i2)).length() < n2) continue;
                    arrayList.add(i2, string2);
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    arrayList.add(string2);
                }
            }
            return;
        }
        finally {
            this.d.writeLock().unlock();
        }
    }

    public void register(String string) {
        this.register(string, null);
    }

    public void register(String string, String object) {
        block14: {
            try {
                if (string.toLowerCase().endsWith(".ttf") || string.toLowerCase().endsWith(".otf") || string.toLowerCase().indexOf(".ttc,") > 0) {
                    String[] stringArray;
                    int n2;
                    Object object2 = BaseFont.getAllFontNames(string, "Cp1252", null);
                    this.a.put(((String)object2[0]).toLowerCase(), string);
                    if (object != null) {
                        this.a.put(object.toLowerCase(), string);
                    }
                    Object object3 = object = (String[][])object2[2];
                    int n3 = ((String[][])object).length;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        String[] stringArray2 = object3[i2];
                        this.a.put(stringArray2[3].toLowerCase(), string);
                    }
                    object3 = null;
                    object = (String[][])object2[1];
                    block3: for (n3 = 0; n3 < b.length; n3 += 3) {
                        Object object4 = object;
                        int n4 = ((String[][])object).length;
                        for (n2 = 0; n2 < n4; ++n2) {
                            stringArray = object4[n2];
                            if (stringArray.length != 4 || b.length <= n3 + 2 || !b[n3].equals(stringArray[0]) || !b[n3 + 1].equals(stringArray[1]) || !b[n3 + 2].equals(stringArray[2])) continue;
                            object3 = stringArray[3].toLowerCase();
                            n3 = b.length;
                            continue block3;
                        }
                    }
                    if (object3 != null) {
                        Object object5 = "";
                        String[][] stringArray3 = object = (String[][])object2[2];
                        int n5 = ((String[][])object).length;
                        block5: for (n2 = 0; n2 < n5; ++n2) {
                            stringArray = stringArray3[n2];
                            for (int i3 = 0; i3 < b.length; i3 += 3) {
                                if (stringArray.length != 4 || b.length <= i3 + 2 || !b[i3].equals(stringArray[0]) || !b[i3 + 1].equals(stringArray[1]) || !b[i3 + 2].equals(stringArray[2]) || (object2 = stringArray[3]).equals(object5)) continue;
                                object5 = object2;
                                this.registerFamily((String)object3, (String)object2, string);
                                continue block5;
                            }
                        }
                    }
                    break block14;
                }
                if (string.toLowerCase().endsWith(".ttc")) {
                    if (object != null) {
                        System.err.println("class FontFactory: You can't define an alias for a true type collection.");
                    }
                    String[] stringArray = BaseFont.enumerateTTCNames(string);
                    for (int i4 = 0; i4 < stringArray.length; ++i4) {
                        this.register(string + "," + i4);
                    }
                    break block14;
                }
                if (string.toLowerCase().endsWith(".afm") || string.toLowerCase().endsWith(".pfm")) {
                    BaseFont baseFont = BaseFont.createFont(string, "Cp1252", false);
                    object = baseFont.getFullFontName()[0][3].toLowerCase();
                    String string2 = baseFont.getFamilyFontName()[0][3].toLowerCase();
                    String string3 = baseFont.getPostscriptFontName().toLowerCase();
                    this.registerFamily(string2, (String)object, null);
                    this.a.put(string3, string);
                    this.a.put((String)object, string);
                }
                return;
            }
            catch (DocumentException | IOException exception) {
                throw new ExceptionConverter(exception);
            }
        }
    }

    public int registerDirectory(String string) {
        return this.registerDirectory(string, false);
    }

    public int registerDirectory(String string, boolean bl2) {
        int n2 = 0;
        try {
            Object object = new File(string);
            if (!((File)object).exists() || !((File)object).isDirectory()) {
                return 0;
            }
            if ((object = ((File)object).list()) == null) {
                return 0;
            }
            String[] stringArray = object;
            int n3 = ((String[])object).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object2 = stringArray[i2];
                try {
                    String string2;
                    String string3;
                    object = new File(string, (String)object2);
                    if (((File)object).isDirectory()) {
                        if (!bl2) continue;
                        n2 += this.registerDirectory(((File)object).getAbsolutePath(), true);
                        continue;
                    }
                    if (((String)(object = ((File)object).getPath())).length() < 4) {
                        string3 = null;
                    } else {
                        Object object3 = object;
                        string3 = string2 = ((String)object3).substring(((String)object3).length() - 4).toLowerCase();
                    }
                    if (".afm".equals(string2) || ".pfm".equals(string2)) {
                        object2 = new File(((String)object).substring(0, ((String)object).length() - 4) + ".pfb");
                        if (!((File)object2).exists()) continue;
                        this.register((String)object, null);
                        ++n2;
                        continue;
                    }
                    if (".ttf".equals(string2) || ".otf".equals(string2)) {
                        this.register((String)object, (String)object2);
                        ++n2;
                        continue;
                    }
                    if (!".ttc".equals(string2)) continue;
                    this.register((String)object, null);
                    ++n2;
                    continue;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        return n2;
    }

    public int registerDirectories() {
        int n2 = 0 + this.registerDirectory("c:/windows/fonts");
        n2 += this.registerDirectory("c:/winnt/fonts");
        n2 += this.registerDirectory("d:/windows/fonts");
        n2 += this.registerDirectory("d:/winnt/fonts");
        n2 += this.registerDirectory("/usr/share/X11/fonts", true);
        n2 += this.registerDirectory("/usr/X/lib/X11/fonts", true);
        n2 += this.registerDirectory("/usr/openwin/lib/X11/fonts", true);
        n2 += this.registerDirectory("/usr/share/fonts", true);
        n2 += this.registerDirectory("/usr/X11R6/lib/X11/fonts", true);
        n2 += this.registerDirectory("/Library/Fonts");
        return n2 += this.registerDirectory("/System/Library/Fonts");
    }

    public Set<String> getRegisteredFonts() {
        return Utilities.getKeySet(this.a);
    }

    public Set<String> getRegisteredFamilies() {
        return Utilities.getKeySet(this.c);
    }

    @Override
    public boolean isRegistered(String string) {
        return this.a.containsKey(string.toLowerCase());
    }

    public Object getFontPath(String string) {
        return this.a.get(string.toLowerCase());
    }
}

