/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.ImageLoader;
import com.lowagie.text.ImgCCITT;
import com.lowagie.text.ImgJBIG2;
import com.lowagie.text.ImgRaw;
import com.lowagie.text.ImgTemplate;
import com.lowagie.text.ImgWMF;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Utilities;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfOCG;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.codec.CCITTG4Encoder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.net.URL;

public abstract class Image
extends Rectangle {
    public static final int DEFAULT = 0;
    public static final int RIGHT = 2;
    public static final int LEFT = 0;
    public static final int MIDDLE = 1;
    public static final int TEXTWRAP = 4;
    public static final int UNDERLYING = 8;
    public static final int AX = 0;
    public static final int AY = 1;
    public static final int BX = 2;
    public static final int BY = 3;
    public static final int CX = 4;
    public static final int CY = 5;
    public static final int DX = 6;
    public static final int DY = 7;
    public static final int ORIGINAL_NONE = 0;
    public static final int ORIGINAL_JPEG = 1;
    public static final int ORIGINAL_PNG = 2;
    public static final int ORIGINAL_GIF = 3;
    public static final int ORIGINAL_BMP = 4;
    public static final int ORIGINAL_TIFF = 5;
    public static final int ORIGINAL_WMF = 6;
    public static final int ORIGINAL_PS = 7;
    public static final int ORIGINAL_JPEG2000 = 8;
    public static final int ORIGINAL_JBIG2 = 9;
    protected int type;
    protected URL url;
    protected byte[] rawData;
    protected int bpc = 1;
    protected PdfTemplate[] template = new PdfTemplate[1];
    protected int alignment;
    protected String alt;
    protected float absoluteX = Float.NaN;
    protected float absoluteY = Float.NaN;
    protected float plainWidth;
    protected float plainHeight;
    protected float scaledWidth;
    protected float scaledHeight;
    protected int compressionLevel = -1;
    protected Long mySerialId = Image.getSerialId();
    public static final int[] PNGID = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    private PdfIndirectReference a;
    private static long b = 0L;
    protected float rotationRadians;
    private float c;
    protected float indentationLeft = 0.0f;
    protected float indentationRight = 0.0f;
    protected float spacingBefore;
    protected float spacingAfter;
    private float d = 100.0f;
    protected Annotation annotation = null;
    protected PdfOCG layer;
    protected boolean interpolation;
    protected int originalType = 0;
    protected byte[] originalData;
    protected boolean deflated = false;
    protected int dpiX = 0;
    protected int dpiY = 0;
    private float e = 0.0f;
    protected int colorspace = -1;
    protected boolean invert = false;
    protected ICC_Profile profile = null;
    private PdfDictionary f = null;
    protected boolean mask = false;
    protected Image imageMask;
    private boolean g;
    protected int[] transparency;

    public Image(URL uRL) {
        super(0.0f, 0.0f);
        this.url = uRL;
        this.alignment = 0;
        this.rotationRadians = 0.0f;
    }

    public static Image getInstance(URL uRL) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        block27: {
            Image image;
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        InputStream inputStream = null;
                                        image = null;
                                        try {
                                            inputStream = uRL.openStream();
                                            n9 = inputStream.read();
                                            n8 = inputStream.read();
                                            n7 = inputStream.read();
                                            n6 = inputStream.read();
                                            n5 = inputStream.read();
                                            n4 = inputStream.read();
                                            n3 = inputStream.read();
                                            n2 = inputStream.read();
                                            inputStream.close();
                                            inputStream = null;
                                            if (n9 != 71 || n8 != 73 || n7 != 70) break block20;
                                            Image image2 = image = ImageLoader.getGifImage(uRL);
                                            if (image != null) {
                                                image.setUrl(uRL);
                                            }
                                            return image2;
                                        }
                                        catch (Throwable throwable) {
                                            if (inputStream != null) {
                                                inputStream.close();
                                            }
                                            if (image != null) {
                                                image.setUrl(uRL);
                                            }
                                            throw throwable;
                                        }
                                    }
                                    if (n9 != 255 || n8 != 216) break block21;
                                    Image image3 = image = ImageLoader.getJpegImage(uRL);
                                    if (image != null) {
                                        image.setUrl(uRL);
                                    }
                                    return image3;
                                }
                                if (n9 != 0 || n8 != 0 || n7 != 0 || n6 != 12) break block22;
                                Image image4 = image = ImageLoader.getJpeg2000Image(uRL);
                                if (image != null) {
                                    image.setUrl(uRL);
                                }
                                return image4;
                            }
                            if (n9 != 255 || n8 != 79 || n7 != 255 || n6 != 81) break block23;
                            Image image5 = image = ImageLoader.getJpeg2000Image(uRL);
                            if (image != null) {
                                image.setUrl(uRL);
                            }
                            return image5;
                        }
                        if (n9 != PNGID[0] || n8 != PNGID[1] || n7 != PNGID[2] || n6 != PNGID[3]) break block24;
                        Image image6 = image = ImageLoader.getPngImage(uRL);
                        if (image != null) {
                            image.setUrl(uRL);
                        }
                        return image6;
                    }
                    if (n9 != 215 || n8 != 205) break block25;
                    image = new ImgWMF(uRL);
                    ImgWMF imgWMF = image;
                    image.setUrl(uRL);
                    return imgWMF;
                }
                if (n9 != 66 || n8 != 77) break block26;
                Image image7 = image = ImageLoader.getBmpImage(uRL);
                if (image != null) {
                    image.setUrl(uRL);
                }
                return image7;
            }
            if ((n9 != 77 || n8 != 77 || n7 != 0 || n6 != 42) && (n9 != 73 || n8 != 73 || n7 != 42 || n6 != 0)) break block27;
            Image image8 = image = ImageLoader.getTiffImage(uRL);
            if (image != null) {
                image.setUrl(uRL);
            }
            return image8;
        }
        if (n9 == 151 && n8 == 74 && n7 == 66 && n6 == 50 && n5 == 13 && n4 == 10 && n3 == 26 && n2 == 10) {
            throw new IOException(uRL.toString() + " is not a recognized imageformat. JBIG2 support has been removed.");
        }
        throw new IOException(uRL.toString() + " is not a recognized imageformat.");
    }

    public static Image getInstance(String string) {
        return Image.getInstance(Utilities.toURL(string));
    }

    public static Image getInstance(byte[] object) {
        int n2;
        int n3;
        int n4;
        int n5;
        ByteArrayInputStream byteArrayInputStream;
        block20: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        byteArrayInputStream = null;
                                        try {
                                            byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                                            n5 = ((InputStream)byteArrayInputStream).read();
                                            n4 = ((InputStream)byteArrayInputStream).read();
                                            n3 = ((InputStream)byteArrayInputStream).read();
                                            n2 = ((InputStream)byteArrayInputStream).read();
                                            ((InputStream)byteArrayInputStream).close();
                                            byteArrayInputStream = null;
                                            if (n5 != 71 || n4 != 73 || n3 != 70) break block13;
                                            object = ImageLoader.getGifImage(object);
                                            return object;
                                        }
                                        catch (Throwable throwable) {
                                            if (byteArrayInputStream != null) {
                                                ((InputStream)byteArrayInputStream).close();
                                            }
                                            throw throwable;
                                        }
                                    }
                                    if (n5 != 255 || n4 != 216) break block14;
                                    object = ImageLoader.getJpegImage(object);
                                    return object;
                                }
                                if (n5 != 0 || n4 != 0 || n3 != 0 || n2 != 12) break block15;
                                object = ImageLoader.getJpeg2000Image(object);
                                return object;
                            }
                            if (n5 != 255 || n4 != 79 || n3 != 255 || n2 != 81) break block16;
                            object = ImageLoader.getJpeg2000Image(object);
                            return object;
                        }
                        if (n5 != PNGID[0] || n4 != PNGID[1] || n3 != PNGID[2] || n2 != PNGID[3]) break block17;
                        object = ImageLoader.getPngImage(object);
                        return object;
                    }
                    if (n5 != 215 || n4 != 205) break block18;
                    object = new ImgWMF((byte[])object);
                    return object;
                }
                if (n5 != 66 || n4 != 77) break block19;
                object = ImageLoader.getBmpImage(object);
                return object;
            }
            if ((n5 != 77 || n4 != 77 || n3 != 0 || n2 != 42) && (n5 != 73 || n4 != 73 || n3 != 42 || n2 != 0)) break block20;
            object = ImageLoader.getTiffImage(object);
            return object;
        }
        if (n5 == 151 && n4 == 74 && n3 == 66 && n2 == 50) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            ((InputStream)byteArrayInputStream).skip(4L);
            int n6 = ((InputStream)byteArrayInputStream).read();
            n5 = ((InputStream)byteArrayInputStream).read();
            n4 = ((InputStream)byteArrayInputStream).read();
            n3 = ((InputStream)byteArrayInputStream).read();
            if (n6 == 13 && n5 == 10 && n4 == 26 && n3 == 10) {
                throw new IOException(MessageLocalization.getComposedMessage("the.byte.array.is.not.a.recognized.imageformat"));
            }
        }
        throw new IOException(MessageLocalization.getComposedMessage("the.byte.array.is.not.a.recognized.imageformat"));
    }

    public static Image getInstance(int n2, int n3, int n4, int n5, byte[] byArray) {
        return Image.getInstance(n2, n3, n4, n5, byArray, null);
    }

    public static Image getInstance(int n2, int n3, byte[] byArray, byte[] byArray2) {
        ImgJBIG2 imgJBIG2 = new ImgJBIG2(n2, n3, byArray, byArray2);
        return imgJBIG2;
    }

    public static Image getInstance(int n2, int n3, boolean bl2, int n4, int n5, byte[] byArray) {
        return Image.getInstance(n2, n3, bl2, n4, n5, byArray, null);
    }

    public static Image getInstance(int n2, int n3, boolean bl2, int n4, int n5, byte[] byArray, int[] nArray) {
        if (nArray != null && nArray.length != 2) {
            throw new BadElementException(MessageLocalization.getComposedMessage("transparency.length.must.be.equal.to.2.with.ccitt.images"));
        }
        ImgCCITT imgCCITT = new ImgCCITT(n2, n3, bl2, n4, n5, byArray);
        new ImgCCITT(n2, n3, bl2, n4, n5, byArray).transparency = nArray;
        return imgCCITT;
    }

    public static Image getInstance(int n2, int n3, int n4, int n5, byte[] byArray, int[] nArray) {
        if (nArray != null && nArray.length != n4 << 1) {
            throw new BadElementException(MessageLocalization.getComposedMessage("transparency.length.must.be.equal.to.componentes.2"));
        }
        if (n4 == 1 && n5 == 1) {
            byte[] byArray2 = CCITTG4Encoder.compress(byArray, n2, n3);
            return Image.getInstance(n2, n3, false, 256, 1, byArray2, nArray);
        }
        ImgRaw imgRaw = new ImgRaw(n2, n3, n4, n5, byArray);
        new ImgRaw(n2, n3, n4, n5, byArray).transparency = nArray;
        return imgRaw;
    }

    public static Image getInstance(PdfTemplate pdfTemplate) {
        return new ImgTemplate(pdfTemplate);
    }

    /*
     * WARNING - void declaration
     */
    public static Image getInstance(java.awt.Image image, Color color, boolean bl2) {
        int[] nArray;
        byte[] byArray;
        byte[] byArray2;
        int n2;
        int n3;
        block39: {
            boolean bl3;
            int n4;
            int n5;
            int n6;
            int n7;
            Object object;
            block38: {
                boolean bl4;
                if (image instanceof BufferedImage && ((BufferedImage)(object = (BufferedImage)image)).getType() == 12 && ((BufferedImage)object).getColorModel().getNumColorComponents() <= 2) {
                    bl4 = true;
                }
                object = new PixelGrabber(image, 0, 0, -1, -1, true);
                try {
                    ((PixelGrabber)object).grabPixels();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(MessageLocalization.getComposedMessage("java.awt.image.interrupted.waiting.for.pixels"));
                }
                if ((((PixelGrabber)object).getStatus() & 0x80) != 0) {
                    throw new IOException(MessageLocalization.getComposedMessage("java.awt.image.fetch.aborted.or.errored"));
                }
                n3 = ((PixelGrabber)object).getWidth();
                n2 = ((PixelGrabber)object).getHeight();
                object = (int[])((PixelGrabber)object).getPixels();
                if (bl4) {
                    int n8 = n3 / 8 + ((n3 & 7) != 0 ? 1 : 0);
                    byte[] byArray3 = new byte[n8 * n2];
                    int n9 = 0;
                    int n10 = n2 * n3;
                    boolean bl5 = true;
                    if (color != null) {
                        bl5 = color.getRed() + color.getGreen() + color.getBlue() >= 384;
                    }
                    int[] nArray2 = null;
                    int n11 = 128;
                    int n12 = 0;
                    int n13 = 0;
                    if (color != null) {
                        void i3;
                        boolean i2 = false;
                        while (i3 < n10) {
                            reference var13_34 = object[i3] >>> 24;
                            if (var13_34 < 250) {
                                if (bl5) {
                                    n13 |= n11;
                                }
                            } else if ((object[i3] & 0x888) != 0) {
                                n13 |= n11;
                            }
                            if ((n11 >>= 1) == 0 || n12 + 1 >= n3) {
                                byArray3[n9++] = (byte)n13;
                                n11 = 128;
                                n13 = 0;
                            }
                            if (++n12 >= n3) {
                                n12 = 0;
                            }
                            ++i3;
                        }
                    } else {
                        void bl42;
                        boolean bl6 = false;
                        while (bl42 < n10) {
                            reference var13_35;
                            if (nArray2 == null && (var13_35 = object[bl42] >>> 24) == false) {
                                int[] nArray3 = new int[2];
                                nArray2 = nArray3;
                                nArray2[1] = (object[bl42] & 0x888) != 0 ? 255 : 0;
                                nArray3[0] = nArray2[1];
                            }
                            if ((object[bl42] & 0x888) != 0) {
                                n13 |= n11;
                            }
                            if ((n11 >>= 1) == 0 || n12 + 1 >= n3) {
                                byArray3[n9++] = (byte)n13;
                                n11 = 128;
                                n13 = 0;
                            }
                            if (++n12 >= n3) {
                                n12 = 0;
                            }
                            ++bl42;
                        }
                    }
                    return Image.getInstance(n3, n2, 1, 1, byArray3, nArray2);
                }
                byArray2 = new byte[n3 * n2 * 3];
                byArray = null;
                int n14 = 0;
                n7 = n2 * n3;
                n6 = 255;
                int n15 = 255;
                int n16 = 255;
                if (color != null) {
                    n6 = color.getRed();
                    n15 = color.getGreen();
                    n16 = color.getBlue();
                }
                nArray = null;
                if (color == null) break block38;
                for (n5 = 0; n5 < n7; ++n5) {
                    reference image3 = object[n5] >>> 24;
                    if (image3 < 250) {
                        byArray2[n14++] = (byte)n6;
                        byArray2[n14++] = (byte)n15;
                        byArray2[n14++] = (byte)n16;
                        continue;
                    }
                    byArray2[n14++] = (byte)(object[n5] >> 16);
                    byArray2[n14++] = (byte)(object[n5] >> 8);
                    byArray2[n14++] = (byte)object[n5];
                }
                break block39;
            }
            n5 = 0;
            byArray = new byte[n3 * n2];
            boolean bl7 = false;
            boolean bl8 = false;
            while (n4 < n7) {
                block37: {
                    block40: {
                        block41: {
                            byArray[n4] = (byte)(object[n4] >>> 24);
                            n6 = byArray[n4];
                            if (bl3) break block37;
                            if (n6 != 0 && n6 != -1) break block40;
                            if (nArray != null) break block41;
                            if (n6 == 0) {
                                n5 = object[n4] & 0xFFFFFF;
                                int[] nArray4 = new int[6];
                                nArray = nArray4;
                                nArray4[0] = nArray[1] = n5 >> 16 & 0xFF;
                                nArray[2] = nArray[3] = n5 >> 8 & 0xFF;
                                nArray[4] = nArray[5] = n5 & 0xFF;
                                for (n6 = 0; n6 < n4; ++n6) {
                                    if ((object[n6] & 0xFFFFFF) != n5) continue;
                                    bl3 = true;
                                    break block37;
                                }
                            }
                            break block37;
                        }
                        if (((object[n4] & 0xFFFFFF) == n5 || n6 != 0) && ((object[n4] & 0xFFFFFF) != n5 || n6 == 0)) break block37;
                    }
                    bl3 = true;
                }
                byArray2[n14++] = (byte)(object[n4] >> 16);
                byArray2[n14++] = (byte)(object[n4] >> 8);
                byArray2[n14++] = (byte)object[n4];
                ++n4;
            }
            if (bl3) {
                nArray = null;
            } else {
                byArray = null;
            }
        }
        Image image2 = Image.getInstance(n3, n2, 3, 8, byArray2, nArray);
        if (byArray != null) {
            Image image3 = Image.getInstance(n3, n2, 1, 8, byArray);
            try {
                image3.makeMask();
                image2.setImageMask(image3);
            }
            catch (DocumentException documentException) {
                throw new ExceptionConverter(documentException);
            }
        }
        return image2;
    }

    public static Image getInstance(java.awt.Image image, Color color) {
        return Image.getInstance(image, color, false);
    }

    public static Image getInstance(PdfWriter pdfWriter, java.awt.Image image, float f2) {
        return Image.getInstance(new PdfContentByte(pdfWriter), image, f2);
    }

    public static Image getInstance(PdfContentByte pdfContentByte, java.awt.Image image, float f2) {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(MessageLocalization.getComposedMessage("java.awt.image.interrupted.waiting.for.pixels"));
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new IOException(MessageLocalization.getComposedMessage("java.awt.image.fetch.aborted.or.errored"));
        }
        int n2 = pixelGrabber.getWidth();
        int n3 = pixelGrabber.getHeight();
        pdfContentByte = pdfContentByte.createTemplate(n2, n3);
        Graphics2D graphics2D = pdfContentByte.createGraphics(n2, n3, true, f2);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return Image.getInstance((PdfTemplate)pdfContentByte);
    }

    public PdfIndirectReference getDirectReference() {
        return this.a;
    }

    public void setDirectReference(PdfIndirectReference pdfIndirectReference) {
        this.a = pdfIndirectReference;
    }

    public static Image getInstance(PRIndirectReference pRIndirectReference) {
        Object object = (PdfDictionary)PdfReader.getPdfObjectRelease(pRIndirectReference);
        int n2 = ((PdfNumber)PdfReader.getPdfObjectRelease(((PdfDictionary)object).get(PdfName.WIDTH))).intValue();
        int n3 = ((PdfNumber)PdfReader.getPdfObjectRelease(((PdfDictionary)object).get(PdfName.HEIGHT))).intValue();
        Image image = null;
        PdfObject pdfObject = ((PdfDictionary)object).get(PdfName.SMASK);
        if (pdfObject != null && pdfObject.isIndirect()) {
            image = Image.getInstance((PRIndirectReference)pdfObject);
        } else {
            pdfObject = ((PdfDictionary)object).get(PdfName.MASK);
            if (pdfObject != null && pdfObject.isIndirect() && (object = PdfReader.getPdfObjectRelease(pdfObject)) instanceof PdfDictionary) {
                image = Image.getInstance((PRIndirectReference)pdfObject);
            }
        }
        object = new ImgRaw(n2, n3, 1, 1, null);
        new ImgRaw(n2, n3, 1, 1, null).imageMask = image;
        ((Image)object).a = pRIndirectReference;
        return object;
    }

    protected Image(Image image) {
        super(image);
        this.type = image.type;
        this.url = image.url;
        this.rawData = image.rawData;
        this.bpc = image.bpc;
        this.template = image.template;
        this.alignment = image.alignment;
        this.alt = image.alt;
        this.absoluteX = image.absoluteX;
        this.absoluteY = image.absoluteY;
        this.plainWidth = image.plainWidth;
        this.plainHeight = image.plainHeight;
        this.scaledWidth = image.scaledWidth;
        this.scaledHeight = image.scaledHeight;
        this.mySerialId = image.mySerialId;
        this.a = image.a;
        this.rotationRadians = image.rotationRadians;
        this.c = image.c;
        this.indentationLeft = image.indentationLeft;
        this.indentationRight = image.indentationRight;
        this.spacingBefore = image.spacingBefore;
        this.spacingAfter = image.spacingAfter;
        this.d = image.d;
        this.annotation = image.annotation;
        this.layer = image.layer;
        this.interpolation = image.interpolation;
        this.originalType = image.originalType;
        this.originalData = image.originalData;
        this.deflated = image.deflated;
        this.dpiX = image.dpiX;
        this.dpiY = image.dpiY;
        this.e = image.e;
        this.colorspace = image.colorspace;
        this.invert = image.invert;
        this.profile = image.profile;
        this.f = image.f;
        this.mask = image.mask;
        this.imageMask = image.imageMask;
        this.g = image.g;
        this.transparency = image.transparency;
    }

    public static Image getInstance(Image image) {
        if (image == null) {
            return null;
        }
        try {
            GenericDeclaration genericDeclaration = image.getClass();
            genericDeclaration = genericDeclaration.getDeclaredConstructor(Image.class);
            return (Image)((Constructor)genericDeclaration).newInstance(image);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    public boolean isJpeg() {
        return this.type == 32;
    }

    public boolean isImgRaw() {
        return this.type == 34;
    }

    public boolean isImgTemplate() {
        return this.type == 35;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public int getBpc() {
        return this.bpc;
    }

    public PdfTemplate getTemplateData() {
        return this.template[0];
    }

    public void setTemplateData(PdfTemplate pdfTemplate) {
        this.template[0] = pdfTemplate;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public String getAlt() {
        return this.alt;
    }

    public void setAlt(String string) {
        this.alt = string;
    }

    public void setAbsolutePosition(float f2, float f3) {
        this.absoluteX = f2;
        this.absoluteY = f3;
    }

    public boolean hasAbsoluteX() {
        return !Float.isNaN(this.absoluteX);
    }

    public float getAbsoluteX() {
        return this.absoluteX;
    }

    public boolean hasAbsoluteY() {
        return !Float.isNaN(this.absoluteY);
    }

    public float getAbsoluteY() {
        return this.absoluteY;
    }

    public float getScaledWidth() {
        return this.scaledWidth;
    }

    public float getScaledHeight() {
        return this.scaledHeight;
    }

    public float getPlainWidth() {
        return this.plainWidth;
    }

    public float getPlainHeight() {
        return this.plainHeight;
    }

    public void scaleAbsolute(float f2, float f3) {
        this.plainWidth = f2;
        this.plainHeight = f3;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
        this.setWidthPercentage(0.0f);
    }

    public void scaleAbsoluteWidth(float f2) {
        this.plainWidth = f2;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
        this.setWidthPercentage(0.0f);
    }

    public void scaleAbsoluteHeight(float f2) {
        this.plainHeight = f2;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
        this.setWidthPercentage(0.0f);
    }

    public void scalePercent(float f2) {
        float f3 = f2;
        this.scalePercent(f3, f3);
    }

    public void scalePercent(float f2, float f3) {
        this.plainWidth = this.getWidth() * f2 / 100.0f;
        this.plainHeight = this.getHeight() * f3 / 100.0f;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
        this.setWidthPercentage(0.0f);
    }

    public void scaleToFit(float f2, float f3) {
        this.scalePercent(100.0f);
        f2 = f2 * 100.0f / this.getScaledWidth();
        f3 = f3 * 100.0f / this.getScaledHeight();
        this.scalePercent(f2 < f3 ? f2 : f3);
        this.setWidthPercentage(0.0f);
    }

    public float[] matrix() {
        float[] fArray = new float[8];
        float f2 = (float)Math.cos(this.rotationRadians);
        float f3 = (float)Math.sin(this.rotationRadians);
        fArray[0] = this.plainWidth * f2;
        fArray[1] = this.plainWidth * f3;
        fArray[2] = -this.plainHeight * f3;
        fArray[3] = this.plainHeight * f2;
        if ((double)this.rotationRadians < 1.5707963267948966) {
            fArray[4] = fArray[2];
            fArray[5] = 0.0f;
            fArray[6] = fArray[0];
            fArray[7] = fArray[1] + fArray[3];
        } else if ((double)this.rotationRadians < Math.PI) {
            fArray[4] = fArray[0] + fArray[2];
            fArray[5] = fArray[3];
            fArray[6] = 0.0f;
            fArray[7] = fArray[1];
        } else if ((double)this.rotationRadians < 4.71238898038469) {
            fArray[4] = fArray[0];
            fArray[5] = fArray[1] + fArray[3];
            fArray[6] = fArray[2];
            fArray[7] = 0.0f;
        } else {
            fArray[4] = 0.0f;
            fArray[5] = fArray[1];
            fArray[6] = fArray[0] + fArray[2];
            fArray[7] = fArray[3];
        }
        return fArray;
    }

    protected static synchronized Long getSerialId() {
        return ++b;
    }

    public Long getMySerialId() {
        return this.mySerialId;
    }

    public float getImageRotation() {
        float f2;
        float f3 = (this.rotationRadians - this.c) % ((float)Math.PI * 2);
        if (f2 < 0.0f) {
            f3 += (float)Math.PI * 2;
        }
        return f3;
    }

    public void setRotation(float f2) {
        this.rotationRadians = (f2 + this.c) % ((float)Math.PI * 2);
        if (this.rotationRadians < 0.0f) {
            this.rotationRadians += (float)Math.PI * 2;
        }
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void setRotationDegrees(float f2) {
        this.setRotation(f2 / 180.0f * (float)Math.PI);
    }

    public float getInitialRotation() {
        return this.c;
    }

    public void setInitialRotation(float f2) {
        float f3 = this.rotationRadians - this.c;
        this.c = f2;
        this.setRotation(f3);
    }

    public float getIndentationLeft() {
        return this.indentationLeft;
    }

    public void setIndentationLeft(float f2) {
        this.indentationLeft = f2;
    }

    public float getIndentationRight() {
        return this.indentationRight;
    }

    public void setIndentationRight(float f2) {
        this.indentationRight = f2;
    }

    public float getSpacingBefore() {
        return this.spacingBefore;
    }

    public void setSpacingBefore(float f2) {
        this.spacingBefore = f2;
    }

    public float getSpacingAfter() {
        return this.spacingAfter;
    }

    public void setSpacingAfter(float f2) {
        this.spacingAfter = f2;
    }

    public float getWidthPercentage() {
        return this.d;
    }

    public void setWidthPercentage(float f2) {
        this.d = f2;
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public PdfOCG getLayer() {
        return this.layer;
    }

    public void setLayer(PdfOCG pdfOCG) {
        this.layer = pdfOCG;
    }

    public boolean isInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(boolean bl2) {
        this.interpolation = bl2;
    }

    public int getOriginalType() {
        return this.originalType;
    }

    public void setOriginalType(int n2) {
        this.originalType = n2;
    }

    public byte[] getOriginalData() {
        return this.originalData;
    }

    public void setOriginalData(byte[] byArray) {
        this.originalData = byArray;
    }

    public boolean isDeflated() {
        return this.deflated;
    }

    public void setDeflated(boolean bl2) {
        this.deflated = bl2;
    }

    public int getDpiX() {
        return this.dpiX;
    }

    public int getDpiY() {
        return this.dpiY;
    }

    public void setDpi(int n2, int n3) {
        this.dpiX = n2;
        this.dpiY = n3;
    }

    public float getXYRatio() {
        return this.e;
    }

    public void setXYRatio(float f2) {
        this.e = f2;
    }

    public int getColorspace() {
        return this.colorspace;
    }

    public boolean isInverted() {
        return this.invert;
    }

    public void setInverted(boolean bl2) {
        this.invert = bl2;
    }

    public void tagICC(ICC_Profile iCC_Profile) {
        this.profile = iCC_Profile;
    }

    public boolean hasICCProfile() {
        return this.profile != null;
    }

    public ICC_Profile getICCProfile() {
        return this.profile;
    }

    public PdfDictionary getAdditional() {
        return this.f;
    }

    public void setAdditional(PdfDictionary pdfDictionary) {
        this.f = pdfDictionary;
    }

    public void simplifyColorspace() {
        if (this.f == null) {
            return;
        }
        PdfArray pdfArray = this.f.getAsArray(PdfName.COLORSPACE);
        if (pdfArray == null) {
            return;
        }
        PdfObject pdfObject = Image.a(pdfArray);
        if (!pdfObject.isName()) {
            pdfObject = pdfArray;
            PdfObject pdfObject2 = pdfArray.getAsName(0);
            if (PdfName.INDEXED.equals(pdfObject2) && pdfArray.size() >= 2 && (pdfObject2 = pdfArray.getAsArray(1)) != null) {
                pdfArray.set(1, Image.a((PdfArray)pdfObject2));
            }
        }
        this.f.put(PdfName.COLORSPACE, pdfObject);
    }

    private static PdfObject a(PdfArray pdfArray) {
        if (pdfArray == null) {
            return pdfArray;
        }
        PdfName pdfName = pdfArray.getAsName(0);
        if (PdfName.CALGRAY.equals(pdfName)) {
            return PdfName.DEVICEGRAY;
        }
        if (PdfName.CALRGB.equals(pdfName)) {
            return PdfName.DEVICERGB;
        }
        return pdfArray;
    }

    public boolean isMask() {
        return this.mask;
    }

    public void makeMask() {
        if (!this.isMaskCandidate()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("this.image.can.not.be.an.image.mask"));
        }
        this.mask = true;
    }

    public boolean isMaskCandidate() {
        if (this.type == 34 && this.bpc > 255) {
            return true;
        }
        return this.colorspace == 1;
    }

    public Image getImageMask() {
        return this.imageMask;
    }

    public void setImageMask(Image image) {
        if (this.mask) {
            throw new DocumentException(MessageLocalization.getComposedMessage("an.image.mask.cannot.contain.another.image.mask"));
        }
        if (!image.mask) {
            throw new DocumentException(MessageLocalization.getComposedMessage("the.image.mask.is.not.a.mask.did.you.do.makemask"));
        }
        this.imageMask = image;
        this.g = image.bpc > 1 && image.bpc <= 8;
    }

    public boolean isSmask() {
        return this.g;
    }

    public void setSmask(boolean bl2) {
        this.g = bl2;
    }

    public int[] getTransparency() {
        return this.transparency;
    }

    public void setTransparency(int[] nArray) {
        this.transparency = nArray;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int n2) {
        if (n2 < 0 || n2 > 9) {
            this.compressionLevel = -1;
            return;
        }
        this.compressionLevel = n2;
    }
}

