/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import com.lowagie.text.Utilities;
import com.lowagie.text.error_messages.MessageLocalization;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class Jpeg
extends Image {
    public static final int NOT_A_MARKER = -1;
    public static final int VALID_MARKER = 0;
    public static final int[] VALID_MARKERS = new int[]{192, 193, 194};
    public static final int UNSUPPORTED_MARKER = 1;
    public static final int[] UNSUPPORTED_MARKERS = new int[]{195, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207};
    public static final int NOPARAM_MARKER = 2;
    public static final int[] NOPARAM_MARKERS = new int[]{208, 209, 210, 211, 212, 213, 214, 215, 216, 1};
    public static final int M_APP0 = 224;
    public static final int M_APP2 = 226;
    public static final int M_APPE = 238;
    public static final byte[] JFIF_ID = new byte[]{74, 70, 73, 70, 0};
    private byte[][] a;

    public Jpeg(URL uRL) {
        super(uRL);
        this.a();
    }

    public Jpeg(byte[] byArray) {
        super((URL)null);
        this.rawData = byArray;
        this.originalData = byArray;
        this.a();
    }

    public Jpeg(byte[] byArray, float f2, float f3) {
        this(byArray);
        this.scaledWidth = f2;
        this.scaledHeight = f3;
    }

    private static int a(InputStream inputStream) {
        return (inputStream.read() << 8) + inputStream.read();
    }

    private static int a(int n2) {
        int n3;
        int n4;
        int[] nArray = VALID_MARKERS;
        int n5 = VALID_MARKERS.length;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = nArray[n4];
            if (n2 != n3) continue;
            return 0;
        }
        nArray = NOPARAM_MARKERS;
        n5 = NOPARAM_MARKERS.length;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = nArray[n4];
            if (n2 != n3) continue;
            return 2;
        }
        nArray = UNSUPPORTED_MARKERS;
        n5 = UNSUPPORTED_MARKERS.length;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = nArray[n4];
            if (n2 != n3) continue;
            return 1;
        }
        return -1;
    }

    private void a() {
        int n2;
        int n3;
        int n4;
        this.type = 32;
        this.originalType = 1;
        try (InputStream inputStream = null;){
            String string;
            if (this.rawData == null) {
                inputStream = this.url.openStream();
                string = this.url.toString();
            } else {
                inputStream = new ByteArrayInputStream(this.rawData);
                string = "Byte array";
            }
            if (inputStream.read() != 255 || inputStream.read() != 216) {
                throw new BadElementException(MessageLocalization.getComposedMessage("1.is.not.a.valid.jpeg.file", string));
            }
            n4 = 1;
            while (true) {
                int n5;
                if ((n3 = inputStream.read()) < 0) {
                    throw new IOException(MessageLocalization.getComposedMessage("premature.eof.while.reading.jpg"));
                }
                if (n3 != 255) continue;
                n2 = inputStream.read();
                if (n4 != 0 && n2 == 224) {
                    n4 = 0;
                    n5 = Jpeg.a(inputStream);
                    if (n5 < 16) {
                        Utilities.skip(inputStream, n5 - 2);
                        continue;
                    }
                    byte[] byArray = new byte[JFIF_ID.length];
                    n3 = inputStream.read(byArray);
                    if (n3 != byArray.length) {
                        throw new BadElementException(MessageLocalization.getComposedMessage("1.corrupted.jfif.marker", string));
                    }
                    n3 = 1;
                    for (n2 = 0; n2 < byArray.length; ++n2) {
                        if (byArray[n2] == JFIF_ID[n2]) continue;
                        n3 = 0;
                        break;
                    }
                    if (n3 == 0) {
                        Utilities.skip(inputStream, n5 - 2 - byArray.length);
                        continue;
                    }
                    Utilities.skip(inputStream, 2);
                    n2 = inputStream.read();
                    n3 = Jpeg.a(inputStream);
                    int n6 = Jpeg.a(inputStream);
                    if (n2 == 1) {
                        this.dpiX = n3;
                        this.dpiY = n6;
                    } else if (n2 == 2) {
                        this.dpiX = (int)((float)n3 * 2.54f + 0.5f);
                        this.dpiY = (int)((float)n6 * 2.54f + 0.5f);
                    }
                    Utilities.skip(inputStream, n5 - 2 - byArray.length - 7);
                    continue;
                }
                if (n2 == 238) {
                    String string2;
                    n5 = Jpeg.a(inputStream) - 2;
                    byte[] byArray = new byte[n5];
                    for (n3 = 0; n3 < n5; ++n3) {
                        byArray[n3] = (byte)inputStream.read();
                    }
                    if (byArray.length < 12 || !(string2 = new String(byArray, 0, 5, StandardCharsets.ISO_8859_1)).equals("Adobe")) continue;
                    this.invert = true;
                    continue;
                }
                if (n2 == 226) {
                    String string3;
                    n5 = Jpeg.a(inputStream) - 2;
                    byte[] byArray = new byte[n5];
                    for (n3 = 0; n3 < n5; ++n3) {
                        byArray[n3] = (byte)inputStream.read();
                    }
                    if (byArray.length < 14 || !(string3 = new String(byArray, 0, 11, StandardCharsets.ISO_8859_1)).equals("ICC_PROFILE")) continue;
                    int n7 = byArray[12] & 0xFF;
                    n2 = byArray[13] & 0xFF;
                    if (n7 <= 0) {
                        n7 = 1;
                    }
                    if (n2 <= 0) {
                        n2 = 1;
                    }
                    if (this.a == null) {
                        this.a = new byte[n2][];
                    }
                    this.a[n7 - 1] = byArray;
                    continue;
                }
                n4 = 0;
                int n8 = Jpeg.a(n2);
                if (n8 == 0) {
                    Utilities.skip(inputStream, 2);
                    if (inputStream.read() != 8) {
                        throw new BadElementException(MessageLocalization.getComposedMessage("1.must.have.8.bits.per.component", string));
                    }
                    this.scaledHeight = Jpeg.a(inputStream);
                    Jpeg jpeg = this;
                    jpeg.setTop(jpeg.scaledHeight);
                    this.scaledWidth = Jpeg.a(inputStream);
                    Jpeg jpeg2 = this;
                    jpeg2.setRight(jpeg2.scaledWidth);
                    this.colorspace = inputStream.read();
                    this.bpc = 8;
                    break;
                }
                if (n8 == 1) {
                    throw new BadElementException(MessageLocalization.getComposedMessage("1.unsupported.jpeg.marker.2", string, String.valueOf(n2)));
                }
                if (n8 == 2) continue;
                InputStream inputStream2 = inputStream;
                Utilities.skip(inputStream2, Jpeg.a(inputStream2) - 2);
            }
        }
        this.plainWidth = this.getWidth();
        this.plainHeight = this.getHeight();
        if (this.a != null) {
            int n9 = 0;
            for (n4 = 0; n4 < this.a.length; ++n4) {
                if (this.a[n4] == null) {
                    this.a = null;
                    return;
                }
                n9 += this.a[n4].length - 14;
            }
            byte[] byArray = new byte[n9];
            n9 = 0;
            Object object = this.a;
            n3 = this.a.length;
            for (n2 = 0; n2 < n3; ++n2) {
                byte[] byArray2 = object[n2];
                System.arraycopy(byArray2, 14, byArray, n9, byArray2.length - 14);
                n9 += byArray2.length - 14;
            }
            try {
                object = ICC_Profile.getInstance(byArray);
                this.tagICC((ICC_Profile)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            this.a = null;
        }
    }
}

