/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.factories.RomanAlphabetFactory;
import java.util.ArrayList;

public class List
implements TextElementArray {
    public static final boolean ORDERED = true;
    public static final boolean UNORDERED = false;
    public static final boolean NUMERICAL = false;
    public static final boolean ALPHABETICAL = true;
    public static final boolean UPPERCASE = false;
    public static final boolean LOWERCASE = true;
    protected java.util.List<Element> list = new ArrayList<Element>();
    protected boolean numbered = false;
    protected boolean lettered = false;
    protected boolean lowercase = false;
    protected boolean autoindent = false;
    protected boolean alignindent = false;
    protected int first = 1;
    protected Chunk symbol = new Chunk("- ");
    protected String preSymbol = "";
    protected String postSymbol = ". ";
    protected float indentationLeft = 0.0f;
    protected float indentationRight = 0.0f;
    protected float symbolIndent = 0.0f;

    public List() {
        this(false, false);
    }

    public List(float f2) {
        this.symbolIndent = f2;
    }

    public List(boolean bl2) {
        this(bl2, false);
    }

    public List(boolean bl2, boolean bl3) {
        this.numbered = bl2;
        this.lettered = bl3;
        this.autoindent = true;
        this.alignindent = true;
    }

    public List(boolean bl2, float f2) {
        this(bl2, false, f2);
    }

    public List(boolean bl2, boolean bl3, float f2) {
        this.numbered = bl2;
        this.lettered = bl3;
        this.symbolIndent = f2;
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            for (Element element : this.list) {
                elementListener.add(element);
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    @Override
    public int type() {
        return 14;
    }

    @Override
    public ArrayList<Element> getChunks() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element element : this.list) {
            arrayList.addAll(element.getChunks());
        }
        return arrayList;
    }

    @Override
    public boolean add(Element element) {
        if (element instanceof ListItem) {
            element = (ListItem)element;
            if (this.numbered || this.lettered) {
                Chunk chunk = new Chunk(this.preSymbol, this.symbol.getFont());
                int n2 = this.first + this.list.size();
                if (this.lettered) {
                    chunk.append(RomanAlphabetFactory.getString(n2, this.lowercase));
                } else {
                    chunk.append(String.valueOf(n2));
                }
                chunk.append(this.postSymbol);
                ((ListItem)element).setListSymbol(chunk);
            } else {
                ((ListItem)element).setListSymbol(this.symbol);
            }
            ((ListItem)element).setIndentationLeft(this.symbolIndent, this.autoindent);
            ((Paragraph)element).setIndentationRight(0.0f);
            return this.list.add(element);
        }
        return false;
    }

    public boolean add(List list) {
        List list2 = list;
        list2.setIndentationLeft(list2.getIndentationLeft() + this.symbolIndent);
        --this.first;
        return this.list.add(list);
    }

    public boolean add(String string) {
        return this.add(new ListItem(string));
    }

    public void normalizeIndentation() {
        float f2 = 0.0f;
        for (Element element : this.list) {
            Element element2;
            element = element;
            if (!(element2 instanceof ListItem)) continue;
            f2 = Math.max(f2, ((ListItem)element).getIndentationLeft());
        }
        for (Element element : this.list) {
            Element element3;
            element = element;
            if (!(element3 instanceof ListItem)) continue;
            ((ListItem)element).setIndentationLeft(f2);
        }
    }

    public void setNumbered(boolean bl2) {
        this.numbered = bl2;
    }

    public void setLettered(boolean bl2) {
        this.lettered = bl2;
    }

    public void setLowercase(boolean bl2) {
        this.lowercase = bl2;
    }

    public void setAutoindent(boolean bl2) {
        this.autoindent = bl2;
    }

    public void setAlignindent(boolean bl2) {
        this.alignindent = bl2;
    }

    public void setFirst(int n2) {
        this.first = n2;
    }

    public void setListSymbol(Chunk chunk) {
        this.symbol = chunk;
    }

    public void setListSymbol(String string) {
        this.symbol = new Chunk(string);
    }

    public void setIndentationLeft(float f2) {
        this.indentationLeft = f2;
    }

    public void setIndentationRight(float f2) {
        this.indentationRight = f2;
    }

    public void setSymbolIndent(float f2) {
        this.symbolIndent = f2;
    }

    public java.util.List<Element> getItems() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public float getTotalLeading() {
        if (this.list.size() <= 0) {
            return -1.0f;
        }
        ListItem listItem = (ListItem)this.list.get(0);
        return listItem.getTotalLeading();
    }

    public boolean isNumbered() {
        return this.numbered;
    }

    public boolean isLettered() {
        return this.lettered;
    }

    public boolean isLowercase() {
        return this.lowercase;
    }

    public boolean isAutoindent() {
        return this.autoindent;
    }

    public boolean isAlignindent() {
        return this.alignindent;
    }

    public int getFirst() {
        return this.first;
    }

    public Chunk getSymbol() {
        return this.symbol;
    }

    public float getIndentationLeft() {
        return this.indentationLeft;
    }

    public float getIndentationRight() {
        return this.indentationRight;
    }

    public float getSymbolIndent() {
        return this.symbolIndent;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    public String getPostSymbol() {
        return this.postSymbol;
    }

    public void setPostSymbol(String string) {
        this.postSymbol = string;
    }

    public String getPreSymbol() {
        return this.preSymbol;
    }

    public void setPreSymbol(String string) {
        this.preSymbol = string;
    }
}

