/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.MarkedObject;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Section;
import java.util.Collection;

public class MarkedSection
extends MarkedObject {
    protected MarkedObject title = null;

    public MarkedSection(Section section) {
        if (section.title != null) {
            this.title = new MarkedObject(section.title);
            section.setTitle(null);
        }
        this.element = section;
    }

    public void add(int n2, Element element) {
        ((Section)this.element).add(n2, element);
    }

    public boolean add(Element element) {
        return ((Section)this.element).add(element);
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            for (Object object : (Section)this.element) {
                object = (Element)object;
                elementListener.add((Element)object);
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public boolean addAll(Collection<? extends Element> collection) {
        return ((Section)this.element).addAll(collection);
    }

    public MarkedSection addSection(float f2, int n2) {
        MarkedSection markedSection = ((Section)this.element).addMarkedSection();
        markedSection.setIndentation(f2);
        markedSection.setNumberDepth(n2);
        return markedSection;
    }

    public MarkedSection addSection(float f2) {
        MarkedSection markedSection = ((Section)this.element).addMarkedSection();
        markedSection.setIndentation(f2);
        return markedSection;
    }

    public MarkedSection addSection(int n2) {
        MarkedSection markedSection = ((Section)this.element).addMarkedSection();
        markedSection.setNumberDepth(n2);
        return markedSection;
    }

    public MarkedSection addSection() {
        return ((Section)this.element).addMarkedSection();
    }

    public void setTitle(MarkedObject markedObject) {
        if (markedObject.element instanceof Paragraph) {
            this.title = markedObject;
        }
    }

    public MarkedObject getTitle() {
        Element element = Section.constructTitle((Paragraph)this.title.element, ((Section)this.element).numbers, ((Section)this.element).numberDepth, ((Section)this.element).numberStyle);
        element = new MarkedObject(element);
        v0.markupAttributes = this.title.markupAttributes;
        return element;
    }

    public void setNumberDepth(int n2) {
        ((Section)this.element).setNumberDepth(n2);
    }

    public void setIndentationLeft(float f2) {
        ((Section)this.element).setIndentationLeft(f2);
    }

    public void setIndentationRight(float f2) {
        ((Section)this.element).setIndentationRight(f2);
    }

    public void setIndentation(float f2) {
        ((Section)this.element).setIndentation(f2);
    }

    public void setBookmarkOpen(boolean bl2) {
        ((Section)this.element).setBookmarkOpen(bl2);
    }

    public void setTriggerNewPage(boolean bl2) {
        ((Section)this.element).setTriggerNewPage(bl2);
    }

    public void setBookmarkTitle(String string) {
        ((Section)this.element).setBookmarkTitle(string);
    }

    public void newPage() {
        ((Section)this.element).newPage();
    }
}

