/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Font;
import com.lowagie.text.RtfElementInterface;
import com.lowagie.text.SpecialSymbol;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.HyphenationEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Phrase
extends ArrayList<Element>
implements TextElementArray {
    protected float leading = Float.NaN;
    protected Font font;
    protected HyphenationEvent hyphenation = null;

    public Phrase() {
        this(16.0f);
    }

    public Phrase(Phrase phrase) {
        this.addAll(phrase);
        this.leading = phrase.getLeading();
        this.font = phrase.getFont();
        this.setHyphenation(phrase.getHyphenation());
    }

    public Phrase(float f2) {
        this.leading = f2;
        this.font = new Font();
    }

    public Phrase(Chunk chunk) {
        super.add(chunk);
        this.font = chunk.getFont();
        this.setHyphenation(chunk.getHyphenation());
    }

    public Phrase(float f2, Chunk chunk) {
        this.leading = f2;
        super.add(chunk);
        this.font = chunk.getFont();
        this.setHyphenation(chunk.getHyphenation());
    }

    public Phrase(String string) {
        this(Float.NaN, string, new Font());
    }

    public Phrase(String string, Font font) {
        this(Float.NaN, string, font);
    }

    public Phrase(float f2, String string) {
        this(f2, string, new Font());
    }

    public Phrase(float f2, String string, Font font) {
        this.leading = f2;
        this.font = font;
        if (string != null && string.length() != 0) {
            super.add(new Chunk(string, font));
        }
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            for (Object e2 : this) {
                elementListener.add((Element)e2);
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    @Override
    public int type() {
        return 11;
    }

    @Override
    public ArrayList<Element> getChunks() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element element : this) {
            arrayList.addAll(element.getChunks());
        }
        return arrayList;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    @Override
    public void add(int n2, Element element) {
        block7: {
            if (element == null) {
                return;
            }
            try {
                if (element.type() == 10) {
                    element = (Chunk)element;
                    if (!this.font.isStandardFont()) {
                        ((Chunk)element).setFont(this.font.difference(((Chunk)element).getFont()));
                    }
                    if (this.hyphenation != null && ((Chunk)element).getHyphenation() == null && !((Chunk)element).isEmpty()) {
                        ((Chunk)element).setHyphenation(this.hyphenation);
                    }
                    super.add(n2, element);
                    break block7;
                }
                if (element.type() == 11 || element.type() == 17 || element.type() == 29 || element.type() == 22 || element.type() == 55 || element.type() == 50) {
                    super.add(n2, element);
                    break block7;
                }
                throw new ClassCastException(String.valueOf(element.type()));
            }
            catch (ClassCastException classCastException) {
                throw new ClassCastException(MessageLocalization.getComposedMessage("insertion.of.illegal.element.1", classCastException.getMessage()));
            }
        }
    }

    @Override
    public boolean add(String string) {
        if (string == null) {
            return false;
        }
        return super.add(new Chunk(string, this.font));
    }

    @Override
    public boolean add(Element element) {
        if (element == null) {
            return false;
        }
        if (element instanceof RtfElementInterface) {
            return super.add(element);
        }
        try {
            switch (element.type()) {
                case 10: {
                    return this.addChunk((Chunk)element);
                }
                case 11: 
                case 12: {
                    element = (Phrase)element;
                    boolean bl2 = true;
                    Iterator iterator = ((ArrayList)((Object)element)).iterator();
                    while (iterator.hasNext()) {
                        element = iterator.next();
                        if ((element = (Element)element) instanceof Chunk) {
                            bl2 &= this.addChunk((Chunk)element);
                            continue;
                        }
                        bl2 &= this.add(element);
                    }
                    return bl2;
                }
                case 14: 
                case 17: 
                case 22: 
                case 23: 
                case 29: 
                case 50: 
                case 55: 
                case 56: {
                    return super.add(element);
                }
            }
            throw new ClassCastException(String.valueOf(element.type()));
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(MessageLocalization.getComposedMessage("insertion.of.illegal.element.1", classCastException.getMessage()));
        }
    }

    @Override
    public boolean addAll(Collection<? extends Element> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Element element = (Element)object.next();
            this.add(element);
        }
        return true;
    }

    protected boolean addChunk(Chunk chunk) {
        Chunk chunk2;
        Font font = chunk.getFont();
        String string = chunk.getContent();
        if (this.font != null && !this.font.isStandardFont()) {
            font = this.font.difference(chunk.getFont());
        }
        if (this.size() > 0 && !chunk.hasAttributes()) {
            try {
                Phrase phrase = this;
                chunk2 = (Chunk)phrase.get(phrase.size() - 1);
                if (!(chunk2.hasAttributes() || font != null && font.compareTo(chunk2.getFont()) != 0 || "".equals(chunk2.getContent().trim()) || "".equals(string.trim()))) {
                    chunk2.append(string);
                    return true;
                }
            }
            catch (ClassCastException classCastException) {}
        }
        chunk2 = new Chunk(string, font);
        chunk2.setChunkAttributes(chunk.getChunkAttributes());
        if (this.hyphenation != null && chunk2.getHyphenation() == null && !chunk2.isEmpty()) {
            chunk2.setHyphenation(this.hyphenation);
        }
        return super.add(chunk2);
    }

    protected void addSpecial(Object object) {
        super.add((Element)object);
    }

    public void setLeading(float f2) {
        this.leading = f2;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public float getLeading() {
        if (Float.isNaN(this.leading) && this.font != null) {
            return this.font.getCalculatedLeading(1.5f);
        }
        return this.leading;
    }

    public boolean hasLeading() {
        return !Float.isNaN(this.leading);
    }

    public Font getFont() {
        return this.font;
    }

    public String getContent() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : this.getChunks()) {
            stringBuilder.append(((Object)element).toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isEmpty() {
        switch (this.size()) {
            case 0: {
                return true;
            }
            case 1: {
                Element element = (Element)this.get(0);
                return element.type() == 10 && ((Chunk)element).isEmpty();
            }
        }
        return false;
    }

    public HyphenationEvent getHyphenation() {
        return this.hyphenation;
    }

    public void setHyphenation(HyphenationEvent hyphenationEvent) {
        this.hyphenation = hyphenationEvent;
    }

    private Phrase(byte by) {
    }

    public static final Phrase getInstance(String string) {
        return Phrase.getInstance(16, string, new Font());
    }

    public static final Phrase getInstance(int n2, String string) {
        return Phrase.getInstance(n2, string, new Font());
    }

    public static final Phrase getInstance(int n2, String string, Font font) {
        Phrase phrase = new Phrase(0);
        phrase.setLeading(n2);
        phrase.font = font;
        if (font.getFamily() != 3 && font.getFamily() != 4 && font.getBaseFont() == null) {
            while ((n2 = SpecialSymbol.index(string)) >= 0) {
                Object object;
                if (n2 > 0) {
                    object = string.substring(0, n2);
                    phrase.add(new Chunk((String)object, font));
                    string = string.substring(n2);
                }
                object = new Font(3, font.getSize(), font.getStyle(), font.getColor());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(SpecialSymbol.getCorrespondingSymbol(string.charAt(0)));
                string = string.substring(1);
                while (SpecialSymbol.index(string) == 0) {
                    stringBuilder.append(SpecialSymbol.getCorrespondingSymbol(string.charAt(0)));
                    string = string.substring(1);
                }
                phrase.add(new Chunk(stringBuilder.toString(), (Font)object));
            }
        }
        if (string != null && string.length() != 0) {
            phrase.add(new Chunk(string, font));
        }
        return phrase;
    }
}

