/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Table;
import com.lowagie.text.TableRectangle;
import com.lowagie.text.alignment.HorizontalAlignment;
import com.lowagie.text.alignment.WithHorizontalAlignment;
import com.lowagie.text.error_messages.MessageLocalization;
import java.util.ArrayList;

public class Row
implements Element,
WithHorizontalAlignment {
    public static final int NULL = 0;
    public static final int CELL = 1;
    public static final int TABLE = 2;
    protected int columns;
    protected int currentColumn;
    protected boolean[] reserved;
    protected TableRectangle[] cells;
    protected int horizontalAlignment;

    protected Row(int n2) {
        this.columns = n2;
        this.reserved = new boolean[n2];
        this.cells = new TableRectangle[n2];
        this.currentColumn = 0;
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    @Override
    public int type() {
        return 21;
    }

    @Override
    public ArrayList<Element> getChunks() {
        return new ArrayList<Element>();
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return false;
    }

    final void a(int n2) {
        int n3;
        if (n2 >= this.columns || n2 < 0) {
            throw new IndexOutOfBoundsException(MessageLocalization.getComposedMessage("getcell.at.illegal.index.1", n2));
        }
        --this.columns;
        boolean[] blArray = new boolean[this.columns];
        Cell[] cellArray = new Cell[this.columns];
        for (n3 = 0; n3 < n2; ++n3) {
            blArray[n3] = this.reserved[n3];
            cellArray[n3] = this.cells[n3];
            if (cellArray[n3] == null || n3 + cellArray[n3].getColspan() <= n2) continue;
            cellArray[n3].setColspan(((Cell)this.cells[n3]).getColspan() - 1);
        }
        for (n3 = n2; n3 < this.columns; ++n3) {
            blArray[n3] = this.reserved[n3 + 1];
            cellArray[n3] = this.cells[n3 + 1];
        }
        if (this.cells[n2] != null && ((Cell)this.cells[n2]).getColspan() > 1) {
            cellArray[n2] = this.cells[n2];
            cellArray[n2].setColspan(cellArray[n2].getColspan() - 1);
        }
        this.reserved = blArray;
        this.cells = cellArray;
    }

    final int a(TableRectangle tableRectangle, int n2) {
        int n3;
        if (tableRectangle == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("addcell.null.argument"));
        }
        if (n2 < 0 || n2 > this.columns) {
            throw new IndexOutOfBoundsException(MessageLocalization.getComposedMessage("addcell.illegal.column.argument"));
        }
        if (Row.a(tableRectangle) != 1 && Row.a(tableRectangle) != 2) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("addcell.only.cells.or.tables.allowed"));
        }
        int n4 = n3 = tableRectangle instanceof Cell ? ((Cell)tableRectangle).getColspan() : 1;
        if (!this.a(n2, n3)) {
            return -1;
        }
        this.cells[n2] = tableRectangle;
        this.currentColumn += n3 - 1;
        return n2;
    }

    final void b(TableRectangle tableRectangle, int n2) {
        if (this.reserved[n2]) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("setelement.position.already.taken"));
        }
        this.cells[n2] = tableRectangle;
        if (tableRectangle != null) {
            this.reserved[n2] = true;
        }
    }

    final boolean a(int n2, int n3) {
        if (n2 < 0 || n2 + n3 > this.columns) {
            throw new IndexOutOfBoundsException(MessageLocalization.getComposedMessage("reserve.incorrect.column.size"));
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (this.reserved[i2]) {
                for (n3 = i2; n3 >= n2; --n3) {
                    this.reserved[n3] = false;
                }
                return false;
            }
            this.reserved[i2] = true;
        }
        return true;
    }

    final boolean b(int n2) {
        return this.reserved[n2];
    }

    private static int a(TableRectangle tableRectangle) {
        if (tableRectangle == null) {
            return 0;
        }
        if (tableRectangle instanceof Cell) {
            return 1;
        }
        if (tableRectangle instanceof Table) {
            return 2;
        }
        return -1;
    }

    public TableRectangle getCell(int n2) {
        if (n2 < 0 || n2 > this.columns) {
            throw new IndexOutOfBoundsException(MessageLocalization.getComposedMessage("getcell.at.illegal.index.1.max.is.2", String.valueOf(n2), String.valueOf(this.columns)));
        }
        return this.cells[n2];
    }

    public boolean isEmpty() {
        for (int i2 = 0; i2 < this.columns; ++i2) {
            if (this.cells[i2] == null) continue;
            return false;
        }
        return true;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setHorizontalAlignment(int n2) {
        this.horizontalAlignment = n2;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            return;
        }
        this.horizontalAlignment = horizontalAlignment.getId();
    }
}

