/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.LargeElement;
import com.lowagie.text.MarkedObject;
import com.lowagie.text.MarkedSection;
import com.lowagie.text.Paragraph;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.error_messages.MessageLocalization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Section
extends ArrayList<Element>
implements LargeElement,
TextElementArray {
    public static final int NUMBERSTYLE_DOTTED = 0;
    public static final int NUMBERSTYLE_DOTTED_WITHOUT_FINAL_DOT = 1;
    protected Paragraph title;
    protected String bookmarkTitle;
    protected int numberDepth;
    protected int numberStyle = 0;
    protected float indentationLeft;
    protected float indentationRight;
    protected float indentation;
    protected boolean bookmarkOpen = true;
    protected boolean triggerNewPage = false;
    protected int subsections = 0;
    protected List<Integer> numbers = null;
    protected boolean complete = true;
    protected boolean addedCompletely = false;
    protected boolean notAddedYet = true;

    protected Section() {
        this.title = new Paragraph();
        this.numberDepth = 1;
    }

    protected Section(Paragraph paragraph, int n2) {
        this.numberDepth = n2;
        this.title = paragraph;
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            for (Object object : this) {
                object = (Element)object;
                elementListener.add((Element)object);
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    @Override
    public int type() {
        return 13;
    }

    public boolean isChapter() {
        return this.type() == 16;
    }

    public boolean isSection() {
        return this.type() == 13;
    }

    @Override
    public ArrayList<Element> getChunks() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element element : this) {
            arrayList.addAll(element.getChunks());
        }
        return arrayList;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return false;
    }

    @Override
    public void add(int n2, Element element) {
        if (this.isAddedCompletely()) {
            throw new IllegalStateException(MessageLocalization.getComposedMessage("this.largeelement.has.already.been.added.to.the.document"));
        }
        try {
            if (!element.isNestable()) {
                throw new ClassCastException(MessageLocalization.getComposedMessage("you.can.t.add.a.1.to.a.section", element.getClass().getName()));
            }
            super.add(n2, element);
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(MessageLocalization.getComposedMessage("insertion.of.illegal.element.1", classCastException.getMessage()));
        }
    }

    @Override
    public boolean add(Element element) {
        if (this.isAddedCompletely()) {
            throw new IllegalStateException(MessageLocalization.getComposedMessage("this.largeelement.has.already.been.added.to.the.document"));
        }
        try {
            Element element2 = element;
            if (element2.type() == 13) {
                element = (Section)element;
                ((Section)element).a(++this.subsections, this.numbers);
                return super.add(element);
            }
            if (element instanceof MarkedSection && ((MarkedObject)element).element.type() == 13) {
                element = (MarkedSection)element;
                element2 = (Section)((MarkedObject)element).element;
                ((Section)element2).a(++this.subsections, this.numbers);
                return super.add(element);
            }
            if (element2.isNestable()) {
                return super.add(element);
            }
            throw new ClassCastException(MessageLocalization.getComposedMessage("you.can.t.add.a.1.to.a.section", element2.getClass().getName()));
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(MessageLocalization.getComposedMessage("insertion.of.illegal.element.1", classCastException.getMessage()));
        }
    }

    @Override
    public boolean addAll(Collection<? extends Element> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Element element = (Element)object.next();
            this.add(element);
        }
        return true;
    }

    public Section addSection(float f2, Paragraph arrayList, int n2) {
        if (this.isAddedCompletely()) {
            throw new IllegalStateException(MessageLocalization.getComposedMessage("this.largeelement.has.already.been.added.to.the.document"));
        }
        arrayList = new Section((Paragraph)arrayList, n2);
        ((Section)arrayList).setIndentation(f2);
        this.add((Element)((Object)arrayList));
        return arrayList;
    }

    public Section addSection(float f2, Paragraph paragraph) {
        return this.addSection(f2, paragraph, this.numberDepth + 1);
    }

    public Section addSection(Paragraph paragraph, int n2) {
        return this.addSection(0.0f, paragraph, n2);
    }

    public MarkedSection addMarkedSection() {
        MarkedSection markedSection = new MarkedSection(new Section(null, this.numberDepth + 1));
        this.add(markedSection);
        return markedSection;
    }

    public Section addSection(Paragraph paragraph) {
        return this.addSection(0.0f, paragraph, this.numberDepth + 1);
    }

    public Section addSection(float f2, String string, int n2) {
        return this.addSection(f2, new Paragraph(string), n2);
    }

    public Section addSection(String string, int n2) {
        return this.addSection(new Paragraph(string), n2);
    }

    public Section addSection(float f2, String string) {
        return this.addSection(f2, new Paragraph(string));
    }

    public Section addSection(String string) {
        return this.addSection(new Paragraph(string));
    }

    public void setTitle(Paragraph paragraph) {
        this.title = paragraph;
    }

    public Paragraph getTitle() {
        return Section.constructTitle(this.title, this.numbers, this.numberDepth, this.numberStyle);
    }

    public static Paragraph constructTitle(Paragraph paragraph, List<Integer> list, int n2, int n3) {
        if (paragraph == null) {
            return null;
        }
        n2 = Math.min(list.size(), n2);
        if (n2 <= 0) {
            return paragraph;
        }
        StringBuilder stringBuilder = new StringBuilder(" ");
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.insert(0, ".");
            stringBuilder.insert(0, list.get(i2));
        }
        if (n3 == 1) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.deleteCharAt(stringBuilder2.length() - 2);
        }
        Paragraph paragraph2 = new Paragraph(paragraph);
        paragraph2.add(0, new Chunk(stringBuilder.toString(), paragraph.getFont()));
        return paragraph2;
    }

    public void setNumberDepth(int n2) {
        this.numberDepth = n2;
    }

    public int getNumberDepth() {
        return this.numberDepth;
    }

    public void setNumberStyle(int n2) {
        this.numberStyle = n2;
    }

    public int getNumberStyle() {
        return this.numberStyle;
    }

    public void setIndentationLeft(float f2) {
        this.indentationLeft = f2;
    }

    public float getIndentationLeft() {
        return this.indentationLeft;
    }

    public void setIndentationRight(float f2) {
        this.indentationRight = f2;
    }

    public float getIndentationRight() {
        return this.indentationRight;
    }

    public void setIndentation(float f2) {
        this.indentation = f2;
    }

    public float getIndentation() {
        return this.indentation;
    }

    public void setBookmarkOpen(boolean bl2) {
        this.bookmarkOpen = bl2;
    }

    public boolean isBookmarkOpen() {
        return this.bookmarkOpen;
    }

    public void setTriggerNewPage(boolean bl2) {
        this.triggerNewPage = bl2;
    }

    public boolean isTriggerNewPage() {
        return this.triggerNewPage && this.notAddedYet;
    }

    public void setBookmarkTitle(String string) {
        this.bookmarkTitle = string;
    }

    public Paragraph getBookmarkTitle() {
        if (this.bookmarkTitle == null) {
            return this.getTitle();
        }
        return new Paragraph(this.bookmarkTitle);
    }

    public void setChapterNumber(int n2) {
        this.numbers.set(this.numbers.size() - 1, n2);
        for (Object e2 : this) {
            Object e3;
            e2 = e2;
            if (!(e3 instanceof Section)) continue;
            ((Section)e2).setChapterNumber(n2);
        }
    }

    public int getDepth() {
        return this.numbers.size();
    }

    private void a(int n2, List<Integer> list) {
        this.numbers = new ArrayList<Integer>();
        this.numbers.add(n2);
        this.numbers.addAll(list);
    }

    public boolean isNotAddedYet() {
        return this.notAddedYet;
    }

    public void setNotAddedYet(boolean bl2) {
        this.notAddedYet = bl2;
    }

    protected boolean isAddedCompletely() {
        return this.addedCompletely;
    }

    protected void setAddedCompletely(boolean bl2) {
        this.addedCompletely = bl2;
    }

    @Override
    public void flushContent() {
        this.setNotAddedYet(false);
        this.title = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (element instanceof Section) {
                if (!((Section)(element = (Section)element)).isComplete() && this.size() == 1) {
                    ((Section)element).flushContent();
                    return;
                }
                ((Section)element).setAddedCompletely(true);
            }
            iterator.remove();
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void setComplete(boolean bl2) {
        this.complete = bl2;
    }

    public void newPage() {
        this.add(Chunk.NEXTPAGE);
    }
}

