/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.alignment.HorizontalAlignment;
import com.lowagie.text.alignment.VerticalAlignment;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class SimpleCell
extends Rectangle
implements TextElementArray,
PdfPCellEvent {
    public static final boolean ROW = true;
    public static final boolean CELL = false;
    private List<Element> a = new ArrayList<Element>();
    private float b = 0.0f;
    private float c = 0.0f;
    private float d = Float.NaN;
    private float e = Float.NaN;
    private float f = Float.NaN;
    private float g = Float.NaN;
    private float h = Float.NaN;
    private float i = Float.NaN;
    private float j = Float.NaN;
    private float k = Float.NaN;
    private int l = 1;
    private int m = -1;
    private int n = -1;
    private boolean o = false;
    protected boolean useAscender = false;
    protected boolean useDescender = false;
    protected boolean useBorderPadding;

    public SimpleCell(boolean bl2) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.o = bl2;
        this.setBorder(15);
    }

    public void addElement(Element element) {
        if (this.o) {
            if (element instanceof SimpleCell) {
                if (((SimpleCell)element).isCellgroup()) {
                    throw new BadElementException(MessageLocalization.getComposedMessage("you.can.t.add.one.row.to.another.row"));
                }
                this.a.add(element);
                return;
            }
            throw new BadElementException(MessageLocalization.getComposedMessage("you.can.only.add.cells.to.rows.no.objects.of.type.1", element.getClass().getName()));
        }
        if (element.type() == 12 || element.type() == 11 || element.type() == 17 || element.type() == 10 || element.type() == 14 || element.type() == 50 || element.type() == 32 || element.type() == 33 || element.type() == 36 || element.type() == 34 || element.type() == 35) {
            this.a.add(element);
            return;
        }
        throw new BadElementException(MessageLocalization.getComposedMessage("you.can.t.add.an.element.of.type.1.to.a.simplecell", element.getClass().getName()));
    }

    public Cell createCell(SimpleCell object2) {
        Cell cell = new Cell();
        cell.cloneNonPositionParameters((Rectangle)object2);
        cell.softCloneNonPositionParameters(this);
        cell.setColspan(this.l);
        Optional<HorizontalAlignment> optional = HorizontalAlignment.of(this.m);
        cell.setHorizontalAlignment(optional.orElse(HorizontalAlignment.UNDEFINED));
        Optional<VerticalAlignment> optional2 = VerticalAlignment.of(this.n);
        cell.setVerticalAlignment(optional2.orElse(VerticalAlignment.UNDEFINED));
        cell.setUseAscender(this.useAscender);
        cell.setUseBorderPadding(this.useBorderPadding);
        cell.setUseDescender(this.useDescender);
        Iterator<Element> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            Element element;
            Element element2 = element = iterator.next();
            cell.addElement(element2);
        }
        return cell;
    }

    public PdfPCell createPdfPCell(SimpleCell simpleCell) {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setBorder(0);
        SimpleCell simpleCell2 = new SimpleCell(false);
        simpleCell2.setSpacing_left(this.d);
        simpleCell2.setSpacing_right(this.e);
        simpleCell2.setSpacing_top(this.f);
        simpleCell2.setSpacing_bottom(this.g);
        simpleCell2.cloneNonPositionParameters(simpleCell);
        simpleCell2.softCloneNonPositionParameters(this);
        pdfPCell.setCellEvent(simpleCell2);
        pdfPCell.setHorizontalAlignment(simpleCell.m);
        pdfPCell.setVerticalAlignment(simpleCell.n);
        pdfPCell.setUseAscender(simpleCell.useAscender);
        pdfPCell.setUseBorderPadding(simpleCell.useBorderPadding);
        pdfPCell.setUseDescender(simpleCell.useDescender);
        pdfPCell.setColspan(this.l);
        if (this.m != -1) {
            pdfPCell.setHorizontalAlignment(this.m);
        }
        if (this.n != -1) {
            pdfPCell.setVerticalAlignment(this.n);
        }
        if (this.useAscender) {
            pdfPCell.setUseAscender(this.useAscender);
        }
        if (this.useBorderPadding) {
            pdfPCell.setUseBorderPadding(this.useBorderPadding);
        }
        if (this.useDescender) {
            pdfPCell.setUseDescender(this.useDescender);
        }
        if (Float.isNaN(f6 = this.d)) {
            f6 = 0.0f;
        }
        if (Float.isNaN(f5 = this.e)) {
            f5 = 0.0f;
        }
        if (Float.isNaN(f4 = this.f)) {
            f4 = 0.0f;
        }
        if (Float.isNaN(f3 = this.g)) {
            f3 = 0.0f;
        }
        if (Float.isNaN(f2 = this.h)) {
            f2 = 0.0f;
        }
        pdfPCell.setPaddingLeft(f2 + f6);
        f2 = this.i;
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        pdfPCell.setPaddingRight(f2 + f5);
        f2 = this.j;
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        pdfPCell.setPaddingTop(f2 + f4);
        f2 = this.k;
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        pdfPCell.setPaddingBottom(f2 + f3);
        for (Element element : this.a) {
            pdfPCell.addElement(element);
        }
        return pdfPCell;
    }

    @Override
    public void cellLayout(PdfPCell pdfPCell, Rectangle rectangle, PdfContentByte[] pdfContentByteArray) {
        float f2;
        float f3;
        float f4;
        float f5 = this.d;
        if (Float.isNaN(f5)) {
            f5 = 0.0f;
        }
        if (Float.isNaN(f4 = this.e)) {
            f4 = 0.0f;
        }
        if (Float.isNaN(f3 = this.f)) {
            f3 = 0.0f;
        }
        if (Float.isNaN(f2 = this.g)) {
            f2 = 0.0f;
        }
        Rectangle rectangle2 = new Rectangle(rectangle.getLeft(f5), rectangle.getBottom(f2), rectangle.getRight(f4), rectangle.getTop(f3));
        rectangle2.cloneNonPositionParameters(this);
        pdfContentByteArray[1].rectangle(rectangle2);
        rectangle2.setBackgroundColor(null);
        pdfContentByteArray[2].rectangle(rectangle2);
    }

    public void setPadding(float f2) {
        if (Float.isNaN(this.i)) {
            this.setPadding_right(f2);
        }
        if (Float.isNaN(this.h)) {
            this.setPadding_left(f2);
        }
        if (Float.isNaN(this.j)) {
            this.setPadding_top(f2);
        }
        if (Float.isNaN(this.k)) {
            this.setPadding_bottom(f2);
        }
    }

    public int getColspan() {
        return this.l;
    }

    public void setColspan(int n2) {
        if (n2 > 0) {
            this.l = n2;
        }
    }

    public float getPadding_bottom() {
        return this.k;
    }

    public void setPadding_bottom(float f2) {
        this.k = f2;
    }

    public float getPadding_left() {
        return this.h;
    }

    public void setPadding_left(float f2) {
        this.h = f2;
    }

    public float getPadding_right() {
        return this.i;
    }

    public void setPadding_right(float f2) {
        this.i = f2;
    }

    public float getPadding_top() {
        return this.j;
    }

    public void setPadding_top(float f2) {
        this.j = f2;
    }

    public float getSpacing_left() {
        return this.d;
    }

    public float getSpacing_right() {
        return this.e;
    }

    public float getSpacing_top() {
        return this.f;
    }

    public float getSpacing_bottom() {
        return this.g;
    }

    public void setSpacing(float f2) {
        this.d = f2;
        this.e = f2;
        this.f = f2;
        this.g = f2;
    }

    public void setSpacing_left(float f2) {
        this.d = f2;
    }

    public void setSpacing_right(float f2) {
        this.e = f2;
    }

    public void setSpacing_top(float f2) {
        this.f = f2;
    }

    public void setSpacing_bottom(float f2) {
        this.g = f2;
    }

    public boolean isCellgroup() {
        return this.o;
    }

    public void setCellgroup(boolean bl2) {
        this.o = bl2;
    }

    public int getHorizontalAlignment() {
        return this.m;
    }

    public void setHorizontalAlignment(int n2) {
        this.m = n2;
    }

    public int getVerticalAlignment() {
        return this.n;
    }

    public void setVerticalAlignment(int n2) {
        this.n = n2;
    }

    @Override
    public float getWidth() {
        return this.b;
    }

    public void setWidth(float f2) {
        this.b = f2;
    }

    public float getWidthpercentage() {
        return this.c;
    }

    public void setWidthpercentage(float f2) {
        this.c = f2;
    }

    public boolean isUseAscender() {
        return this.useAscender;
    }

    public void setUseAscender(boolean bl2) {
        this.useAscender = bl2;
    }

    public boolean isUseBorderPadding() {
        return this.useBorderPadding;
    }

    public void setUseBorderPadding(boolean bl2) {
        this.useBorderPadding = bl2;
    }

    public boolean isUseDescender() {
        return this.useDescender;
    }

    public void setUseDescender(boolean bl2) {
        this.useDescender = bl2;
    }

    final List<Element> a() {
        return this.a;
    }

    @Override
    public boolean add(Element element) {
        try {
            this.addElement(element);
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (BadElementException badElementException) {
            throw new ExceptionConverter(badElementException);
        }
    }

    @Override
    public int type() {
        return 20;
    }
}

