/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.LargeElement;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.SimpleCell;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.TableRectangle;
import com.lowagie.text.alignment.HorizontalAlignment;
import com.lowagie.text.alignment.VerticalAlignment;
import com.lowagie.text.alignment.WithHorizontalAlignment;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPTableEvent;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;

public class Table
extends TableRectangle
implements LargeElement,
WithHorizontalAlignment {
    private int a;
    private ArrayList<Row> b = new ArrayList();
    private Point c = new Point(0, 0);
    private Cell d = new Cell(true);
    private int e = -1;
    private int f = 1;
    private float g;
    private float h;
    private float i = 80.0f;
    private boolean j = false;
    private float[] k;
    private boolean l = false;
    protected boolean autoFillEmptyCells = false;
    private boolean m = false;
    private boolean n = false;
    private float o = Float.NaN;
    protected boolean convert2pdfptable = false;
    protected boolean notAddedYet = true;
    protected boolean complete = true;

    public Table(int n2) {
        this(n2, 1);
    }

    public Table(int n2, int n3) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(15);
        this.setBorderWidth(1.0f);
        this.d.setBorder(15);
        if (n2 <= 0) {
            throw new BadElementException(MessageLocalization.getComposedMessage("a.table.should.have.at.least.1.column"));
        }
        this.a = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.b.add(new Row(n2));
        }
        this.c = new Point(0, 0);
        this.k = new float[n2];
        float f2 = 100.0f / (float)n2;
        for (n3 = 0; n3 < n2; ++n3) {
            this.k[n3] = f2;
        }
    }

    public Table(Table table) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.cloneNonPositionParameters(table);
        this.a = table.a;
        this.b = table.b;
        this.c = table.c;
        this.d = table.d;
        this.e = table.e;
        this.f = table.f;
        this.g = table.g;
        this.h = table.h;
        this.i = table.i;
        this.k = table.k;
        this.autoFillEmptyCells = table.autoFillEmptyCells;
        this.m = table.m;
        this.n = table.n;
        this.o = table.o;
        this.convert2pdfptable = table.convert2pdfptable;
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    @Override
    public int type() {
        return 22;
    }

    @Override
    public ArrayList<Element> getChunks() {
        return new ArrayList<Element>();
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    public int getColumns() {
        return this.a;
    }

    public int size() {
        return this.b.size();
    }

    public Dimension getDimension() {
        return new Dimension(this.a, this.size());
    }

    public Cell getDefaultCell() {
        return this.d;
    }

    public void setDefaultCell(Cell cell) {
        this.d = cell;
    }

    public int getLastHeaderRow() {
        return this.e;
    }

    public void setLastHeaderRow(int n2) {
        this.e = n2;
    }

    public int endHeaders() {
        this.e = this.c.x - 1;
        return this.e;
    }

    public int getAlignment() {
        return this.f;
    }

    public void setAlignment(int n2) {
        this.f = n2;
    }

    public void setAlignment(String string) {
        if ("Left".equalsIgnoreCase(string)) {
            this.f = 0;
            return;
        }
        if ("right".equalsIgnoreCase(string)) {
            this.f = 2;
            return;
        }
        this.f = 1;
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            return;
        }
        this.f = horizontalAlignment.getId();
    }

    public float getPadding() {
        return this.g;
    }

    public void setPadding(float f2) {
        this.g = f2;
    }

    public float getSpacing() {
        return this.h;
    }

    public void setSpacing(float f2) {
        this.h = f2;
    }

    public void setAutoFillEmptyCells(boolean bl2) {
        this.autoFillEmptyCells = bl2;
    }

    @Override
    public float getWidth() {
        return this.i;
    }

    public void setWidth(float f2) {
        this.i = f2;
    }

    public boolean isLocked() {
        return this.j;
    }

    public void setLocked(boolean bl2) {
        this.j = bl2;
    }

    public float[] getProportionalWidths() {
        return this.k;
    }

    public void setWidths(float[] fArray) {
        if (fArray.length != this.a) {
            throw new BadElementException(MessageLocalization.getComposedMessage("wrong.number.of.columns"));
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.a; ++i2) {
            f2 += fArray[i2];
        }
        this.k[this.a - 1] = 100.0f;
        for (int i3 = 0; i3 < this.a - 1; ++i3) {
            float f3;
            this.k[i3] = f3 = 100.0f * fArray[i3] / f2;
            int n2 = this.a - 1;
            this.k[n2] = this.k[n2] - f3;
        }
    }

    public void setWidths(int[] nArray) {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2];
        }
        this.setWidths(fArray);
    }

    public boolean isTableFitsPage() {
        return this.m;
    }

    public void setTableFitsPage(boolean bl2) {
        this.m = bl2;
        if (bl2) {
            this.setCellsFitPage(true);
        }
    }

    public boolean isCellsFitPage() {
        return this.n;
    }

    public void setCellsFitPage(boolean bl2) {
        this.n = bl2;
    }

    public void setOffset(float f2) {
        this.o = f2;
    }

    public float getOffset() {
        return this.o;
    }

    public boolean isConvert2pdfptable() {
        return this.convert2pdfptable;
    }

    public void setConvert2pdfptable(boolean bl2) {
        this.convert2pdfptable = bl2;
    }

    public void addCell(Cell cell, int n2, int n3) {
        this.addCell(cell, new Point(n2, n3));
    }

    public void addCell(Cell cell, Point point) {
        boolean bl2;
        block9: {
            block12: {
                Table table;
                Cell cell2;
                Point point2;
                block10: {
                    block11: {
                        if (cell == null) {
                            throw new NullPointerException(MessageLocalization.getComposedMessage("addcell.cell.has.null.value"));
                        }
                        if (point == null) {
                            throw new NullPointerException(MessageLocalization.getComposedMessage("addcell.point.has.null.value"));
                        }
                        if (cell.isTable()) {
                            this.insertTable((Table)cell.getElements().next(), point);
                        }
                        if (point.x < 0) {
                            throw new BadElementException(MessageLocalization.getComposedMessage("row.coordinate.of.location.must.be.gt.eq.0"));
                        }
                        if (point.y <= 0 && point.y > this.a) {
                            throw new BadElementException(MessageLocalization.getComposedMessage("column.coordinate.of.location.must.be.gt.eq.0.and.lt.nr.of.columns"));
                        }
                        point2 = point;
                        cell2 = cell;
                        table = this;
                        if (point2.x >= table.b.size()) break block10;
                        if (point2.y + cell2.getColspan() <= table.a) break block11;
                        bl2 = false;
                        break block9;
                    }
                    int n2 = table.b.size() - point2.x > cell2.getRowspan() ? cell2.getRowspan() : table.b.size() - point2.x;
                    int n3 = table.a - point2.y > cell2.getColspan() ? cell2.getColspan() : table.a - point2.y;
                    for (int i2 = point2.x; i2 < point2.x + n2; ++i2) {
                        for (int i3 = point2.y; i3 < point2.y + n3; ++i3) {
                            if (!table.b.get(i2).b(i3)) continue;
                            bl2 = false;
                            break block9;
                        }
                    }
                    break block12;
                }
                bl2 = point2.y + cell2.getColspan() <= table.a;
                break block9;
            }
            bl2 = true;
        }
        if (!bl2) {
            throw new BadElementException(MessageLocalization.getComposedMessage("adding.a.cell.at.the.location.1.2.with.a.colspan.of.3.and.a.rowspan.of.4.is.illegal.beyond.boundaries.overlapping", String.valueOf(point.x), String.valueOf(point.y), String.valueOf(cell.getColspan()), String.valueOf(cell.getRowspan())));
        }
        if (cell.getBorder() == -1) {
            cell.setBorder(this.d.getBorder());
        }
        cell.a();
        Table table = this;
        table.a(table.b, cell, point);
        this.a(point);
    }

    public void addCell(Cell cell) {
        try {
            this.addCell(cell, this.c);
            return;
        }
        catch (BadElementException badElementException) {
            return;
        }
    }

    public void addCell(Phrase phrase) {
        this.addCell(phrase, this.c);
    }

    public void addCell(Phrase textElementArray, Point point) {
        textElementArray = new Cell(textElementArray);
        ((Rectangle)((Object)textElementArray)).setBorder(this.d.getBorder());
        ((Rectangle)((Object)textElementArray)).setBorderWidth(this.d.getBorderWidth());
        ((Rectangle)((Object)textElementArray)).setBorderColor(this.d.getBorderColor());
        ((Rectangle)((Object)textElementArray)).setBackgroundColor(this.d.getBackgroundColor());
        Optional<Enum> optional = HorizontalAlignment.of(this.d.getHorizontalAlignment());
        ((Cell)textElementArray).setHorizontalAlignment(optional.orElse(HorizontalAlignment.UNDEFINED));
        optional = VerticalAlignment.of(this.d.getVerticalAlignment());
        ((Cell)textElementArray).setVerticalAlignment((VerticalAlignment)((Object)optional.orElse((HorizontalAlignment)((Object)VerticalAlignment.UNDEFINED))));
        ((Cell)textElementArray).setColspan(this.d.getColspan());
        ((Cell)textElementArray).setRowspan(this.d.getRowspan());
        this.addCell((Cell)textElementArray, point);
    }

    public void addCell(String string) {
        this.addCell(new Phrase(string), this.c);
    }

    public void addCell(String string, Point point) {
        this.addCell(new Phrase(string), point);
    }

    public void insertTable(Table table) {
        if (table == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("inserttable.table.has.null.value"));
        }
        this.insertTable(table, this.c);
    }

    public void insertTable(Table table, int n2, int n3) {
        if (table == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("inserttable.table.has.null.value"));
        }
        this.insertTable(table, new Point(n2, n3));
    }

    public void insertTable(Table table, Point point) {
        if (table == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("inserttable.table.has.null.value"));
        }
        if (point == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("inserttable.point.has.null.value"));
        }
        this.l = true;
        table.complete();
        if (point.y > this.a) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("inserttable.wrong.columnposition.1.of.location.max.eq.2", String.valueOf(point.y), String.valueOf(this.a)));
        }
        int n2 = point.x + 1 - this.b.size();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.b.add(new Row(this.a));
            }
        }
        this.b.get(point.x).b(table, point.y);
        this.a(point);
    }

    public void addColumns(int n2) {
        int n3;
        ArrayList<Row> arrayList = new ArrayList<Row>(this.b.size());
        n2 = this.a + n2;
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            Row row = new Row(n2);
            for (n3 = 0; n3 < this.a; ++n3) {
                row.b(this.b.get(i2).getCell(n3), n3);
            }
            for (n3 = this.a; n3 < n2 && i2 < this.c.x; ++n3) {
                row.b(null, n3);
            }
            arrayList.add(row);
        }
        float[] fArray = new float[n2];
        System.arraycopy(this.k, 0, fArray, 0, this.a);
        for (n3 = this.a; n3 < n2; ++n3) {
            fArray[n3] = 0.0f;
        }
        this.a = n2;
        this.k = fArray;
        this.b = arrayList;
    }

    public void deleteColumn(int n2) {
        Object object = new float[--this.a];
        System.arraycopy(this.k, 0, object, 0, n2);
        System.arraycopy(this.k, n2 + 1, object, n2, this.a - n2);
        this.setWidths((float[])object);
        System.arraycopy(this.k, 0, object, 0, this.a);
        this.k = object;
        int n3 = this.b.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Row row = this.b.get(i2);
            object = row;
            row.a(n2);
            this.b.set(i2, (Row)object);
        }
        if (n2 == this.a) {
            this.c.setLocation(this.c.x + 1, 0);
        }
    }

    public boolean deleteRow(int n2) {
        if (n2 < 0 || n2 >= this.b.size()) {
            return false;
        }
        this.b.remove(n2);
        this.c.setLocation(this.c.x - 1, this.c.y);
        return true;
    }

    public void deleteAllRows() {
        this.b.clear();
        this.b.add(new Row(this.a));
        this.c.setLocation(0, 0);
        this.e = -1;
    }

    public boolean deleteLastRow() {
        Table table = this;
        return table.deleteRow(table.b.size() - 1);
    }

    public void complete() {
        int n2;
        int n3;
        Table table;
        if (this.l) {
            int n4;
            int n5;
            int n6;
            Table table2;
            int n7;
            table = this;
            int[] nArray = new int[table.a];
            float[][] fArrayArray = new float[table.a][];
            int[] nArray2 = new int[table.b.size()];
            boolean bl2 = false;
            Object object = 0;
            int n8 = 0;
            for (n3 = 0; n3 < table.a; ++n3) {
                n7 = 1;
                float[] fArray = null;
                for (n2 = 0; n2 < table.b.size(); ++n2) {
                    if (!(table.b.get(n2).getCell(n3) instanceof Table)) continue;
                    bl2 = true;
                    table2 = (Table)table.b.get(n2).getCell(n3);
                    if (fArray == null) {
                        fArray = table2.k;
                        n7 = table2.k.length;
                        continue;
                    }
                    n6 = table2.getDimension().width;
                    float[] fArray2 = new float[n6 * fArray.length];
                    float f2 = 0.0f;
                    n5 = 0;
                    n4 = 0;
                    int n9 = 0;
                    float f3 = 0.0f + fArray[0];
                    float f4 = 0.0f + table2.k[0];
                    while (n5 < fArray.length && n4 < n6) {
                        if (f4 > f3) {
                            fArray2[n9] = f3 - f2;
                            if (++n5 < fArray.length) {
                                f3 += fArray[n5];
                            }
                        } else {
                            fArray2[n9] = f4 - f2;
                            ++n4;
                            if ((double)Math.abs(f4 - f3) < 1.0E-4 && ++n5 < fArray.length) {
                                f3 += fArray[n5];
                            }
                            if (n4 < n6) {
                                f4 += table2.k[n4];
                            }
                        }
                        f2 += fArray2[n9];
                        ++n9;
                    }
                    fArray = new float[n9];
                    System.arraycopy(fArray2, 0, fArray, 0, n9);
                    n7 = n9;
                }
                fArrayArray[n3] = fArray;
                n8 += n7;
                nArray[n3] = n7;
            }
            for (n2 = 0; n2 < table.b.size(); ++n2) {
                n7 = 1;
                for (n3 = 0; n3 < table.a; ++n3) {
                    if (!(table.b.get(n2).getCell(n3) instanceof Table)) continue;
                    bl2 = true;
                    table2 = (Table)table.b.get(n2).getCell(n3);
                    if (table2.getDimension().height <= n7) continue;
                    n7 = table2.getDimension().height;
                }
                object += n7;
                nArray2[n2] = n7;
            }
            if (n8 != table.a || object != table.b.size() || bl2) {
                float[] fArray = new float[n8];
                int n10 = 0;
                for (n6 = 0; n6 < table.k.length; ++n6) {
                    if (nArray[n6] != 1) {
                        for (int i2 = 0; i2 < nArray[n6]; ++i2) {
                            fArray[n10] = table.k[n6] * fArrayArray[n6][i2] / 100.0f;
                            ++n10;
                        }
                        continue;
                    }
                    fArray[n10] = table.k[n6];
                    ++n10;
                }
                ArrayList<Row> arrayList = new ArrayList<Row>((int)object);
                for (n2 = 0; n2 < object; ++n2) {
                    arrayList.add(new Row(n8));
                }
                n6 = 0;
                for (n2 = 0; n2 < table.b.size(); ++n2) {
                    int n11 = 0;
                    for (n3 = 0; n3 < table.a; ++n3) {
                        Object object2;
                        if (table.b.get(n2).getCell(n3) instanceof Table) {
                            Object object3;
                            table2 = (Table)table.b.get(n2).getCell(n3);
                            object2 = new int[table2.k.length + 1];
                            n5 = 0;
                            for (object3 = 0; object3 < table2.k.length; ++object3) {
                                object2[object3] = n11 + n5;
                                float f5 = table2.k[object3];
                                float f6 = 0.0f;
                                while (n5 < nArray[n3]) {
                                    int n12 = n5++;
                                    if (!((double)Math.abs(f5 - (f6 += fArrayArray[n3][n12])) < 1.0E-4)) continue;
                                }
                            }
                            object2[object3] = n11 + n5;
                            for (n4 = 0; n4 < table2.getDimension().height; ++n4) {
                                for (int i3 = 0; i3 < table2.getDimension().width; ++i3) {
                                    TableRectangle tableRectangle = table2.getElement(n4, i3);
                                    if (tableRectangle == null) continue;
                                    object = n11 + i3;
                                    if (tableRectangle instanceof Cell) {
                                        Cell cell = (Cell)tableRectangle;
                                        object = object2[i3];
                                        object3 = object2[i3 + cell.getColspan()];
                                        cell.setColspan(object3 - object);
                                    }
                                    arrayList.get(n4 + n6).a(tableRectangle, (int)object);
                                }
                            }
                        } else {
                            object2 = table.getElement(n2, n3);
                            if (object2 instanceof Cell) {
                                ((Cell)object2).setRowspan(((Cell)table.b.get(n2).getCell(n3)).getRowspan() + nArray2[n2] - 1);
                                ((Cell)object2).setColspan(((Cell)table.b.get(n2).getCell(n3)).getColspan() + nArray[n3] - 1);
                                table.a(arrayList, (Cell)object2, new Point(n6, n11));
                            }
                        }
                        n11 += nArray[n3];
                    }
                    n6 += nArray2[n2];
                }
                table.a = n8;
                table.b = arrayList;
                table.k = fArray;
            }
            this.l = false;
        }
        if (this.autoFillEmptyCells) {
            table = this;
            try {
                for (n2 = 0; n2 < table.b.size(); ++n2) {
                    for (n3 = 0; n3 < table.a; ++n3) {
                        if (table.b.get(n2).b(n3)) continue;
                        Table table3 = table;
                        table3.addCell(table3.d, new Point(n2, n3));
                    }
                }
                return;
            }
            catch (BadElementException badElementException) {
                throw new ExceptionConverter(badElementException);
            }
        }
    }

    public TableRectangle getElement(int n2, int n3) {
        return this.b.get(n2).getCell(n3);
    }

    private void a(Cell cell) {
        Optional<Enum> optional;
        if (cell.getBorder() == -1) {
            cell.setBorder(this.d.getBorder());
        }
        if (cell.getBorderWidth() == -1.0f) {
            cell.setBorderWidth(this.d.getBorderWidth());
        }
        if (cell.getBorderColor() == null) {
            cell.setBorderColor(this.d.getBorderColor());
        }
        if (cell.getBackgroundColor() == null) {
            cell.setBackgroundColor(this.d.getBackgroundColor());
        }
        if (cell.getHorizontalAlignment() == -1) {
            optional = HorizontalAlignment.of(this.d.getHorizontalAlignment());
            cell.setHorizontalAlignment(optional.orElse(HorizontalAlignment.UNDEFINED));
        }
        if (cell.getVerticalAlignment() == -1) {
            optional = VerticalAlignment.of(this.d.getVerticalAlignment());
            cell.setVerticalAlignment((VerticalAlignment)((Object)optional.orElse((HorizontalAlignment)((Object)VerticalAlignment.UNDEFINED))));
        }
    }

    private void a(ArrayList<Row> arrayList, Cell cell, Point point) {
        Row row;
        int n2;
        int n3 = point.x + cell.getRowspan() - arrayList.size();
        this.a(cell);
        if (point.x + cell.getRowspan() > arrayList.size()) {
            for (n2 = 0; n2 < n3; ++n2) {
                row = new Row(this.a);
                arrayList.add(row);
            }
        }
        for (n2 = point.x + 1; n2 < point.x + cell.getRowspan(); ++n2) {
            if (arrayList.get(n2).a(point.y, cell.getColspan())) continue;
            throw new RuntimeException(MessageLocalization.getComposedMessage("addcell.error.in.reserve"));
        }
        row = arrayList.get(point.x);
        row.a(cell, point.y);
    }

    private void a(Point point) {
        int n2 = point.x;
        int n3 = point.y;
        do {
            if (n3 + 1 == this.a) {
                ++n2;
                n3 = 0;
                continue;
            }
            ++n3;
        } while (n2 < this.b.size() && n3 < this.a && this.b.get(n2).b(n3));
        this.c = new Point(n2, n3);
    }

    public float[] getWidths(float f2, float f3) {
        float[] fArray = new float[this.a + 1];
        float f4 = this.j ? 100.0f * this.i / f3 : this.i;
        switch (this.f) {
            case 0: {
                fArray[0] = f2;
                break;
            }
            case 2: {
                fArray[0] = f2 + f3 * (100.0f - f4) / 100.0f;
                break;
            }
            default: {
                fArray[0] = f2 + f3 * (100.0f - f4) / 200.0f;
            }
        }
        f3 = f3 * f4 / 100.0f;
        for (int i2 = 1; i2 < this.a; ++i2) {
            fArray[i2] = fArray[i2 - 1] + this.k[i2 - 1] * f3 / 100.0f;
        }
        fArray[this.a] = fArray[0] + f3;
        return fArray;
    }

    public Iterator iterator() {
        return this.b.iterator();
    }

    public PdfPTable createPdfPTable() {
        if (!this.convert2pdfptable) {
            throw new BadElementException(MessageLocalization.getComposedMessage("no.error.just.an.old.style.table"));
        }
        this.setAutoFillEmptyCells(true);
        this.complete();
        PdfPTable pdfPTable = new PdfPTable(this.k);
        pdfPTable.setComplete(this.complete);
        if (this.isNotAddedYet()) {
            pdfPTable.setSkipFirstHeader(true);
        }
        Element element = new SimpleTable();
        ((Rectangle)element).cloneNonPositionParameters(this);
        ((SimpleTable)element).setCellspacing(this.h);
        pdfPTable.setTableEvent((PdfPTableEvent)((Object)element));
        pdfPTable.setHeaderRows(this.e + 1);
        pdfPTable.setSplitLate(this.n);
        pdfPTable.setKeepTogether(this.m);
        if (!Float.isNaN(this.o)) {
            pdfPTable.setSpacingBefore(this.o);
        }
        pdfPTable.setHorizontalAlignment(this.f);
        if (this.j) {
            pdfPTable.setTotalWidth(this.i);
            pdfPTable.setLockedWidth(true);
        } else {
            pdfPTable.setWidthPercentage(this.i);
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            element = (Row)iterator.next();
            for (int i2 = 0; i2 < ((Row)element).getColumns(); ++i2) {
                PdfPCell pdfPCell;
                TableRectangle tableRectangle = ((Row)element).getCell(i2);
                if (tableRectangle == null) continue;
                if (tableRectangle instanceof Table) {
                    pdfPCell = new PdfPCell(((Table)tableRectangle).createPdfPTable());
                } else if (tableRectangle instanceof Cell) {
                    pdfPCell = ((Cell)tableRectangle).createPdfPCell();
                    pdfPCell.setPadding(this.g + this.h / 2.0f);
                    SimpleCell simpleCell = new SimpleCell(false);
                    simpleCell.cloneNonPositionParameters((Cell)tableRectangle);
                    simpleCell.setSpacing(this.h * 2.0f);
                    pdfPCell.setCellEvent(simpleCell);
                } else {
                    pdfPCell = new PdfPCell();
                }
                pdfPTable.addCell(pdfPCell);
            }
        }
        return pdfPTable;
    }

    public boolean isNotAddedYet() {
        return this.notAddedYet;
    }

    public void setNotAddedYet(boolean bl2) {
        this.notAddedYet = bl2;
    }

    @Override
    public void flushContent() {
        this.setNotAddedYet(false);
        ArrayList<Row> arrayList = new ArrayList<Row>();
        for (int i2 = 0; i2 < this.getLastHeaderRow() + 1; ++i2) {
            arrayList.add(this.b.get(i2));
        }
        this.b = arrayList;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void setComplete(boolean bl2) {
        this.complete = bl2;
    }

    public Cell getDefaultLayout() {
        return this.getDefaultCell();
    }

    public void setDefaultLayout(Cell cell) {
        this.d = cell;
    }
}

