/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.pdf.PRTokeniser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Utilities {
    public static Set<String> getKeySet(Map<String, ?> map) {
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    public static Object[][] addToArray(Object[][] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            Object[][] objectArrayArray = new Object[1][];
            objectArray = objectArrayArray;
            objectArrayArray[0] = objectArray2;
            return objectArray;
        }
        Object[][] objectArray3 = new Object[objectArray.length + 1][];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        objectArray3[objectArray.length] = objectArray2;
        return objectArray3;
    }

    public static boolean checkTrueOrFalse(Properties properties, String string) {
        return "true".equalsIgnoreCase(properties.getProperty(string));
    }

    public static String unEscapeURL(String object) {
        StringBuilder stringBuilder = new StringBuilder();
        object = ((String)object).toCharArray();
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            Object object2 = object[i2];
            if (object2 == 37) {
                if (i2 + 2 >= ((Object)object).length) {
                    stringBuilder.append((char)object2);
                    continue;
                }
                int n2 = PRTokeniser.getHex((int)object[i2 + 1]);
                int n3 = PRTokeniser.getHex((int)object[i2 + 2]);
                if (n2 < 0 || n3 < 0) {
                    stringBuilder.append((char)object2);
                    continue;
                }
                stringBuilder.append((char)((n2 << 4) + n3));
                i2 += 2;
                continue;
            }
            stringBuilder.append((char)object2);
        }
        return stringBuilder.toString();
    }

    public static URL toURL(String string) {
        try {
            return new URL(string);
        }
        catch (Exception exception) {
            return new File(string).toURI().toURL();
        }
    }

    public static void skip(InputStream inputStream, int n2) {
        long l2;
        while (n2 > 0 && (l2 = inputStream.skip(n2)) > 0L) {
            n2 = (int)((long)n2 - l2);
        }
    }

    public static float millimetersToPoints(float f2) {
        return Utilities.inchesToPoints(Utilities.millimetersToInches(f2));
    }

    public static float millimetersToInches(float f2) {
        return f2 / 25.4f;
    }

    public static float pointsToMillimeters(float f2) {
        return Utilities.inchesToMillimeters(Utilities.pointsToInches(f2));
    }

    public static float pointsToInches(float f2) {
        return f2 / 72.0f;
    }

    public static float inchesToMillimeters(float f2) {
        return f2 * 25.4f;
    }

    public static float inchesToPoints(float f2) {
        return f2 * 72.0f;
    }

    public static boolean isSurrogateHigh(char c2) {
        return c2 >= '\ud800' && c2 <= '\udbff';
    }

    public static boolean isSurrogateLow(char c2) {
        return c2 >= '\udc00' && c2 <= '\udfff';
    }

    public static boolean isSurrogatePair(String string, int n2) {
        if (n2 < 0 || n2 > string.length() - 2) {
            return false;
        }
        return Utilities.isSurrogateHigh(string.charAt(n2)) && Utilities.isSurrogateLow(string.charAt(n2 + 1));
    }

    public static boolean isSurrogatePair(char[] cArray, int n2) {
        if (n2 < 0 || n2 > cArray.length - 2) {
            return false;
        }
        return Utilities.isSurrogateHigh(cArray[n2]) && Utilities.isSurrogateLow(cArray[n2 + 1]);
    }

    public static int convertToUtf32(char c2, char c3) {
        return (c2 - 55296 << 10) + (c3 - 56320) + 65536;
    }

    public static int convertToUtf32(char[] cArray, int n2) {
        return (cArray[n2] - 55296 << 10) + (cArray[n2 + 1] - 56320) + 65536;
    }

    public static int convertToUtf32(String string, int n2) {
        return (string.charAt(n2) - 55296 << 10) + (string.charAt(n2 + 1) - 56320) + 65536;
    }

    public static String convertFromUtf32(int n2) {
        if (n2 < 65536) {
            return Character.toString((char)n2);
        }
        return new String(new char[]{(char)((n2 -= 65536) / 1024 + 55296), (char)(n2 % 1024 + 56320)});
    }

    public static byte[] toByteArray(InputStream inputStream) {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

