/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.factories;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.ChapterAutoNumber;
import com.lowagie.text.Chunk;
import com.lowagie.text.ElementTags;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.TableRectangle;
import com.lowagie.text.Utilities;
import com.lowagie.text.alignment.HorizontalAlignment;
import com.lowagie.text.alignment.VerticalAlignment;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.html.Markup;
import java.awt.Color;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class ElementFactory {
    public static Chunk getChunk(Properties properties) {
        Chunk chunk = new Chunk();
        chunk.setFont(FontFactory.getFont(properties));
        String string = properties.getProperty("itext");
        if (string != null) {
            chunk.append(string);
        }
        if ((string = properties.getProperty(ElementTags.LOCALGOTO)) != null) {
            chunk.setLocalGoto(string);
        }
        if ((string = properties.getProperty(ElementTags.REMOTEGOTO)) != null) {
            String string2 = properties.getProperty("page");
            if (string2 != null) {
                chunk.setRemoteGoto(string, Integer.parseInt(string2));
            } else {
                string2 = properties.getProperty("destination");
                if (string2 != null) {
                    chunk.setRemoteGoto(string, string2);
                }
            }
        }
        if ((string = properties.getProperty(ElementTags.LOCALDESTINATION)) != null) {
            chunk.setLocalDestination(string);
        }
        if ((string = properties.getProperty(ElementTags.SUBSUPSCRIPT)) != null) {
            chunk.setTextRise(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("vertical-align")) != null && string.endsWith("%")) {
            float f2 = Float.parseFloat(string.substring(0, string.length() - 1) + "f") / 100.0f;
            chunk.setTextRise(f2 * chunk.getFont().getSize());
        }
        if ((string = properties.getProperty(ElementTags.GENERICTAG)) != null) {
            chunk.setGenericTag(string);
        }
        if ((string = properties.getProperty("backgroundcolor")) != null) {
            chunk.setBackground(Markup.decodeColor(string));
        }
        return chunk;
    }

    public static Phrase getPhrase(Properties properties) {
        Phrase phrase = new Phrase();
        phrase.setFont(FontFactory.getFont(properties));
        String string = properties.getProperty("leading");
        if (string != null) {
            phrase.setLeading(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("line-height")) != null) {
            phrase.setLeading(Markup.parseLength(string, 12.0f));
        }
        if ((string = properties.getProperty("itext")) != null) {
            Chunk chunk = new Chunk(string);
            string = properties.getProperty(ElementTags.GENERICTAG);
            if (string != null) {
                chunk.setGenericTag(string);
            }
            phrase.add(chunk);
        }
        return phrase;
    }

    public static Anchor getAnchor(Properties properties) {
        Anchor anchor = new Anchor(ElementFactory.getPhrase(properties));
        String string = properties.getProperty("name");
        if (string != null) {
            anchor.setName(string);
        }
        if ((string = (String)properties.remove("reference")) != null) {
            anchor.setReference(string);
        }
        return anchor;
    }

    public static Paragraph getParagraph(Properties properties) {
        Paragraph paragraph = new Paragraph(ElementFactory.getPhrase(properties));
        String string = properties.getProperty("align");
        if (string != null) {
            paragraph.setAlignment(string);
        }
        if ((string = properties.getProperty("indentationleft")) != null) {
            paragraph.setIndentationLeft(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("indentationright")) != null) {
            paragraph.setIndentationRight(Float.parseFloat(string + "f"));
        }
        return paragraph;
    }

    public static ListItem getListItem(Properties cloneable) {
        cloneable = new ListItem(ElementFactory.getParagraph(cloneable));
        return cloneable;
    }

    public static List getList(Properties properties) {
        List list = new List();
        list.setNumbered(Utilities.checkTrueOrFalse(properties, "numbered"));
        list.setLettered(Utilities.checkTrueOrFalse(properties, "lettered"));
        list.setLowercase(Utilities.checkTrueOrFalse(properties, "lowercase"));
        list.setAutoindent(Utilities.checkTrueOrFalse(properties, "autoindent"));
        list.setAlignindent(Utilities.checkTrueOrFalse(properties, "alignindent"));
        String string = properties.getProperty("first");
        if (string != null) {
            char c2 = string.charAt(0);
            if (Character.isLetter(c2)) {
                list.setFirst(c2);
            } else {
                list.setFirst(Integer.parseInt(string));
            }
        }
        if ((string = properties.getProperty("listsymbol")) != null) {
            list.setListSymbol(new Chunk(string, FontFactory.getFont(properties)));
        }
        if ((string = properties.getProperty("indentationleft")) != null) {
            list.setIndentationLeft(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("indentationright")) != null) {
            list.setIndentationRight(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("symbolindent")) != null) {
            list.setSymbolIndent(Float.parseFloat(string));
        }
        return list;
    }

    public static Cell getCell(Properties properties) {
        Object object;
        Cell cell = new Cell();
        try {
            if (properties.getProperty("horizontalalign") != null) {
                object = HorizontalAlignment.valueOf(properties.getProperty("horizontalalign"));
                cell.setHorizontalAlignment((HorizontalAlignment)((Object)object));
            } else {
                cell.setHorizontalAlignment(HorizontalAlignment.UNDEFINED);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            cell.setHorizontalAlignment(HorizontalAlignment.UNDEFINED);
        }
        try {
            if (properties.getProperty("verticalalign") != null) {
                object = VerticalAlignment.valueOf(properties.getProperty("verticalalign"));
                cell.setVerticalAlignment((VerticalAlignment)((Object)object));
            } else {
                cell.setVerticalAlignment(VerticalAlignment.UNDEFINED);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            cell.setVerticalAlignment(VerticalAlignment.UNDEFINED);
        }
        object = properties.getProperty("width");
        if (object != null) {
            cell.setWidth((String)object);
        }
        if ((object = properties.getProperty("colspan")) != null) {
            cell.setColspan(Integer.parseInt((String)object));
        }
        if ((object = properties.getProperty("rowspan")) != null) {
            cell.setRowspan(Integer.parseInt((String)object));
        }
        if ((object = properties.getProperty("leading")) != null) {
            cell.setLeading(Float.parseFloat((String)object + "f"));
        }
        cell.setHeader(Utilities.checkTrueOrFalse(properties, "header"));
        if (Utilities.checkTrueOrFalse(properties, "nowrap")) {
            cell.setMaxLines(1);
        }
        ElementFactory.a(cell, properties);
        return cell;
    }

    public static Table getTable(Properties properties) {
        try {
            Table table;
            Object object = properties.getProperty("widths");
            if (object != null) {
                object = new StringTokenizer((String)object, ";");
                ArrayList<String> arrayList = new ArrayList<String>();
                while (((StringTokenizer)object).hasMoreTokens()) {
                    arrayList.add(((StringTokenizer)object).nextToken());
                }
                table = new Table(arrayList.size());
                float[] fArray = new float[table.getColumns()];
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    object = (String)arrayList.get(i2);
                    fArray[i2] = Float.parseFloat((String)object + "f");
                }
                table.setWidths(fArray);
            } else {
                object = properties.getProperty("columns");
                try {
                    table = new Table(Integer.parseInt((String)object));
                }
                catch (Exception exception) {
                    table = new Table(1);
                }
            }
            table.setBorder(15);
            table.setBorderWidth(1.0f);
            table.getDefaultCell().setBorder(15);
            object = properties.getProperty("lastHeaderRow");
            if (object != null) {
                table.setLastHeaderRow(Integer.parseInt((String)object));
            }
            if ((object = properties.getProperty("align")) != null) {
                try {
                    object = HorizontalAlignment.valueOf((String)object);
                    table.setHorizontalAlignment((HorizontalAlignment)((Object)object));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    table.setHorizontalAlignment(HorizontalAlignment.UNDEFINED);
                }
            }
            if ((object = properties.getProperty("cellspacing")) != null) {
                table.setSpacing(Float.parseFloat((String)object + "f"));
            }
            if ((object = properties.getProperty("cellpadding")) != null) {
                table.setPadding(Float.parseFloat((String)object + "f"));
            }
            if ((object = properties.getProperty("offset")) != null) {
                table.setOffset(Float.parseFloat((String)object + "f"));
            }
            if ((object = properties.getProperty("width")) != null) {
                if (((String)object).endsWith("%")) {
                    table.setWidth(Float.parseFloat(((String)object).substring(0, ((String)object).length() - 1) + "f"));
                } else {
                    table.setWidth(Float.parseFloat((String)object + "f"));
                    table.setLocked(true);
                }
            }
            table.setTableFitsPage(Utilities.checkTrueOrFalse(properties, "tablefitspage"));
            table.setCellsFitPage(Utilities.checkTrueOrFalse(properties, "cellsfitpage"));
            table.setConvert2pdfptable(Utilities.checkTrueOrFalse(properties, "convert2pdfp"));
            ElementFactory.a(table, properties);
            return table;
        }
        catch (BadElementException badElementException) {
            throw new ExceptionConverter(badElementException);
        }
    }

    private static void a(TableRectangle tableRectangle, Properties properties) {
        int n2;
        int n3;
        String string = properties.getProperty("borderwidth");
        if (string != null) {
            tableRectangle.setBorderWidth(Float.parseFloat(string + "f"));
        }
        int n4 = 0;
        if (Utilities.checkTrueOrFalse(properties, "left")) {
            n4 = 4;
        }
        if (Utilities.checkTrueOrFalse(properties, "right")) {
            n4 |= 8;
        }
        if (Utilities.checkTrueOrFalse(properties, "top")) {
            n4 |= 1;
        }
        if (Utilities.checkTrueOrFalse(properties, "bottom")) {
            n4 |= 2;
        }
        tableRectangle.setBorder(n4);
        String string2 = properties.getProperty("red");
        String string3 = properties.getProperty("green");
        String string4 = properties.getProperty("blue");
        if (string2 != null || string3 != null || string4 != null) {
            n4 = 0;
            n3 = 0;
            n2 = 0;
            if (string2 != null) {
                n4 = Integer.parseInt(string2);
            }
            if (string3 != null) {
                n3 = Integer.parseInt(string3);
            }
            if (string4 != null) {
                n2 = Integer.parseInt(string4);
            }
            tableRectangle.setBorderColor(new Color(n4, n3, n2));
        } else {
            tableRectangle.setBorderColor(Markup.decodeColor(properties.getProperty("bordercolor")));
        }
        string2 = (String)properties.remove("bgred");
        string3 = (String)properties.remove("bggreen");
        string4 = (String)properties.remove("bgblue");
        String string5 = properties.getProperty("backgroundcolor");
        if (string2 != null || string3 != null || string4 != null) {
            int n5 = 0;
            n3 = 0;
            n2 = 0;
            if (string2 != null) {
                n5 = Integer.parseInt(string2);
            }
            if (string3 != null) {
                n3 = Integer.parseInt(string3);
            }
            if (string4 != null) {
                n2 = Integer.parseInt(string4);
            }
            tableRectangle.setBackgroundColor(new Color(n5, n3, n2));
            return;
        }
        if (string5 != null) {
            tableRectangle.setBackgroundColor(Markup.decodeColor(string5));
            return;
        }
        string5 = properties.getProperty("grayfill");
        if (string5 != null) {
            tableRectangle.setGrayFill(Float.parseFloat(string5 + "f"));
        }
    }

    public static ChapterAutoNumber getChapter(Properties properties) {
        ChapterAutoNumber chapterAutoNumber = new ChapterAutoNumber("");
        ElementFactory.a(chapterAutoNumber, properties);
        return chapterAutoNumber;
    }

    public static Section getSection(Section section, Properties properties) {
        section = section.addSection("");
        ElementFactory.a(section, properties);
        return section;
    }

    private static void a(Section section, Properties properties) {
        String string = properties.getProperty("numberdepth");
        if (string != null) {
            section.setNumberDepth(Integer.parseInt(string));
        }
        if ((string = properties.getProperty("indent")) != null) {
            section.setIndentation(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("indentationleft")) != null) {
            section.setIndentationLeft(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("indentationright")) != null) {
            section.setIndentationRight(Float.parseFloat(string + "f"));
        }
    }

    public static Image getImage(Properties properties) {
        String string = properties.getProperty("url");
        if (string == null) {
            throw new MalformedURLException(MessageLocalization.getComposedMessage("the.url.of.the.image.is.missing"));
        }
        Image image = Image.getInstance(string);
        string = properties.getProperty("align");
        int n2 = 0;
        if (string != null) {
            if ("Left".equalsIgnoreCase(string)) {
                n2 = 0;
            } else if ("Right".equalsIgnoreCase(string)) {
                n2 = 2;
            } else if ("Middle".equalsIgnoreCase(string)) {
                n2 = 1;
            }
        }
        if ("true".equalsIgnoreCase(properties.getProperty("underlying"))) {
            n2 |= 8;
        }
        if ("true".equalsIgnoreCase(properties.getProperty("textwrap"))) {
            n2 |= 4;
        }
        image.setAlignment(n2);
        string = properties.getProperty("alt");
        if (string != null) {
            image.setAlt(string);
        }
        string = properties.getProperty("absolutex");
        String string2 = properties.getProperty("absolutey");
        if (string != null && string2 != null) {
            image.setAbsolutePosition(Float.parseFloat(string + "f"), Float.parseFloat(string2 + "f"));
        }
        if ((string = properties.getProperty("plainwidth")) != null) {
            image.scaleAbsoluteWidth(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("plainheight")) != null) {
            image.scaleAbsoluteHeight(Float.parseFloat(string + "f"));
        }
        if ((string = properties.getProperty("rotation")) != null) {
            image.setRotation(Float.parseFloat(string + "f"));
        }
        return image;
    }

    public static Annotation getAnnotation(Properties object) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        String string = ((Properties)object).getProperty("llx");
        if (string != null) {
            f2 = Float.parseFloat(string + "f");
        }
        if ((string = ((Properties)object).getProperty("lly")) != null) {
            f3 = Float.parseFloat(string + "f");
        }
        if ((string = ((Properties)object).getProperty("urx")) != null) {
            f4 = Float.parseFloat(string + "f");
        }
        if ((string = ((Properties)object).getProperty("ury")) != null) {
            f5 = Float.parseFloat(string + "f");
        }
        string = ((Properties)object).getProperty("title");
        String string2 = ((Properties)object).getProperty("content");
        if (string != null || string2 != null) {
            return new Annotation(string, string2, f2, f3, f4, f5);
        }
        string = ((Properties)object).getProperty("url");
        if (string != null) {
            return new Annotation(f2, f3, f4, f5, string);
        }
        string = ((Properties)object).getProperty("named");
        if (string != null) {
            return new Annotation(f2, f3, f4, f5, Integer.parseInt(string));
        }
        string = ((Properties)object).getProperty("file");
        string2 = ((Properties)object).getProperty("destination");
        object = (String)((Properties)object).remove("page");
        if (string != null) {
            if (string2 != null) {
                return new Annotation(f2, f3, f4, f5, string, string2);
            }
            if (object != null) {
                return new Annotation(f2, f3, f4, f5, string, Integer.parseInt((String)object));
            }
        }
        return new Annotation("", "", f2, f3, f4, f5);
    }
}

