/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.factories;

import com.lowagie.text.error_messages.MessageLocalization;

public class RomanAlphabetFactory {
    public static final String getString(int n2) {
        if (n2 <= 0) {
            throw new NumberFormatException(MessageLocalization.getComposedMessage("you.can.t.translate.a.negative.number.into.an.alphabetical.value"));
        }
        --n2;
        int n3 = 1;
        int n4 = 0;
        int n5 = 26;
        while (n2 >= n5 + n4) {
            ++n3;
            n4 += n5;
            n5 *= 26;
        }
        n2 -= n4;
        char[] cArray = new char[n3];
        while (n3 > 0) {
            cArray[--n3] = (char)(97 + n2 % 26);
            n2 /= 26;
        }
        return new String(cArray);
    }

    public static final String getLowerCaseString(int n2) {
        return RomanAlphabetFactory.getString(n2);
    }

    public static final String getUpperCaseString(int n2) {
        return RomanAlphabetFactory.getString(n2).toUpperCase();
    }

    public static final String getString(int n2, boolean bl2) {
        if (bl2) {
            return RomanAlphabetFactory.getLowerCaseString(n2);
        }
        return RomanAlphabetFactory.getUpperCaseString(n2);
    }
}

