/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import java.awt.Color;

public final class HtmlEncoder {
    private static final String[] a;

    private HtmlEncoder() {
    }

    public static String encode(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0100') {
                stringBuilder.append(a[c2]);
                continue;
            }
            stringBuilder.append("&#").append((int)c2).append(';');
        }
        return stringBuilder.toString();
    }

    public static String encode(Color color) {
        StringBuilder stringBuilder = new StringBuilder("#");
        if (color.getRed() < 16) {
            stringBuilder.append('0');
        }
        stringBuilder.append(Integer.toString(color.getRed(), 16));
        if (color.getGreen() < 16) {
            stringBuilder.append('0');
        }
        stringBuilder.append(Integer.toString(color.getGreen(), 16));
        if (color.getBlue() < 16) {
            stringBuilder.append('0');
        }
        stringBuilder.append(Integer.toString(color.getBlue(), 16));
        return stringBuilder.toString();
    }

    public static String getAlignment(int n2) {
        switch (n2) {
            case 0: {
                return "Left";
            }
            case 1: {
                return "Center";
            }
            case 2: {
                return "Right";
            }
            case 3: 
            case 8: {
                return "Justify";
            }
            case 4: {
                return "Top";
            }
            case 5: {
                return "Middle";
            }
            case 6: {
                return "Bottom";
            }
            case 7: {
                return "Baseline";
            }
        }
        return "";
    }

    static {
        int n2;
        a = new String[256];
        for (n2 = 0; n2 < 10; ++n2) {
            HtmlEncoder.a[n2] = "&#00" + n2 + ";";
        }
        for (n2 = 10; n2 < 32; ++n2) {
            HtmlEncoder.a[n2] = "&#0" + n2 + ";";
        }
        n2 = 32;
        while (n2 < 128) {
            int n3 = n2++;
            HtmlEncoder.a[n3] = String.valueOf((char)n3);
        }
        HtmlEncoder.a[9] = "\t";
        HtmlEncoder.a[10] = "<br />\n";
        HtmlEncoder.a[34] = "&quot;";
        HtmlEncoder.a[38] = "&amp;";
        HtmlEncoder.a[60] = "&lt;";
        HtmlEncoder.a[62] = "&gt;";
        for (n2 = 128; n2 < 256; ++n2) {
            HtmlEncoder.a[n2] = "&#" + n2 + ";";
        }
    }
}

