/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Header;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.MarkedObject;
import com.lowagie.text.MarkedSection;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.Section;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.Table;
import com.lowagie.text.TableRectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.html.HtmlEncoder;
import com.lowagie.text.html.HtmlTags;
import com.lowagie.text.pdf.BaseFont;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class HtmlWriter
extends DocWriter {
    public static final byte[] BEGINCOMMENT = HtmlWriter.getISOBytes("<!-- ");
    public static final byte[] ENDCOMMENT = HtmlWriter.getISOBytes(" -->");
    public static final String NBSP = "&nbsp;";
    protected Stack<Font> currentfont = new Stack();
    protected Font standardfont = new Font();
    protected String imagepath = null;
    protected int pageN = 0;
    protected HeaderFooter header = null;
    protected HeaderFooter footer = null;
    protected Properties markup = new Properties();

    protected HtmlWriter(Document document, OutputStream outputStream) {
        super(document, outputStream);
        this.document.addDocListener(this);
        this.pageN = this.document.getPageNumber();
        try {
            outputStream.write(60);
            outputStream.write(HtmlWriter.getISOBytes("html"));
            outputStream.write(62);
            outputStream.write(10);
            outputStream.write(9);
            outputStream.write(60);
            outputStream.write(HtmlWriter.getISOBytes("head"));
            outputStream.write(62);
            return;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public static HtmlWriter getInstance(Document document, OutputStream outputStream) {
        return new HtmlWriter(document, outputStream);
    }

    @Override
    public boolean newPage() {
        try {
            this.writeStart("div");
            this.write(" ");
            this.write("style");
            this.write("=\"");
            this.writeCssProperty("page-break-before", "always");
            this.write("\" /");
            this.os.write(62);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        return true;
    }

    @Override
    public boolean add(Element element) {
        if (this.pause) {
            return false;
        }
        if (this.open && !element.isContent()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("the.document.is.open.you.can.only.add.elements.with.content"));
        }
        try {
            switch (element.type()) {
                case 0: {
                    try {
                        element = (Header)element;
                        if ("stylesheet".equals(((Meta)element).getName())) {
                            this.writeLink((Header)element);
                        } else if ("JavaScript".equals(((Meta)element).getName())) {
                            this.writeJavaScript((Header)element);
                        } else {
                            this.writeHeader((Meta)element);
                        }
                    }
                    catch (ClassCastException classCastException) {}
                    return true;
                }
                case 2: 
                case 3: 
                case 4: {
                    element = (Meta)element;
                    this.writeHeader((Meta)element);
                    return true;
                }
                case 1: {
                    this.addTabs(2);
                    this.writeStart("title");
                    this.os.write(62);
                    this.addTabs(3);
                    this.write(HtmlEncoder.encode(((Meta)element).getContent()));
                    this.addTabs(2);
                    this.writeEnd("title");
                    return true;
                }
                case 7: {
                    this.writeComment("Creator: " + HtmlEncoder.encode(((Meta)element).getContent()));
                    return true;
                }
                case 5: {
                    this.writeComment("Producer: " + HtmlEncoder.encode(((Meta)element).getContent()));
                    return true;
                }
                case 6: {
                    this.writeComment("Creationdate: " + HtmlEncoder.encode(((Meta)element).getContent()));
                    return true;
                }
                case 50: {
                    if (element instanceof MarkedSection) {
                        MarkedSection markedSection = (MarkedSection)element;
                        this.addTabs(1);
                        this.writeStart("div");
                        this.writeMarkupAttributes(markedSection.getMarkupAttributes());
                        this.os.write(62);
                        element = ((MarkedSection)element).getTitle();
                        if (element != null) {
                            this.markup = ((MarkedObject)element).getMarkupAttributes();
                            ((MarkedObject)element).process(this);
                        }
                        ((MarkedObject)markedSection).process(this);
                        this.writeEnd("div");
                        return true;
                    }
                    MarkedObject markedObject = (MarkedObject)element;
                    this.markup = markedObject.getMarkupAttributes();
                    return markedObject.process(this);
                }
            }
            this.write(element, 2);
            return true;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    @Override
    public void open() {
        super.open();
        try {
            this.writeComment(Document.getVersion());
            this.writeComment("CreationDate: " + new Date().toString());
            this.addTabs(1);
            this.writeEnd("head");
            this.addTabs(1);
            this.writeStart("body");
            if (this.document.leftMargin() > 0.0f) {
                this.write("leftmargin", String.valueOf(this.document.leftMargin()));
            }
            if (this.document.rightMargin() > 0.0f) {
                this.write("rightmargin", String.valueOf(this.document.rightMargin()));
            }
            if (this.document.topMargin() > 0.0f) {
                this.write("topmargin", String.valueOf(this.document.topMargin()));
            }
            if (this.document.bottomMargin() > 0.0f) {
                this.write("bottommargin", String.valueOf(this.document.bottomMargin()));
            }
            if (this.pageSize.getBackgroundColor() != null) {
                this.write("bgcolor", HtmlEncoder.encode(this.pageSize.getBackgroundColor()));
            }
            if (this.document.getJavaScript_onLoad() != null) {
                this.write("onLoad", HtmlEncoder.encode(this.document.getJavaScript_onLoad()));
            }
            if (this.document.getJavaScript_onUnLoad() != null) {
                this.write("onUnLoad", HtmlEncoder.encode(this.document.getJavaScript_onUnLoad()));
            }
            if (this.document.getHtmlStyleClass() != null) {
                this.write("class", this.document.getHtmlStyleClass());
            }
            this.os.write(62);
            this.initHeader();
            return;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    @Override
    public void close() {
        try {
            this.initFooter();
            this.addTabs(1);
            this.writeEnd("body");
            this.os.write(10);
            this.writeEnd("html");
            super.close();
            return;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    protected void initHeader() {
        if (this.header != null) {
            try {
                HtmlWriter htmlWriter = this;
                ((DocWriter)htmlWriter).add(htmlWriter.header.paragraph());
                return;
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
    }

    protected void initFooter() {
        if (this.footer != null) {
            try {
                this.footer.setPageNumber(this.pageN + 1);
                HtmlWriter htmlWriter = this;
                ((DocWriter)htmlWriter).add(htmlWriter.footer.paragraph());
                return;
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
    }

    protected void writeHeader(Meta meta) {
        this.addTabs(2);
        this.writeStart("meta");
        switch (meta.type()) {
            case 0: {
                this.write("name", meta.getName());
                break;
            }
            case 2: {
                this.write("name", "subject");
                break;
            }
            case 3: {
                this.write("name", "keywords");
                break;
            }
            case 4: {
                this.write("name", "author");
            }
        }
        this.write("content", HtmlEncoder.encode(meta.getContent()));
        this.writeEnd();
    }

    protected void writeLink(Header header) {
        this.addTabs(2);
        this.writeStart("link");
        this.write("rel", ((Meta)header).getName());
        this.write("type", "text/css");
        this.write("href", header.getContent());
        this.writeEnd();
    }

    protected void writeJavaScript(Header header) {
        this.addTabs(2);
        this.writeStart("script");
        this.write("language", "JavaScript");
        if (this.markup.size() > 0) {
            HtmlWriter htmlWriter = this;
            htmlWriter.writeMarkupAttributes(htmlWriter.markup);
            this.os.write(62);
            this.writeEnd("script");
            return;
        }
        this.write("type", "text/javascript");
        this.os.write(62);
        this.addTabs(2);
        this.write(new String(BEGINCOMMENT) + "\n");
        this.write(header.getContent());
        this.addTabs(2);
        this.write("//" + new String(ENDCOMMENT));
        this.addTabs(2);
        this.writeEnd("script");
    }

    protected void writeComment(String string) {
        this.addTabs(2);
        this.os.write(BEGINCOMMENT);
        this.write(string);
        this.os.write(ENDCOMMENT);
    }

    public void setStandardFont(Font font) {
        this.standardfont = font;
    }

    public boolean isOtherFont(Font font) {
        try {
            Font font2 = this.currentfont.peek();
            return font2.compareTo(font) != 0;
        }
        catch (EmptyStackException emptyStackException) {
            return this.standardfont.compareTo(font) != 0;
        }
    }

    public void setImagepath(String string) {
        this.imagepath = string;
    }

    public void resetImagepath() {
        this.imagepath = null;
    }

    @Override
    public void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter;
    }

    @Override
    public void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter;
    }

    public boolean add(String string) {
        if (this.pause) {
            return false;
        }
        try {
            this.write(string);
            return true;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void write(Element map2, int n2) {
        switch (map2.type()) {
            case 50: {
                try {
                    ((DocWriter)this).add((Element)((Object)map2));
                    return;
                }
                catch (DocumentException documentException) {
                    DocumentException documentException2 = documentException;
                    documentException.printStackTrace();
                    return;
                }
            }
            case 10: {
                void var2_22;
                Chunk chunk = (Chunk)((Object)map2);
                Image image = chunk.getImage();
                if (image != null) {
                    this.write(image, (int)var2_22);
                    return;
                }
                if (chunk.isEmpty()) {
                    return;
                }
                Map<String, Object> i2 = chunk.getChunkAttributes();
                if (i2 != null && i2.get("NEWPAGE") != null) {
                    return;
                }
                boolean bl2 = this.isOtherFont(chunk.getFont()) || this.markup.size() > 0;
                if (bl2) {
                    this.addTabs((int)var2_22);
                    this.writeStart("span");
                    if (this.isOtherFont(chunk.getFont())) {
                        this.write(chunk.getFont(), null);
                    }
                    HtmlWriter htmlWriter = this;
                    htmlWriter.writeMarkupAttributes(htmlWriter.markup);
                    this.os.write(62);
                }
                if (i2 != null && i2.get("SUBSUPSCRIPT") != null) {
                    if (((Float)i2.get("SUBSUPSCRIPT")).floatValue() > 0.0f) {
                        this.writeStart("sup");
                    } else {
                        this.writeStart("sub");
                    }
                    this.os.write(62);
                }
                this.write(HtmlEncoder.encode(chunk.getContent()));
                if (i2 != null && i2.get("SUBSUPSCRIPT") != null) {
                    this.os.write(60);
                    this.os.write(47);
                    if (((Float)i2.get("SUBSUPSCRIPT")).floatValue() > 0.0f) {
                        this.write("sup");
                    } else {
                        this.write("sub");
                    }
                    this.os.write(62);
                }
                if (bl2) {
                    this.writeEnd("span");
                }
                return;
            }
            case 11: {
                void var2_22;
                Phrase phrase = (Phrase)((Object)map2);
                Properties badElementException = new Properties();
                if (phrase.hasLeading()) {
                    badElementException.setProperty("line-height", phrase.getLeading() + "pt");
                }
                this.addTabs((int)var2_22);
                this.writeStart("span");
                HtmlWriter htmlWriter = this;
                htmlWriter.writeMarkupAttributes(htmlWriter.markup);
                this.write(phrase.getFont(), badElementException);
                this.os.write(62);
                this.currentfont.push(phrase.getFont());
                for (Object e2 : phrase) {
                    this.write((Element)e2, (int)(var2_22 + true));
                }
                this.addTabs((int)var2_22);
                this.writeEnd("span");
                this.currentfont.pop();
                return;
            }
            case 17: {
                void var2_22;
                Anchor anchor = (Anchor)((Object)map2);
                Properties properties = new Properties();
                if (anchor.hasLeading()) {
                    properties.setProperty("line-height", anchor.getLeading() + "pt");
                }
                this.addTabs((int)var2_22);
                this.writeStart("a");
                if (anchor.getName() != null) {
                    this.write("name", anchor.getName());
                }
                if (anchor.getReference() != null) {
                    this.write("href", anchor.getReference());
                }
                HtmlWriter htmlWriter = this;
                htmlWriter.writeMarkupAttributes(htmlWriter.markup);
                this.write(anchor.getFont(), properties);
                this.os.write(62);
                this.currentfont.push(anchor.getFont());
                for (Object e3 : anchor) {
                    this.write((Element)e3, (int)(var2_22 + true));
                }
                this.addTabs((int)var2_22);
                this.writeEnd("a");
                this.currentfont.pop();
                return;
            }
            case 12: {
                void var2_22;
                Paragraph paragraph = (Paragraph)((Object)map2);
                Properties properties = new Properties();
                if (paragraph.hasLeading()) {
                    properties.setProperty("line-height", paragraph.getTotalLeading() + "pt");
                }
                this.addTabs((int)var2_22);
                this.writeStart("div");
                HtmlWriter htmlWriter = this;
                htmlWriter.writeMarkupAttributes(htmlWriter.markup);
                String string2 = HtmlEncoder.getAlignment(paragraph.getAlignment());
                if (!"".equals(string2)) {
                    this.write("align", string2);
                }
                this.write(paragraph.getFont(), properties);
                this.os.write(62);
                this.currentfont.push(paragraph.getFont());
                for (String string2 : paragraph) {
                    this.write((Element)((Object)string2), (int)(var2_22 + true));
                }
                this.addTabs((int)var2_22);
                this.writeEnd("div");
                this.currentfont.pop();
                return;
            }
            case 13: 
            case 16: {
                void var2_22;
                this.writeSection((Section)((Object)map2), (int)var2_22);
                return;
            }
            case 14: {
                void var2_22;
                List list = (List)((Object)map2);
                this.addTabs((int)var2_22);
                if (list.isNumbered()) {
                    this.writeStart("ol");
                } else {
                    this.writeStart("ul");
                }
                HtmlWriter htmlWriter = this;
                htmlWriter.writeMarkupAttributes(htmlWriter.markup);
                this.os.write(62);
                for (Element element : list.getItems()) {
                    this.write(element, (int)(var2_22 + true));
                }
                this.addTabs((int)var2_22);
                if (list.isNumbered()) {
                    this.writeEnd("ol");
                    return;
                }
                this.writeEnd("ul");
                return;
            }
            case 15: {
                void var2_22;
                ListItem listItem = (ListItem)((Object)map2);
                Properties properties = new Properties();
                if (listItem.hasLeading()) {
                    properties.setProperty("line-height", listItem.getTotalLeading() + "pt");
                }
                this.addTabs((int)var2_22);
                this.writeStart("li");
                HtmlWriter htmlWriter = this;
                htmlWriter.writeMarkupAttributes(htmlWriter.markup);
                this.write(listItem.getFont(), properties);
                this.os.write(62);
                this.currentfont.push(listItem.getFont());
                for (Object e4 : listItem) {
                    this.write((Element)e4, (int)(var2_22 + true));
                }
                this.addTabs((int)var2_22);
                this.writeEnd("li");
                this.currentfont.pop();
                return;
            }
            case 20: {
                String string;
                void var2_22;
                Cell cell = (Cell)((Object)map2);
                this.addTabs((int)var2_22);
                if (cell.isHeader()) {
                    this.writeStart("th");
                } else {
                    this.writeStart("td");
                }
                HtmlWriter htmlWriter = this;
                htmlWriter.writeMarkupAttributes(htmlWriter.markup);
                if (cell.getBorderWidth() != -1.0f) {
                    this.write("border", String.valueOf(cell.getBorderWidth()));
                }
                if (cell.getBorderColor() != null) {
                    this.write("bordercolor", HtmlEncoder.encode(cell.getBorderColor()));
                }
                if (cell.getBackgroundColor() != null) {
                    this.write("bgcolor", HtmlEncoder.encode(cell.getBackgroundColor()));
                }
                if (!"".equals(string = HtmlEncoder.getAlignment(cell.getHorizontalAlignment()))) {
                    this.write("align", string);
                }
                if (!"".equals(string = HtmlEncoder.getAlignment(cell.getVerticalAlignment()))) {
                    this.write("valign", string);
                }
                if (cell.getWidthAsString() != null) {
                    this.write("width", cell.getWidthAsString());
                }
                if (cell.getColspan() != 1) {
                    this.write("colspan", String.valueOf(cell.getColspan()));
                }
                if (cell.getRowspan() != 1) {
                    this.write("rowspan", String.valueOf(cell.getRowspan()));
                }
                if (cell.getMaxLines() == 1) {
                    this.write("style", "white-space: nowrap;");
                }
                this.os.write(62);
                if (cell.isEmpty()) {
                    this.write(NBSP);
                } else {
                    Iterator iterator = cell.getElements();
                    while (iterator.hasNext()) {
                        this.write((Element)iterator.next(), (int)(var2_22 + true));
                    }
                }
                this.addTabs((int)var2_22);
                if (cell.isHeader()) {
                    this.writeEnd("th");
                    return;
                }
                this.writeEnd("td");
                return;
            }
            case 21: {
                void var1_18;
                void var2_22;
                Row row = (Row)((Object)map2);
                this.addTabs((int)var2_22);
                this.writeStart("tr");
                HtmlWriter htmlWriter = this;
                htmlWriter.writeMarkupAttributes(htmlWriter.markup);
                this.os.write(62);
                boolean bl3 = false;
                while (var1_18 < row.getColumns()) {
                    TableRectangle tableRectangle = row.getCell((int)var1_18);
                    if (tableRectangle != null) {
                        this.write(tableRectangle, (int)(var2_22 + true));
                    }
                    ++var1_18;
                }
                this.addTabs((int)var2_22);
                this.writeEnd("tr");
                return;
            }
            case 22: {
                Table table;
                void var2_22;
                try {
                    table = (Table)((Object)map2);
                }
                catch (ClassCastException classCastException) {
                    try {
                        table = ((SimpleTable)((Object)map2)).createTable();
                    }
                    catch (BadElementException badElementException) {
                        throw new ExceptionConverter(badElementException);
                    }
                }
                table.complete();
                this.addTabs((int)var2_22);
                this.writeStart("table");
                HtmlWriter htmlWriter = this;
                htmlWriter.writeMarkupAttributes(htmlWriter.markup);
                this.os.write(32);
                this.write("width");
                this.os.write(61);
                this.os.write(34);
                this.write(String.valueOf(((Rectangle)table).getWidth()));
                if (!table.isLocked()) {
                    this.write("%");
                }
                this.os.write(34);
                Object object = HtmlEncoder.getAlignment(table.getAlignment());
                if (!"".equals(object)) {
                    this.write("align", (String)object);
                }
                this.write("cellpadding", String.valueOf(table.getPadding()));
                this.write("cellspacing", String.valueOf(table.getSpacing()));
                if (table.getBorderWidth() != -1.0f) {
                    this.write("border", String.valueOf(table.getBorderWidth()));
                }
                if (table.getBorderColor() != null) {
                    this.write("bordercolor", HtmlEncoder.encode(table.getBorderColor()));
                }
                if (table.getBackgroundColor() != null) {
                    this.write("bgcolor", HtmlEncoder.encode(table.getBackgroundColor()));
                }
                this.os.write(62);
                object = table.iterator();
                while (object.hasNext()) {
                    Row row = (Row)object.next();
                    this.write(row, (int)(var2_22 + true));
                }
                this.addTabs((int)var2_22);
                this.writeEnd("table");
                return;
            }
            case 29: {
                Annotation annotation = (Annotation)((Object)map2);
                this.writeComment(annotation.title() + ": " + annotation.content());
                return;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                void var2_22;
                Image image = (Image)((Object)map2);
                if (image.getUrl() == null) {
                    return;
                }
                this.addTabs((int)var2_22);
                this.writeStart("img");
                String string = image.getUrl().toString();
                if (this.imagepath != null) {
                    if (string.indexOf(47) > 0) {
                        String string3 = string;
                        string = this.imagepath + string3.substring(string3.lastIndexOf(47) + 1);
                    } else {
                        string = this.imagepath + string;
                    }
                }
                this.write("src", string);
                if ((image.getAlignment() & 2) > 0) {
                    this.write("align", "Right");
                } else if ((image.getAlignment() & 1) > 0) {
                    this.write("align", "Middle");
                } else {
                    this.write("align", "Left");
                }
                if (image.getAlt() != null) {
                    this.write("alt", image.getAlt());
                }
                this.write("width", String.valueOf(image.getScaledWidth()));
                this.write("height", String.valueOf(image.getScaledHeight()));
                HtmlWriter htmlWriter = this;
                htmlWriter.writeMarkupAttributes(htmlWriter.markup);
                this.writeEnd();
                return;
            }
        }
    }

    protected void writeSection(Section section, int n2) {
        if (section.getTitle() != null) {
            int n3 = section.getDepth() - 1;
            if (n3 > 5) {
                n3 = 5;
            }
            Object object = new Properties();
            if (section.getTitle().hasLeading()) {
                ((Properties)object).setProperty("line-height", section.getTitle().getTotalLeading() + "pt");
            }
            this.addTabs(n2);
            this.writeStart(HtmlTags.H[n3]);
            this.write(section.getTitle().getFont(), (Properties)object);
            object = HtmlEncoder.getAlignment(section.getTitle().getAlignment());
            if (!"".equals(object)) {
                this.write("align", (String)object);
            }
            HtmlWriter htmlWriter = this;
            htmlWriter.writeMarkupAttributes(htmlWriter.markup);
            this.os.write(62);
            this.currentfont.push(section.getTitle().getFont());
            for (Object e2 : section.getTitle()) {
                this.write((Element)e2, n2 + 1);
            }
            this.addTabs(n2);
            this.writeEnd(HtmlTags.H[n3]);
            this.currentfont.pop();
        }
        for (Object object : section) {
            this.write((Element)object, n2);
        }
    }

    protected void write(Font object, Properties properties) {
        Object object2;
        if (object == null || !this.isOtherFont((Font)object)) {
            return;
        }
        this.write(" ");
        this.write("style");
        this.write("=\"");
        if (properties != null) {
            object2 = properties.propertyNames();
            while (object2.hasMoreElements()) {
                String string = (String)object2.nextElement();
                this.writeCssProperty(string, properties.getProperty(string));
            }
        }
        if (this.isOtherFont((Font)object)) {
            this.writeCssProperty("font-family", ((Font)object).getFamilyname());
            if (((Font)object).getSize() != -1.0f) {
                this.writeCssProperty("font-size", ((Font)object).getSize() + "pt");
            }
            if (((Font)object).getColor() != null) {
                this.writeCssProperty("color", HtmlEncoder.encode(((Font)object).getColor()));
            }
            int n2 = ((Font)object).getStyle();
            object2 = ((Font)object).getBaseFont();
            if (object2 != null) {
                object = ((BaseFont)object2).getPostscriptFontName().toLowerCase();
                if (((String)object).contains("bold")) {
                    if (n2 == -1) {
                        n2 = 0;
                    }
                    n2 |= 1;
                }
                if (((String)object).contains("italic") || ((String)object).contains("oblique")) {
                    if (n2 == -1) {
                        n2 = 0;
                    }
                    n2 |= 2;
                }
            }
            if (n2 != -1 && n2 != 0) {
                switch (n2 & 3) {
                    case 1: {
                        this.writeCssProperty("font-weight", "bold");
                        break;
                    }
                    case 2: {
                        this.writeCssProperty("font-style", "italic");
                        break;
                    }
                    case 3: {
                        this.writeCssProperty("font-weight", "bold");
                        this.writeCssProperty("font-style", "italic");
                    }
                }
                if ((n2 & 4) > 0) {
                    this.writeCssProperty("text-decoration", "underline");
                }
                if ((n2 & 8) > 0) {
                    this.writeCssProperty("text-decoration", "line-through");
                }
            }
        }
        this.write("\"");
    }

    protected void writeCssProperty(String string, String string2) {
        this.write(string + ": " + string2 + "; ");
    }
}

