/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import com.lowagie.text.html.WebColors;
import java.awt.Color;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Markup {
    public static final String ITEXT_TAG = "tag";
    public static final String HTML_TAG_BODY = "body";
    public static final String HTML_TAG_DIV = "div";
    public static final String HTML_TAG_LINK = "link";
    public static final String HTML_TAG_SPAN = "span";
    public static final String HTML_ATTR_HEIGHT = "height";
    public static final String HTML_ATTR_HREF = "href";
    public static final String HTML_ATTR_REL = "rel";
    public static final String HTML_ATTR_STYLE = "style";
    public static final String HTML_ATTR_TYPE = "type";
    public static final String HTML_ATTR_STYLESHEET = "stylesheet";
    public static final String HTML_ATTR_WIDTH = "width";
    public static final String HTML_ATTR_CSS_CLASS = "class";
    public static final String HTML_ATTR_CSS_ID = "id";
    public static final String HTML_VALUE_JAVASCRIPT = "text/javascript";
    public static final String HTML_VALUE_CSS = "text/css";
    public static final String CSS_KEY_BGCOLOR = "background-color";
    public static final String CSS_KEY_COLOR = "color";
    public static final String CSS_KEY_DISPLAY = "display";
    public static final String CSS_KEY_FONTFAMILY = "font-family";
    public static final String CSS_KEY_FONTSIZE = "font-size";
    public static final String CSS_KEY_FONTSTYLE = "font-style";
    public static final String CSS_KEY_FONTWEIGHT = "font-weight";
    public static final String CSS_KEY_LINEHEIGHT = "line-height";
    public static final String CSS_KEY_MARGIN = "margin";
    public static final String CSS_KEY_MARGINLEFT = "margin-left";
    public static final String CSS_KEY_MARGINRIGHT = "margin-right";
    public static final String CSS_KEY_MARGINTOP = "margin-top";
    public static final String CSS_KEY_MARGINBOTTOM = "margin-bottom";
    public static final String CSS_KEY_PADDING = "padding";
    public static final String CSS_KEY_PADDINGLEFT = "padding-left";
    public static final String CSS_KEY_PADDINGRIGHT = "padding-right";
    public static final String CSS_KEY_PADDINGTOP = "padding-top";
    public static final String CSS_KEY_PADDINGBOTTOM = "padding-bottom";
    public static final String CSS_KEY_BORDERCOLOR = "border-color";
    public static final String CSS_KEY_BORDERWIDTH = "border-width";
    public static final String CSS_KEY_BORDERWIDTHLEFT = "border-left-width";
    public static final String CSS_KEY_BORDERWIDTHRIGHT = "border-right-width";
    public static final String CSS_KEY_BORDERWIDTHTOP = "border-top-width";
    public static final String CSS_KEY_BORDERWIDTHBOTTOM = "border-bottom-width";
    public static final String CSS_KEY_PAGE_BREAK_AFTER = "page-break-after";
    public static final String CSS_KEY_PAGE_BREAK_BEFORE = "page-break-before";
    public static final String CSS_KEY_TEXTALIGN = "text-align";
    public static final String CSS_KEY_TEXTDECORATION = "text-decoration";
    public static final String CSS_KEY_VERTICALALIGN = "vertical-align";
    public static final String CSS_KEY_VISIBILITY = "visibility";
    public static final String CSS_VALUE_ALWAYS = "always";
    public static final String CSS_VALUE_BLOCK = "block";
    public static final String CSS_VALUE_BOLD = "bold";
    public static final String CSS_VALUE_HIDDEN = "hidden";
    public static final String CSS_VALUE_INLINE = "inline";
    public static final String CSS_VALUE_ITALIC = "italic";
    public static final String CSS_VALUE_LINETHROUGH = "line-through";
    public static final String CSS_VALUE_LISTITEM = "list-item";
    public static final String CSS_VALUE_NONE = "none";
    public static final String CSS_VALUE_NORMAL = "normal";
    public static final String CSS_VALUE_OBLIQUE = "oblique";
    public static final String CSS_VALUE_TABLE = "table";
    public static final String CSS_VALUE_TABLEROW = "table-row";
    public static final String CSS_VALUE_TABLECELL = "table-cell";
    public static final String CSS_VALUE_TEXTALIGNLEFT = "left";
    public static final String CSS_VALUE_TEXTALIGNRIGHT = "right";
    public static final String CSS_VALUE_TEXTALIGNCENTER = "center";
    public static final String CSS_VALUE_TEXTALIGNJUSTIFY = "justify";
    public static final String CSS_VALUE_UNDERLINE = "underline";
    public static final float DEFAULT_FONT_SIZE = 12.0f;

    public static float parseLength(String string) {
        int n2 = 0;
        int n3 = string.length();
        boolean bl2 = true;
        block3: while (bl2 && n2 < n3) {
            switch (string.charAt(n2)) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++n2;
                    continue block3;
                }
            }
            bl2 = false;
        }
        if (n2 == 0) {
            return 0.0f;
        }
        if (n2 == n3) {
            return Float.parseFloat(string + "f");
        }
        float f2 = Float.parseFloat(string.substring(0, n2) + "f");
        if ((string = string.substring(n2)).startsWith("in")) {
            return f2 * 72.0f;
        }
        if (string.startsWith("cm")) {
            return f2 / 2.54f * 72.0f;
        }
        if (string.startsWith("mm")) {
            return f2 / 25.4f * 72.0f;
        }
        if (string.startsWith("pc")) {
            return f2 * 12.0f;
        }
        return f2;
    }

    public static float parseLength(String string, float f2) {
        if (string == null) {
            return 0.0f;
        }
        int n2 = 0;
        int n3 = string.length();
        boolean bl2 = true;
        block3: while (bl2 && n2 < n3) {
            switch (string.charAt(n2)) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++n2;
                    continue block3;
                }
            }
            bl2 = false;
        }
        if (n2 == 0) {
            return 0.0f;
        }
        if (n2 == n3) {
            return Float.parseFloat(string + "f");
        }
        float f3 = Float.parseFloat(string.substring(0, n2) + "f");
        if ((string = string.substring(n2)).startsWith("in")) {
            return f3 * 72.0f;
        }
        if (string.startsWith("cm")) {
            return f3 / 2.54f * 72.0f;
        }
        if (string.startsWith("mm")) {
            return f3 / 25.4f * 72.0f;
        }
        if (string.startsWith("pc")) {
            return f3 * 12.0f;
        }
        if (string.startsWith("em")) {
            return f3 * f2;
        }
        if (string.startsWith("ex")) {
            return f3 * f2 / 2.0f;
        }
        return f3;
    }

    @Nullable
    public static Color decodeColor(String string) {
        if (string == null) {
            return null;
        }
        string = string.toLowerCase(Locale.ROOT).trim();
        try {
            return WebColors.getRGBColor(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Nonnull
    public static Properties parseAttributes(String object) {
        Properties properties = new Properties();
        if (object == null) {
            return properties;
        }
        object = new StringTokenizer((String)object, ";");
        while (((StringTokenizer)object).hasMoreTokens()) {
            Object object2 = new StringTokenizer(((StringTokenizer)object).nextToken(), ":");
            if (!((StringTokenizer)object2).hasMoreTokens()) continue;
            String string = ((StringTokenizer)object2).nextToken().trim();
            if (!((StringTokenizer)object2).hasMoreTokens()) continue;
            if (((String)(object2 = ((StringTokenizer)object2).nextToken().trim())).startsWith("\"")) {
                object2 = ((String)object2).substring(1);
            }
            if (((String)object2).endsWith("\"")) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
            }
            properties.setProperty(string.toLowerCase(Locale.ROOT), (String)object2);
        }
        return properties;
    }

    public static String removeComment(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = string3.length();
        int n4 = string.indexOf(string2, 0);
        while (n4 >= 0) {
            stringBuilder.append(string, n2, n4);
            n2 = string.indexOf(string3, n4) + n3;
            n4 = string.indexOf(string2, n2);
        }
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }
}

