/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import com.lowagie.text.error_messages.MessageLocalization;
import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;

public class WebColors
extends HashMap<String, int[]> {
    public static final WebColors NAMES = new WebColors();

    public static Color getRGBColor(String object) {
        if (object == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Object object2 = ((String)object).trim().toLowerCase(Locale.ROOT);
        if ("".equals(object2)) {
            throw new IllegalArgumentException("name must not be empty");
        }
        if (((String)object2).startsWith("#")) {
            Object object3;
            object = object2;
            int n2 = ((String)object).length();
            if (!((String)object).matches("^#[a-f0-9]{3,8}$") || n2 != 4 && n2 != 5 && n2 != 7 && n2 != 9) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("unknown.color.format.must.be.rgb.or.rrggbb"));
            }
            String string = ((String)object).substring(1);
            if (n2 == 4 || n2 == 5) {
                object3 = new StringBuilder();
                for (char c2 : string.toCharArray()) {
                    ((StringBuilder)object3).append(c2).append(c2);
                }
                string = ((StringBuilder)object3).toString();
            }
            int[] nArray = new int[]{0, 0, 0, 255};
            object3 = nArray;
            nArray[0] = Integer.parseInt(string.substring(0, 2), 16);
            object3[1] = Integer.parseInt(string.substring(2, 4), 16);
            object3[2] = Integer.parseInt(string.substring(4, 6), 16);
            if (string.length() > 6) {
                object3[3] = Integer.parseInt(string.substring(6, 8), 16);
            }
            return new Color((int)object3[0], (int)object3[1], (int)object3[2], (int)object3[3]);
        }
        if (((String)object).startsWith("rgb")) {
            object = object2;
            object2 = new int[]{0, 0, 0, 255};
            String string = ((String)object).startsWith("rgba") ? ((String)object).substring(4) : ((String)object).substring(3);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "()/, \t\r\n\f");
            for (int i2 = 0; i2 < 3; ++i2) {
                String string2 = stringTokenizer.nextToken();
                object2[i2] = string2.endsWith("%") ? (Object)WebColors.a(string2, 255) : (Object)((int)Double.parseDouble(string2));
                if (object2[i2] < 0) {
                    object2[i2] = false;
                    continue;
                }
                if (object2[i2] <= 255) continue;
                object2[i2] = 255;
            }
            if (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                object2[3] = string3.endsWith("%") ? (Object)WebColors.a(string3, 255) : (Object)((int)(Double.parseDouble(string3) * 255.0));
            }
            return new Color((int)object2[0], (int)object2[1], (int)object2[2], (int)object2[3]);
        }
        if (((String)object).startsWith("hsl")) {
            float f2;
            double d2;
            double d3;
            double d4;
            object = object2;
            object2 = ((String)object).startsWith("hsla") ? ((String)object).substring(4) : ((String)object).substring(3);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2, "()/, \t\r\n\f");
            String string = "";
            String string4 = "";
            String string5 = "";
            object2 = "1";
            if (stringTokenizer.hasMoreElements()) {
                string = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreElements()) {
                string4 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreElements()) {
                string5 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreElements()) {
                object2 = stringTokenizer.nextToken();
            }
            if (string.isEmpty() || string4.isEmpty() || string5.isEmpty() || !string4.endsWith("%") || !string5.endsWith("%")) {
                throw new IllegalArgumentException("Not a valid hsl color:" + (String)object);
            }
            object = string;
            if (((String)object).endsWith("deg")) {
                d4 = Double.parseDouble(((String)object).substring(0, ((String)object).length() - 3));
                d3 = d4 % 360.0;
            } else if (((String)object).endsWith("rad")) {
                d4 = Double.parseDouble(((String)object).substring(0, ((String)object).length() - 3));
                d2 = Math.toDegrees(d4);
                d3 = d2 % 360.0;
            } else if (((String)object).endsWith("grad")) {
                d4 = Double.parseDouble(((String)object).substring(0, ((String)object).length() - 4));
                d2 = d4 * 360.0 / 400.0;
                d3 = d2 % 360.0;
            } else if (((String)object).endsWith("turn")) {
                d4 = Double.parseDouble(((String)object).substring(0, ((String)object).length() - 4));
                d2 = d4 * 360.0;
                d3 = d2 % 360.0;
            } else {
                d4 = Double.parseDouble((String)object);
                d3 = d4 % 360.0;
            }
            float f3 = Double.valueOf(d3).floatValue();
            float f4 = Float.parseFloat(string4.substring(0, string4.length() - 1));
            float f5 = Float.parseFloat(string5.substring(0, string5.length() - 1));
            int n3 = ((String)object2).endsWith("%") ? WebColors.a((String)object2, 255) : (int)(Double.parseDouble((String)object2) * 255.0);
            float f6 = f5 / 100.0f;
            float f7 = f4 / 100.0f;
            int[] nArray = new int[3];
            if (f7 == 0.0f) {
                f3 = f4 = f6 * 255.0f;
                f2 = f4;
            } else {
                f4 = f3 / 360.0f;
                f5 = (double)f6 < 0.5 ? f6 * (f7 + 1.0f) : f6 + f7 - f6 * f7;
                float f8 = f6 * 2.0f - f5;
                f2 = 256.0f * WebColors.a(f8, f5, f4 + 0.33333334f);
                f3 = 256.0f * WebColors.a(f8, f5, f4);
                f4 = 256.0f * WebColors.a(f8, f5, f4 - 0.33333334f);
            }
            nArray[0] = Math.min(255, (int)f2);
            nArray[1] = Math.min(255, (int)f3);
            nArray[2] = Math.min(255, (int)f4);
            int[] nArray2 = nArray;
            return new Color(nArray2[0], nArray2[1], nArray2[2], n3);
        }
        object = object2;
        if (!NAMES.containsKey(object)) {
            throw new IllegalArgumentException("Color '" + (String)object + "' not found.");
        }
        object2 = (int[])NAMES.get(object);
        return new Color((int)object2[0], (int)object2[1], (int)object2[2], (int)object2[3]);
    }

    private static int a(String string, int n2) {
        double d2 = Double.parseDouble(string.substring(0, string.length() - 1));
        double d3 = d2 * 255.0 / 100.0;
        return Double.valueOf(d3).intValue();
    }

    private static float a(float f2, float f3, float f4) {
        if (f4 < 0.0f) {
            f4 += 1.0f;
        }
        if (f4 > 1.0f) {
            f4 -= 1.0f;
        }
        if (f4 < 0.16666667f) {
            return f2 + (f3 - f2) * 6.0f * f4;
        }
        if (f4 < 0.5f) {
            return f3;
        }
        if (f4 < 0.6666667f) {
            return f2 + (f3 - f2) * (0.6666667f - f4) * 6.0f;
        }
        return f2;
    }

    static {
        NAMES.put("aliceblue", new int[]{240, 248, 255, 255});
        NAMES.put("antiquewhite", new int[]{250, 235, 215, 255});
        NAMES.put("aqua", new int[]{0, 255, 255, 255});
        NAMES.put("aquamarine", new int[]{127, 255, 212, 255});
        NAMES.put("azure", new int[]{240, 255, 255, 255});
        NAMES.put("beige", new int[]{245, 245, 220, 255});
        NAMES.put("bisque", new int[]{255, 228, 196, 255});
        NAMES.put("black", new int[]{0, 0, 0, 255});
        NAMES.put("blanchedalmond", new int[]{255, 235, 205, 255});
        NAMES.put("blue", new int[]{0, 0, 255, 255});
        NAMES.put("blueviolet", new int[]{138, 43, 226, 255});
        NAMES.put("brown", new int[]{165, 42, 42, 255});
        NAMES.put("burlywood", new int[]{222, 184, 135, 255});
        NAMES.put("cadetblue", new int[]{95, 158, 160, 255});
        NAMES.put("chartreuse", new int[]{127, 255, 0, 255});
        NAMES.put("chocolate", new int[]{210, 105, 30, 255});
        NAMES.put("coral", new int[]{255, 127, 80, 255});
        NAMES.put("cornflowerblue", new int[]{100, 149, 237, 255});
        NAMES.put("cornsilk", new int[]{255, 248, 220, 255});
        NAMES.put("crimson", new int[]{220, 20, 60, 255});
        NAMES.put("cyan", new int[]{0, 255, 255, 255});
        NAMES.put("darkblue", new int[]{0, 0, 139, 255});
        NAMES.put("darkcyan", new int[]{0, 139, 139, 255});
        NAMES.put("darkgoldenrod", new int[]{184, 134, 11, 255});
        NAMES.put("darkgray", new int[]{169, 169, 169, 255});
        NAMES.put("darkgreen", new int[]{0, 100, 0, 255});
        NAMES.put("darkkhaki", new int[]{189, 183, 107, 255});
        NAMES.put("darkmagenta", new int[]{139, 0, 139, 255});
        NAMES.put("darkolivegreen", new int[]{85, 107, 47, 255});
        NAMES.put("darkorange", new int[]{255, 140, 0, 255});
        NAMES.put("darkorchid", new int[]{153, 50, 204, 255});
        NAMES.put("darkred", new int[]{139, 0, 0, 255});
        NAMES.put("darksalmon", new int[]{233, 150, 122, 255});
        NAMES.put("darkseagreen", new int[]{143, 188, 143, 255});
        NAMES.put("darkslateblue", new int[]{72, 61, 139, 255});
        NAMES.put("darkslategray", new int[]{47, 79, 79, 255});
        NAMES.put("darkslategrey", new int[]{47, 79, 79, 255});
        NAMES.put("darkturquoise", new int[]{0, 206, 209, 255});
        NAMES.put("darkviolet", new int[]{148, 0, 211, 255});
        NAMES.put("deeppink", new int[]{255, 20, 147, 255});
        NAMES.put("deepskyblue", new int[]{0, 191, 255, 255});
        NAMES.put("dimgray", new int[]{105, 105, 105, 255});
        NAMES.put("dimgrey", new int[]{105, 105, 105, 255});
        NAMES.put("dodgerblue", new int[]{30, 144, 255, 255});
        NAMES.put("firebrick", new int[]{178, 34, 34, 255});
        NAMES.put("floralwhite", new int[]{255, 250, 240, 255});
        NAMES.put("forestgreen", new int[]{34, 139, 34, 255});
        NAMES.put("fuchsia", new int[]{255, 0, 255, 255});
        NAMES.put("gainsboro", new int[]{220, 220, 220, 255});
        NAMES.put("ghostwhite", new int[]{248, 248, 255, 255});
        NAMES.put("gold", new int[]{255, 215, 0, 255});
        NAMES.put("goldenrod", new int[]{218, 165, 32, 255});
        NAMES.put("gray", new int[]{128, 128, 128, 255});
        NAMES.put("green", new int[]{0, 128, 0, 255});
        NAMES.put("greenyellow", new int[]{173, 255, 47, 255});
        NAMES.put("honeydew", new int[]{240, 255, 240, 255});
        NAMES.put("hotpink", new int[]{255, 105, 180, 255});
        NAMES.put("indianred", new int[]{205, 92, 92, 255});
        NAMES.put("indigo", new int[]{75, 0, 130, 255});
        NAMES.put("ivory", new int[]{255, 255, 240, 255});
        NAMES.put("khaki", new int[]{240, 230, 140, 255});
        NAMES.put("lavender", new int[]{230, 230, 250, 255});
        NAMES.put("lavenderblush", new int[]{255, 240, 245, 255});
        NAMES.put("lawngreen", new int[]{124, 252, 0, 255});
        NAMES.put("lemonchiffon", new int[]{255, 250, 205, 255});
        NAMES.put("lightblue", new int[]{173, 216, 230, 255});
        NAMES.put("lightcoral", new int[]{240, 128, 128, 255});
        NAMES.put("lightcyan", new int[]{224, 255, 255, 255});
        NAMES.put("lightgoldenrodyellow", new int[]{250, 250, 210, 255});
        NAMES.put("lightgray", new int[]{211, 211, 211, 255});
        NAMES.put("lightgreen", new int[]{144, 238, 144, 255});
        NAMES.put("lightgrey", new int[]{211, 211, 211, 255});
        NAMES.put("lightpink", new int[]{255, 182, 193, 255});
        NAMES.put("lightsalmon", new int[]{255, 160, 122, 255});
        NAMES.put("lightseagreen", new int[]{32, 178, 170, 255});
        NAMES.put("lightskyblue", new int[]{135, 206, 250, 255});
        NAMES.put("lightslategray", new int[]{119, 136, 153, 255});
        NAMES.put("lightslategrey", new int[]{119, 136, 153, 255});
        NAMES.put("lightsteelblue", new int[]{176, 196, 222, 255});
        NAMES.put("lightyellow", new int[]{255, 255, 224, 255});
        NAMES.put("lime", new int[]{0, 255, 0, 255});
        NAMES.put("limegreen", new int[]{50, 205, 50, 255});
        NAMES.put("linen", new int[]{250, 240, 230, 255});
        NAMES.put("magenta", new int[]{255, 0, 255, 255});
        NAMES.put("maroon", new int[]{128, 0, 0, 255});
        NAMES.put("mediumaquamarine", new int[]{102, 205, 170, 255});
        NAMES.put("mediumblue", new int[]{0, 0, 205, 255});
        NAMES.put("mediumorchid", new int[]{186, 85, 211, 255});
        NAMES.put("mediumpurple", new int[]{147, 112, 219, 255});
        NAMES.put("mediumseagreen", new int[]{60, 179, 113, 255});
        NAMES.put("mediumslateblue", new int[]{123, 104, 238, 255});
        NAMES.put("mediumspringgreen", new int[]{0, 250, 154, 255});
        NAMES.put("mediumturquoise", new int[]{72, 209, 204, 255});
        NAMES.put("mediumvioletred", new int[]{199, 21, 133, 255});
        NAMES.put("midnightblue", new int[]{25, 25, 112, 255});
        NAMES.put("mintcream", new int[]{245, 255, 250, 255});
        NAMES.put("mistyrose", new int[]{255, 228, 225, 255});
        NAMES.put("moccasin", new int[]{255, 228, 181, 255});
        NAMES.put("navajowhite", new int[]{255, 222, 173, 255});
        NAMES.put("navy", new int[]{0, 0, 128, 255});
        NAMES.put("oldlace", new int[]{253, 245, 230, 255});
        NAMES.put("olive", new int[]{128, 128, 0, 255});
        NAMES.put("olivedrab", new int[]{107, 142, 35, 255});
        NAMES.put("orange", new int[]{255, 165, 0, 255});
        NAMES.put("orangered", new int[]{255, 69, 0, 255});
        NAMES.put("orchid", new int[]{218, 112, 214, 255});
        NAMES.put("palegoldenrod", new int[]{238, 232, 170, 255});
        NAMES.put("palegreen", new int[]{152, 251, 152, 255});
        NAMES.put("paleturquoise", new int[]{175, 238, 238, 255});
        NAMES.put("palevioletred", new int[]{219, 112, 147, 255});
        NAMES.put("papayawhip", new int[]{255, 239, 213, 255});
        NAMES.put("peachpuff", new int[]{255, 218, 185, 255});
        NAMES.put("peru", new int[]{205, 133, 63, 255});
        NAMES.put("pink", new int[]{255, 192, 203, 255});
        NAMES.put("plum", new int[]{221, 160, 221, 255});
        NAMES.put("powderblue", new int[]{176, 224, 230, 255});
        NAMES.put("purple", new int[]{128, 0, 128, 255});
        NAMES.put("rebeccapurple", new int[]{102, 51, 153, 255});
        NAMES.put("red", new int[]{255, 0, 0, 255});
        NAMES.put("rosybrown", new int[]{188, 143, 143, 255});
        NAMES.put("royalblue", new int[]{65, 105, 225, 255});
        NAMES.put("saddlebrown", new int[]{139, 69, 19, 255});
        NAMES.put("salmon", new int[]{250, 128, 114, 255});
        NAMES.put("sandybrown", new int[]{244, 164, 96, 255});
        NAMES.put("seagreen", new int[]{46, 139, 87, 255});
        NAMES.put("seashell", new int[]{255, 245, 238, 255});
        NAMES.put("sienna", new int[]{160, 82, 45, 255});
        NAMES.put("silver", new int[]{192, 192, 192, 255});
        NAMES.put("skyblue", new int[]{135, 206, 235, 255});
        NAMES.put("slateblue", new int[]{106, 90, 205, 255});
        NAMES.put("slategray", new int[]{112, 128, 144, 255});
        NAMES.put("slategrey", new int[]{112, 128, 144, 255});
        NAMES.put("snow", new int[]{255, 250, 250, 255});
        NAMES.put("springgreen", new int[]{0, 255, 127, 255});
        NAMES.put("steelblue", new int[]{70, 130, 180, 255});
        NAMES.put("tan", new int[]{210, 180, 140, 255});
        NAMES.put("transparent", new int[]{0, 0, 0, 0});
        NAMES.put("teal", new int[]{0, 128, 128, 255});
        NAMES.put("thistle", new int[]{216, 191, 216, 255});
        NAMES.put("tomato", new int[]{255, 99, 71, 255});
        NAMES.put("turquoise", new int[]{64, 224, 208, 255});
        NAMES.put("violet", new int[]{238, 130, 238, 255});
        NAMES.put("wheat", new int[]{245, 222, 179, 255});
        NAMES.put("white", new int[]{255, 255, 255, 255});
        NAMES.put("whitesmoke", new int[]{245, 245, 245, 255});
        NAMES.put("yellow", new int[]{255, 255, 0, 255});
        NAMES.put("yellowgreen", new int[]{9, 2765, 50, 255});
    }
}

