/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.FontProvider;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.html.Markup;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import com.lowagie.text.pdf.HyphenationAuto;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.utils.NumberUtilities;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.annotation.Nullable;

public class FactoryProperties {
    public static Map<String, String> followTags = new HashMap<String, String>();
    private FontProvider a = FontFactory.getFontImp();

    public static void createParagraph(Paragraph paragraph, ChainedProperties chainedProperties) {
        chainedProperties.findProperty("align").map(String::trim).ifPresent(string -> {
            if (string.equalsIgnoreCase("center")) {
                paragraph.setAlignment(1);
                return;
            }
            if (string.equalsIgnoreCase("right")) {
                paragraph.setAlignment(2);
                return;
            }
            if (string.equalsIgnoreCase("justify")) {
                paragraph.setAlignment(3);
            }
        });
        paragraph.setHyphenation(FactoryProperties.getHyphenation(chainedProperties));
        Object object = chainedProperties.getProperty("leading");
        Paragraph paragraph2 = paragraph;
        if (object == null) {
            paragraph2.setLeading(0.0f, 1.5f);
        } else {
            try {
                object = new StringTokenizer((String)object, " ,");
                String string2 = ((StringTokenizer)object).nextToken();
                float f2 = Float.parseFloat(string2);
                if (!((StringTokenizer)object).hasMoreTokens()) {
                    paragraph2.setLeading(f2, 0.0f);
                } else {
                    string2 = ((StringTokenizer)object).nextToken();
                    float f3 = Float.parseFloat(string2);
                    paragraph2.setLeading(f2, f3);
                }
            }
            catch (Exception exception) {
                paragraph2.setLeading(0.0f, 1.5f);
            }
        }
        chainedProperties.findProperty("before").flatMap(NumberUtilities::parseFloat).ifPresent(paragraph::setSpacingBefore);
        chainedProperties.findProperty("after").flatMap(NumberUtilities::parseFloat).ifPresent(paragraph::setSpacingAfter);
        chainedProperties.findProperty("extraparaspace").flatMap(NumberUtilities::parseFloat).ifPresent(paragraph::setExtraParagraphSpace);
    }

    public static Paragraph createParagraph(ChainedProperties chainedProperties) {
        Paragraph paragraph = new Paragraph();
        FactoryProperties.createParagraph(paragraph, chainedProperties);
        return paragraph;
    }

    public static ListItem createListItem(ChainedProperties chainedProperties) {
        ListItem listItem = new ListItem();
        FactoryProperties.createParagraph(listItem, chainedProperties);
        return listItem;
    }

    public static HyphenationEvent getHyphenation(ChainedProperties chainedProperties) {
        return FactoryProperties.getHyphenation(chainedProperties.getProperty("hyphenation"));
    }

    public static HyphenationEvent getHyphenation(HashMap hashMap) {
        return FactoryProperties.getHyphenation((String)hashMap.get("hyphenation"));
    }

    @Nullable
    public static HyphenationEvent getHyphenation(String string) {
        int n2;
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = string;
        int n3 = 2;
        int n4 = string.indexOf(95);
        if (n4 == -1) {
            return new HyphenationAuto(string2, null, 2, 2);
        }
        string2 = string.substring(0, n4);
        String string3 = string.substring(n4 + 1);
        if ((n4 = string3.indexOf(44)) == -1) {
            return new HyphenationAuto(string2, string3, 2, 2);
        }
        string = string3.substring(n4 + 1);
        string3 = string3.substring(0, n4);
        n4 = string.indexOf(44);
        if (n4 == -1) {
            n2 = Integer.parseInt(string);
        } else {
            n2 = Integer.parseInt(string.substring(0, n4));
            n3 = Integer.parseInt(string.substring(n4 + 1));
        }
        return new HyphenationAuto(string2, string3, n2, n3);
    }

    @Deprecated
    public static void insertStyle(HashMap hashMap) {
        FactoryProperties.insertStyle((Map<String, String>)hashMap);
    }

    public static void insertStyle(Map<String, String> map) {
        Object object = map.get("style");
        if (object == null) {
            return;
        }
        object = Markup.parseAttributes((String)object);
        for (Object object2 : ((Properties)object).keySet()) {
            object2 = (String)object2;
            switch (object2) {
                case "font-family": {
                    map.put("face", ((Properties)object).getProperty((String)object2));
                    break;
                }
                case "font-size": {
                    map.put("size", Markup.parseLength(((Properties)object).getProperty((String)object2)) + "pt");
                    break;
                }
                case "font-style": {
                    object2 = ((Properties)object).getProperty((String)object2).trim().toLowerCase();
                    if (!((String)object2).equals("italic") && !((String)object2).equals("oblique")) break;
                    map.put("i", null);
                    break;
                }
                case "font-weight": {
                    object2 = ((Properties)object).getProperty((String)object2).trim().toLowerCase();
                    if (!((String)object2).equals("bold") && !((String)object2).equals("700") && !((String)object2).equals("800") && !((String)object2).equals("900")) break;
                    map.put("b", null);
                    break;
                }
                case "text-decoration": {
                    object2 = ((Properties)object).getProperty((String)object2).trim().toLowerCase();
                    if (!((String)object2).equals("underline")) break;
                    map.put("u", null);
                    break;
                }
                case "color": {
                    object2 = Markup.decodeColor(((Properties)object).getProperty((String)object2));
                    if (object2 == null) break;
                    int n2 = ((Color)object2).getRGB();
                    object2 = Integer.toHexString(n2);
                    Object object3 = object2 = "000000" + (String)object2;
                    object2 = "#" + ((String)object3).substring(((String)object3).length() - 6);
                    map.put("color", (String)object2);
                    break;
                }
                case "line-height": {
                    String string = ((Properties)object).getProperty((String)object2).trim();
                    float f2 = Markup.parseLength(((Properties)object).getProperty((String)object2));
                    if (string.endsWith("%")) {
                        map.put("leading", "0," + f2 / 100.0f);
                        break;
                    }
                    if ("normal".equalsIgnoreCase(string)) {
                        map.put("leading", "0,1.5");
                        break;
                    }
                    map.put("leading", f2 + ",0");
                    break;
                }
                case "text-align": {
                    String string = ((Properties)object).getProperty((String)object2).trim().toLowerCase();
                    map.put("align", string);
                }
            }
        }
    }

    public static void insertStyle(Map<String, String> map, ChainedProperties chainedProperties) {
        Object object = map.get("style");
        if (object == null) {
            return;
        }
        object = Markup.parseAttributes((String)object);
        for (Object object2 : ((Properties)object).keySet()) {
            switch (object2 = (String)object2) {
                case "font-family": {
                    map.put("face", ((Properties)object).getProperty((String)object2));
                    break;
                }
                case "font-size": {
                    float f2;
                    float f3 = Markup.parseLength(chainedProperties.getProperty("size"), 12.0f);
                    if (f2 <= 0.0f) {
                        f3 = 12.0f;
                    }
                    map.put("size", Markup.parseLength(((Properties)object).getProperty((String)object2), f3) + "pt");
                    break;
                }
                case "font-style": {
                    Object object3 = ((Properties)object).getProperty((String)object2).trim().toLowerCase();
                    if (!((String)object3).equals("italic") && !((String)object3).equals("oblique")) break;
                    map.put("i", null);
                    break;
                }
                case "font-weight": {
                    Object object3 = ((Properties)object).getProperty((String)object2).trim().toLowerCase();
                    if (!((String)object3).equals("bold") && !((String)object3).equals("700") && !((String)object3).equals("800") && !((String)object3).equals("900")) break;
                    map.put("b", null);
                    break;
                }
                case "text-decoration": {
                    Object object3 = ((Properties)object).getProperty((String)object2).trim().toLowerCase();
                    if (!((String)object3).equals("underline")) break;
                    map.put("u", null);
                    break;
                }
                case "color": {
                    Object object3 = Markup.decodeColor(((Properties)object).getProperty((String)object2));
                    if (object3 == null) break;
                    int n2 = ((Color)object3).getRGB();
                    String string = Integer.toHexString(n2);
                    String string2 = string = "000000" + string;
                    string = "#" + string2.substring(string2.length() - 6);
                    map.put("color", string);
                    break;
                }
                case "line-height": {
                    float f4;
                    Object object3 = ((Properties)object).getProperty((String)object2).trim();
                    float f5 = Markup.parseLength(chainedProperties.getProperty("size"), 12.0f);
                    if (f4 <= 0.0f) {
                        f5 = 12.0f;
                    }
                    float f6 = Markup.parseLength(((Properties)object).getProperty((String)object2), f5);
                    if (((String)object3).endsWith("%")) {
                        map.put("leading", "0," + f6 / 100.0f);
                        return;
                    }
                    if ("normal".equalsIgnoreCase((String)object3)) {
                        map.put("leading", "0,1.5");
                        return;
                    }
                    if (f6 != 0.0f) {
                        Object object4 = object3;
                        if (Character.isDigit(((String)object4).charAt(((String)object4).length() - 1))) {
                            map.put("leading", "0," + f6);
                            break;
                        }
                    }
                    map.put("leading", f6 + ",0");
                    break;
                }
                case "text-align": {
                    Object object3 = ((Properties)object).getProperty((String)object2).trim().toLowerCase();
                    map.put("align", (String)object3);
                    break;
                }
                case "padding-left": {
                    Object object3 = ((Properties)object).getProperty((String)object2).trim().toLowerCase();
                    map.put("indent", Float.toString(Markup.parseLength((String)object3)));
                }
            }
        }
    }

    public Chunk createChunk(String object, ChainedProperties chainedProperties) {
        Font font = this.getFont(chainedProperties);
        float f2 = font.getSize();
        f2 /= 2.0f;
        object = new Chunk((String)object, font);
        if (chainedProperties.hasProperty("sub")) {
            ((Chunk)object).setTextRise(-f2);
        } else if (chainedProperties.hasProperty("sup")) {
            ((Chunk)object).setTextRise(f2);
        }
        ((Chunk)object).setHyphenation(FactoryProperties.getHyphenation(chainedProperties));
        return object;
    }

    public Font getFont(ChainedProperties object) {
        String string = ((ChainedProperties)object).getProperty("face");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                if (string.startsWith("\"")) {
                    string = string.substring(1);
                }
                if (string.endsWith("\"")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (!this.a.isRegistered(string)) continue;
            }
        }
        int n2 = 0;
        if (((ChainedProperties)object).hasProperty("i")) {
            n2 = 2;
        }
        if (((ChainedProperties)object).hasProperty("b")) {
            n2 |= 1;
        }
        if (((ChainedProperties)object).hasProperty("u")) {
            n2 |= 4;
        }
        if (((ChainedProperties)object).hasProperty("s")) {
            n2 |= 8;
        }
        float f2 = ((ChainedProperties)object).findProperty("size").flatMap(NumberUtilities::parseFloat).orElse(Float.valueOf(12.0f)).floatValue();
        Color color = Markup.decodeColor(((ChainedProperties)object).getProperty("color"));
        object = ((ChainedProperties)object).getOrDefault("encoding", "Cp1252");
        return this.a.getFont(string, (String)object, true, f2, n2, color);
    }

    public FontProvider getFontImp() {
        return this.a;
    }

    public void setFontImp(FontProvider fontProvider) {
        this.a = fontProvider;
    }

    static {
        followTags.put("i", "i");
        followTags.put("b", "b");
        followTags.put("u", "u");
        followTags.put("sub", "sub");
        followTags.put("sup", "sup");
        followTags.put("em", "i");
        followTags.put("strong", "b");
        followTags.put("s", "s");
        followTags.put("strike", "s");
    }
}

