/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.FontProvider;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.html.Markup;
import com.lowagie.text.html.simpleparser.ALink;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import com.lowagie.text.html.simpleparser.FactoryProperties;
import com.lowagie.text.html.simpleparser.ImageProvider;
import com.lowagie.text.html.simpleparser.Img;
import com.lowagie.text.html.simpleparser.IncCell;
import com.lowagie.text.html.simpleparser.IncTable;
import com.lowagie.text.html.simpleparser.StyleSheet;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.draw.LineSeparator;
import com.lowagie.text.utils.NumberUtilities;
import com.lowagie.text.xml.simpleparser.SimpleXMLDocHandler;
import com.lowagie.text.xml.simpleparser.SimpleXMLParser;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;

public class HTMLWorker
implements DocListener,
SimpleXMLDocHandler {
    public static final String tagsSupportedString = "ol ul li a pre font span br p div body table td th tr i b u sub sup em strong s strike h1 h2 h3 h4 h5 h6 img hr";
    public static final Map<String, Object> tagsSupported = new HashMap<String, Object>();
    protected ArrayList<Element> objectList;
    protected DocListener document;
    private Paragraph a;
    private ChainedProperties b = new ChainedProperties();
    private Stack<Object> c = new Stack();
    private boolean d = false;
    private boolean e = false;
    private boolean f = false;
    private StyleSheet g = new StyleSheet();
    private boolean h = false;
    private Stack<Object> i = new Stack();
    private boolean j = false;
    private Map<String, Object> k;
    private FactoryProperties l = new FactoryProperties();

    public HTMLWorker(DocListener docListener) {
        this.document = docListener;
    }

    public static ArrayList<Element> parseToList(Reader reader, StyleSheet styleSheet) {
        return HTMLWorker.parseToList(reader, styleSheet, null);
    }

    @Deprecated
    public static ArrayList<Element> parseToList(Reader reader, StyleSheet styleSheet, HashMap hashMap) {
        return HTMLWorker.parseToList(reader, styleSheet, (Map<String, Object>)hashMap);
    }

    public static ArrayList<Element> parseToList(Reader reader, StyleSheet styleSheet, Map<String, Object> map) {
        HTMLWorker hTMLWorker = new HTMLWorker(null);
        if (styleSheet != null) {
            hTMLWorker.g = styleSheet;
        }
        hTMLWorker.document = hTMLWorker;
        hTMLWorker.setInterfaceProps(map);
        hTMLWorker.objectList = new ArrayList();
        hTMLWorker.parse(reader);
        return hTMLWorker.objectList;
    }

    public StyleSheet getStyleSheet() {
        return this.g;
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        this.g = styleSheet;
    }

    public Map<String, Object> getInterfaceProps() {
        return this.k;
    }

    @Deprecated
    public void setInterfaceProps(HashMap hashMap) {
        this.setInterfaceProps((Map<String, Object>)hashMap);
    }

    public void setInterfaceProps(Map<String, Object> map) {
        this.k = map;
        FontProvider fontProvider = null;
        if (map != null) {
            fontProvider = (FontProvider)map.get("font_factory");
        }
        if (fontProvider != null) {
            this.l.setFontImp(fontProvider);
        }
    }

    public void parse(Reader reader) {
        SimpleXMLParser.parse(this, null, reader, true);
    }

    @Override
    public void endDocument() {
        try {
            this.c.forEach(object -> this.document.add((Element)object));
            if (this.a != null) {
                this.document.add(this.a);
            }
            this.a = null;
            return;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    @Override
    public void startDocument() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.g.applyStyle("body", (Map<String, String>)hashMap);
        this.b.addToChain("body", (Map<String, String>)hashMap);
    }

    @Override
    @Deprecated
    public void startElement(String string, HashMap hashMap) {
        this.startElement(string, (Map<String, String>)hashMap);
    }

    @Override
    public void startElement(String string, Map<String, String> map) {
        if (!tagsSupported.containsKey(string)) {
            return;
        }
        try {
            this.g.applyStyle(string, map);
            Object object = FactoryProperties.followTags.get(string);
            if (object != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put((String)object, (String)null);
                this.b.addToChain((String)object, (Map<String, String>)hashMap);
                return;
            }
            FactoryProperties.insertStyle(map, this.b);
            if (string.equals("a")) {
                this.b.addToChain(string, map);
                if (this.a == null) {
                    this.a = new Paragraph();
                }
                this.c.push(this.a);
                this.a = new Paragraph();
                return;
            }
            if (string.equals("br")) {
                if (this.a == null) {
                    this.a = new Paragraph();
                }
                Chunk chunk = this.l.createChunk("\n", this.b);
                ((Phrase)this.a).add(chunk);
                return;
            }
            if (string.equals("hr")) {
                int n2;
                boolean bl2 = true;
                if (this.a == null) {
                    this.a = new Paragraph();
                    bl2 = false;
                }
                if (bl2 && ((n2 = this.a.getChunks().size()) == 0 || ((Chunk)this.a.getChunks().get(n2 - 1)).getContent().endsWith("\n"))) {
                    bl2 = false;
                }
                object = map.get("align");
                int n3 = 1;
                if (object != null) {
                    if (((String)object).equalsIgnoreCase("left")) {
                        n3 = 0;
                    }
                    if (((String)object).equalsIgnoreCase("right")) {
                        n3 = 2;
                    }
                }
                String string2 = map.get("width");
                float f2 = 1.0f;
                if (string2 != null) {
                    float f3;
                    float f4 = Markup.parseLength(string2, 12.0f);
                    if (f3 > 0.0f) {
                        f2 = f4;
                    }
                    if (!string2.endsWith("%")) {
                        f2 = 100.0f;
                    }
                }
                String string3 = map.get("size");
                float f5 = 1.0f;
                if (string3 != null) {
                    float f6;
                    float f7 = Markup.parseLength(string3, 12.0f);
                    if (f6 > 0.0f) {
                        f5 = f7;
                    }
                }
                if (bl2) {
                    ((Phrase)this.a).add(Chunk.NEWLINE);
                }
                ((Phrase)this.a).add(new LineSeparator(f5, f2, null, n3, this.a.getLeading() / 2.0f));
                ((Phrase)this.a).add(Chunk.NEWLINE);
                return;
            }
            if (string.equals("font") || string.equals("span")) {
                this.b.addToChain(string, map);
                return;
            }
            if (string.equals("img")) {
                float f8;
                Object object2;
                Object object3;
                Object object4;
                String string4 = map.get("src");
                if (string4 == null) {
                    return;
                }
                this.b.addToChain(string, map);
                object = null;
                if (this.k != null) {
                    object4 = (ImageProvider)this.k.get("img_provider");
                    if (object4 != null) {
                        object = object4.getImage(string4, (HashMap)map, this.b, this.document);
                    }
                    if (object == null) {
                        object3 = (HashMap)this.k.get("img_static");
                        if (object3 != null) {
                            object2 = (Image)object3.get(string4);
                            if (object2 != null) {
                                object = Image.getInstance((Image)object2);
                            }
                        } else if (!string4.startsWith("http") && (object2 = (String)this.k.get("img_baseurl")) != null) {
                            string4 = (String)object2 + string4;
                            object = Image.getInstance(string4);
                        }
                    }
                }
                if (object == null) {
                    if (!string4.startsWith("http")) {
                        object4 = this.b.getOrDefault("image_path", "");
                        string4 = new File((String)object4, string4).getPath();
                    }
                    object = Image.getInstance(string4);
                }
                object4 = map.get("align");
                object3 = map.get("width");
                object2 = map.get("height");
                this.b.findProperty("before").flatMap(NumberUtilities::parseFloat).ifPresent(((Image)object)::setSpacingBefore);
                this.b.findProperty("after").flatMap(NumberUtilities::parseFloat).ifPresent(((Image)object)::setSpacingAfter);
                float f9 = Markup.parseLength(this.b.getProperty("size"), 12.0f);
                if (f8 <= 0.0f) {
                    f9 = 12.0f;
                }
                float f10 = Markup.parseLength((String)object3, f9);
                f9 = Markup.parseLength((String)object2, f9);
                if (f10 > 0.0f && f9 > 0.0f) {
                    ((Image)object).scaleAbsolute(f10, f9);
                } else if (f10 > 0.0f) {
                    f9 = ((Rectangle)object).getHeight() * f10 / ((Rectangle)object).getWidth();
                    ((Image)object).scaleAbsolute(f10, f9);
                } else if (f9 > 0.0f) {
                    f10 = ((Rectangle)object).getWidth() * f9 / ((Rectangle)object).getHeight();
                    ((Image)object).scaleAbsolute(f10, f9);
                }
                ((Image)object).setWidthPercentage(0.0f);
                if (object4 != null) {
                    Img img;
                    this.endElement("p");
                    int n4 = 1;
                    if (((String)object4).equalsIgnoreCase("left")) {
                        n4 = 0;
                    } else if (((String)object4).equalsIgnoreCase("right")) {
                        n4 = 2;
                    }
                    ((Image)object).setAlignment(n4);
                    boolean bl3 = false;
                    if (this.k != null && (img = (Img)this.k.get("img_interface")) != null) {
                        bl3 = img.process((Image)object, (HashMap)map, this.b, this.document);
                    }
                    if (!bl3) {
                        this.document.add((Element)object);
                    }
                    this.b.removeChain(string);
                    return;
                }
                this.b.removeChain(string);
                if (this.a == null) {
                    this.a = FactoryProperties.createParagraph(this.b);
                }
                ((Phrase)this.a).add(new Chunk((Image)object, 0.0f, 0.0f));
                return;
            }
            this.endElement("p");
            if (string.equals("h1") || string.equals("h2") || string.equals("h3") || string.equals("h4") || string.equals("h5") || string.equals("h6")) {
                if (!map.containsKey("size")) {
                    int n5 = 7 - Integer.parseInt(string.substring(1));
                    map.put("size", Integer.toString(n5));
                }
                this.b.addToChain(string, map);
                return;
            }
            if (string.equals("ul")) {
                if (this.f) {
                    this.endElement("li");
                }
                this.j = true;
                this.b.addToChain(string, map);
                List list = new List(false);
                try {
                    list.setIndentationLeft(Float.parseFloat(this.b.getProperty("indent")));
                }
                catch (Exception exception) {
                    list.setAutoindent(true);
                }
                list.setListSymbol("\u2022");
                this.c.push(list);
                return;
            }
            if (string.equals("ol")) {
                if (this.f) {
                    this.endElement("li");
                }
                this.j = true;
                this.b.addToChain(string, map);
                List list = new List(true);
                try {
                    list.setIndentationLeft(Float.parseFloat(this.b.getProperty("indent")));
                }
                catch (Exception exception) {
                    list.setAutoindent(true);
                }
                this.c.push(list);
                return;
            }
            if (string.equals("li")) {
                if (this.f) {
                    this.endElement("li");
                }
                this.j = false;
                this.f = true;
                this.b.addToChain(string, map);
                ListItem listItem = FactoryProperties.createListItem(this.b);
                this.c.push(listItem);
                return;
            }
            if (string.equals("div") || string.equals("body") || string.equals("p")) {
                this.b.addToChain(string, map);
                return;
            }
            if (string.equals("pre")) {
                if (!map.containsKey("face")) {
                    map.put("face", "Courier");
                }
                this.b.addToChain(string, map);
                this.h = true;
                return;
            }
            if (string.equals("tr")) {
                if (this.d) {
                    this.endElement("tr");
                }
                this.j = true;
                this.d = true;
                this.b.addToChain("tr", map);
                return;
            }
            if (string.equals("td") || string.equals("th")) {
                if (this.e) {
                    this.endElement(string);
                }
                this.j = false;
                this.e = true;
                this.b.addToChain("td", map);
                this.c.push(new IncCell(string, this.b));
                return;
            }
            if (string.equals("table")) {
                this.b.addToChain("table", map);
                IncTable incTable = new IncTable(map);
                this.c.push(incTable);
                this.i.push(new boolean[]{this.d, this.e});
                HTMLWorker hTMLWorker = this;
                hTMLWorker.e = false;
                hTMLWorker.d = false;
                this.j = true;
                return;
            }
            return;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    @Override
    public void endElement(String object) {
        if (!tagsSupported.containsKey(object)) {
            return;
        }
        try {
            Object object2;
            Object object3 = FactoryProperties.followTags.get(object);
            if (object3 != null) {
                this.b.removeChain((String)object3);
                return;
            }
            if (((String)object).equals("font") || ((String)object).equals("span")) {
                this.b.removeChain((String)object);
                return;
            }
            if (((String)object).equals("a")) {
                Object object4;
                if (this.a == null) {
                    this.a = new Paragraph();
                }
                boolean bl2 = false;
                if (this.k != null && (object4 = (ALink)this.k.get("alink_interface")) != null) {
                    bl2 = object4.process(this.a, this.b);
                }
                if (!bl2) {
                    this.b.findProperty("href").ifPresent(string -> {
                        Object object = this.a.getChunks();
                        object = object.iterator();
                        while (object.hasNext()) {
                            Element element = (Element)object.next();
                            element = (Chunk)element;
                            ((Chunk)element).setAnchor((String)string);
                        }
                    });
                }
                object4 = (Paragraph)this.c.pop();
                object = new Phrase();
                ((Phrase)object).add(this.a);
                ((Phrase)object4).add((Element)object);
                this.a = object4;
                this.b.removeChain("a");
                return;
            }
            if (((String)object).equals("br")) {
                return;
            }
            if (this.a != null) {
                if (this.c.empty()) {
                    this.document.add(this.a);
                } else {
                    object3 = this.c.pop();
                    if (object3 instanceof TextElementArray) {
                        object2 = (TextElementArray)object3;
                        object2.add(this.a);
                    }
                    this.c.push(object3);
                }
            }
            this.a = null;
            if (((String)object).equals("ul") || ((String)object).equals("ol")) {
                if (this.f) {
                    this.endElement("li");
                }
                this.j = false;
                this.b.removeChain((String)object);
                if (this.c.empty()) {
                    return;
                }
                object3 = this.c.pop();
                if (!(object3 instanceof List)) {
                    this.c.push(object3);
                    return;
                }
                if (this.c.empty()) {
                    this.document.add((Element)object3);
                    return;
                }
                object2 = this.c.peek();
                if (object2 instanceof List) {
                    ((List)object2).add((List)object3);
                    return;
                }
                ((TextElementArray)object2).add((Element)object3);
                return;
            }
            if (((String)object).equals("li")) {
                this.f = false;
                this.j = true;
                this.b.removeChain((String)object);
                if (this.c.empty()) {
                    return;
                }
                object3 = this.c.pop();
                if (!(object3 instanceof ListItem)) {
                    this.c.push(object3);
                    return;
                }
                if (this.c.empty()) {
                    this.document.add((Element)object3);
                    return;
                }
                object2 = this.c.pop();
                if (!(object2 instanceof List)) {
                    this.c.push(object2);
                    return;
                }
                object = (ListItem)object3;
                ((List)object2).add((Element)object);
                object3 = ((Phrase)object).getChunks();
                if (!object3.isEmpty()) {
                    ((ListItem)object).getListSymbol().setFont(((Chunk)object3.get(0)).getFont());
                }
                this.c.push(object2);
                return;
            }
            if (((String)object).equals("div") || ((String)object).equals("body")) {
                this.b.removeChain((String)object);
                return;
            }
            if (((String)object).equals("pre")) {
                this.b.removeChain((String)object);
                this.h = false;
                return;
            }
            if (((String)object).equals("p")) {
                this.b.removeChain((String)object);
                return;
            }
            if (((String)object).equals("h1") || ((String)object).equals("h2") || ((String)object).equals("h3") || ((String)object).equals("h4") || ((String)object).equals("h5") || ((String)object).equals("h6")) {
                this.b.removeChain((String)object);
                return;
            }
            if (((String)object).equals("table")) {
                if (this.d) {
                    this.endElement("tr");
                }
                this.b.removeChain("table");
                object3 = (IncTable)this.c.pop();
                object2 = ((IncTable)object3).buildTable();
                ((PdfPTable)object2).setSplitRows(true);
                if (this.c.empty()) {
                    this.document.add((Element)object2);
                } else {
                    ((TextElementArray)this.c.peek()).add((Element)object2);
                }
                object = (boolean[])this.i.pop();
                this.d = object[0];
                this.e = object[1];
                this.j = false;
                return;
            }
            if (((String)object).equals("tr")) {
                if (this.e) {
                    this.endElement("td");
                }
                this.d = false;
                this.b.removeChain("tr");
                object3 = new ArrayList<PdfPCell>();
                do {
                    if (!((object = this.c.pop()) instanceof IncCell)) continue;
                    object3.add(((IncCell)object).getCell());
                } while (!(object instanceof IncTable));
                object2 = (IncTable)object;
                ((IncTable)object2).addCols((java.util.List<PdfPCell>)object3);
                ((IncTable)object2).endRow();
                this.c.push(object2);
                this.j = true;
                return;
            }
            if (((String)object).equals("td") || ((String)object).equals("th")) {
                this.e = false;
                this.b.removeChain("td");
                this.j = true;
                return;
            }
            return;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    @Override
    public void text(String string) {
        if (this.j) {
            return;
        }
        if (this.h) {
            if (this.a == null) {
                this.a = FactoryProperties.createParagraph(this.b);
            }
            Chunk chunk = this.l.createChunk(string, this.b);
            ((Phrase)this.a).add(chunk);
            return;
        }
        if (string.trim().length() == 0 && string.indexOf(32) < 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        boolean bl2 = false;
        block6: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case ' ': {
                    if (bl2) continue block6;
                    stringBuilder.append(c2);
                    continue block6;
                }
                case '\n': {
                    if (i2 <= 0) continue block6;
                    bl2 = true;
                    stringBuilder.append(' ');
                    continue block6;
                }
                case '\r': {
                    continue block6;
                }
                case '\t': {
                    continue block6;
                }
                default: {
                    bl2 = false;
                    stringBuilder.append(c2);
                }
            }
        }
        if (this.a == null) {
            this.a = FactoryProperties.createParagraph(this.b);
        }
        Chunk chunk = this.l.createChunk(stringBuilder.toString(), this.b);
        ((Phrase)this.a).add(chunk);
    }

    @Override
    public boolean add(Element element) {
        this.objectList.add(element);
        return true;
    }

    public void clearTextWrap() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean newPage() {
        return true;
    }

    @Override
    public void open() {
    }

    @Override
    public void resetFooter() {
    }

    @Override
    public void resetHeader() {
    }

    @Override
    public void resetPageCount() {
    }

    @Override
    public void setFooter(HeaderFooter headerFooter) {
    }

    @Override
    public void setHeader(HeaderFooter headerFooter) {
    }

    @Override
    public boolean setMarginMirroring(boolean bl2) {
        return false;
    }

    @Override
    public boolean setMarginMirroringTopBottom(boolean bl2) {
        return false;
    }

    @Override
    public boolean setMargins(float f2, float f3, float f4, float f5) {
        return true;
    }

    @Override
    public void setPageCount(int n2) {
    }

    @Override
    public boolean setPageSize(Rectangle rectangle) {
        return true;
    }

    static {
        StringTokenizer stringTokenizer = new StringTokenizer(tagsSupportedString);
        while (stringTokenizer.hasMoreTokens()) {
            tagsSupported.put(stringTokenizer.nextToken(), null);
        }
    }
}

