/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class Barcode128
extends Barcode {
    private static final byte[][] a;
    private static final byte[] b;
    public static final char CODE_AB_TO_C = 'c';
    public static final char CODE_AC_TO_B = 'd';
    public static final char CODE_BC_TO_A = 'e';
    public static final char FNC1_INDEX = 'f';
    public static final char START_A = 'g';
    public static final char START_B = 'h';
    public static final char START_C = 'i';
    public static final char FNC1 = '\u00ca';
    public static final char DEL = '\u00c3';
    public static final char FNC3 = '\u00c4';
    public static final char FNC2 = '\u00c5';
    public static final char SHIFT = '\u00c6';
    public static final char CODE_C = '\u00c7';
    public static final char CODE_A = '\u00c8';
    public static final char FNC4 = '\u00c8';
    public static final char STARTA = '\u00cb';
    public static final char STARTB = '\u00cc';
    public static final char STARTC = '\u00cd';
    private static final IntHashtable c;

    public Barcode128() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.codeType = 9;
            return;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static String removeFNC1(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < ' ' || c2 > '~') continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String getHumanReadableUCCEAN(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "\u00ca";
        try {
            while (true) {
                int n2;
                if (string.startsWith(string2)) {
                    string = string.substring(1);
                    continue;
                }
                int n3 = 0;
                int n4 = 0;
                for (n2 = 2; n2 < 5 && string.length() >= n2; ++n2) {
                    n3 = c.get(Integer.parseInt(string.substring(0, n2)));
                    if (n3 == 0) continue;
                    n4 = n2;
                    break;
                }
                if (n4 != 0) {
                    stringBuilder.append('(').append(string, 0, n4).append(')');
                    string = string.substring(n4);
                    if (n3 > 0) {
                        if (string.length() > (n3 -= n4)) {
                            stringBuilder.append(Barcode128.removeFNC1(string.substring(0, n3)));
                            string = string.substring(n3);
                            continue;
                        }
                    } else {
                        n2 = string.indexOf(202);
                        if (n2 >= 0) {
                            stringBuilder.append(string, 0, n2);
                            string = string.substring(n2 + 1);
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (Exception exception) {}
        stringBuilder.append(Barcode128.removeFNC1(string));
        return stringBuilder.toString();
    }

    private static boolean a(String string, int n2, int n3) {
        int n4 = string.length();
        while (n2 < n4 && n3 > 0) {
            if (string.charAt(n2) == '\u00ca') {
                ++n2;
                continue;
            }
            int n5 = Math.min(2, n3);
            if (n2 + n5 > n4) {
                return false;
            }
            while (n5-- > 0) {
                char c2;
                if ((c2 = string.charAt(n2++)) < '0' || c2 > '9') {
                    return false;
                }
                --n3;
            }
        }
        return n3 == 0;
    }

    private static String b(String string, int n2, int n3) {
        String string2 = "";
        int n4 = n2;
        while (n3 > 0) {
            if (string.charAt(n2) == '\u00ca') {
                string2 = string2 + 'f';
                ++n2;
                continue;
            }
            n3 -= 2;
            int n5 = string.charAt(n2++) - 48;
            int n6 = string.charAt(n2++) - 48;
            string2 = string2 + (char)(n5 * 10 + n6);
        }
        return (char)(n2 - n4) + string2;
    }

    public static String getRawText(String string, boolean bl2) {
        char c2;
        int n2;
        String string2 = "";
        int n3 = string.length();
        if (n3 == 0) {
            string2 = string2 + 'h';
            if (bl2) {
                string2 = string2 + 'f';
            }
            return string2;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            c2 = string.charAt(n2);
            if (c2 <= '\u007f' || c2 == '\u00ca') continue;
            throw new RuntimeException(MessageLocalization.getComposedMessage("there.are.illegal.characters.for.barcode.128.in.1", string));
        }
        c2 = string.charAt(0);
        n2 = 104;
        int n4 = 0;
        if (Barcode128.a(string, 0, 2)) {
            n2 = 105;
            string2 = string2 + 'i';
            if (bl2) {
                string2 = string2 + 'f';
            }
            String string3 = Barcode128.b(string, 0, 2);
            n4 = '\u0000' + string3.charAt(0);
            string2 = string2 + string3.substring(1);
        } else {
            if (c2 < ' ') {
                n2 = 103;
                string2 = string2 + 'g';
                if (bl2) {
                    string2 = string2 + 'f';
                }
                string2 = string2 + (char)(c2 + 64);
            } else {
                string2 = string2 + 'h';
                if (bl2) {
                    string2 = string2 + 'f';
                }
                string2 = c2 == '\u00ca' ? string2 + 'f' : string2 + (char)(c2 - 32);
            }
            ++n4;
        }
        while (n4 < n3) {
            switch (n2) {
                case 103: {
                    if (Barcode128.a(string, n4, 4)) {
                        n2 = 105;
                        string2 = string2 + 'c';
                        String string4 = Barcode128.b(string, n4, 4);
                        n4 += string4.charAt(0);
                        string2 = string2 + string4.substring(1);
                        break;
                    }
                    if ((c2 = string.charAt(n4++)) == '\u00ca') {
                        string2 = string2 + 'f';
                        break;
                    }
                    if (c2 > '_') {
                        n2 = 104;
                        string2 = string2 + 'd';
                        string2 = string2 + (char)(c2 - 32);
                        break;
                    }
                    if (c2 < ' ') {
                        string2 = string2 + (char)(c2 + 64);
                        break;
                    }
                    string2 = string2 + (char)(c2 - 32);
                    break;
                }
                case 104: {
                    if (Barcode128.a(string, n4, 4)) {
                        n2 = 105;
                        string2 = string2 + 'c';
                        String string5 = Barcode128.b(string, n4, 4);
                        n4 += string5.charAt(0);
                        string2 = string2 + string5.substring(1);
                        break;
                    }
                    if ((c2 = string.charAt(n4++)) == '\u00ca') {
                        string2 = string2 + 'f';
                        break;
                    }
                    if (c2 < ' ') {
                        n2 = 103;
                        string2 = string2 + 'e';
                        string2 = string2 + (char)(c2 + 64);
                        break;
                    }
                    string2 = string2 + (char)(c2 - 32);
                    break;
                }
                case 105: {
                    if (Barcode128.a(string, n4, 2)) {
                        String string6 = Barcode128.b(string, n4, 2);
                        n4 += string6.charAt(0);
                        string2 = string2 + string6.substring(1);
                        break;
                    }
                    if ((c2 = string.charAt(n4++)) == '\u00ca') {
                        string2 = string2 + 'f';
                        break;
                    }
                    if (c2 < ' ') {
                        n2 = 103;
                        string2 = string2 + 'e';
                        string2 = string2 + (char)(c2 + 64);
                        break;
                    }
                    n2 = 104;
                    string2 = string2 + 'd';
                    string2 = string2 + (char)(c2 - 32);
                }
            }
        }
        return string2;
    }

    public static byte[] getBarsCode128Raw(String string) {
        int n2 = string.indexOf(65535);
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        n2 = string.charAt(0);
        for (int i2 = 1; i2 < string.length(); ++i2) {
            n2 += i2 * string.charAt(i2);
        }
        string = string + (char)(n2 %= 103);
        byte[] byArray = new byte[(string.length() + 1) * 6 + 7];
        for (n2 = 0; n2 < string.length(); ++n2) {
            System.arraycopy(a[string.charAt(n2)], 0, byArray, n2 * 6, 6);
        }
        System.arraycopy(b, 0, byArray, n2 * 6, 7);
        return byArray;
    }

    @Override
    public Rectangle getBarcodeSize() {
        int n2;
        String string;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            int n3;
            f3 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.codeType == 11 ? ((n3 = this.code.indexOf(65535)) < 0 ? "" : this.code.substring(n3 + 1)) : (this.codeType == 10 ? Barcode128.getHumanReadableUCCEAN(this.code) : Barcode128.removeFNC1(this.code));
            f2 = this.font.getWidthPoint(this.altText != null ? this.altText : string, this.size);
        }
        string = this.codeType == 11 ? ((n2 = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n2) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        int n4 = string.length();
        float f4 = (float)((n4 + 2) * 11) * this.x + 2.0f * this.x;
        f4 = Math.max(f4, f2);
        f2 = this.barHeight + f3;
        return new Rectangle(f4, f2);
    }

    @Override
    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color object, Color color) {
        int n2;
        int n3;
        String string = this.codeType == 11 ? ((n3 = this.code.indexOf(65535)) < 0 ? "" : this.code.substring(n3 + 1)) : (this.codeType == 10 ? Barcode128.getHumanReadableUCCEAN(this.code) : Barcode128.removeFNC1(this.code));
        float f2 = 0.0f;
        if (this.font != null) {
            string = this.altText != null ? this.altText : string;
            f2 = this.font.getWidthPoint(string, this.size);
        }
        Object object2 = this.codeType == 11 ? ((n2 = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n2) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        n2 = ((String)object2).length();
        float f3 = (float)((n2 + 2) * 11) * this.x + 2.0f * this.x;
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f2 > f3) {
                    f4 = f2 - f3;
                    break;
                }
                f5 = f3 - f2;
                break;
            }
            default: {
                if (f2 > f3) {
                    f4 = (f2 - f3) / 2.0f;
                    break;
                }
                f5 = (f3 - f2) / 2.0f;
            }
        }
        f2 = 0.0f;
        f3 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f3 = this.barHeight - this.baseline;
            } else {
                f3 = -this.font.getFontDescriptor(3, this.size);
                f2 = f3 + this.baseline;
            }
        }
        object2 = Barcode128.getBarsCode128Raw((String)object2);
        boolean bl2 = true;
        if (object != null) {
            pdfContentByte.setColorFill((Color)object);
        }
        for (Object object3 : object2) {
            float f6 = (float)object3 * this.x;
            if (bl2) {
                pdfContentByte.rectangle(f4, f2, f6 - this.inkSpreading, this.barHeight);
            }
            bl2 = !bl2;
            f4 += f6;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color != null) {
                pdfContentByte.setColorFill(color);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f5, f3);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return ((Barcode)this).getBarcodeSize();
    }

    @Override
    public Image createAwtImage(Color color, Color color2) {
        int n2;
        int n3 = color.getRGB();
        int n4 = color2.getRGB();
        Canvas canvas = new Canvas();
        Object object = this.codeType == 11 ? ((n2 = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n2) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        n2 = ((String)object).length();
        n2 = (n2 + 2) * 11 + 2;
        object = Barcode128.getBarsCode128Raw((String)object);
        boolean bl2 = true;
        int n5 = 0;
        int n6 = (int)this.barHeight;
        int[] nArray = new int[n2 * n6];
        for (Object object2 : object) {
            int n7 = n4;
            if (bl2) {
                n7 = n3;
            }
            bl2 = !bl2;
            for (int i2 = 0; i2 < object2; ++i2) {
                nArray[n5++] = n7;
            }
        }
        for (int i3 = n2; i3 < nArray.length; i3 += n2) {
            System.arraycopy(nArray, 0, nArray, i3, n2);
        }
        Image image = canvas.createImage(new MemoryImageSource(n2, n6, nArray, 0, n2));
        return image;
    }

    @Override
    public void setCode(String string) {
        if (this.getCodeType() == 10 && string.startsWith("(")) {
            int n2 = 0;
            String string2 = "";
            while (n2 >= 0) {
                int n3 = string.indexOf(41, n2);
                if (n3 < 0) {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("badly.formed.ucc.string.1", string));
                }
                String string3 = string.substring(n2 + 1, n3);
                if (string3.length() < 2) {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("ai.too.short.1", string3));
                }
                n2 = Integer.parseInt(string3);
                int n4 = c.get(n2);
                if (n4 == 0) {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("ai.not.found.1", string3));
                }
                string3 = String.valueOf(n2);
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                int n5 = (n2 = string.indexOf(40, n3)) < 0 ? string.length() : n2;
                string2 = string2 + string3 + string.substring(n3 + 1, n5);
                if (n4 < 0) {
                    if (n2 < 0) continue;
                    string2 = string2 + '\u00ca';
                    continue;
                }
                if (n5 - n3 - 1 + string3.length() == n4) continue;
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("invalid.ai.length.1", string3));
            }
            super.setCode(string2);
            return;
        }
        super.setCode(string);
    }

    static {
        int n2;
        a = new byte[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}};
        b = new byte[]{2, 3, 3, 1, 1, 1, 2};
        c = new IntHashtable();
        c.put(0, 20);
        c.put(1, 16);
        c.put(2, 16);
        c.put(10, -1);
        c.put(11, 9);
        c.put(12, 8);
        c.put(13, 8);
        c.put(15, 8);
        c.put(17, 8);
        c.put(20, 4);
        c.put(21, -1);
        c.put(22, -1);
        c.put(23, -1);
        c.put(240, -1);
        c.put(241, -1);
        c.put(250, -1);
        c.put(251, -1);
        c.put(252, -1);
        c.put(30, -1);
        for (n2 = 3100; n2 < 3700; ++n2) {
            c.put(n2, 10);
        }
        c.put(37, -1);
        for (n2 = 3900; n2 < 3940; ++n2) {
            c.put(n2, -1);
        }
        c.put(400, -1);
        c.put(401, -1);
        c.put(402, 20);
        c.put(403, -1);
        for (n2 = 410; n2 < 416; ++n2) {
            c.put(n2, 16);
        }
        c.put(420, -1);
        c.put(421, -1);
        c.put(422, 6);
        c.put(423, -1);
        c.put(424, 6);
        c.put(425, 6);
        c.put(426, 6);
        c.put(7001, 17);
        c.put(7002, -1);
        for (n2 = 7030; n2 < 7040; ++n2) {
            c.put(n2, -1);
        }
        c.put(8001, 18);
        c.put(8002, -1);
        c.put(8003, -1);
        c.put(8004, -1);
        c.put(8005, 10);
        c.put(8006, 22);
        c.put(8007, -1);
        c.put(8008, -1);
        c.put(8018, 22);
        c.put(8020, -1);
        c.put(8100, 10);
        c.put(8101, 14);
        c.put(8102, 6);
        for (n2 = 90; n2 < 100; ++n2) {
            c.put(n2, -1);
        }
    }
}

