/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class Barcode39
extends Barcode {
    private static final byte[][] a = new byte[][]{{0, 0, 0, 1, 1, 0, 1, 0, 0}, {1, 0, 0, 1, 0, 0, 0, 0, 1}, {0, 0, 1, 1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 1}, {1, 0, 0, 1, 1, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 1, 0, 1}, {1, 0, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 0, 0, 1, 0, 0}, {1, 0, 0, 0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1, 0, 0, 1}, {1, 0, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 1, 0, 0, 0}, {0, 0, 1, 0, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 0, 1}, {1, 0, 0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 1, 1}, {0, 0, 1, 0, 0, 0, 0, 1, 1}, {1, 0, 1, 0, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 1, 0, 0, 1, 1}, {1, 0, 0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 1, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 1, 1, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 1}, {0, 1, 1, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 1, 0, 0, 0, 1}, {1, 1, 0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 0, 1, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 1, 0, 1}, {1, 1, 0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 0, 1, 0, 0}, {0, 1, 0, 1, 0, 1, 0, 0, 0}, {0, 1, 0, 1, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 1, 0, 1, 0}, {0, 0, 0, 1, 0, 1, 0, 1, 0}, {0, 1, 0, 0, 1, 0, 1, 0, 0}};

    public Barcode39() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
            this.startStopText = true;
            this.extended = false;
            return;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static byte[] getBarsCode39(String string) {
        string = "*" + string + "*";
        byte[] byArray = new byte[string.length() * 10 - 1];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%*".indexOf(string.charAt(i2));
            if (n2 < 0) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.character.1.is.illegal.in.code.39", string.charAt(i2)));
            }
            System.arraycopy(a[n2], 0, byArray, i2 * 10, 9);
        }
        return byArray;
    }

    public static String getCode39Ex(String string) {
        String string2 = "";
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u007f') {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.character.1.is.illegal.in.code.39.extended", c2));
            }
            char c3 = "%U$A$B$C$D$E$F$G$H$I$J$K$L$M$N$O$P$Q$R$S$T$U$V$W$X$Y$Z%A%B%C%D%E  /A/B/C/D/E/F/G/H/I/J/K/L - ./O 0 1 2 3 4 5 6 7 8 9/Z%F%G%H%I%J%V A B C D E F G H I J K L M N O P Q R S T U V W X Y Z%K%L%M%N%O%W+A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q+R+S+T+U+V+W+X+Y+Z%P%Q%R%S%T".charAt(c2 << 1);
            c2 = "%U$A$B$C$D$E$F$G$H$I$J$K$L$M$N$O$P$Q$R$S$T$U$V$W$X$Y$Z%A%B%C%D%E  /A/B/C/D/E/F/G/H/I/J/K/L - ./O 0 1 2 3 4 5 6 7 8 9/Z%F%G%H%I%J%V A B C D E F G H I J K L M N O P Q R S T U V W X Y Z%K%L%M%N%O%W+A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q+R+S+T+U+V+W+X+Y+Z%P%Q%R%S%T".charAt((c2 << 1) + 1);
            if (c3 != ' ') {
                string2 = string2 + c3;
            }
            string2 = string2 + c2;
        }
        return string2;
    }

    private static char a(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n3 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%*".indexOf(string.charAt(i2));
            if (n3 < 0) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.character.1.is.illegal.in.code.39", string.charAt(i2)));
            }
            n2 += n3;
        }
        return "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%*".charAt(n2 % 43);
    }

    @Override
    public Rectangle getBarcodeSize() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        String string = this.code;
        if (this.extended) {
            string = Barcode39.getCode39Ex(this.code);
        }
        if (this.font != null) {
            f3 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            String string2 = this.code;
            if (this.generateChecksum && this.checksumText) {
                string2 = string2 + Barcode39.a(string);
            }
            if (this.startStopText) {
                string2 = "*" + string2 + "*";
            }
            f2 = this.font.getWidthPoint(this.altText != null ? this.altText : string2, this.size);
        }
        int n2 = string.length() + 2;
        if (this.generateChecksum) {
            ++n2;
        }
        float f4 = (float)n2 * (6.0f * this.x + 3.0f * this.x * this.n) + (float)(n2 - 1) * this.x;
        f4 = Math.max(f4, f2);
        f2 = this.barHeight + f3;
        return new Rectangle(f4, f2);
    }

    @Override
    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color object, Color color) {
        String string = this.code;
        float f2 = 0.0f;
        Object object2 = this.code;
        if (this.extended) {
            object2 = Barcode39.getCode39Ex(this.code);
        }
        if (this.font != null) {
            if (this.generateChecksum && this.checksumText) {
                string = string + Barcode39.a((String)object2);
            }
            if (this.startStopText) {
                string = "*" + string + "*";
            }
            string = this.altText != null ? this.altText : string;
            f2 = this.font.getWidthPoint(string, this.size);
        }
        if (this.generateChecksum) {
            object2 = (String)object2 + Barcode39.a((String)object2);
        }
        int n2 = ((String)object2).length() + 2;
        float f3 = (float)n2 * (6.0f * this.x + 3.0f * this.x * this.n) + (float)(n2 - 1) * this.x;
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f2 > f3) {
                    f4 = f2 - f3;
                    break;
                }
                f5 = f3 - f2;
                break;
            }
            default: {
                if (f2 > f3) {
                    f4 = (f2 - f3) / 2.0f;
                    break;
                }
                f5 = (f3 - f2) / 2.0f;
            }
        }
        f2 = 0.0f;
        f3 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f3 = this.barHeight - this.baseline;
            } else {
                f3 = -this.font.getFontDescriptor(3, this.size);
                f2 = f3 + this.baseline;
            }
        }
        object2 = Barcode39.getBarsCode39((String)object2);
        boolean bl2 = true;
        if (object != null) {
            pdfContentByte.setColorFill((Color)object);
        }
        for (Object object3 : object2) {
            float f6;
            float f7 = f6 = object3 == false ? this.x : this.x * this.n;
            if (bl2) {
                pdfContentByte.rectangle(f4, f2, f6 - this.inkSpreading, this.barHeight);
            }
            bl2 = !bl2;
            f4 += f6;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color != null) {
                pdfContentByte.setColorFill(color);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f5, f3);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return ((Barcode)this).getBarcodeSize();
    }

    @Override
    public Image createAwtImage(Color color, Color color2) {
        int n2 = color.getRGB();
        int n3 = color2.getRGB();
        Canvas canvas = new Canvas();
        Object object = this.code;
        if (this.extended) {
            object = Barcode39.getCode39Ex(this.code);
        }
        if (this.generateChecksum) {
            object = (String)object + Barcode39.a((String)object);
        }
        int n4 = ((String)object).length() + 2;
        int n5 = (int)this.n;
        n4 = n4 * (6 + 3 * n5) + (n4 - 1);
        object = Barcode39.getBarsCode39((String)object);
        boolean bl2 = true;
        int n6 = 0;
        int n7 = (int)this.barHeight;
        int[] nArray = new int[n4 * n7];
        for (Object object2 : object) {
            object2 = object2 == false ? 1 : n5;
            int n8 = n3;
            if (bl2) {
                n8 = n2;
            }
            bl2 = !bl2;
            for (int i2 = 0; i2 < object2; ++i2) {
                nArray[n6++] = n8;
            }
        }
        for (int i3 = n4; i3 < nArray.length; i3 += n4) {
            System.arraycopy(nArray, 0, nArray, i3, n4);
        }
        Image image = canvas.createImage(new MemoryImageSource(n4, n7, nArray, 0, n4));
        return image;
    }
}

