/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodeCodabar
extends Barcode {
    private static final byte[][] a = new byte[][]{{0, 0, 0, 0, 0, 1, 1}, {0, 0, 0, 0, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 1}, {1, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 0, 0, 0}, {1, 0, 0, 0, 1, 0, 1}, {1, 0, 1, 0, 0, 0, 1}, {1, 0, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 1, 0, 1}, {0, 0, 1, 1, 0, 1, 0}, {0, 1, 0, 1, 0, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 0, 1, 1, 1, 0}};

    public BarcodeCodabar() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
            this.startStopText = false;
            this.codeType = 12;
            return;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static byte[] getBarsCodabar(String string) {
        int n2 = (string = string.toUpperCase()).length();
        if (n2 < 2) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("codabar.must.have.at.least.a.start.and.stop.character"));
        }
        if ("0123456789-$:/.+ABCD".indexOf(string.charAt(0)) < 16 || "0123456789-$:/.+ABCD".indexOf(string.charAt(n2 - 1)) < 16) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("codabar.must.have.one.of.abcd.as.start.stop.character"));
        }
        byte[] byArray = new byte[(string.length() << 3) - 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = "0123456789-$:/.+ABCD".indexOf(string.charAt(i2));
            if (n3 >= 16 && i2 > 0 && i2 < n2 - 1) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("in.codabar.start.stop.characters.are.only.allowed.at.the.extremes"));
            }
            if (n3 < 0) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.character.1.is.illegal.in.codabar", string.charAt(i2)));
            }
            System.arraycopy(a[n3], 0, byArray, i2 << 3, 7);
        }
        return byArray;
    }

    public static String calculateChecksum(String string) {
        if (string.length() < 2) {
            return string;
        }
        String string2 = string.toUpperCase();
        int n2 = 0;
        int n3 = string2.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += "0123456789-$:/.+ABCD".indexOf(string2.charAt(i2));
        }
        n2 = ((n2 + 15) / 16 << 4) - n2;
        return string.substring(0, n3 - 1) + "0123456789-$:/.+ABCD".charAt(n2) + string.substring(n3 - 1);
    }

    @Override
    public Rectangle getBarcodeSize() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        Object object = this.code;
        if (this.generateChecksum && this.checksumText) {
            object = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            object = ((String)object).substring(1, ((String)object).length() - 1);
        }
        if (this.font != null) {
            f3 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            f2 = this.font.getWidthPoint((String)(this.altText != null ? this.altText : object), this.size);
        }
        object = this.code;
        if (this.generateChecksum) {
            object = BarcodeCodabar.calculateChecksum(this.code);
        }
        object = BarcodeCodabar.getBarsCodabar((String)object);
        int n2 = 0;
        for (Object object2 : object) {
            n2 += object2;
        }
        int n3 = ((Object)object).length - n2;
        float f4 = this.x * ((float)n3 + (float)n2 * this.n);
        f4 = Math.max(f4, f2);
        float f5 = this.barHeight + f3;
        return new Rectangle(f4, f5);
    }

    @Override
    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color object, Color color) {
        String string = this.code;
        if (this.generateChecksum && this.checksumText) {
            string = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            string = string.substring(1, string.length() - 1);
        }
        float f2 = 0.0f;
        if (this.font != null) {
            string = this.altText != null ? this.altText : string;
            f2 = this.font.getWidthPoint(string, this.size);
        }
        byte[] byArray = BarcodeCodabar.getBarsCodabar(this.generateChecksum ? BarcodeCodabar.calculateChecksum(this.code) : this.code);
        int n2 = 0;
        byte[] byArray2 = byArray;
        int n3 = byArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by = byArray2[i2];
            n2 += by;
        }
        int n4 = byArray.length - n2;
        float f3 = this.x * ((float)n4 + (float)n2 * this.n);
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f2 > f3) {
                    f4 = f2 - f3;
                    break;
                }
                f5 = f3 - f2;
                break;
            }
            default: {
                if (f2 > f3) {
                    f4 = (f2 - f3) / 2.0f;
                    break;
                }
                f5 = (f3 - f2) / 2.0f;
            }
        }
        f2 = 0.0f;
        float f6 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f6 = this.barHeight - this.baseline;
            } else {
                f6 = -this.font.getFontDescriptor(3, this.size);
                f2 = f6 + this.baseline;
            }
        }
        n4 = 1;
        if (object != null) {
            pdfContentByte.setColorFill((Color)object);
        }
        object = byArray;
        int n5 = byArray.length;
        for (int i3 = 0; i3 < n5; ++i3) {
            float f7;
            Object object2 = object[i3];
            float f8 = f7 = object2 == false ? this.x : this.x * this.n;
            if (n4 != 0) {
                pdfContentByte.rectangle(f4, f2, f7 - this.inkSpreading, this.barHeight);
            }
            n4 = n4 == 0 ? 1 : 0;
            f4 += f7;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color != null) {
                pdfContentByte.setColorFill(color);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f5, f6);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return ((Barcode)this).getBarcodeSize();
    }

    @Override
    public Image createAwtImage(Color color, Color color2) {
        int n2;
        int n3;
        int n4 = color.getRGB();
        int n5 = color2.getRGB();
        Canvas canvas = new Canvas();
        if (this.generateChecksum && this.checksumText) {
            BarcodeCodabar.calculateChecksum(this.code);
        }
        byte[] byArray = BarcodeCodabar.getBarsCodabar(this.generateChecksum ? BarcodeCodabar.calculateChecksum(this.code) : this.code);
        int n6 = 0;
        byte[] byArray2 = byArray;
        int n7 = byArray.length;
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = byArray2[n3];
            n6 += n2;
        }
        int n8 = byArray.length - n6;
        n7 = n8 + n6 * (int)this.n;
        n3 = 1;
        n2 = 0;
        n6 = (int)this.barHeight;
        int[] nArray = new int[n7 * n6];
        for (int n9 : byArray) {
            n9 = n9 == 0 ? 1 : (int)this.n;
            int n10 = n5;
            if (n3 != 0) {
                n10 = n4;
            }
            n3 = n3 == 0 ? 1 : 0;
            for (int i2 = 0; i2 < n9; ++i2) {
                nArray[n2++] = n10;
            }
        }
        for (int i3 = n7; i3 < nArray.length; i3 += n7) {
            System.arraycopy(nArray, 0, nArray, i3, n7);
        }
        Image image = canvas.createImage(new MemoryImageSource(n7, n6, nArray, 0, n7));
        return image;
    }
}

