/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Image;
import com.lowagie.text.pdf.codec.CCITTG4Encoder;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.image.MemoryImageSource;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;

public class BarcodeDatamatrix {
    public static final int DM_NO_ERROR = 0;
    public static final int DM_ERROR_TEXT_TOO_BIG = 1;
    public static final int DM_ERROR_INVALID_SQUARE = 3;
    public static final int DM_ERROR_EXTENSION = 5;
    public static final int DM_AUTO = 0;
    public static final int DM_ASCII = 1;
    public static final int DM_C40 = 2;
    public static final int DM_TEXT = 3;
    public static final int DM_B256 = 4;
    public static final int DM_X21 = 5;
    public static final int DM_EDIFACT = 6;
    public static final int DM_RAW = 7;
    public static final int DM_EXTENSION = 32;
    public static final int DM_TEST = 64;
    private static final a[] a = new a[]{new a(10, 10, 10, 10, 3, 3, 5), new a(12, 12, 12, 12, 5, 5, 7), new a(8, 18, 8, 18, 5, 5, 7), new a(14, 14, 14, 14, 8, 8, 10), new a(8, 32, 8, 16, 10, 10, 11), new a(16, 16, 16, 16, 12, 12, 12), new a(12, 26, 12, 26, 16, 16, 14), new a(18, 18, 18, 18, 18, 18, 14), new a(20, 20, 20, 20, 22, 22, 18), new a(12, 36, 12, 18, 22, 22, 18), new a(22, 22, 22, 22, 30, 30, 20), new a(16, 36, 16, 18, 32, 32, 24), new a(24, 24, 24, 24, 36, 36, 24), new a(26, 26, 26, 26, 44, 44, 28), new a(16, 48, 16, 24, 49, 49, 28), new a(32, 32, 16, 16, 62, 62, 36), new a(36, 36, 18, 18, 86, 86, 42), new a(40, 40, 20, 20, 114, 114, 48), new a(44, 44, 22, 22, 144, 144, 56), new a(48, 48, 24, 24, 174, 174, 68), new a(52, 52, 26, 26, 204, 102, 42), new a(64, 64, 16, 16, 280, 140, 56), new a(72, 72, 18, 18, 368, 92, 36), new a(80, 80, 20, 20, 456, 114, 48), new a(88, 88, 22, 22, 576, 144, 56), new a(96, 96, 24, 24, 696, 174, 68), new a(104, 104, 26, 26, 816, 136, 56), new a(120, 120, 20, 20, 1050, 175, 68), new a(132, 132, 22, 22, 1304, 163, 62), new a(144, 144, 24, 24, 1558, 156, 62)};
    private int b;
    private short[] c;
    private byte[] d;
    private int e;
    private int f;
    private int g;
    private int h;

    private void a(int n2, int n3, int n4) {
        int n5 = n3 * n4 + n2 / 8;
        this.d[n5] = (byte)(this.d[n5] | (byte)(128 >> (n2 & 7)));
    }

    private static boolean a(int n2) {
        return n2 >= 48 && n2 <= 57;
    }

    private static int a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        int n6 = n2;
        int n7 = n4;
        n3 += n2;
        n5 += n4;
        while (n6 < n3) {
            if (n7 >= n5) {
                return -1;
            }
            if (BarcodeDatamatrix.a(n2 = byArray[n6++] & 0xFF) && n6 < n3 && BarcodeDatamatrix.a(byArray[n6] & 0xFF)) {
                byArray2[n7++] = (byte)((n2 - 48) * 10 + (byArray[n6++] & 0xFF) - 48 + 130);
                continue;
            }
            if (n2 > 127) {
                if (n7 + 1 >= n5) {
                    return -1;
                }
                byArray2[n7++] = -21;
                byArray2[n7++] = (byte)(n2 - 128 + 1);
                continue;
            }
            byArray2[n7++] = (byte)(n2 + 1);
        }
        return n7 - n4;
    }

    private static int b(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        if (n3 == 0) {
            return 0;
        }
        if (n3 < 250 && n3 + 2 > n5) {
            return -1;
        }
        if (n3 >= 250 && n3 + 3 > n5) {
            return -1;
        }
        byArray2[n4] = -25;
        if (n3 < 250) {
            byArray2[n4 + 1] = (byte)n3;
            n5 = 2;
        } else {
            byArray2[n4 + 1] = (byte)(n3 / 250 + 249);
            byArray2[n4 + 2] = (byte)(n3 % 250);
            n5 = 3;
        }
        System.arraycopy(byArray, n2, byArray2, n5 + n4, n3);
        n5 += n3 + n4;
        for (int i2 = n4 + 1; i2 < n5; ++i2) {
            n3 = byArray2[i2] & 0xFF;
            n2 = 149 * (i2 + 1) % 255 + 1;
            if ((n2 = n3 + n2) > 255) {
                n2 -= 256;
            }
            byArray2[i2] = (byte)n2;
        }
        return n5 - n4;
    }

    private static int c(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        int n6;
        int n7;
        if (n3 == 0) {
            return 0;
        }
        int n8 = 0;
        byte[] byArray3 = new byte[n3];
        int n9 = 0;
        for (n7 = 0; n7 < n3; ++n7) {
            n6 = "\r*> 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf((char)byArray[n7 + n2]);
            if (n6 >= 0) {
                byArray3[n7] = (byte)n6;
                ++n9;
                continue;
            }
            byArray3[n7] = 100;
            if (n9 >= 6) {
                int n10 = n9;
                n9 = n10 - n10 / 3 * 3;
            }
            for (n6 = 0; n6 < n9; ++n6) {
                byArray3[n7 - n6 - 1] = 100;
            }
            n9 = 0;
        }
        if (n9 >= 6) {
            int n11 = n9;
            n9 = n11 - n11 / 3 * 3;
        }
        for (n6 = 0; n6 < n9; ++n6) {
            byArray3[n7 - n6 - 1] = 100;
        }
        for (n7 = 0; n7 < n3; ++n7) {
            n9 = byArray3[n7];
            if (n8 >= n5) break;
            if (n9 < 40) {
                if (n7 == 0 || byArray3[n7 - 1] > 40) {
                    byArray2[n4 + n8++] = -18;
                }
                if (n8 + 2 > n5 || byArray3.length - 1 < n7 + 2) break;
                n9 = 1600 * byArray3[n7] + 40 * byArray3[n7 + 1] + byArray3[n7 + 2] + 1;
                byArray2[n4 + n8++] = (byte)(n9 / 256);
                byArray2[n4 + n8++] = (byte)n9;
                n7 += 2;
                continue;
            }
            if (n7 > 0 && byArray3[n7 - 1] < 40) {
                byArray2[n4 + n8++] = -2;
            }
            if ((n9 = byArray[n7 + n2] & 0xFF) > 127) {
                byArray2[n4 + n8++] = -21;
                n9 -= 128;
            }
            if (n8 >= n5) break;
            byArray2[n4 + n8++] = (byte)(n9 + 1);
        }
        n9 = byArray3[n3 - 1];
        if (n7 != n3 || n9 < 40 && n8 >= n5) {
            return -1;
        }
        if (n9 < 40) {
            byArray2[n4 + n8++] = -2;
        }
        return n8;
    }

    private static int d(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        int n6;
        if (n3 == 0) {
            return 0;
        }
        int n7 = 0;
        int n8 = 0;
        int n9 = 18;
        boolean bl2 = true;
        for (n6 = 0; n6 < n3; ++n6) {
            int n10 = byArray[n6 + n2] & 0xFF;
            if (((n10 & 0xE0) == 64 || (n10 & 0xE0) == 32) && n10 != 95) {
                if (bl2) {
                    if (n7 + 1 > n5) break;
                    byArray2[n4 + n7++] = -16;
                    bl2 = false;
                }
                n8 |= (n10 &= 0x3F) << n9;
                if (n9 == 0) {
                    if (n7 + 3 > n5) break;
                    byArray2[n4 + n7++] = (byte)(n8 >> 16);
                    byArray2[n4 + n7++] = (byte)(n8 >> 8);
                    byArray2[n4 + n7++] = (byte)n8;
                    n8 = 0;
                    n9 = 18;
                    continue;
                }
                n9 -= 6;
                continue;
            }
            if (!bl2) {
                n8 |= 31 << n9;
                if (n7 + (3 - n9 / 8) > n5) break;
                byArray2[n4 + n7++] = (byte)(n8 >> 16);
                if (n9 <= 12) {
                    byArray2[n4 + n7++] = (byte)(n8 >> 8);
                }
                if (n9 <= 6) {
                    byArray2[n4 + n7++] = (byte)n8;
                }
                bl2 = true;
                n9 = 18;
                n8 = 0;
            }
            if (n10 > 127) {
                if (n7 >= n5) break;
                byArray2[n4 + n7++] = -21;
                n10 -= 128;
            }
            if (n7 >= n5) break;
            byArray2[n4 + n7++] = (byte)(n10 + 1);
        }
        if (n6 != n3) {
            return -1;
        }
        if (!bl2) {
            n8 |= 31 << n9;
            if (n7 + (3 - n9 / 8) > n5) {
                return -1;
            }
            byArray2[n4 + n7++] = (byte)(n8 >> 16);
            if (n9 <= 12) {
                byArray2[n4 + n7++] = (byte)(n8 >> 8);
            }
            if (n9 <= 6) {
                byArray2[n4 + n7++] = (byte)n8;
            }
        }
        return n7;
    }

    private static int a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, boolean n6) {
        String string;
        String string2;
        if (n3 == 0) {
            return 0;
        }
        int n7 = 0;
        int n8 = 0;
        if (n6 != 0) {
            ++n8;
            byArray2[n4 + 0] = -26;
        } else {
            ++n8;
            byArray2[n4 + 0] = -17;
        }
        String string3 = "!\"#$%&'()*+,-./:;<=>?@[\\]^_";
        if (n6 != 0) {
            string2 = " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            string = "`abcdefghijklmnopqrstuvwxyz{|}~\u007f";
        } else {
            string2 = " 0123456789abcdefghijklmnopqrstuvwxyz";
            string = "`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~\u007f";
        }
        int[] nArray = new int[(n3 << 2) + 10];
        n6 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n7 < n3) {
            int n11;
            int n12;
            if (n6 % 3 == 0) {
                n9 = n7;
                n10 = n6;
            }
            if ((n12 = byArray[n2 + n7++] & 0xFF) > 127) {
                n12 -= 128;
                nArray[n6++] = 1;
                nArray[n6++] = 30;
            }
            if ((n11 = string2.indexOf((char)n12)) >= 0) {
                nArray[n6++] = n11 + 3;
                continue;
            }
            if (n12 < 32) {
                nArray[n6++] = 0;
                nArray[n6++] = n12;
                continue;
            }
            n11 = string3.indexOf((char)n12);
            if (n11 >= 0) {
                nArray[n6++] = 1;
                nArray[n6++] = n11;
                continue;
            }
            n11 = string.indexOf((char)n12);
            if (n11 < 0) continue;
            nArray[n6++] = 2;
            nArray[n6++] = n11;
        }
        if (n6 % 3 != 0) {
            n7 = n9;
            n6 = n10;
        }
        if (n6 / 3 << 1 > n5 - 2) {
            return -1;
        }
        for (n2 = 0; n2 < n6; n2 += 3) {
            n9 = 1600 * nArray[n2] + 40 * nArray[n2 + 1] + nArray[n2 + 2] + 1;
            byArray2[n4 + n8++] = (byte)(n9 / 256);
            byArray2[n4 + n8++] = (byte)n9;
        }
        byArray2[n8++] = -2;
        n2 = BarcodeDatamatrix.a(byArray, n7, n3 - n7, byArray2, n8, n5 - n8);
        if (n2 < 0) {
            return n2;
        }
        return n8 + n2;
    }

    private static int a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, int n6, boolean n7) {
        int[] nArray = new int[6];
        if (n5 < 0) {
            return -1;
        }
        if ((n6 &= 7) == 0) {
            nArray[0] = BarcodeDatamatrix.a(byArray, n2, n3, byArray2, n4, n5);
            if (n7 != 0 && nArray[0] >= 0) {
                return nArray[0];
            }
            nArray[1] = BarcodeDatamatrix.a(byArray, n2, n3, byArray2, n4, n5, false);
            if (n7 != 0 && nArray[1] >= 0) {
                return nArray[1];
            }
            nArray[2] = BarcodeDatamatrix.a(byArray, n2, n3, byArray2, n4, n5, true);
            if (n7 != 0 && nArray[2] >= 0) {
                return nArray[2];
            }
            nArray[3] = BarcodeDatamatrix.b(byArray, n2, n3, byArray2, n4, n5);
            if (n7 != 0 && nArray[3] >= 0) {
                return nArray[3];
            }
            nArray[4] = BarcodeDatamatrix.c(byArray, n2, n3, byArray2, n4, n5);
            if (n7 != 0 && nArray[4] >= 0) {
                return nArray[4];
            }
            nArray[5] = BarcodeDatamatrix.d(byArray, n2, n3, byArray2, n4, n5);
            if (n7 != 0 && nArray[5] >= 0) {
                return nArray[5];
            }
            if (nArray[0] < 0 && nArray[1] < 0 && nArray[2] < 0 && nArray[3] < 0 && nArray[4] < 0 && nArray[5] < 0) {
                return -1;
            }
            n7 = 0;
            n6 = 99999;
            for (int i2 = 0; i2 < 6; ++i2) {
                if (nArray[i2] < 0 || nArray[i2] >= n6) continue;
                n6 = nArray[i2];
                n7 = i2;
            }
            if (n7 == 0) {
                n6 = BarcodeDatamatrix.a(byArray, n2, n3, byArray2, n4, n5);
            } else if (n7 == 1) {
                n6 = BarcodeDatamatrix.a(byArray, n2, n3, byArray2, n4, n5, false);
            } else if (n7 == 2) {
                n6 = BarcodeDatamatrix.a(byArray, n2, n3, byArray2, n4, n5, true);
            } else if (n7 == 3) {
                n6 = BarcodeDatamatrix.b(byArray, n2, n3, byArray2, n4, n5);
            } else if (n7 == 4) {
                n6 = BarcodeDatamatrix.c(byArray, n2, n3, byArray2, n4, n5);
            }
            return n6;
        }
        switch (n6) {
            case 1: {
                return BarcodeDatamatrix.a(byArray, n2, n3, byArray2, n4, n5);
            }
            case 2: {
                return BarcodeDatamatrix.a(byArray, n2, n3, byArray2, n4, n5, true);
            }
            case 3: {
                return BarcodeDatamatrix.a(byArray, n2, n3, byArray2, n4, n5, false);
            }
            case 4: {
                return BarcodeDatamatrix.b(byArray, n2, n3, byArray2, n4, n5);
            }
            case 5: {
                return BarcodeDatamatrix.c(byArray, n2, n3, byArray2, n4, n5);
            }
            case 6: {
                return BarcodeDatamatrix.d(byArray, n2, n3, byArray2, n4, n5);
            }
            case 7: {
                if (n3 > n5) {
                    return -1;
                }
                System.arraycopy(byArray, n2, byArray2, n4, n3);
                return n3;
            }
        }
        return -1;
    }

    private static int a(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5;
            if ((n5 = byArray[n2++] & 0xFF) < 48 || n5 > 57) {
                return -1;
            }
            n4 = n4 * 10 + n5 - 48;
        }
        return n4;
    }

    public int generate(String object) {
        object = ((String)object).getBytes(StandardCharsets.ISO_8859_1);
        return this.generate((byte[])object, 0, ((Object)object).length);
    }

    public int generate(byte[] byArray, int n2, int n3) {
        int n4;
        a a2;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        Object object;
        byte[] byArray2;
        block40: {
            byArray2 = new byte[2500];
            this.b = 0;
            object = byArray2;
            n17 = n3;
            n16 = n2;
            byte[] byArray3 = byArray;
            BarcodeDatamatrix barcodeDatamatrix = this;
            if ((barcodeDatamatrix.h & 0x20) == 0) {
                n15 = 0;
            } else {
                n14 = 0;
                n13 = 0;
                n12 = 0;
                block8: while (n13 < n17 && n14 <= 20) {
                    n11 = byArray3[n16 + n13++] & 0xFF;
                    ++n14;
                    switch (n11) {
                        case 46: {
                            barcodeDatamatrix.b = n13;
                            n15 = n12;
                            break block40;
                        }
                        case 101: {
                            if (n13 + 6 > n17 || (n10 = BarcodeDatamatrix.a(byArray3, n16 + n13, 6)) < 0) break block8;
                            n13 += 6;
                            object[n12++] = -15;
                            if (n10 < 127) {
                                object[n12++] = (byte)(n10 + 1);
                                continue block8;
                            }
                            if (n10 < 16383) {
                                object[n12++] = (byte)((n10 - 127) / 254 + 128);
                                object[n12++] = (byte)((n10 - 127) % 254 + 1);
                                continue block8;
                            }
                            object[n12++] = (byte)((n10 - 16383) / 64516 + 192);
                            object[n12++] = (byte)((n10 - 16383) / 254 % 254 + 1);
                            object[n12++] = (byte)((n10 - 16383) % 254 + 1);
                            continue block8;
                        }
                        case 115: {
                            if (n14 != 1 || n13 + 9 > n17) break block8;
                            n9 = BarcodeDatamatrix.a(byArray3, n16 + n13, 2);
                            if (n9 <= 0 || n9 > 16) {
                                n15 = -1;
                                break block40;
                            }
                            n8 = BarcodeDatamatrix.a(byArray3, n16 + (n13 += 2), 2);
                            if (n8 <= 1 || n8 > 16) {
                                n15 = -1;
                                break block40;
                            }
                            n7 = BarcodeDatamatrix.a(byArray3, n16 + (n13 += 2), 5);
                            if (n7 < 0) break block8;
                            n13 += 5;
                            object[n12++] = -23;
                            object[n12++] = (byte)(n9 - 1 << 4 | 17 - n8);
                            object[n12++] = (byte)(n7 / 254 + 1);
                            object[n12++] = (byte)(n7 % 254 + 1);
                            continue block8;
                        }
                        case 112: {
                            if (n14 != 1) break block8;
                            object[n12++] = -22;
                            continue block8;
                        }
                        case 109: {
                            if (n14 != 1 || n13 + 1 > n17 || (n11 = byArray3[n16 + n13++] & 0xFF) != 53 && n11 != 53) break block8;
                            object[n12++] = -22;
                            object[n12++] = (byte)(n11 == 53 ? 236 : 237);
                            continue block8;
                        }
                        case 102: {
                            if (n14 != 1 && (n14 != 2 || byArray3[n16] != 115 && byArray3[n16] != 109)) {
                                n15 = -1;
                                break block40;
                            }
                            object[n12++] = -24;
                        }
                        default: {
                            continue block8;
                        }
                    }
                }
                n15 = n6 = -1;
            }
        }
        if (n15 < 0) {
            return 5;
        }
        if (this.e == 0 || this.f == 0) {
            int n18;
            object = a[a.length - 1];
            n5 = BarcodeDatamatrix.a(byArray, n2 + this.b, n3 - this.b, byArray2, n6, object.e - n6, this.h, false);
            if (n5 < 0) {
                return 1;
            }
            n5 += n6;
            for (n18 = 0; n18 < a.length && BarcodeDatamatrix.a[n18].e < n5; ++n18) {
            }
            a2 = a[n18];
            this.e = a2.a;
            this.f = a2.b;
        } else {
            int n19;
            for (n19 = 0; n19 < a.length && (this.e != BarcodeDatamatrix.a[n19].a || this.f != BarcodeDatamatrix.a[n19].b); ++n19) {
            }
            if (n19 == a.length) {
                return 3;
            }
            a2 = a[n19];
            n5 = BarcodeDatamatrix.a(byArray, n2 + this.b, n3 - this.b, byArray2, n6, a2.e - n6, this.h, true);
            if (n5 < 0) {
                return 1;
            }
            n5 += n6;
        }
        if ((this.h & 0x40) != 0) {
            return 0;
        }
        this.d = new byte[(a2.b + 2 * this.g + 7) / 8 * (a2.a + 2 * this.g)];
        n16 = a2.e - n5;
        int n20 = n5;
        Object object2 = byArray2;
        if (n16 > 0) {
            object2[n20++] = -127;
            while (--n16 > 0) {
                n17 = 129 + (n20 + 1) * 149 % 253 + 1;
                if (n17 > 254) {
                    n17 -= 254;
                }
                object2[n20++] = (byte)n17;
            }
        }
        this.c = com.lowagie.text.pdf.BarcodeDatamatrix$b.a(a2.a - (a2.a / a2.c << 1), a2.b - (a2.b / a2.d << 1));
        int cfr_ignored_0 = a2.e;
        int cfr_ignored_1 = (a2.e + 2) / a2.f;
        int cfr_ignored_2 = a2.g;
        com.lowagie.text.pdf.BarcodeDatamatrix$c.a(byArray2, a2.e, a2.f, a2.g);
        a a3 = a2;
        byte[] byArray4 = byArray2;
        object2 = this;
        n11 = (a3.b + (((BarcodeDatamatrix)object2).g << 1) + 7) / 8;
        Arrays.fill(((BarcodeDatamatrix)object2).d, (byte)0);
        for (n4 = ((BarcodeDatamatrix)object2).g; n4 < a3.a + ((BarcodeDatamatrix)object2).g; n4 += a3.c) {
            for (n14 = ((BarcodeDatamatrix)object2).g; n14 < a3.b + ((BarcodeDatamatrix)object2).g; n14 += 2) {
                super.a(n14, n4, n11);
            }
        }
        for (n4 = a3.c - 1 + ((BarcodeDatamatrix)object2).g; n4 < a3.a + ((BarcodeDatamatrix)object2).g; n4 += a3.c) {
            for (n14 = ((BarcodeDatamatrix)object2).g; n14 < a3.b + ((BarcodeDatamatrix)object2).g; ++n14) {
                super.a(n14, n4, n11);
            }
        }
        for (n4 = ((BarcodeDatamatrix)object2).g; n4 < a3.b + ((BarcodeDatamatrix)object2).g; n4 += a3.d) {
            for (n14 = ((BarcodeDatamatrix)object2).g; n14 < a3.a + ((BarcodeDatamatrix)object2).g; ++n14) {
                super.a(n4, n14, n11);
            }
        }
        for (n4 = a3.d - 1 + ((BarcodeDatamatrix)object2).g; n4 < a3.b + ((BarcodeDatamatrix)object2).g; n4 += a3.d) {
            for (n14 = 1 + ((BarcodeDatamatrix)object2).g; n14 < a3.a + ((BarcodeDatamatrix)object2).g; n14 += 2) {
                super.a(n4, n14, n11);
            }
        }
        n13 = 0;
        for (n8 = 0; n8 < a3.a; n8 += a3.c) {
            for (n10 = 1; n10 < a3.c - 1; ++n10) {
                for (n9 = 0; n9 < a3.b; n9 += a3.d) {
                    for (n12 = 1; n12 < a3.d - 1; ++n12) {
                        if ((n7 = ((BarcodeDatamatrix)object2).c[n13++]) != 1 && (n7 <= 1 || (byArray4[n7 / 8 - 1] & 0xFF & 128 >> n7 % 8) == 0)) continue;
                        super.a(n12 + n9 + ((BarcodeDatamatrix)object2).g, n10 + n8 + ((BarcodeDatamatrix)object2).g, n11);
                    }
                }
            }
        }
        return 0;
    }

    public Image createImage() {
        if (this.d == null) {
            return null;
        }
        byte[] byArray = CCITTG4Encoder.compress(this.d, this.f + 2 * this.g, this.e + 2 * this.g);
        return Image.getInstance(this.f + 2 * this.g, this.e + 2 * this.g, false, 256, 0, byArray, null);
    }

    public java.awt.Image createAwtImage(Color color, Color color2) {
        if (this.d == null) {
            return null;
        }
        int n2 = color.getRGB();
        int n3 = color2.getRGB();
        Canvas canvas = new Canvas();
        int n4 = this.f + 2 * this.g;
        int n5 = this.e + 2 * this.g;
        int[] nArray = new int[n4 * n5];
        int n6 = (n4 + 7) / 8;
        int n7 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n8 = i2 * n6;
            for (int i3 = 0; i3 < n4; ++i3) {
                int n9 = this.d[n8 + i3 / 8] & 0xFF;
                nArray[n7++] = ((n9 <<= i3 % 8) & 0x80) == 0 ? n3 : n2;
            }
        }
        java.awt.Image image = canvas.createImage(new MemoryImageSource(n4, n5, nArray, 0, n4));
        return image;
    }

    public byte[] getImage() {
        return this.d;
    }

    public int getHeight() {
        return this.e;
    }

    public void setHeight(int n2) {
        this.e = n2;
    }

    public int getWidth() {
        return this.f;
    }

    public void setWidth(int n2) {
        this.f = n2;
    }

    public int getWs() {
        return this.g;
    }

    public void setWs(int n2) {
        this.g = n2;
    }

    public int getOptions() {
        return this.h;
    }

    public void setOptions(int n2) {
        this.h = n2;
    }

    static final class c {
        private static final int[] a = new int[]{0, 255, 1, 240, 2, 225, 241, 53, 3, 38, 226, 133, 242, 43, 54, 210, 4, 195, 39, 114, 227, 106, 134, 28, 243, 140, 44, 23, 55, 118, 211, 234, 5, 219, 196, 96, 40, 222, 115, 103, 228, 78, 107, 125, 135, 8, 29, 162, 244, 186, 141, 180, 45, 99, 24, 49, 56, 13, 119, 153, 212, 199, 235, 91, 6, 76, 220, 217, 197, 11, 97, 184, 41, 36, 223, 253, 116, 138, 104, 193, 229, 86, 79, 171, 108, 165, 126, 145, 136, 34, 9, 74, 30, 32, 163, 84, 245, 173, 187, 204, 142, 81, 181, 190, 46, 88, 100, 159, 25, 231, 50, 207, 57, 147, 14, 67, 120, 128, 154, 248, 213, 167, 200, 63, 236, 110, 92, 176, 7, 161, 77, 124, 221, 102, 218, 95, 198, 90, 12, 152, 98, 48, 185, 179, 42, 209, 37, 132, 224, 52, 254, 239, 117, 233, 139, 22, 105, 27, 194, 113, 230, 206, 87, 158, 80, 189, 172, 203, 109, 175, 166, 62, 127, 247, 146, 66, 137, 192, 35, 252, 10, 183, 75, 216, 31, 83, 33, 73, 164, 144, 85, 170, 246, 65, 174, 61, 188, 202, 205, 157, 143, 169, 82, 72, 182, 215, 191, 251, 47, 178, 89, 151, 101, 94, 160, 123, 26, 112, 232, 21, 51, 238, 208, 131, 58, 69, 148, 18, 15, 16, 68, 17, 121, 149, 129, 19, 155, 59, 249, 70, 214, 250, 168, 71, 201, 156, 64, 60, 237, 130, 111, 20, 93, 122, 177, 150};
        private static final int[] b = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 45, 90, 180, 69, 138, 57, 114, 228, 229, 231, 227, 235, 251, 219, 155, 27, 54, 108, 216, 157, 23, 46, 92, 184, 93, 186, 89, 178, 73, 146, 9, 18, 36, 72, 144, 13, 26, 52, 104, 208, 141, 55, 110, 220, 149, 7, 14, 28, 56, 112, 224, 237, 247, 195, 171, 123, 246, 193, 175, 115, 230, 225, 239, 243, 203, 187, 91, 182, 65, 130, 41, 82, 164, 101, 202, 185, 95, 190, 81, 162, 105, 210, 137, 63, 126, 252, 213, 135, 35, 70, 140, 53, 106, 212, 133, 39, 78, 156, 21, 42, 84, 168, 125, 250, 217, 159, 19, 38, 76, 152, 29, 58, 116, 232, 253, 215, 131, 43, 86, 172, 117, 234, 249, 223, 147, 11, 22, 44, 88, 176, 77, 154, 25, 50, 100, 200, 189, 87, 174, 113, 226, 233, 255, 211, 139, 59, 118, 236, 245, 199, 163, 107, 214, 129, 47, 94, 188, 85, 170, 121, 242, 201, 191, 83, 166, 97, 194, 169, 127, 254, 209, 143, 51, 102, 204, 181, 71, 142, 49, 98, 196, 165, 103, 206, 177, 79, 158, 17, 34, 68, 136, 61, 122, 244, 197, 167, 99, 198, 161, 111, 222, 145, 15, 30, 60, 120, 240, 205, 183, 67, 134, 33, 66, 132, 37, 74, 148, 5, 10, 20, 40, 80, 160, 109, 218, 153, 31, 62, 124, 248, 221, 151, 3, 6, 12, 24, 48, 96, 192, 173, 119, 238, 241, 207, 179, 75, 150, 1};
        private static final int[] c = new int[]{228, 48, 15, 111, 62};
        private static final int[] d = new int[]{23, 68, 144, 134, 240, 92, 254};
        private static final int[] e = new int[]{28, 24, 185, 166, 223, 248, 116, 255, 110, 61};
        private static final int[] f = new int[]{175, 138, 205, 12, 194, 168, 39, 245, 60, 97, 120};
        private static final int[] g = new int[]{41, 153, 158, 91, 61, 42, 142, 213, 97, 178, 100, 242};
        private static final int[] h = new int[]{156, 97, 192, 252, 95, 9, 157, 119, 138, 45, 18, 186, 83, 185};
        private static final int[] i = new int[]{83, 195, 100, 39, 188, 75, 66, 61, 241, 213, 109, 129, 94, 254, 225, 48, 90, 188};
        private static final int[] j = new int[]{15, 195, 244, 9, 233, 71, 168, 2, 188, 160, 153, 145, 253, 79, 108, 82, 27, 174, 186, 172};
        private static final int[] k = new int[]{52, 190, 88, 205, 109, 39, 176, 21, 155, 197, 251, 223, 155, 21, 5, 172, 254, 124, 12, 181, 184, 96, 50, 193};
        private static final int[] l = new int[]{211, 231, 43, 97, 71, 96, 103, 174, 37, 151, 170, 53, 75, 34, 249, 121, 17, 138, 110, 213, 141, 136, 120, 151, 233, 168, 93, 255};
        private static final int[] m = new int[]{245, 127, 242, 218, 130, 250, 162, 181, 102, 120, 84, 179, 220, 251, 80, 182, 229, 18, 2, 4, 68, 33, 101, 137, 95, 119, 115, 44, 175, 184, 59, 25, 225, 98, 81, 112};
        private static final int[] n = new int[]{77, 193, 137, 31, 19, 38, 22, 153, 247, 105, 122, 2, 245, 133, 242, 8, 175, 95, 100, 9, 167, 105, 214, 111, 57, 121, 21, 1, 253, 57, 54, 101, 248, 202, 69, 50, 150, 177, 226, 5, 9, 5};
        private static final int[] o = new int[]{245, 132, 172, 223, 96, 32, 117, 22, 238, 133, 238, 231, 205, 188, 237, 87, 191, 106, 16, 147, 118, 23, 37, 90, 170, 205, 131, 88, 120, 100, 66, 138, 186, 240, 82, 44, 176, 87, 187, 147, 160, 175, 69, 213, 92, 253, 225, 19};
        private static final int[] p = new int[]{175, 9, 223, 238, 12, 17, 220, 208, 100, 29, 175, 170, 230, 192, 215, 235, 150, 159, 36, 223, 38, 200, 132, 54, 228, 146, 218, 234, 117, 203, 29, 232, 144, 238, 22, 150, 201, 117, 62, 207, 164, 13, 137, 245, 127, 67, 247, 28, 155, 43, 203, 107, 233, 53, 143, 46};
        private static final int[] q = new int[]{242, 93, 169, 50, 144, 210, 39, 118, 202, 188, 201, 189, 143, 108, 196, 37, 185, 112, 134, 230, 245, 63, 197, 190, 250, 106, 185, 221, 175, 64, 114, 71, 161, 44, 147, 6, 27, 218, 51, 63, 87, 10, 40, 130, 188, 17, 163, 31, 176, 170, 4, 107, 232, 7, 94, 166, 224, 124, 86, 47, 11, 204};
        private static final int[] r = new int[]{220, 228, 173, 89, 251, 149, 159, 56, 89, 33, 147, 244, 154, 36, 73, 127, 213, 136, 248, 180, 234, 197, 158, 177, 68, 122, 93, 213, 15, 160, 227, 236, 66, 139, 153, 185, 202, 167, 179, 25, 220, 232, 96, 210, 231, 136, 223, 239, 181, 241, 59, 52, 172, 25, 49, 232, 211, 189, 64, 54, 108, 153, 132, 63, 96, 103, 82, 186};

        static void a(byte[] byArray, int n2, int n3, int n4) {
            int[] nArray;
            n3 = (n2 + 2) / n3;
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            int n5 = n4;
            switch (n5) {
                case 5: {
                    nArray = c;
                    break;
                }
                case 7: {
                    nArray = d;
                    break;
                }
                case 10: {
                    nArray = e;
                    break;
                }
                case 11: {
                    nArray = f;
                    break;
                }
                case 12: {
                    nArray = g;
                    break;
                }
                case 14: {
                    nArray = h;
                    break;
                }
                case 18: {
                    nArray = i;
                    break;
                }
                case 20: {
                    nArray = j;
                    break;
                }
                case 24: {
                    nArray = k;
                    break;
                }
                case 28: {
                    nArray = l;
                    break;
                }
                case 36: {
                    nArray = m;
                    break;
                }
                case 42: {
                    nArray = n;
                    break;
                }
                case 48: {
                    nArray = o;
                    break;
                }
                case 56: {
                    nArray = p;
                    break;
                }
                case 62: {
                    nArray = q;
                    break;
                }
                case 68: {
                    nArray = r;
                    break;
                }
                default: {
                    nArray = null;
                }
            }
            int[] nArray2 = nArray;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n6;
                int n7 = 0;
                for (n5 = i2; n5 < n2; n5 += n3) {
                    byArray2[n7++] = byArray[n5];
                }
                int[] nArray3 = nArray2;
                int n8 = n4;
                byte[] byArray4 = byArray3;
                byte[] byArray5 = byArray2;
                for (n6 = 0; n6 <= n8; ++n6) {
                    byArray4[n6] = 0;
                }
                for (n6 = 0; n6 < n7; ++n6) {
                    int n9 = (byArray4[0] ^ byArray5[n6]) & 0xFF;
                    for (int i3 = 0; i3 < n8; ++i3) {
                        byArray4[i3] = (byte)(byArray4[i3 + 1] ^ (n9 == 0 ? (byte)0 : (byte)b[(a[n9] + a[nArray3[n8 - i3 - 1]]) % 255]));
                    }
                }
                n7 = 0;
                for (n5 = i2; n5 < n4 * n3; n5 += n3) {
                    byArray[n2 + n5] = byArray3[n7++];
                }
            }
        }
    }

    static final class b {
        private int a;
        private int b;
        private short[] c;
        private static final Map<Integer, short[]> d = new Hashtable<Integer, short[]>();

        private b() {
        }

        static short[] a(int n2, int n3) {
            Integer n4 = n2 * 1000 + n3;
            Object object = d.get(n4);
            if (object != null) {
                return object;
            }
            object = new b();
            new b().a = n2;
            object.b = n3;
            object.c = new short[n2 * n3];
            short[] sArray = object;
            Arrays.fill(sArray.c, (short)0);
            int n5 = 1;
            n3 = 4;
            int n6 = 0;
            do {
                short[] sArray2;
                int n7;
                if (n3 == sArray.a && n6 == 0) {
                    n7 = n5++;
                    sArray2 = sArray;
                    super.a(sArray2.a - 1, 0, n7, 0);
                    short[] sArray3 = sArray2;
                    super.a(sArray3.a - 1, 1, n7, 1);
                    short[] sArray4 = sArray2;
                    super.a(sArray4.a - 1, 2, n7, 2);
                    super.a(0, sArray2.b - 2, n7, 3);
                    super.a(0, sArray2.b - 1, n7, 4);
                    super.a(1, sArray2.b - 1, n7, 5);
                    super.a(2, sArray2.b - 1, n7, 6);
                    super.a(3, sArray2.b - 1, n7, 7);
                }
                if (n3 == sArray.a - 2 && n6 == 0 && sArray.b % 4 != 0) {
                    n7 = n5++;
                    sArray2 = sArray;
                    super.a(sArray2.a - 3, 0, n7, 0);
                    Object object2 = sArray2;
                    super.a(((b)object2).a - 2, 0, n7, 1);
                    short[] sArray5 = sArray2;
                    super.a(sArray5.a - 1, 0, n7, 2);
                    super.a(0, sArray2.b - 4, n7, 3);
                    super.a(0, sArray2.b - 3, n7, 4);
                    super.a(0, sArray2.b - 2, n7, 5);
                    super.a(0, sArray2.b - 1, n7, 6);
                    super.a(1, sArray2.b - 1, n7, 7);
                }
                if (n3 == sArray.a - 2 && n6 == 0 && sArray.b % 8 == 4) {
                    n7 = n5++;
                    sArray2 = sArray;
                    super.a(sArray2.a - 3, 0, n7, 0);
                    Object object3 = sArray2;
                    super.a(((b)object3).a - 2, 0, n7, 1);
                    Object object4 = sArray2;
                    super.a(((b)object4).a - 1, 0, n7, 2);
                    super.a(0, sArray2.b - 2, n7, 3);
                    super.a(0, sArray2.b - 1, n7, 4);
                    super.a(1, sArray2.b - 1, n7, 5);
                    super.a(2, sArray2.b - 1, n7, 6);
                    super.a(3, sArray2.b - 1, n7, 7);
                }
                if (n3 == sArray.a + 4 && n6 == 2 && sArray.b % 8 == 0) {
                    n7 = n5++;
                    sArray2 = sArray;
                    super.a(sArray2.a - 1, 0, n7, 0);
                    short[] sArray6 = sArray2;
                    super.a(sArray6.a - 1, sArray2.b - 1, n7, 1);
                    super.a(0, sArray2.b - 3, n7, 2);
                    super.a(0, sArray2.b - 2, n7, 3);
                    super.a(0, sArray2.b - 1, n7, 4);
                    super.a(1, sArray2.b - 3, n7, 5);
                    super.a(1, sArray2.b - 2, n7, 6);
                    super.a(1, sArray2.b - 1, n7, 7);
                }
                do {
                    if (n3 >= sArray.a || n6 < 0 || sArray.c[n3 * sArray.b + n6] != 0) continue;
                    super.a(n3, n6, n5++);
                } while ((n3 -= 2) >= 0 && (n6 += 2) < sArray.b);
                ++n3;
                n6 += 3;
                do {
                    if (n3 < 0 || n6 >= sArray.b || sArray.c[n3 * sArray.b + n6] != 0) continue;
                    super.a(n3, n6, n5++);
                } while ((n3 += 2) < sArray.a && (n6 -= 2) >= 0);
            } while ((n3 += 3) < sArray.a || ++n6 < sArray.b);
            if (sArray.c[sArray.a * sArray.b - 1] == 0) {
                sArray.c[sArray.a * sArray.b - sArray.b - 2] = 1;
                sArray.c[sArray.a * sArray.b - 1] = 1;
            }
            d.put(n4, object.c);
            return object.c;
        }

        private void a(int n2, int n3, int n4, int n5) {
            if (n2 < 0) {
                n2 += this.a;
                n3 += 4 - (this.a + 4) % 8;
            }
            if (n3 < 0) {
                n3 += this.b;
                n2 += 4 - (this.b + 4) % 8;
            }
            this.c[n2 * this.b + n3] = (short)(n4 * 8 + n5);
        }

        private void a(int n2, int n3, int n4) {
            this.a(n2 - 2, n3 - 2, n4, 0);
            this.a(n2 - 2, n3 - 1, n4, 1);
            this.a(n2 - 1, n3 - 2, n4, 2);
            this.a(n2 - 1, n3 - 1, n4, 3);
            this.a(n2 - 1, n3, n4, 4);
            this.a(n2, n3 - 2, n4, 5);
            this.a(n2, n3 - 1, n4, 6);
            this.a(n2, n3, n4, 7);
        }
    }

    private static final class a {
        int a;
        int b;
        int c;
        int d;
        int e;
        int f;
        int g;

        a(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
            this.d = n5;
            this.e = n6;
            this.f = n7;
            this.g = n8;
        }
    }
}

