/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;

public class BarcodeEAN
extends Barcode {
    private static final int[] a = new int[0];
    private static final int[] b = new int[]{0, 2, 4, 6, 28, 30, 52, 54, 56, 58};
    private static final int[] c = new int[]{0, 2, 28, 30, 56, 58};
    private static final int[] d = new int[]{0, 2, 20, 22, 40, 42};
    private static final int[] e = new int[]{0, 2, 28, 30, 32};
    private static final float[] f = new float[]{6.5f, 13.5f, 20.5f, 27.5f, 34.5f, 41.5f, 53.5f, 60.5f, 67.5f, 74.5f, 81.5f, 88.5f};
    private static final float[] g = new float[]{6.5f, 13.5f, 20.5f, 27.5f, 39.5f, 46.5f, 53.5f, 60.5f};
    private static final byte[][] h = new byte[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
    private static final byte[][] i = new byte[][]{{0, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 0, 1}, {0, 0, 1, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 0, 0, 1}, {0, 1, 1, 1, 0, 0}, {0, 1, 0, 1, 0, 1}, {0, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 0}};
    private static final byte[][] j = new byte[][]{{0, 0}, {0, 1}, {1, 0}, {1, 1}};
    private static final byte[][] k = new byte[][]{{1, 1, 0, 0, 0}, {1, 0, 1, 0, 0}, {1, 0, 0, 1, 0}, {1, 0, 0, 0, 1}, {0, 1, 1, 0, 0}, {0, 0, 1, 1, 0}, {0, 0, 0, 1, 1}, {0, 1, 0, 1, 0}, {0, 1, 0, 0, 1}, {0, 0, 1, 0, 1}};
    private static final byte[][] l = new byte[][]{{1, 1, 1, 0, 0, 0}, {1, 1, 0, 1, 0, 0}, {1, 1, 0, 0, 1, 0}, {1, 1, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 0}, {1, 0, 0, 1, 1, 0}, {1, 0, 0, 0, 1, 1}, {1, 0, 1, 0, 1, 0}, {1, 0, 1, 0, 0, 1}, {1, 0, 0, 1, 0, 1}};

    public BarcodeEAN() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.guardBars = true;
            this.codeType = 1;
            this.code = "";
            return;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static int calculateEANParity(String string) {
        int n2 = 3;
        int n3 = 0;
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            int n4 = string.charAt(i2) - 48;
            n3 += n2 * n4;
            n2 ^= 2;
        }
        return (10 - n3 % 10) % 10;
    }

    public static String convertUPCAtoUPCE(String string) {
        if (string.length() != 12 || !string.startsWith("0") && !string.startsWith("1")) {
            return null;
        }
        if (string.substring(3, 6).equals("000") || string.substring(3, 6).equals("100") || string.substring(3, 6).equals("200")) {
            if (string.substring(6, 8).equals("00")) {
                return string.substring(0, 1) + string.substring(1, 3) + string.substring(8, 11) + string.substring(3, 4) + string.substring(11);
            }
        } else if (string.substring(4, 6).equals("00")) {
            if (string.substring(6, 9).equals("000")) {
                return string.substring(0, 1) + string.substring(1, 4) + string.substring(9, 11) + "3" + string.substring(11);
            }
        } else if (string.substring(5, 6).equals("0")) {
            if (string.substring(6, 10).equals("0000")) {
                return string.substring(0, 1) + string.substring(1, 5) + string.substring(10, 11) + "4" + string.substring(11);
            }
        } else if (string.charAt(10) >= '5' && string.substring(6, 10).equals("0000")) {
            return string.substring(0, 1) + string.substring(1, 6) + string.substring(10, 11) + string.substring(11);
        }
        return null;
    }

    public static byte[] getBarsEAN13(String string) {
        byte[] byArray;
        int n2;
        int[] nArray = new int[string.length()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = string.charAt(i2) - 48;
        }
        byte[] byArray2 = new byte[59];
        int n3 = 0;
        ++n3;
        byArray2[0] = 1;
        ++n3;
        byArray2[1] = 1;
        ++n3;
        byArray2[2] = 1;
        byte[] byArray3 = i[nArray[0]];
        for (n2 = 0; n2 < byArray3.length; ++n2) {
            int n4 = nArray[n2 + 1];
            byArray = h[n4];
            if (byArray3[n2] == 0) {
                byArray2[n3++] = byArray[0];
                byArray2[n3++] = byArray[1];
                byArray2[n3++] = byArray[2];
                byArray2[n3++] = byArray[3];
                continue;
            }
            byArray2[n3++] = byArray[3];
            byArray2[n3++] = byArray[2];
            byArray2[n3++] = byArray[1];
            byArray2[n3++] = byArray[0];
        }
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        for (n2 = 7; n2 < 13; ++n2) {
            int n5 = nArray[n2];
            byArray = h[n5];
            byArray2[n3++] = byArray[0];
            byArray2[n3++] = byArray[1];
            byArray2[n3++] = byArray[2];
            byArray2[n3++] = byArray[3];
        }
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3] = 1;
        return byArray2;
    }

    public static byte[] getBarsEAN8(String string) {
        byte[] byArray;
        int n2;
        int[] nArray = new int[string.length()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = string.charAt(i2) - 48;
        }
        byte[] byArray2 = new byte[43];
        int n3 = 0;
        ++n3;
        byArray2[0] = 1;
        ++n3;
        byArray2[1] = 1;
        ++n3;
        byArray2[2] = 1;
        for (n2 = 0; n2 < 4; ++n2) {
            int n4 = nArray[n2];
            byArray = h[n4];
            byArray2[n3++] = byArray[0];
            byArray2[n3++] = byArray[1];
            byArray2[n3++] = byArray[2];
            byArray2[n3++] = byArray[3];
        }
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        for (n2 = 4; n2 < 8; ++n2) {
            int n5 = nArray[n2];
            byArray = h[n5];
            byArray2[n3++] = byArray[0];
            byArray2[n3++] = byArray[1];
            byArray2[n3++] = byArray[2];
            byArray2[n3++] = byArray[3];
        }
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3] = 1;
        return byArray2;
    }

    public static byte[] getBarsUPCE(String string) {
        int[] nArray = new int[string.length()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = string.charAt(i2) - 48;
        }
        byte[] byArray = new byte[33];
        boolean bl2 = nArray[0] != 0;
        int n2 = 0;
        ++n2;
        byArray[0] = 1;
        ++n2;
        byArray[1] = 1;
        ++n2;
        byArray[2] = 1;
        byte[] byArray2 = l[nArray[nArray.length - 1]];
        for (int i3 = 1; i3 < nArray.length - 1; ++i3) {
            int n3 = nArray[i3];
            byte[] byArray3 = h[n3];
            if (byArray2[i3 - 1] == (bl2 ? (byte)1 : 0)) {
                byArray[n2++] = byArray3[0];
                byArray[n2++] = byArray3[1];
                byArray[n2++] = byArray3[2];
                byArray[n2++] = byArray3[3];
                continue;
            }
            byArray[n2++] = byArray3[3];
            byArray[n2++] = byArray3[2];
            byArray[n2++] = byArray3[1];
            byArray[n2++] = byArray3[0];
        }
        byArray[n2++] = 1;
        byArray[n2++] = 1;
        byArray[n2++] = 1;
        byArray[n2++] = 1;
        byArray[n2++] = 1;
        byArray[n2] = 1;
        return byArray;
    }

    public static byte[] getBarsSupplemental2(String string) {
        int[] nArray = new int[2];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = string.charAt(i2) - 48;
        }
        byte[] byArray = new byte[13];
        int n2 = 0;
        int n3 = (nArray[0] * 10 + nArray[1]) % 4;
        ++n2;
        byArray[0] = 1;
        ++n2;
        byArray[1] = 1;
        ++n2;
        byArray[2] = 2;
        byte[] byArray2 = j[n3];
        for (int i3 = 0; i3 < byArray2.length; ++i3) {
            if (i3 == 1) {
                byArray[n2++] = 1;
                byArray[n2++] = 1;
            }
            int n4 = nArray[i3];
            byte[] byArray3 = h[n4];
            if (byArray2[i3] == 0) {
                byArray[n2++] = byArray3[0];
                byArray[n2++] = byArray3[1];
                byArray[n2++] = byArray3[2];
                byArray[n2++] = byArray3[3];
                continue;
            }
            byArray[n2++] = byArray3[3];
            byArray[n2++] = byArray3[2];
            byArray[n2++] = byArray3[1];
            byArray[n2++] = byArray3[0];
        }
        return byArray;
    }

    public static byte[] getBarsSupplemental5(String string) {
        int[] nArray = new int[5];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = string.charAt(i2) - 48;
        }
        byte[] byArray = new byte[31];
        int n2 = 0;
        int n3 = ((nArray[0] + nArray[2] + nArray[4]) * 3 + (nArray[1] + nArray[3]) * 9) % 10;
        ++n2;
        byArray[0] = 1;
        ++n2;
        byArray[1] = 1;
        ++n2;
        byArray[2] = 2;
        byte[] byArray2 = k[n3];
        for (int i3 = 0; i3 < byArray2.length; ++i3) {
            if (i3 != 0) {
                byArray[n2++] = 1;
                byArray[n2++] = 1;
            }
            int n4 = nArray[i3];
            byte[] byArray3 = h[n4];
            if (byArray2[i3] == 0) {
                byArray[n2++] = byArray3[0];
                byArray[n2++] = byArray3[1];
                byArray[n2++] = byArray3[2];
                byArray[n2++] = byArray3[3];
                continue;
            }
            byArray[n2++] = byArray3[3];
            byArray[n2++] = byArray3[2];
            byArray[n2++] = byArray3[1];
            byArray[n2++] = byArray3[0];
        }
        return byArray;
    }

    @Override
    public Rectangle getBarcodeSize() {
        float f2;
        float f3 = this.barHeight;
        if (this.font != null) {
            f3 = this.baseline <= 0.0f ? (f3 += -this.baseline + this.size) : (f3 += this.baseline - this.font.getFontDescriptor(3, this.size));
        }
        switch (this.codeType) {
            case 1: {
                f2 = this.x * 95.0f;
                if (this.font == null) break;
                f2 += this.font.getWidthPoint(this.code.charAt(0), this.size);
                break;
            }
            case 2: {
                f2 = this.x * 67.0f;
                break;
            }
            case 3: {
                f2 = this.x * 95.0f;
                if (this.font == null) break;
                f2 += this.font.getWidthPoint(this.code.charAt(0), this.size) + this.font.getWidthPoint(this.code.charAt(11), this.size);
                break;
            }
            case 4: {
                f2 = this.x * 51.0f;
                if (this.font == null) break;
                f2 += this.font.getWidthPoint(this.code.charAt(0), this.size) + this.font.getWidthPoint(this.code.charAt(7), this.size);
                break;
            }
            case 5: {
                f2 = this.x * 20.0f;
                break;
            }
            case 6: {
                f2 = this.x * 47.0f;
                break;
            }
            default: {
                throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.code.type"));
            }
        }
        return new Rectangle(f2, f3);
    }

    @Override
    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        Rectangle rectangle = ((Barcode)this).getBarcodeSize();
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f4 = this.barHeight - this.baseline;
            } else {
                f4 = -this.font.getFontDescriptor(3, this.size);
                f3 = f4 + this.baseline;
            }
        }
        switch (this.codeType) {
            case 1: 
            case 3: 
            case 4: {
                if (this.font == null) break;
                f2 = 0.0f + this.font.getWidthPoint(this.code.charAt(0), this.size);
            }
        }
        byte[] byArray = null;
        int[] nArray = a;
        switch (this.codeType) {
            case 1: {
                byArray = BarcodeEAN.getBarsEAN13(this.code);
                nArray = c;
                break;
            }
            case 2: {
                byArray = BarcodeEAN.getBarsEAN8(this.code);
                nArray = d;
                break;
            }
            case 3: {
                byArray = BarcodeEAN.getBarsEAN13("0" + this.code);
                nArray = b;
                break;
            }
            case 4: {
                byArray = BarcodeEAN.getBarsUPCE(this.code);
                nArray = e;
                break;
            }
            case 5: {
                byArray = BarcodeEAN.getBarsSupplemental2(this.code);
                break;
            }
            case 6: {
                byArray = BarcodeEAN.getBarsSupplemental5(this.code);
            }
        }
        float f5 = f2;
        boolean bl2 = true;
        float f6 = 0.0f;
        if (this.font != null && this.baseline > 0.0f && this.guardBars) {
            f6 = this.baseline / 2.0f;
        }
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        if (byArray != null) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                float f7 = (float)byArray[i2] * this.x;
                if (bl2) {
                    if (Arrays.binarySearch(nArray, i2) >= 0) {
                        pdfContentByte.rectangle(f2, f3 - f6, f7 - this.inkSpreading, this.barHeight + f6);
                    } else {
                        pdfContentByte.rectangle(f2, f3, f7 - this.inkSpreading, this.barHeight);
                    }
                }
                bl2 = !bl2;
                f2 += f7;
            }
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            switch (this.codeType) {
                case 1: {
                    pdfContentByte.setTextMatrix(0.0f, f4);
                    pdfContentByte.showText(this.code.substring(0, 1));
                    for (int i3 = 1; i3 < 13; ++i3) {
                        int n2 = i3;
                        String string = this.code.substring(n2, n2 + 1);
                        float f8 = this.font.getWidthPoint(string, this.size);
                        f8 = f5 + f[i3 - 1] * this.x - f8 / 2.0f;
                        pdfContentByte.setTextMatrix(f8, f4);
                        pdfContentByte.showText(string);
                    }
                    break;
                }
                case 2: {
                    for (int i4 = 0; i4 < 8; ++i4) {
                        int n3 = i4;
                        String string = this.code.substring(n3, n3 + 1);
                        float f9 = this.font.getWidthPoint(string, this.size);
                        f9 = g[i4] * this.x - f9 / 2.0f;
                        pdfContentByte.setTextMatrix(f9, f4);
                        pdfContentByte.showText(string);
                    }
                    break;
                }
                case 3: {
                    pdfContentByte.setTextMatrix(0.0f, f4);
                    pdfContentByte.showText(this.code.substring(0, 1));
                    for (int i5 = 1; i5 < 11; ++i5) {
                        int n4 = i5;
                        String string = this.code.substring(n4, n4 + 1);
                        float f10 = this.font.getWidthPoint(string, this.size);
                        f10 = f5 + f[i5] * this.x - f10 / 2.0f;
                        pdfContentByte.setTextMatrix(f10, f4);
                        pdfContentByte.showText(string);
                    }
                    pdfContentByte.setTextMatrix(f5 + this.x * 95.0f, f4);
                    pdfContentByte.showText(this.code.substring(11, 12));
                    break;
                }
                case 4: {
                    pdfContentByte.setTextMatrix(0.0f, f4);
                    pdfContentByte.showText(this.code.substring(0, 1));
                    for (int i6 = 1; i6 < 7; ++i6) {
                        int n5 = i6;
                        String string = this.code.substring(n5, n5 + 1);
                        float f11 = this.font.getWidthPoint(string, this.size);
                        f11 = f5 + f[i6 - 1] * this.x - f11 / 2.0f;
                        pdfContentByte.setTextMatrix(f11, f4);
                        pdfContentByte.showText(string);
                    }
                    pdfContentByte.setTextMatrix(f5 + this.x * 51.0f, f4);
                    pdfContentByte.showText(this.code.substring(7, 8));
                    break;
                }
                case 5: 
                case 6: {
                    for (int i7 = 0; i7 < this.code.length(); ++i7) {
                        int n6 = i7;
                        String string = this.code.substring(n6, n6 + 1);
                        float f12 = this.font.getWidthPoint(string, this.size);
                        f12 = (7.5f + (float)(i7 * 9)) * this.x - f12 / 2.0f;
                        pdfContentByte.setTextMatrix(f12, f4);
                        pdfContentByte.showText(string);
                    }
                    break;
                }
            }
            pdfContentByte.endText();
        }
        return rectangle;
    }

    @Override
    public Image createAwtImage(Color color, Color color2) {
        int n2;
        byte[] byArray;
        int n3 = color.getRGB();
        int n4 = color2.getRGB();
        Canvas canvas = new Canvas();
        switch (this.codeType) {
            case 1: {
                byArray = BarcodeEAN.getBarsEAN13(this.code);
                n2 = 95;
                break;
            }
            case 2: {
                byArray = BarcodeEAN.getBarsEAN8(this.code);
                n2 = 67;
                break;
            }
            case 3: {
                byArray = BarcodeEAN.getBarsEAN13("0" + this.code);
                n2 = 95;
                break;
            }
            case 4: {
                byArray = BarcodeEAN.getBarsUPCE(this.code);
                n2 = 51;
                break;
            }
            case 5: {
                byArray = BarcodeEAN.getBarsSupplemental2(this.code);
                n2 = 20;
                break;
            }
            case 6: {
                byArray = BarcodeEAN.getBarsSupplemental5(this.code);
                n2 = 47;
                break;
            }
            default: {
                throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.code.type"));
            }
        }
        boolean bl2 = true;
        int n5 = 0;
        int n6 = (int)this.barHeight;
        int[] nArray = new int[n2 * n6];
        for (int n7 : byArray) {
            int n8 = n4;
            if (bl2) {
                n8 = n3;
            }
            bl2 = !bl2;
            for (int i2 = 0; i2 < n7; ++i2) {
                nArray[n5++] = n8;
            }
        }
        for (int i3 = n2; i3 < nArray.length; i3 += n2) {
            System.arraycopy(nArray, 0, nArray, i3, n2);
        }
        Image image = canvas.createImage(new MemoryImageSource(n2, n6, nArray, 0, n2));
        return image;
    }
}

