/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodeInter25
extends Barcode {
    private static final byte[][] a = new byte[][]{{0, 0, 1, 1, 0}, {1, 0, 0, 0, 1}, {0, 1, 0, 0, 1}, {1, 1, 0, 0, 0}, {0, 0, 1, 0, 1}, {1, 0, 1, 0, 0}, {0, 1, 1, 0, 0}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {0, 1, 0, 1, 0}};

    public BarcodeInter25() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
            return;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static String keepNumbers(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '0' || c2 > '9') continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static char getChecksum(String string) {
        int n2 = 3;
        int n3 = 0;
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            int n4 = string.charAt(i2) - 48;
            n3 += n2 * n4;
            n2 ^= 2;
        }
        return (char)((10 - n3 % 10) % 10 + 48);
    }

    public static byte[] getBarsInter25(String string) {
        if (((string = BarcodeInter25.keepNumbers(string)).length() & 1) != 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.text.length.must.be.even"));
        }
        byte[] byArray = new byte[string.length() * 5 + 7];
        int n2 = 0;
        ++n2;
        byArray[0] = 0;
        ++n2;
        byArray[1] = 0;
        ++n2;
        byArray[2] = 0;
        ++n2;
        byArray[3] = 0;
        int n3 = string.length() / 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = string.charAt(i2 << 1) - 48;
            int n5 = string.charAt((i2 << 1) + 1) - 48;
            byte[] byArray2 = a[n4];
            byte[] byArray3 = a[n5];
            for (int i3 = 0; i3 < 5; ++i3) {
                byArray[n2++] = byArray2[i3];
                byArray[n2++] = byArray3[i3];
            }
        }
        byArray[n2++] = 1;
        byArray[n2++] = 0;
        byArray[n2] = 0;
        return byArray;
    }

    @Override
    public Rectangle getBarcodeSize() {
        String string;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            f3 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.code;
            if (this.generateChecksum && this.checksumText) {
                string = string + BarcodeInter25.getChecksum(string);
            }
            f2 = this.font.getWidthPoint(this.altText != null ? this.altText : string, this.size);
        }
        string = BarcodeInter25.keepNumbers(this.code);
        int n2 = string.length();
        if (this.generateChecksum) {
            ++n2;
        }
        float f4 = (float)n2 * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        f4 = Math.max(f4, f2);
        f2 = this.barHeight + f3;
        return new Rectangle(f4, f2);
    }

    @Override
    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color object, Color color) {
        String string = this.code;
        float f2 = 0.0f;
        if (this.font != null) {
            if (this.generateChecksum && this.checksumText) {
                string = string + BarcodeInter25.getChecksum(string);
            }
            string = this.altText != null ? this.altText : string;
            f2 = this.font.getWidthPoint(string, this.size);
        }
        Object object2 = BarcodeInter25.keepNumbers(this.code);
        if (this.generateChecksum) {
            object2 = (String)object2 + BarcodeInter25.getChecksum((String)object2);
        }
        int n2 = ((String)object2).length();
        float f3 = (float)n2 * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f2 > f3) {
                    f4 = f2 - f3;
                    break;
                }
                f5 = f3 - f2;
                break;
            }
            default: {
                if (f2 > f3) {
                    f4 = (f2 - f3) / 2.0f;
                    break;
                }
                f5 = (f3 - f2) / 2.0f;
            }
        }
        f2 = 0.0f;
        f3 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f3 = this.barHeight - this.baseline;
            } else {
                f3 = -this.font.getFontDescriptor(3, this.size);
                f2 = f3 + this.baseline;
            }
        }
        object2 = BarcodeInter25.getBarsInter25((String)object2);
        boolean bl2 = true;
        if (object != null) {
            pdfContentByte.setColorFill((Color)object);
        }
        for (Object object3 : object2) {
            float f6;
            float f7 = f6 = object3 == false ? this.x : this.x * this.n;
            if (bl2) {
                pdfContentByte.rectangle(f4, f2, f6 - this.inkSpreading, this.barHeight);
            }
            bl2 = !bl2;
            f4 += f6;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color != null) {
                pdfContentByte.setColorFill(color);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f5, f3);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return ((Barcode)this).getBarcodeSize();
    }

    @Override
    public Image createAwtImage(Color color, Color color2) {
        int n2 = color.getRGB();
        int n3 = color2.getRGB();
        Canvas canvas = new Canvas();
        Object object = BarcodeInter25.keepNumbers(this.code);
        if (this.generateChecksum) {
            object = (String)object + BarcodeInter25.getChecksum((String)object);
        }
        int n4 = ((String)object).length();
        int n5 = (int)this.n;
        n4 = n4 * (3 + 2 * n5) + (n5 + 6);
        object = BarcodeInter25.getBarsInter25((String)object);
        boolean bl2 = true;
        int n6 = 0;
        int n7 = (int)this.barHeight;
        int[] nArray = new int[n4 * n7];
        for (Object object2 : object) {
            object2 = object2 == false ? 1 : n5;
            int n8 = n3;
            if (bl2) {
                n8 = n2;
            }
            bl2 = !bl2;
            for (int i2 = 0; i2 < object2; ++i2) {
                nArray[n6++] = n8;
            }
        }
        for (int i3 = n4; i3 < nArray.length; i3 += n4) {
            System.arraycopy(nArray, 0, nArray, i3, n4);
        }
        Image image = canvas.createImage(new MemoryImageSource(n4, n7, nArray, 0, n4));
        return image;
    }
}

