/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodePostnet
extends Barcode {
    private static final byte[][] a = new byte[][]{{1, 1, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {0, 0, 1, 1, 0}, {0, 1, 0, 0, 1}, {0, 1, 0, 1, 0}, {0, 1, 1, 0, 0}, {1, 0, 0, 0, 1}, {1, 0, 0, 1, 0}, {1, 0, 1, 0, 0}};

    public BarcodePostnet() {
        this.n = 3.2727273f;
        this.x = 1.4399999f;
        this.barHeight = 9.0f;
        this.size = 3.6000001f;
        this.codeType = 7;
    }

    public static byte[] getBarsPostnet(String string) {
        int n2;
        int n3 = 0;
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            n2 = string.charAt(i2) - 48;
            n3 += n2;
        }
        string = string + (char)((10 - n3 % 10) % 10 + 48);
        byte[] byArray = new byte[string.length() * 5 + 2];
        byte[] byArray2 = byArray;
        byArray[0] = 1;
        byArray2[byArray2.length - 1] = 1;
        for (n2 = 0; n2 < string.length(); ++n2) {
            n3 = string.charAt(n2) - 48;
            System.arraycopy(a[n3], 0, byArray2, n2 * 5 + 1, 5);
        }
        return byArray2;
    }

    @Override
    public Rectangle getBarcodeSize() {
        float f2 = (float)((this.code.length() + 1) * 5 + 1) * this.n + this.x;
        return new Rectangle(f2, this.barHeight);
    }

    @Override
    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color object, Color color) {
        if (object != null) {
            pdfContentByte.setColorFill((Color)object);
        }
        object = BarcodePostnet.getBarsPostnet(this.code);
        boolean bl2 = true;
        if (this.codeType == 8) {
            bl2 = false;
            object[0] = false;
            Object object2 = object;
            object2[((Object)object2).length - 1] = false;
        }
        float f2 = 0.0f;
        for (Object object3 : object) {
            pdfContentByte.rectangle(f2, 0.0f, this.x - this.inkSpreading, object3 == bl2 ? this.barHeight : this.size);
            f2 += this.n;
        }
        pdfContentByte.fill();
        return ((Barcode)this).getBarcodeSize();
    }

    @Override
    public Image createAwtImage(Color color, Color color2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = color.getRGB();
        int n7 = color2.getRGB();
        Canvas canvas = new Canvas();
        int n8 = (int)this.x;
        if (n8 <= 0) {
            n8 = 1;
        }
        if ((n5 = (int)this.n) <= n8) {
            n5 = n8 + 1;
        }
        if ((n4 = (int)this.size) <= 0) {
            n4 = 1;
        }
        if ((n3 = (int)this.barHeight) <= n4) {
            n3 = n4 + 1;
        }
        int n9 = ((this.code.length() + 1) * 5 + 1) * n5 + n8;
        int[] nArray = new int[n9 * n3];
        byte[] byArray = BarcodePostnet.getBarsPostnet(this.code);
        byte by = 1;
        if (this.codeType == 8) {
            by = 0;
            byArray[0] = 0;
            byArray[byArray.length - 1] = 0;
        }
        int n10 = 0;
        byte[] byArray2 = byArray;
        int n11 = byArray.length;
        for (n2 = 0; n2 < n11; ++n2) {
            byte by2 = byArray2[n2];
            by2 = by2 == by ? (byte)1 : 0;
            for (int i2 = 0; i2 < n5; ++i2) {
                nArray[n10 + i2] = by2 != 0 && i2 < n8 ? n6 : n7;
            }
            n10 += n5;
        }
        int n12 = n9 * (n3 - n4);
        for (n11 = n9; n11 < n12; n11 += n9) {
            System.arraycopy(nArray, 0, nArray, n11, n9);
        }
        n10 = n12;
        for (n11 = 0; n11 < byArray.length; ++n11) {
            for (n2 = 0; n2 < n5; ++n2) {
                nArray[n10 + n2] = n2 < n8 ? n6 : n7;
            }
            n10 += n5;
        }
        for (n11 = n12 + n9; n11 < nArray.length; n11 += n9) {
            System.arraycopy(nArray, n12, nArray, n11, n9);
        }
        Image image = canvas.createImage(new MemoryImageSource(n9, n3, nArray, 0, n9));
        return image;
    }
}

