/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.h;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BaseField {
    public static final float BORDER_WIDTH_THIN = 1.0f;
    public static final float BORDER_WIDTH_MEDIUM = 2.0f;
    public static final float BORDER_WIDTH_THICK = 3.0f;
    public static final int VISIBLE = 0;
    public static final int HIDDEN = 1;
    public static final int VISIBLE_BUT_DOES_NOT_PRINT = 2;
    public static final int HIDDEN_BUT_PRINTABLE = 3;
    public static final int READ_ONLY = 1;
    public static final int REQUIRED = 2;
    public static final int MULTILINE = 4096;
    public static final int DO_NOT_SCROLL = 0x800000;
    public static final int PASSWORD = 8192;
    public static final int FILE_SELECTION = 0x100000;
    public static final int DO_NOT_SPELL_CHECK = 0x400000;
    public static final int EDIT = 262144;
    public static final int MULTISELECT = 0x200000;
    public static final int COMB = 0x1000000;
    protected float borderWidth = 1.0f;
    protected int borderStyle = 0;
    protected Color borderColor;
    protected Color backgroundColor;
    protected Color textColor;
    protected BaseFont font;
    protected float fontSize = 0.0f;
    protected int alignment = 0;
    protected PdfWriter writer;
    protected String text;
    protected Rectangle box;
    protected int rotation = 0;
    protected int visibility;
    protected String fieldName;
    protected int options;
    protected int maxCharacterLength;
    private static final Map<PdfName, Integer> a = new HashMap<PdfName, Integer>();

    public BaseField(PdfWriter pdfWriter, Rectangle rectangle, String string) {
        this.writer = pdfWriter;
        this.setBox(rectangle);
        this.fieldName = string;
    }

    protected BaseFont getRealFont() {
        if (this.font == null) {
            return BaseFont.createFont("Helvetica", "Cp1252", false);
        }
        return this.font;
    }

    protected PdfAppearance getBorderAppearance() {
        PdfAppearance pdfAppearance;
        block18: {
            block19: {
                block17: {
                    pdfAppearance = PdfAppearance.createAppearance(this.writer, this.box.getWidth(), this.box.getHeight());
                    switch (this.rotation) {
                        case 90: {
                            pdfAppearance.setMatrix(0.0f, 1.0f, -1.0f, 0.0f, this.box.getHeight(), 0.0f);
                            break;
                        }
                        case 180: {
                            pdfAppearance.setMatrix(-1.0f, 0.0f, 0.0f, -1.0f, this.box.getWidth(), this.box.getHeight());
                            break;
                        }
                        case 270: {
                            pdfAppearance.setMatrix(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, this.box.getWidth());
                        }
                    }
                    pdfAppearance.saveState();
                    if (this.backgroundColor != null) {
                        pdfAppearance.setColorFill(this.backgroundColor);
                        pdfAppearance.rectangle(0.0f, 0.0f, this.box.getWidth(), this.box.getHeight());
                        pdfAppearance.fill();
                    }
                    if (this.borderStyle != 4) break block17;
                    if (this.borderWidth == 0.0f || this.borderColor == null) break block18;
                    pdfAppearance.setColorStroke(this.borderColor);
                    pdfAppearance.setLineWidth(this.borderWidth);
                    pdfAppearance.moveTo(0.0f, this.borderWidth / 2.0f);
                    pdfAppearance.lineTo(this.box.getWidth(), this.borderWidth / 2.0f);
                    break block19;
                }
                if (this.borderStyle == 2) {
                    Color color;
                    if (this.borderWidth != 0.0f && this.borderColor != null) {
                        pdfAppearance.setColorStroke(this.borderColor);
                        pdfAppearance.setLineWidth(this.borderWidth);
                        pdfAppearance.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.getWidth() - this.borderWidth, this.box.getHeight() - this.borderWidth);
                        pdfAppearance.stroke();
                    }
                    if ((color = this.backgroundColor) == null) {
                        color = Color.white;
                    }
                    pdfAppearance.setGrayFill(1.0f);
                    this.a(pdfAppearance);
                    pdfAppearance.setColorFill(color.darker());
                    this.b(pdfAppearance);
                } else if (this.borderStyle == 3) {
                    if (this.borderWidth != 0.0f && this.borderColor != null) {
                        pdfAppearance.setColorStroke(this.borderColor);
                        pdfAppearance.setLineWidth(this.borderWidth);
                        pdfAppearance.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.getWidth() - this.borderWidth, this.box.getHeight() - this.borderWidth);
                        pdfAppearance.stroke();
                    }
                    pdfAppearance.setGrayFill(0.5f);
                    this.a(pdfAppearance);
                    pdfAppearance.setGrayFill(0.75f);
                    this.b(pdfAppearance);
                } else if (this.borderWidth != 0.0f && this.borderColor != null) {
                    if (this.borderStyle == 1) {
                        pdfAppearance.setLineDash(3.0f, 0.0f);
                    }
                    pdfAppearance.setColorStroke(this.borderColor);
                    pdfAppearance.setLineWidth(this.borderWidth);
                    pdfAppearance.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.getWidth() - this.borderWidth, this.box.getHeight() - this.borderWidth);
                    pdfAppearance.stroke();
                    if ((this.options & 0x1000000) != 0 && this.maxCharacterLength > 1) {
                        float f2 = this.box.getWidth() / (float)this.maxCharacterLength;
                        float f3 = this.borderWidth / 2.0f;
                        float f4 = this.box.getHeight() - this.borderWidth / 2.0f;
                        for (int i2 = 1; i2 < this.maxCharacterLength; ++i2) {
                            float f5 = f2 * (float)i2;
                            pdfAppearance.moveTo(f5, f3);
                            pdfAppearance.lineTo(f5, f4);
                        }
                    }
                }
                break block18;
            }
            pdfAppearance.stroke();
        }
        pdfAppearance.restoreState();
        return pdfAppearance;
    }

    @Deprecated
    protected static ArrayList getHardBreaks(String string) {
        return (ArrayList)BaseField.getAllHardBreaks(string);
    }

    protected static List<String> getAllHardBreaks(String object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = cArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object[i2];
            if (object2 == 13) {
                if (i2 + 1 < n2 && object[i2 + 1] == 10) {
                    ++i2;
                }
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            if (object2 == 10) {
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append((char)object2);
        }
        arrayList.add(stringBuffer.toString());
        return arrayList;
    }

    protected static void trimRight(StringBuffer stringBuffer) {
        int n2 = stringBuffer.length();
        while (n2 != 0) {
            if (stringBuffer.charAt(--n2) != ' ') {
                return;
            }
            stringBuffer.setLength(n2);
        }
        return;
    }

    @Deprecated
    protected static ArrayList breakLines(ArrayList arrayList, BaseFont baseFont, float f2, float f3) {
        return (ArrayList)BaseField.breakLines((List<String>)arrayList, baseFont, f2, f3);
    }

    protected static List<String> breakLines(List<String> object, BaseFont baseFont, float f2, float f3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (String)object.next();
            stringBuffer.setLength(0);
            float f4 = 0.0f;
            char[] cArray = ((String)object2).toCharArray();
            object2 = cArray;
            int n2 = cArray.length;
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            block6: for (int i2 = 0; i2 < n2; ++i2) {
                Object object3 = object2[i2];
                switch (n3) {
                    case 0: {
                        f4 += baseFont.getWidthPoint((int)object3, f2);
                        stringBuffer.append((char)object3);
                        if (f4 > f3) {
                            f4 = 0.0f;
                            if (stringBuffer.length() > 1) {
                                StringBuffer stringBuffer2 = stringBuffer;
                                stringBuffer2.setLength(stringBuffer2.length() - 1);
                            }
                            arrayList.add(stringBuffer.toString());
                            stringBuffer.setLength(0);
                            n5 = --i2;
                            if (object3 == 32) {
                                n3 = 2;
                                continue block6;
                            }
                            n3 = 1;
                            continue block6;
                        }
                        if (object3 == 32) continue block6;
                        n3 = 1;
                        continue block6;
                    }
                    case 1: {
                        f4 += baseFont.getWidthPoint((int)object3, f2);
                        stringBuffer.append((char)object3);
                        if (object3 == 32) {
                            n4 = i2;
                        }
                        if (!(f4 > f3)) continue block6;
                        f4 = 0.0f;
                        if (n4 >= 0) {
                            i2 = n4;
                            stringBuffer.setLength(n4 - n5);
                            BaseField.trimRight(stringBuffer);
                            arrayList.add(stringBuffer.toString());
                            stringBuffer.setLength(0);
                            n5 = i2;
                            n4 = -1;
                            n3 = 2;
                            continue block6;
                        }
                        if (stringBuffer.length() > 1) {
                            StringBuffer stringBuffer3 = stringBuffer;
                            stringBuffer3.setLength(stringBuffer3.length() - 1);
                        }
                        arrayList.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        n5 = --i2;
                        if (object3 != 32) continue block6;
                        n3 = 2;
                        continue block6;
                    }
                    case 2: {
                        if (object3 == 32) continue block6;
                        f4 = 0.0f;
                        --i2;
                        n3 = 1;
                    }
                }
            }
            BaseField.trimRight(stringBuffer);
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    private void a(PdfAppearance pdfAppearance) {
        pdfAppearance.moveTo(this.borderWidth, this.borderWidth);
        pdfAppearance.lineTo(this.borderWidth, this.box.getHeight() - this.borderWidth);
        pdfAppearance.lineTo(this.box.getWidth() - this.borderWidth, this.box.getHeight() - this.borderWidth);
        pdfAppearance.lineTo(this.box.getWidth() - 2.0f * this.borderWidth, this.box.getHeight() - 2.0f * this.borderWidth);
        pdfAppearance.lineTo(2.0f * this.borderWidth, this.box.getHeight() - 2.0f * this.borderWidth);
        pdfAppearance.lineTo(2.0f * this.borderWidth, 2.0f * this.borderWidth);
        pdfAppearance.lineTo(this.borderWidth, this.borderWidth);
        pdfAppearance.fill();
    }

    private void b(PdfAppearance pdfAppearance) {
        pdfAppearance.moveTo(this.borderWidth, this.borderWidth);
        pdfAppearance.lineTo(this.box.getWidth() - this.borderWidth, this.borderWidth);
        pdfAppearance.lineTo(this.box.getWidth() - this.borderWidth, this.box.getHeight() - this.borderWidth);
        pdfAppearance.lineTo(this.box.getWidth() - 2.0f * this.borderWidth, this.box.getHeight() - 2.0f * this.borderWidth);
        pdfAppearance.lineTo(this.box.getWidth() - 2.0f * this.borderWidth, 2.0f * this.borderWidth);
        pdfAppearance.lineTo(2.0f * this.borderWidth, 2.0f * this.borderWidth);
        pdfAppearance.lineTo(this.borderWidth, this.borderWidth);
        pdfAppearance.fill();
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float f2) {
        this.borderWidth = f2;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int n2) {
        this.borderStyle = n2;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public BaseFont getFont() {
        return this.font;
    }

    public void setFont(BaseFont baseFont) {
        this.font = baseFont;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float f2) {
        this.fontSize = f2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Rectangle getBox() {
        return this.box;
    }

    public void setBox(Rectangle rectangle) {
        if (rectangle == null) {
            this.box = null;
            return;
        }
        this.box = new Rectangle(rectangle);
        this.box.normalize();
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int n2) {
        if (n2 % 90 != 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("rotation.must.be.a.multiple.of.90"));
        }
        if ((n2 %= 360) < 0) {
            n2 += 360;
        }
        this.rotation = n2;
    }

    public void setRotationFromPage(Rectangle rectangle) {
        this.setRotation(rectangle.getRotation());
    }

    public int getVisibility() {
        return this.visibility;
    }

    public void setVisibility(int n2) {
        this.visibility = n2;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int n2) {
        this.options = n2;
    }

    public int getMaxCharacterLength() {
        return this.maxCharacterLength;
    }

    public void setMaxCharacterLength(int n2) {
        this.maxCharacterLength = n2;
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PdfWriter pdfWriter) {
        this.writer = pdfWriter;
    }

    public static void moveFields(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2) {
        Iterator<PdfName> iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = iterator.next();
            if (!a.containsKey(pdfName)) continue;
            if (pdfDictionary2 != null) {
                pdfDictionary2.put(pdfName, pdfDictionary.get(pdfName));
            }
            iterator.remove();
        }
    }

    static {
        a.putAll(h.c);
        a.put(PdfName.T, 1);
    }
}

