/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.LayoutProcessor;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFont;
import com.lowagie.text.pdf.c;
import com.lowagie.text.pdf.o;
import com.lowagie.text.pdf.p;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseFont {
    public static final String COURIER = "Courier";
    public static final String COURIER_BOLD = "Courier-Bold";
    public static final String COURIER_OBLIQUE = "Courier-Oblique";
    public static final String COURIER_BOLDOBLIQUE = "Courier-BoldOblique";
    public static final String HELVETICA = "Helvetica";
    public static final String HELVETICA_BOLD = "Helvetica-Bold";
    public static final String HELVETICA_OBLIQUE = "Helvetica-Oblique";
    public static final String HELVETICA_BOLDOBLIQUE = "Helvetica-BoldOblique";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES_ROMAN = "Times-Roman";
    public static final String TIMES_BOLD = "Times-Bold";
    public static final String TIMES_ITALIC = "Times-Italic";
    public static final String TIMES_BOLDITALIC = "Times-BoldItalic";
    public static final String ZAPFDINGBATS = "ZapfDingbats";
    public static final int ASCENT = 1;
    public static final int CAPHEIGHT = 2;
    public static final int DESCENT = 3;
    public static final int ITALICANGLE = 4;
    public static final int BBOXLLX = 5;
    public static final int BBOXLLY = 6;
    public static final int BBOXURX = 7;
    public static final int BBOXURY = 8;
    public static final int AWT_ASCENT = 9;
    public static final int AWT_DESCENT = 10;
    public static final int AWT_LEADING = 11;
    public static final int AWT_MAXADVANCE = 12;
    public static final int UNDERLINE_POSITION = 13;
    public static final int UNDERLINE_THICKNESS = 14;
    public static final int STRIKETHROUGH_POSITION = 15;
    public static final int STRIKETHROUGH_THICKNESS = 16;
    public static final int SUBSCRIPT_SIZE = 17;
    public static final int SUBSCRIPT_OFFSET = 18;
    public static final int SUPERSCRIPT_SIZE = 19;
    public static final int SUPERSCRIPT_OFFSET = 20;
    public static final int FONT_TYPE_T1 = 0;
    public static final int FONT_TYPE_TT = 1;
    public static final int FONT_TYPE_CJK = 2;
    public static final int FONT_TYPE_TTUNI = 3;
    public static final int FONT_TYPE_DOCUMENT = 4;
    public static final int FONT_TYPE_T3 = 5;
    public static final String IDENTITY_H = "Identity-H";
    public static final String IDENTITY_V = "Identity-V";
    public static final String CP1250 = "Cp1250";
    public static final String CP1252 = "Cp1252";
    public static final String CP1257 = "Cp1257";
    public static final String WINANSI = "Cp1252";
    public static final String MACROMAN = "MacRoman";
    public static final int[] CHAR_RANGE_LATIN = new int[]{0, 383, 8192, 8303, 8352, 8399, 64256, 64262};
    public static final int[] CHAR_RANGE_ARABIC = new int[]{0, 127, 1536, 1663, 8352, 8399, 64336, 64511, 65136, 65279};
    public static final int[] CHAR_RANGE_HEBREW = new int[]{0, 127, 1424, 1535, 8352, 8399, 64285, 64335};
    public static final int[] CHAR_RANGE_CYRILLIC = new int[]{0, 127, 1024, 1327, 8192, 8303, 8352, 8399};
    public static final boolean EMBEDDED = true;
    public static final boolean NOT_EMBEDDED = false;
    public static final boolean CACHED = true;
    public static final boolean NOT_CACHED = false;
    public static final String RESOURCE_PATH = "com/lowagie/text/pdf/fonts/";
    public static final char CID_NEWLINE = Short.MAX_VALUE;
    protected ArrayList<int[]> subsetRanges;
    int a;
    public static final String notdef = ".notdef";
    protected int[] widths = new int[256];
    protected String[] differences = new String[256];
    protected char[] unicodeDifferences = new char[256];
    protected int[][] charBBoxes = new int[256][];
    protected String encoding;
    protected boolean embedded;
    protected int compressionLevel = -1;
    protected boolean fontSpecific = true;
    protected static ConcurrentHashMap<String, BaseFont> fontCache = new ConcurrentHashMap(500, 0.85f, 64);
    protected static final HashMap<String, PdfName> BuiltinFonts14 = new HashMap<String, PdfName>();
    protected boolean forceWidthsOutput = false;
    protected boolean directTextToByte = false;
    protected boolean subset = true;
    protected boolean fastWinansi = false;
    protected IntHashtable specialMap;

    protected BaseFont() {
    }

    public static BaseFont createFont() {
        return BaseFont.createFont(HELVETICA, "Cp1252", false);
    }

    public static BaseFont createFont(String string, String string2, boolean bl2) {
        return BaseFont.createFont(string, string2, bl2, true, null, null, false);
    }

    public static BaseFont createFont(String string, String string2, boolean bl2, boolean bl3) {
        return BaseFont.createFont(string, string2, bl2, true, null, null, bl3);
    }

    public static BaseFont createFont(String string, String string2, boolean bl2, boolean bl3, byte[] byArray, byte[] byArray2) {
        return BaseFont.createFont(string, string2, bl2, bl3, byArray, byArray2, false);
    }

    public static BaseFont createFont(String string, String string2, boolean bl2, boolean bl3, byte[] byArray, byte[] byArray2, boolean bl4) {
        return BaseFont.createFont(string, string2, bl2, bl3, byArray, byArray2, false, false);
    }

    public static BaseFont createFont(String string, String string2, boolean bl2, boolean bl3, byte[] byArray, byte[] byArray2, boolean bl4, boolean bl5) {
        BaseFont baseFont;
        BaseFont baseFont2;
        boolean bl6;
        String string3 = BaseFont.getBaseName(string);
        string2 = BaseFont.normalizeEncoding(string2);
        boolean bl7 = BuiltinFonts14.containsKey(string);
        boolean bl8 = bl6 = !bl7 && com.lowagie.text.pdf.a.a(string3, string2);
        if (bl7 || bl6) {
            bl2 = false;
        } else if (string2.equals(IDENTITY_H) || string2.equals(IDENTITY_V)) {
            bl2 = true;
        }
        String string4 = string + "\n" + string2 + "\n" + bl2;
        if (bl3 && (baseFont2 = fontCache.get(string4)) != null) {
            return baseFont2;
        }
        if (bl7 || string.toLowerCase().endsWith(".afm") || string.toLowerCase().endsWith(".pfm")) {
            baseFont = new p(string, string2, bl2, byArray, byArray2, bl5);
            new p(string, string2, bl2, byArray, byArray2, bl5).fastWinansi = string2.equals("Cp1252");
        } else if (string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0) {
            if (string2.equals(IDENTITY_H) || string2.equals(IDENTITY_V)) {
                baseFont = new o(string, string2, bl2, byArray, bl5);
                LayoutProcessor.loadFont(baseFont, string);
            } else {
                baseFont = new TrueTypeFont(string, string2, bl2, byArray, false, bl5);
                new TrueTypeFont(string, string2, bl2, byArray, false, bl5).fastWinansi = string2.equals("Cp1252");
            }
        } else if (bl6) {
            baseFont = new com.lowagie.text.pdf.a(string, string2);
        } else {
            if (bl4) {
                return null;
            }
            throw new DocumentException(MessageLocalization.getComposedMessage("font.1.with.2.is.not.recognized", string, string2));
        }
        if (bl3) {
            fontCache.putIfAbsent(string4, baseFont);
            return fontCache.get(string4);
        }
        return baseFont;
    }

    public static BaseFont createFont(PRIndirectReference pRIndirectReference) {
        return new DocumentFont(pRIndirectReference);
    }

    protected static String getBaseName(String string) {
        if (string.endsWith(",Bold")) {
            return string.substring(0, string.length() - 5);
        }
        if (string.endsWith(",Italic")) {
            return string.substring(0, string.length() - 7);
        }
        if (string.endsWith(",BoldItalic")) {
            return string.substring(0, string.length() - 11);
        }
        return string;
    }

    protected static String normalizeEncoding(String string) {
        if (string.equals("winansi") || string.equals("")) {
            return "Cp1252";
        }
        if (string.equals("macroman")) {
            return MACROMAN;
        }
        return string;
    }

    protected void createEncoding() {
        if (this.encoding.startsWith("#")) {
            int n2;
            String string;
            this.specialMap = new IntHashtable();
            StringTokenizer stringTokenizer = new StringTokenizer(this.encoding.substring(1), " ,\t\n\r\f");
            if (stringTokenizer.nextToken().equals("full")) {
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    string = stringTokenizer.nextToken();
                    n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                    int n3 = string2.startsWith("'") ? (int)string2.charAt(1) : Integer.parseInt(string2);
                    this.specialMap.put(n2, n3 %= 256);
                    this.differences[n3] = string;
                    this.unicodeDifferences[n3] = n2;
                    this.widths[n3] = this.a(n2, string);
                    this.charBBoxes[n3] = this.getRawCharBBox(n2, string);
                }
            } else {
                int n4 = 0;
                if (stringTokenizer.hasMoreTokens()) {
                    n4 = Integer.parseInt(stringTokenizer.nextToken());
                }
                while (stringTokenizer.hasMoreTokens() && n4 < 256) {
                    string = stringTokenizer.nextToken();
                    n2 = Integer.parseInt(string, 16) % 65536;
                    String string3 = GlyphList.unicodeToName(n2);
                    if (string3 == null) continue;
                    this.specialMap.put(n2, n4);
                    this.differences[n4] = string3;
                    this.unicodeDifferences[n4] = (char)n2;
                    this.widths[n4] = this.a(n2, string3);
                    this.charBBoxes[n4] = this.getRawCharBBox(n2, string3);
                    ++n4;
                }
            }
            for (int i2 = 0; i2 < 256; ++i2) {
                if (this.differences[i2] != null) continue;
                this.differences[i2] = notdef;
            }
            return;
        }
        if (this.fontSpecific) {
            for (int i3 = 0; i3 < 256; ++i3) {
                this.widths[i3] = this.a(i3, null);
                this.charBBoxes[i3] = this.getRawCharBBox(i3, null);
            }
            return;
        }
        byte[] byArray = new byte[1];
        for (int i4 = 0; i4 < 256; ++i4) {
            byArray[0] = (byte)i4;
            String string = PdfEncodings.convertToString(byArray, this.encoding);
            int n5 = string.length() > 0 ? (int)string.charAt(0) : 63;
            String string4 = GlyphList.unicodeToName(n5);
            if (string4 == null) {
                string4 = notdef;
            }
            this.differences[i4] = string4;
            this.unicodeDifferences[i4] = n5;
            this.widths[i4] = this.a(n5, string4);
            this.charBBoxes[i4] = this.getRawCharBBox(n5, string4);
        }
    }

    abstract int a(int var1, String var2);

    public abstract int getKerning(int var1, int var2);

    public abstract boolean setKerning(int var1, int var2, int var3);

    public int getWidth(int n2) {
        if (this.fastWinansi) {
            if (n2 < 128 || n2 >= 160 && n2 <= 255) {
                return this.widths[n2];
            }
            return this.widths[PdfEncodings.a.get(n2)];
        }
        int n3 = 0;
        byte[] byArray = this.a((char)n2);
        byte[] byArray2 = byArray;
        byArray2 = byArray;
        int n4 = byArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            byte by = byArray2[i2];
            n3 += this.widths[0xFF & by];
        }
        return n3;
    }

    public int getWidth(String string) {
        byte[] byArray;
        int n2 = 0;
        if (this.fastWinansi) {
            int n3 = string.length();
            for (int i2 = 0; i2 < n3; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 < '\u0080' || c2 >= '\u00a0' && c2 <= '\u00ff') {
                    n2 += this.widths[c2];
                    continue;
                }
                n2 += this.widths[PdfEncodings.a.get(c2)];
            }
            return n2;
        }
        byte[] byArray2 = byArray = this.a(string);
        int n4 = byArray.length;
        for (int i3 = 0; i3 < n4; ++i3) {
            byte by = byArray2[i3];
            n2 += this.widths[0xFF & by];
        }
        return n2;
    }

    public int getDescent(String object) {
        int n2 = 0;
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        object = cArray;
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object2 = object[i2];
            int[] nArray = this.getCharBBox((int)object2);
            if (nArray == null || nArray[1] >= n2) continue;
            n2 = nArray[1];
        }
        return n2;
    }

    public int getAscent(String object) {
        int n2 = 0;
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        object = cArray;
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object2 = object[i2];
            int[] nArray = this.getCharBBox((int)object2);
            if (nArray == null || nArray[3] <= n2) continue;
            n2 = nArray[3];
        }
        return n2;
    }

    public float getDescentPoint(String string, float f2) {
        return (float)this.getDescent(string) * 0.001f * f2;
    }

    public float getAscentPoint(String string, float f2) {
        return (float)this.getAscent(string) * 0.001f * f2;
    }

    public float getWidthPointKerned(String object, float f2) {
        float f3 = (float)this.getWidth((String)object) * 0.001f * f2;
        if (!this.hasKernPairs()) {
            return f3;
        }
        int n2 = ((String)object).length() - 1;
        int n3 = 0;
        object = ((String)object).toCharArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += this.getKerning((int)object[i2], (int)object[i2 + 1]);
        }
        return f3 + (float)n3 * 0.001f * f2;
    }

    public float getWidthPoint(String string, float f2) {
        return (float)this.getWidth(string) * 0.001f * f2;
    }

    public float getWidthPoint(int n2, float f2) {
        return (float)this.getWidth(n2) * 0.001f * f2;
    }

    byte[] a(String string) {
        if (this.directTextToByte) {
            return PdfEncodings.convertToBytes(string, null);
        }
        if (this.specialMap != null) {
            byte[] byArray = new byte[string.length()];
            int n2 = 0;
            int n3 = string.length();
            for (int i2 = 0; i2 < n3; ++i2) {
                char c2 = string.charAt(i2);
                if (!this.specialMap.containsKey(c2)) continue;
                byArray[n2++] = (byte)this.specialMap.get(c2);
            }
            if (n2 < n3) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                return byArray2;
            }
            return byArray;
        }
        return PdfEncodings.convertToBytes(string, this.encoding);
    }

    byte[] a(int n2) {
        if (this.directTextToByte) {
            return PdfEncodings.convertToBytes((char)n2, null);
        }
        if (this.specialMap != null) {
            if (this.specialMap.containsKey(n2)) {
                return new byte[]{(byte)this.specialMap.get(n2)};
            }
            return new byte[0];
        }
        return PdfEncodings.convertToBytes((char)n2, this.encoding);
    }

    abstract void a(PdfWriter var1, PdfIndirectReference var2, Object[] var3);

    public String getEncoding() {
        return this.encoding;
    }

    public abstract float getFontDescriptor(int var1, float var2);

    public int getFontType() {
        return this.a;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isFontSpecific() {
        return this.fontSpecific;
    }

    public static String createSubsetPrefix() {
        String string = "";
        for (int i2 = 0; i2 < 6; ++i2) {
            string = string + (char)(Math.random() * 26.0 + 65.0);
        }
        return string + "+";
    }

    final char b(int n2) {
        return this.unicodeDifferences[n2];
    }

    public abstract String getPostscriptFontName();

    public abstract void setPostscriptFontName(String var1);

    public abstract String[][] getFullFontName();

    public abstract String[][] getAllNameEntries();

    public static String[][] getFullFontName(String object, String string, byte[] byArray) {
        String string2 = BaseFont.getBaseName((String)object);
        object = string2.toLowerCase().endsWith(".ttf") || string2.toLowerCase().endsWith(".otf") || string2.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont((String)object, "Cp1252", false, byArray, true, false) : BaseFont.createFont((String)object, string, false, false, byArray, null);
        return ((BaseFont)object).getFullFontName();
    }

    public static Object[] getAllFontNames(String object, String string, byte[] byArray) {
        String string2 = BaseFont.getBaseName((String)object);
        object = string2.toLowerCase().endsWith(".ttf") || string2.toLowerCase().endsWith(".otf") || string2.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont((String)object, "Cp1252", false, byArray, true, false) : BaseFont.createFont((String)object, string, false, false, byArray, null);
        return new Object[]{((BaseFont)object).getPostscriptFontName(), ((BaseFont)object).getFamilyFontName(), ((BaseFont)object).getFullFontName()};
    }

    public static String[][] getAllNameEntries(String object, String string, byte[] byArray) {
        String string2 = BaseFont.getBaseName((String)object);
        object = string2.toLowerCase().endsWith(".ttf") || string2.toLowerCase().endsWith(".otf") || string2.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont((String)object, "Cp1252", false, byArray, true, false) : BaseFont.createFont((String)object, string, false, false, byArray, null);
        return ((BaseFont)object).getAllNameEntries();
    }

    public abstract String[][] getFamilyFontName();

    public String[] getCodePagesSupported() {
        return new String[0];
    }

    public static String[] enumerateTTCNames(String string) {
        return new c(string).a();
    }

    public static String[] enumerateTTCNames(byte[] byArray) {
        return new c(byArray).a();
    }

    public int[] getWidths() {
        return this.widths;
    }

    public String[] getDifferences() {
        return this.differences;
    }

    public char[] getUnicodeDifferences() {
        return this.unicodeDifferences;
    }

    public boolean isForceWidthsOutput() {
        return this.forceWidthsOutput;
    }

    public void setForceWidthsOutput(boolean bl2) {
        this.forceWidthsOutput = bl2;
    }

    public boolean isDirectTextToByte() {
        return this.directTextToByte;
    }

    public void setDirectTextToByte(boolean bl2) {
        this.directTextToByte = bl2;
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean bl2) {
        this.subset = bl2;
    }

    public static InputStream getResourceStream(String string) {
        return BaseFont.getResourceStream(string, null);
    }

    public static InputStream getResourceStream(String string, ClassLoader classLoader) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        InputStream inputStream = null;
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(string)) != null) {
            return inputStream;
        }
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                inputStream = classLoader.getResourceAsStream(string);
            }
        }
        catch (Throwable throwable) {}
        if (inputStream == null) {
            inputStream = BaseFont.class.getResourceAsStream("/" + string);
        }
        if (inputStream == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
        }
        return inputStream;
    }

    public int getUnicodeEquivalent(int n2) {
        return n2;
    }

    public int getCidCode(int n2) {
        return n2;
    }

    public abstract boolean hasKernPairs();

    public boolean charExists(int n2) {
        byte[] byArray = this.a(n2);
        return byArray.length > 0;
    }

    public boolean setCharAdvance(int n2, int n3) {
        byte[] byArray = this.a(n2);
        if (byArray.length == 0) {
            return false;
        }
        this.widths[0xFF & byArray[0]] = n3;
        return true;
    }

    private static void a(PdfDictionary pdfDictionary, IntHashtable intHashtable, ArrayList<Object[]> arrayList, int n2) {
        Object object;
        if (++n2 > 50) {
            return;
        }
        if ((pdfDictionary = pdfDictionary.getAsDict(PdfName.RESOURCES)) == null) {
            return;
        }
        PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.FONT);
        if (pdfDictionary2 != null) {
            object = pdfDictionary2.getKeys().iterator();
            while (object.hasNext()) {
                PdfName pdfName;
                int n3;
                PdfName pdfName2 = (PdfName)object.next();
                PdfObject pdfObject = pdfDictionary2.get(pdfName2);
                if (pdfObject == null || !pdfObject.isIndirect() || intHashtable.containsKey(n3 = ((PRIndirectReference)pdfObject).getNumber())) continue;
                ArrayList<Object[]> arrayList2 = arrayList;
                IntHashtable intHashtable2 = intHashtable;
                PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfObject;
                PdfObject pdfObject2 = PdfReader.getPdfObject(pRIndirectReference2);
                if (pdfObject2 == null || !pdfObject2.isDictionary() || !PdfName.TYPE1.equals(pdfName = ((PdfDictionary)(pdfObject2 = (PdfDictionary)pdfObject2)).getAsName(PdfName.SUBTYPE)) && !PdfName.TRUETYPE.equals(pdfName)) continue;
                pdfObject2 = ((PdfDictionary)pdfObject2).getAsName(PdfName.BASEFONT);
                arrayList2.add(new Object[]{PdfName.decodeName(pdfObject2.toString()), pRIndirectReference2});
                intHashtable2.put(pRIndirectReference2.getNumber(), 1);
            }
        }
        if ((object = pdfDictionary.getAsDict(PdfName.XOBJECT)) != null) {
            for (PdfName pdfName : ((PdfDictionary)object).getKeys()) {
                BaseFont.a(((PdfDictionary)object).getAsDict(pdfName), intHashtable, arrayList, n2);
            }
        }
    }

    public static ArrayList<Object[]> getDocumentFonts(PdfReader pdfReader) {
        IntHashtable intHashtable = new IntHashtable();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n2 = pdfReader.getNumberOfPages();
        for (int i2 = 1; i2 <= n2; ++i2) {
            BaseFont.a(pdfReader.getPageN(i2), intHashtable, arrayList, 1);
        }
        return arrayList;
    }

    public static ArrayList<Object[]> getDocumentFonts(PdfReader pdfReader, int n2) {
        IntHashtable intHashtable = new IntHashtable();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        BaseFont.a(pdfReader.getPageN(n2), intHashtable, arrayList, 1);
        return arrayList;
    }

    public int[] getCharBBox(int n2) {
        byte[] byArray = this.a(n2);
        if (byArray.length == 0) {
            return null;
        }
        return this.charBBoxes[byArray[0] & 0xFF];
    }

    protected abstract int[] getRawCharBBox(int var1, String var2);

    public void correctArabicAdvance() {
        int n2;
        for (n2 = 1611; n2 <= 1624; n2 = (int)((char)(n2 + 1))) {
            this.setCharAdvance(n2, 0);
        }
        this.setCharAdvance(1648, 0);
        for (n2 = 1750; n2 <= 1756; n2 = (int)((char)(n2 + 1))) {
            this.setCharAdvance(n2, 0);
        }
        for (n2 = 1759; n2 <= 1764; n2 = (int)((char)(n2 + 1))) {
            this.setCharAdvance(n2, 0);
        }
        for (n2 = 1767; n2 <= 1768; n2 = (int)((char)(n2 + 1))) {
            this.setCharAdvance(n2, 0);
        }
        for (n2 = 1770; n2 <= 1773; n2 = (int)((char)(n2 + 1))) {
            this.setCharAdvance(n2, 0);
        }
    }

    public void addSubsetRange(int[] nArray) {
        if (this.subsetRanges == null) {
            this.subsetRanges = new ArrayList();
        }
        this.subsetRanges.add(nArray);
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int n2) {
        if (n2 < 0 || n2 > 9) {
            this.compressionLevel = -1;
            return;
        }
        this.compressionLevel = n2;
    }

    static {
        BuiltinFonts14.put(COURIER, PdfName.COURIER);
        BuiltinFonts14.put(COURIER_BOLD, PdfName.COURIER_BOLD);
        BuiltinFonts14.put(COURIER_BOLDOBLIQUE, PdfName.COURIER_BOLDOBLIQUE);
        BuiltinFonts14.put(COURIER_OBLIQUE, PdfName.COURIER_OBLIQUE);
        BuiltinFonts14.put(HELVETICA, PdfName.HELVETICA);
        BuiltinFonts14.put(HELVETICA_BOLD, PdfName.HELVETICA_BOLD);
        BuiltinFonts14.put(HELVETICA_BOLDOBLIQUE, PdfName.HELVETICA_BOLDOBLIQUE);
        BuiltinFonts14.put(HELVETICA_OBLIQUE, PdfName.HELVETICA_OBLIQUE);
        BuiltinFonts14.put(SYMBOL, PdfName.SYMBOL);
        BuiltinFonts14.put(TIMES_ROMAN, PdfName.TIMES_ROMAN);
        BuiltinFonts14.put(TIMES_BOLD, PdfName.TIMES_BOLD);
        BuiltinFonts14.put(TIMES_BOLDITALIC, PdfName.TIMES_BOLDITALIC);
        BuiltinFonts14.put(TIMES_ITALIC, PdfName.TIMES_ITALIC);
        BuiltinFonts14.put(ZAPFDINGBATS, PdfName.ZAPFDINGBATS);
    }

    static final class a
    extends PdfStream {
        public a(byte[] byArray, int[] nArray, int n2) {
            try {
                this.bytes = byArray;
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    this.put(new PdfName("Length" + (i2 + 1)), new PdfNumber(nArray[i2]));
                }
                this.flateCompress(n2);
                return;
            }
            catch (Exception exception) {
                throw new DocumentException(exception);
            }
        }

        public a(byte[] byArray, String string, int n2) {
            try {
                this.bytes = byArray;
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                this.put(PdfName.SUBTYPE, new PdfName(string));
                this.flateCompress(n2);
                return;
            }
            catch (Exception exception) {
                throw new DocumentException(exception);
            }
        }
    }
}

