/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PdfEncodings;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class ByteBuffer
extends OutputStream {
    protected int count;
    protected byte[] buf;
    private static int a = 0;
    private static byte[][] b = new byte[0][];
    public static final byte ZERO = 48;
    private static final char[] c = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final byte[] d = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    public static boolean HIGH_PRECISION = false;
    private static final DecimalFormatSymbols e = new DecimalFormatSymbols(Locale.US);

    public ByteBuffer() {
        this(128);
    }

    public ByteBuffer(int n2) {
        if (n2 <= 0) {
            n2 = 128;
        }
        this.buf = new byte[n2];
    }

    public static void setCacheSize(int n2) {
        if (n2 > 3276700) {
            n2 = 3276700;
        }
        if (n2 <= a) {
            return;
        }
        byte[][] byArrayArray = new byte[n2][];
        System.arraycopy(b, 0, byArrayArray, 0, a);
        b = byArrayArray;
        a = n2;
    }

    public static void fillCache(int n2) {
        int n3 = 1;
        switch (n2) {
            case 0: {
                n3 = 100;
                break;
            }
            case 1: {
                n3 = 10;
            }
        }
        for (n2 = 1; n2 < a; n2 += n3) {
            if (b[n2] != null) continue;
            int n4 = n2;
            int n5 = (int)Math.floor(Math.log(n4) / Math.log(10.0));
            if (n4 % 100 != 0) {
                n5 += 2;
            }
            if (n4 % 10 != 0) {
                ++n5;
            }
            if (n4 < 100) {
                ++n5;
                if (n4 < 10) {
                    ++n5;
                }
            }
            byte[] byArray = new byte[--n5];
            --n5;
            if (n4 < 100) {
                byArray[0] = 48;
            }
            if (n4 % 10 != 0) {
                byArray[n5--] = d[n4 % 10];
            }
            if (n4 % 100 != 0) {
                byArray[n5--] = d[n4 / 10 % 10];
                byArray[n5] = 46;
            }
            n5 = (int)Math.floor(Math.log(n4) / Math.log(10.0)) - 1;
            for (int i2 = 0; i2 < n5; ++i2) {
                byArray[i2] = d[n4 / (int)Math.pow(10.0, n5 - i2 + 1) % 10];
            }
            ByteBuffer.b[n4] = byArray;
        }
    }

    public ByteBuffer append_i(int n2) {
        int n3 = this.count + 1;
        if (n3 > this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length << 1, n3)];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        this.buf[this.count] = (byte)n2;
        this.count = n3;
        return this;
    }

    public ByteBuffer append(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0 || n3 == 0) {
            return this;
        }
        int n4 = this.count + n3;
        if (n4 > this.buf.length) {
            byte[] byArray2 = new byte[Math.max(this.buf.length << 1, n4)];
            System.arraycopy(this.buf, 0, byArray2, 0, this.count);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n2, this.buf, this.count, n3);
        this.count = n4;
        return this;
    }

    public ByteBuffer append(byte[] byArray) {
        return this.append(byArray, 0, byArray.length);
    }

    public ByteBuffer append(String string) {
        if (string != null) {
            return this.append(DocWriter.getISOBytes(string));
        }
        return this;
    }

    public ByteBuffer append(char c2) {
        return this.append_i(c2);
    }

    public ByteBuffer append(ByteBuffer byteBuffer) {
        return this.append(byteBuffer.buf, 0, byteBuffer.count);
    }

    public ByteBuffer append(int n2) {
        return this.append(String.valueOf(n2));
    }

    public ByteBuffer append(long l2) {
        return this.append(String.valueOf(l2));
    }

    public ByteBuffer append(byte by) {
        return this.append_i(by);
    }

    public ByteBuffer appendHex(byte by) {
        this.append(d[by >> 4 & 0xF]);
        return this.append(d[by & 0xF]);
    }

    public ByteBuffer append(float f2) {
        return this.append((double)f2);
    }

    public ByteBuffer append(double d2) {
        this.append(ByteBuffer.formatDouble(d2, this));
        return this;
    }

    public static String formatDouble(double d2) {
        return ByteBuffer.formatDouble(d2, null);
    }

    public static String formatDouble(double d2, ByteBuffer byteBuffer) {
        if (HIGH_PRECISION) {
            DecimalFormat decimalFormat = new DecimalFormat("0.######", e);
            String string = decimalFormat.format(d2);
            if (byteBuffer == null) {
                return string;
            }
            byteBuffer.append(string);
            return null;
        }
        boolean bl2 = false;
        if (Math.abs(d2) < 1.5E-5) {
            if (byteBuffer != null) {
                byteBuffer.append((byte)48);
                return null;
            }
            return "0";
        }
        if (d2 < 0.0) {
            bl2 = true;
            d2 = -d2;
        }
        if (d2 < 1.0) {
            double d3;
            d2 += 5.0E-6;
            if (d3 >= 1.0) {
                if (bl2) {
                    if (byteBuffer != null) {
                        byteBuffer.append((byte)45);
                        byteBuffer.append((byte)49);
                        return null;
                    }
                    return "-1";
                }
                if (byteBuffer != null) {
                    byteBuffer.append((byte)49);
                    return null;
                }
                return "1";
            }
            if (byteBuffer != null) {
                int n2 = (int)(d2 * 100000.0);
                if (bl2) {
                    byteBuffer.append((byte)45);
                }
                byteBuffer.append((byte)48);
                byteBuffer.append((byte)46);
                byteBuffer.append((byte)(n2 / 10000 + 48));
                if (n2 % 10000 != 0) {
                    byteBuffer.append((byte)(n2 / 1000 % 10 + 48));
                    if (n2 % 1000 != 0) {
                        byteBuffer.append((byte)(n2 / 100 % 10 + 48));
                        if (n2 % 100 != 0) {
                            byteBuffer.append((byte)(n2 / 10 % 10 + 48));
                            if (n2 % 10 != 0) {
                                byteBuffer.append((byte)(n2 % 10 + 48));
                            }
                        }
                    }
                }
                return null;
            }
            int n3 = 100000;
            int n4 = (int)(d2 * 100000.0);
            StringBuilder stringBuilder = new StringBuilder();
            if (bl2) {
                stringBuilder.append('-');
            }
            stringBuilder.append("0.");
            while (n4 < n3 / 10) {
                stringBuilder.append('0');
                n3 /= 10;
            }
            stringBuilder.append(n4);
            int n5 = stringBuilder.length() - 1;
            while (stringBuilder.charAt(n5) == '0') {
                --n5;
            }
            stringBuilder.setLength(n5 + 1);
            return stringBuilder.toString();
        }
        if (d2 <= 32767.0) {
            int n6 = (int)((d2 += 0.005) * 100.0);
            if (n6 < a && b[n6] != null) {
                if (byteBuffer != null) {
                    if (bl2) {
                        byteBuffer.append((byte)45);
                    }
                    byteBuffer.append(b[n6]);
                    return null;
                }
                String string = PdfEncodings.convertToString(b[n6], null);
                if (bl2) {
                    string = "-" + string;
                }
                return string;
            }
            if (byteBuffer != null) {
                if (n6 < a) {
                    int n7 = 0;
                    if (n6 >= 1000000) {
                        n7 += 5;
                    } else if (n6 >= 100000) {
                        n7 += 4;
                    } else if (n6 >= 10000) {
                        n7 += 3;
                    } else if (n6 >= 1000) {
                        n7 += 2;
                    } else if (n6 >= 100) {
                        ++n7;
                    }
                    if (n6 % 100 != 0) {
                        n7 += 2;
                    }
                    if (n6 % 10 != 0) {
                        ++n7;
                    }
                    byte[] byArray = new byte[n7];
                    int n8 = 0;
                    if (n6 >= 1000000) {
                        ++n8;
                        byArray[0] = d[n6 / 1000000];
                    }
                    if (n6 >= 100000) {
                        byArray[n8++] = d[n6 / 100000 % 10];
                    }
                    if (n6 >= 10000) {
                        byArray[n8++] = d[n6 / 10000 % 10];
                    }
                    if (n6 >= 1000) {
                        byArray[n8++] = d[n6 / 1000 % 10];
                    }
                    if (n6 >= 100) {
                        byArray[n8++] = d[n6 / 100 % 10];
                    }
                    if (n6 % 100 != 0) {
                        byArray[n8++] = 46;
                        byArray[n8++] = d[n6 / 10 % 10];
                        if (n6 % 10 != 0) {
                            byArray[n8] = d[n6 % 10];
                        }
                    }
                    ByteBuffer.b[n6] = byArray;
                }
                if (bl2) {
                    byteBuffer.append((byte)45);
                }
                if (n6 >= 1000000) {
                    byteBuffer.append(d[n6 / 1000000]);
                }
                if (n6 >= 100000) {
                    byteBuffer.append(d[n6 / 100000 % 10]);
                }
                if (n6 >= 10000) {
                    byteBuffer.append(d[n6 / 10000 % 10]);
                }
                if (n6 >= 1000) {
                    byteBuffer.append(d[n6 / 1000 % 10]);
                }
                if (n6 >= 100) {
                    byteBuffer.append(d[n6 / 100 % 10]);
                }
                if (n6 % 100 != 0) {
                    byteBuffer.append((byte)46);
                    byteBuffer.append(d[n6 / 10 % 10]);
                    if (n6 % 10 != 0) {
                        byteBuffer.append(d[n6 % 10]);
                    }
                }
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (bl2) {
                stringBuilder.append('-');
            }
            if (n6 >= 1000000) {
                stringBuilder.append(c[n6 / 1000000]);
            }
            if (n6 >= 100000) {
                stringBuilder.append(c[n6 / 100000 % 10]);
            }
            if (n6 >= 10000) {
                stringBuilder.append(c[n6 / 10000 % 10]);
            }
            if (n6 >= 1000) {
                stringBuilder.append(c[n6 / 1000 % 10]);
            }
            if (n6 >= 100) {
                stringBuilder.append(c[n6 / 100 % 10]);
            }
            if (n6 % 100 != 0) {
                stringBuilder.append('.');
                stringBuilder.append(c[n6 / 10 % 10]);
                if (n6 % 10 != 0) {
                    stringBuilder.append(c[n6 % 10]);
                }
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append('-');
        }
        long l2 = (long)(d2 += 0.5);
        return stringBuilder.append(l2).toString();
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public int size() {
        return this.count;
    }

    public void setSize(int n2) {
        if (n2 > this.count || n2 < 0) {
            throw new IndexOutOfBoundsException(MessageLocalization.getComposedMessage("the.new.size.must.be.positive.and.lt.eq.of.the.current.size"));
        }
        this.count = n2;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String string) {
        return new String(this.buf, 0, this.count, string);
    }

    public void writeTo(OutputStream outputStream) {
        outputStream.write(this.buf, 0, this.count);
    }

    @Override
    public void write(int n2) {
        this.append((byte)n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.append(byArray, n2, n3);
    }

    public byte[] getBuffer() {
        return this.buf;
    }
}

