/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;

public class CFFFont {
    private static String[] c = new String[]{"version", "Notice", "FullName", "FamilyName", "Weight", "FontBBox", "BlueValues", "OtherBlues", "FamilyBlues", "FamilyOtherBlues", "StdHW", "StdVW", "UNKNOWN_12", "UniqueID", "XUID", "charset", "Encoding", "CharStrings", "Private", "Subrs", "defaultWidthX", "nominalWidthX", "UNKNOWN_22", "UNKNOWN_23", "UNKNOWN_24", "UNKNOWN_25", "UNKNOWN_26", "UNKNOWN_27", "UNKNOWN_28", "UNKNOWN_29", "UNKNOWN_30", "UNKNOWN_31", "Copyright", "isFixedPitch", "ItalicAngle", "UnderlinePosition", "UnderlineThickness", "PaintType", "CharstringType", "FontMatrix", "StrokeWidth", "BlueScale", "BlueShift", "BlueFuzz", "StemSnapH", "StemSnapV", "ForceBold", "UNKNOWN_12_15", "UNKNOWN_12_16", "LanguageGroup", "ExpansionFactor", "initialRandomSeed", "SyntheticBase", "PostScript", "BaseFontName", "BaseFontBlend", "UNKNOWN_12_24", "UNKNOWN_12_25", "UNKNOWN_12_26", "UNKNOWN_12_27", "UNKNOWN_12_28", "UNKNOWN_12_29", "ROS", "CIDFontVersion", "CIDFontRevision", "CIDFontType", "CIDCount", "UIDBase", "FDArray", "FDSelect", "FontName"};
    static final String[] a = new String[]{".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "endash", "dagger", "daggerdbl", "periodcentered", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "questiondown", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "emdash", "AE", "ordfeminine", "Lslash", "Oslash", "OE", "ordmasculine", "ae", "dotlessi", "lslash", "oslash", "oe", "germandbls", "onesuperior", "logicalnot", "mu", "trademark", "Eth", "onehalf", "plusminus", "Thorn", "onequarter", "divide", "brokenbar", "degree", "thorn", "threequarters", "twosuperior", "registered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacute", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacute", "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", "Zcaron", "aacute", "acircumflex", "adieresis", "agrave", "aring", "atilde", "ccedilla", "eacute", "ecircumflex", "edieresis", "egrave", "iacute", "icircumflex", "idieresis", "igrave", "ntilde", "oacute", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", "ydieresis", "zcaron", "exclamsmall", "Hungarumlautsmall", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "parenleftinferior", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "exclamdownsmall", "centoldstyle", "Lslashsmall", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "Dotaccentsmall", "Macronsmall", "figuredash", "hypheninferior", "Ogoneksmall", "Ringsmall", "Cedillasmall", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold"};
    int b;
    protected String key;
    protected Object[] args = new Object[48];
    protected int arg_count = 0;
    protected RandomAccessFileOrArray buf;
    private final int d;
    protected int nameIndexOffset;
    protected int topdictIndexOffset;
    protected int stringIndexOffset;
    protected int gsubrIndexOffset;
    protected int[] nameOffsets;
    protected int[] topdictOffsets;
    protected int[] stringOffsets;
    protected int[] gsubrOffsets;
    protected Font[] fonts;

    public String getString(char c2) {
        if (c2 < a.length) {
            return a[c2];
        }
        if (c2 >= a.length + (this.stringOffsets.length - 1)) {
            return null;
        }
        c2 = (char)(c2 - a.length);
        int n2 = this.c();
        CFFFont cFFFont = this;
        cFFFont.b(cFFFont.stringOffsets[c2]);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = this.stringOffsets[c2]; i2 < this.stringOffsets[c2 + '\u0001']; ++i2) {
            stringBuilder.append(this.a());
        }
        this.b(n2);
        return stringBuilder.toString();
    }

    final char a() {
        try {
            byte by = this.buf.readByte();
            return (char)(by & 0xFF);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    final char b() {
        try {
            return this.buf.readChar();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    final int a(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 <<= 8;
            n3 += this.a();
        }
        return n3;
    }

    final void b(int n2) {
        try {
            this.buf.seek(n2);
            return;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private short d() {
        try {
            return this.buf.readShort();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private int e() {
        try {
            return this.buf.readInt();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    final int c() {
        try {
            return this.buf.getFilePointer();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    final int[] c(int n2) {
        this.b(n2);
        int n3 = this.b();
        int[] nArray = new int[n3 + '\u0001'];
        if (n3 == 0) {
            nArray[0] = -1;
            return nArray;
        }
        char c2 = this.a();
        for (int i2 = 0; i2 <= n3; ++i2) {
            nArray[i2] = n2 + 2 + 1 + (n3 + '\u0001') * c2 - 1 + this.a(c2);
        }
        return nArray;
    }

    protected void getDictItem() {
        int n2;
        for (n2 = 0; n2 < this.arg_count; ++n2) {
            this.args[n2] = null;
        }
        this.arg_count = 0;
        this.key = null;
        n2 = 0;
        while (n2 == 0) {
            short s2 = this.a();
            if (s2 == 29) {
                int n3 = this.e();
                this.args[this.arg_count] = n3;
                ++this.arg_count;
                continue;
            }
            if (s2 == 28) {
                short s3 = this.d();
                this.args[this.arg_count] = (int)s3;
                ++this.arg_count;
                continue;
            }
            if (s2 >= 32 && s2 <= 246) {
                byte by = (byte)(s2 - 139);
                this.args[this.arg_count] = (int)by;
                ++this.arg_count;
                continue;
            }
            if (s2 >= 247 && s2 <= 250) {
                char c2 = this.a();
                s2 = (short)((s2 - 247 << 8) + c2 + 108);
                this.args[this.arg_count] = (int)s2;
                ++this.arg_count;
                continue;
            }
            if (s2 >= 251 && s2 <= 254) {
                char c3 = this.a();
                s2 = (short)((-(s2 - 251) << 8) - c3 - 108);
                this.args[this.arg_count] = (int)s2;
                ++this.arg_count;
                continue;
            }
            if (s2 == 30) {
                String string = "";
                s2 = 0;
                char c4 = '\u0000';
                int n4 = 0;
                int n5 = 0;
                block9: while (s2 == 0) {
                    if (n4 == 0) {
                        c4 = this.a();
                        n4 = 2;
                    }
                    if (n4 == 1) {
                        n5 = c4 / 16;
                        n4 = (byte)(n4 - 1);
                    }
                    if (n4 == 2) {
                        n5 = c4 % 16;
                        n4 = (byte)(n4 - 1);
                    }
                    switch (n5) {
                        case 10: {
                            string = string + ".";
                            continue block9;
                        }
                        case 11: {
                            string = string + "E";
                            continue block9;
                        }
                        case 12: {
                            string = string + "E-";
                            continue block9;
                        }
                        case 14: {
                            string = string + "-";
                            continue block9;
                        }
                        case 15: {
                            s2 = 1;
                            continue block9;
                        }
                    }
                    if (n5 >= 0 && n5 <= 9) {
                        string = string + String.valueOf(n5);
                        continue;
                    }
                    string = string + "<NIBBLE ERROR: " + n5 + '>';
                    s2 = 1;
                }
                this.args[this.arg_count] = string;
                ++this.arg_count;
                continue;
            }
            if (s2 > 21) continue;
            n2 = 1;
            if (s2 != 12) {
                this.key = c[s2];
                continue;
            }
            this.key = c[32 + this.a()];
        }
    }

    protected RangeItem getEntireIndexRange(int n2) {
        this.b(n2);
        char c2 = this.b();
        if (c2 == '\u0000') {
            return new RangeItem(this.buf, n2, 2);
        }
        char c3 = this.a();
        this.b(n2 + 2 + 1 + c2 * c3);
        int n3 = this.a(c3) - 1;
        return new RangeItem(this.buf, n2, 3 + (c2 + '\u0001') * c3 + n3);
    }

    public byte[] getCID(String object) {
        int n2;
        for (n2 = 0; n2 < this.fonts.length && !((String)object).equals(this.fonts[n2].name); ++n2) {
        }
        if (n2 == this.fonts.length) {
            return null;
        }
        object = new LinkedList();
        this.b(0);
        this.a();
        this.a();
        int n3 = this.a();
        this.a();
        this.b = n3;
        object.addLast(new RangeItem(this.buf, 0, n3));
        n3 = -1;
        int n4 = -1;
        if (!this.fonts[n2].isCID) {
            CFFFont cFFFont = this;
            cFFFont.b(cFFFont.fonts[n2].charstringsOffset);
            n3 = this.b();
            CFFFont cFFFont2 = this;
            cFFFont2.b(cFFFont2.stringIndexOffset);
            n4 = this.b() + a.length;
        }
        object.addLast(new UInt16Item('\u0001'));
        object.addLast(new UInt8Item('\u0001'));
        object.addLast(new UInt8Item('\u0001'));
        object.addLast(new UInt8Item((char)(1 + this.fonts[n2].name.length())));
        object.addLast(new StringItem(this.fonts[n2].name));
        object.addLast(new UInt16Item('\u0001'));
        object.addLast(new UInt8Item('\u0002'));
        object.addLast(new UInt16Item('\u0001'));
        Item item = new IndexOffsetItem(2);
        object.addLast(item);
        Object object2 = new IndexBaseItem();
        object.addLast(object2);
        DictOffsetItem dictOffsetItem = new DictOffsetItem();
        DictOffsetItem dictOffsetItem2 = new DictOffsetItem();
        DictOffsetItem dictOffsetItem3 = new DictOffsetItem();
        DictOffsetItem dictOffsetItem4 = new DictOffsetItem();
        if (!this.fonts[n2].isCID) {
            object.addLast(new DictNumberItem(n4));
            object.addLast(new DictNumberItem(n4 + 1));
            object.addLast(new DictNumberItem(0));
            object.addLast(new UInt8Item('\f'));
            object.addLast(new UInt8Item('\u001e'));
            object.addLast(new DictNumberItem(n3));
            object.addLast(new UInt8Item('\f'));
            object.addLast(new UInt8Item('\"'));
        }
        object.addLast(dictOffsetItem3);
        object.addLast(new UInt8Item('\f'));
        object.addLast(new UInt8Item('$'));
        object.addLast(dictOffsetItem4);
        object.addLast(new UInt8Item('\f'));
        object.addLast(new UInt8Item('%'));
        object.addLast(dictOffsetItem);
        object.addLast(new UInt8Item('\u000f'));
        object.addLast(dictOffsetItem2);
        object.addLast(new UInt8Item('\u0011'));
        CFFFont cFFFont = this;
        cFFFont.b(cFFFont.topdictOffsets[n2]);
        while (this.c() < this.topdictOffsets[n2 + 1]) {
            n4 = this.c();
            this.getDictItem();
            int n5 = this.c();
            if (Objects.equals(this.key, "Encoding") || Objects.equals(this.key, "Private") || Objects.equals(this.key, "FDSelect") || Objects.equals(this.key, "FDArray") || Objects.equals(this.key, "charset") || Objects.equals(this.key, "CharStrings")) continue;
            object.add(new RangeItem(this.buf, n4, n5 - n4));
        }
        object.addLast(new IndexMarkerItem((OffsetItem)item, (IndexBaseItem)object2));
        if (this.fonts[n2].isCID) {
            CFFFont cFFFont3 = this;
            object.addLast(cFFFont3.getEntireIndexRange(cFFFont3.stringIndexOffset));
        } else {
            String string = this.fonts[n2].name + "-OneRange";
            if (string.length() > 127) {
                string = string.substring(0, 127);
            }
            String string2 = "AdobeIdentity" + string;
            int n6 = this.stringOffsets[this.stringOffsets.length - 1] - this.stringOffsets[0];
            int n7 = this.stringOffsets[0] - 1;
            int n8 = n6 + string2.length() <= 255 ? 1 : (n6 + string2.length() <= 65535 ? 2 : (n6 + string2.length() <= 0xFFFFFF ? 3 : 4));
            object.addLast(new UInt16Item((char)(this.stringOffsets.length - 1 + 3)));
            object.addLast(new UInt8Item((char)n8));
            int[] nArray = this.stringOffsets;
            int n9 = this.stringOffsets.length;
            for (int i2 = 0; i2 < n9; ++i2) {
                int n10 = nArray[i2];
                object.addLast(new IndexOffsetItem(n8, n10 - n7));
            }
            int n11 = this.stringOffsets[this.stringOffsets.length - 1] - n7;
            object.addLast(new IndexOffsetItem(n8, n11 += 5));
            object.addLast(new IndexOffsetItem(n8, n11 += 8));
            object.addLast(new IndexOffsetItem(n8, n11 += string.length()));
            object.addLast(new RangeItem(this.buf, this.stringOffsets[0], n6));
            object.addLast(new StringItem(string2));
        }
        CFFFont cFFFont4 = this;
        object.addLast(cFFFont4.getEntireIndexRange(cFFFont4.gsubrIndexOffset));
        if (!this.fonts[n2].isCID) {
            object.addLast(new MarkerItem(dictOffsetItem4));
            object.addLast(new UInt8Item('\u0003'));
            object.addLast(new UInt16Item('\u0001'));
            object.addLast(new UInt16Item('\u0000'));
            object.addLast(new UInt8Item('\u0000'));
            object.addLast(new UInt16Item((char)n3));
            object.addLast(new MarkerItem(dictOffsetItem));
            object.addLast(new UInt8Item('\u0002'));
            object.addLast(new UInt16Item('\u0001'));
            object.addLast(new UInt16Item((char)(n3 - 1)));
            object.addLast(new MarkerItem(dictOffsetItem3));
            object.addLast(new UInt16Item('\u0001'));
            object.addLast(new UInt8Item('\u0001'));
            object.addLast(new UInt8Item('\u0001'));
            IndexOffsetItem indexOffsetItem = new IndexOffsetItem(1);
            object.addLast(indexOffsetItem);
            IndexBaseItem indexBaseItem = new IndexBaseItem();
            object.addLast(indexBaseItem);
            object.addLast(new DictNumberItem(this.fonts[n2].privateLength));
            item = new DictOffsetItem();
            object.addLast(item);
            object.addLast(new UInt8Item('\u0012'));
            object.addLast(new IndexMarkerItem(indexOffsetItem, indexBaseItem));
            object.addLast(new MarkerItem((OffsetItem)item));
            object.addLast(new RangeItem(this.buf, this.fonts[n2].privateOffset, this.fonts[n2].privateLength));
            if (this.fonts[n2].privateSubrs >= 0) {
                CFFFont cFFFont5 = this;
                object.addLast(cFFFont5.getEntireIndexRange(cFFFont5.fonts[n2].privateSubrs));
            }
        }
        object.addLast(new MarkerItem(dictOffsetItem2));
        CFFFont cFFFont6 = this;
        object.addLast(cFFFont6.getEntireIndexRange(cFFFont6.fonts[n2].charstringsOffset));
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            item = (Item)iterator.next();
            ((Item)item).increment(nArray2);
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            item = (Item)iterator.next();
            item.xref();
        }
        int n12 = nArray2[0];
        object2 = new byte[n12];
        iterator = object.iterator();
        while (iterator.hasNext()) {
            Item item2 = (Item)iterator.next();
            item2.emit((byte[])object2);
        }
        return object2;
    }

    public boolean isCID(String string) {
        for (int i2 = 0; i2 < this.fonts.length; ++i2) {
            if (!string.equals(this.fonts[i2].name)) continue;
            return this.fonts[i2].isCID;
        }
        return false;
    }

    public boolean exists(String string) {
        for (int i2 = 0; i2 < this.fonts.length; ++i2) {
            if (!string.equals(this.fonts[i2].name)) continue;
            return true;
        }
        return false;
    }

    public String[] getNames() {
        String[] stringArray = new String[this.fonts.length];
        for (int i2 = 0; i2 < this.fonts.length; ++i2) {
            stringArray[i2] = this.fonts[i2].name;
        }
        return stringArray;
    }

    public CFFFont(RandomAccessFileOrArray randomAccessFileOrArray) {
        this.buf = randomAccessFileOrArray;
        this.b(0);
        this.a();
        this.a();
        int n2 = this.a();
        this.d = this.a();
        this.nameIndexOffset = n2;
        this.nameOffsets = this.c(this.nameIndexOffset);
        this.topdictIndexOffset = this.nameOffsets[this.nameOffsets.length - 1];
        this.topdictOffsets = this.c(this.topdictIndexOffset);
        this.stringIndexOffset = this.topdictOffsets[this.topdictOffsets.length - 1];
        this.stringOffsets = this.c(this.stringIndexOffset);
        this.gsubrIndexOffset = this.stringOffsets[this.stringOffsets.length - 1];
        this.gsubrOffsets = this.c(this.gsubrIndexOffset);
        this.fonts = new Font[this.nameOffsets.length - 1];
        for (n2 = 0; n2 < this.nameOffsets.length - 1; ++n2) {
            this.fonts[n2] = new Font(this);
            CFFFont cFFFont = this;
            cFFFont.b(cFFFont.nameOffsets[n2]);
            this.fonts[n2].name = "";
            for (int i2 = this.nameOffsets[n2]; i2 < this.nameOffsets[n2 + '\u0001']; ++i2) {
                this.fonts[n2].name = this.fonts[n2].name + this.a();
            }
        }
        for (n2 = 0; n2 < this.topdictOffsets.length - 1; ++n2) {
            CFFFont cFFFont = this;
            cFFFont.b(cFFFont.topdictOffsets[n2]);
            while (this.c() < this.topdictOffsets[n2 + '\u0001']) {
                this.getDictItem();
                if (Objects.equals(this.key, "FullName")) {
                    CFFFont cFFFont2 = this;
                    this.fonts[n2].fullName = cFFFont2.getString((char)((Integer)cFFFont2.args[0]).intValue());
                    continue;
                }
                if (Objects.equals(this.key, "ROS")) {
                    this.fonts[n2].isCID = true;
                    continue;
                }
                if (Objects.equals(this.key, "Private")) {
                    this.fonts[n2].privateLength = (Integer)this.args[0];
                    this.fonts[n2].privateOffset = (Integer)this.args[1];
                    continue;
                }
                if (Objects.equals(this.key, "charset")) {
                    this.fonts[n2].charsetOffset = (Integer)this.args[0];
                    continue;
                }
                if (Objects.equals(this.key, "CharStrings")) {
                    this.fonts[n2].charstringsOffset = (Integer)this.args[0];
                    int n3 = this.c();
                    CFFFont cFFFont3 = this;
                    this.fonts[n2].charstringsOffsets = cFFFont3.c(cFFFont3.fonts[n2].charstringsOffset);
                    this.b(n3);
                    continue;
                }
                if (Objects.equals(this.key, "FDArray")) {
                    this.fonts[n2].fdarrayOffset = (Integer)this.args[0];
                    continue;
                }
                if (Objects.equals(this.key, "FDSelect")) {
                    this.fonts[n2].fdselectOffset = (Integer)this.args[0];
                    continue;
                }
                if (!Objects.equals(this.key, "CharstringType")) continue;
                this.fonts[n2].CharstringType = (Integer)this.args[0];
            }
            if (this.fonts[n2].privateOffset >= 0) {
                CFFFont cFFFont4 = this;
                cFFFont4.b(cFFFont4.fonts[n2].privateOffset);
                while (this.c() < this.fonts[n2].privateOffset + this.fonts[n2].privateLength) {
                    this.getDictItem();
                    if (!Objects.equals(this.key, "Subrs")) continue;
                    this.fonts[n2].privateSubrs = (Integer)this.args[0] + this.fonts[n2].privateOffset;
                }
            }
            if (this.fonts[n2].fdarrayOffset < 0) continue;
            CFFFont cFFFont5 = this;
            int[] nArray = cFFFont5.c(cFFFont5.fonts[n2].fdarrayOffset);
            this.fonts[n2].fdprivateOffsets = new int[nArray.length - 1];
            this.fonts[n2].fdprivateLengths = new int[nArray.length - 1];
            for (int i3 = 0; i3 < nArray.length - 1; ++i3) {
                this.b(nArray[i3]);
                while (this.c() < nArray[i3 + 1]) {
                    this.getDictItem();
                }
                if (!Objects.equals(this.key, "Private")) continue;
                this.fonts[n2].fdprivateLengths[i3] = (Integer)this.args[0];
                this.fonts[n2].fdprivateOffsets[i3] = (Integer)this.args[1];
            }
        }
    }

    protected final class Font {
        public String name;
        public String fullName;
        public boolean isCID = false;
        public int privateOffset = -1;
        public int privateLength = -1;
        public int privateSubrs = -1;
        public int charstringsOffset = -1;
        public int encodingOffset = -1;
        public int charsetOffset = -1;
        public int fdarrayOffset = -1;
        public int fdselectOffset = -1;
        public int[] fdprivateOffsets;
        public int[] fdprivateLengths;
        public int[] fdprivateSubrs;
        public int nglyphs;
        public int nstrings;
        public int CharsetLength;
        public int[] charstringsOffsets;
        public int[] charset;
        public int[] FDSelect;
        public int FDSelectLength;
        public int FDSelectFormat;
        public int CharstringType = 2;
        public int FDArrayCount;
        public int FDArrayOffsize;
        public int[] FDArrayOffsets;
        public int[] PrivateSubrsOffset;
        public int[][] PrivateSubrsOffsetsArray;
        public int[] SubrsOffsets;
        private /* synthetic */ CFFFont a;

        protected Font(CFFFont cFFFont) {
            this.a = cFFFont;
        }
    }

    protected static final class MarkerItem
    extends Item {
        private OffsetItem a;

        public MarkerItem(OffsetItem offsetItem) {
            this.a = offsetItem;
        }

        @Override
        public final void xref() {
            this.a.set(this.myOffset);
        }
    }

    protected static final class DictNumberItem
    extends Item {
        public final int value;
        public int size = 5;

        public DictNumberItem(int n2) {
            this.value = n2;
        }

        @Override
        public final void increment(int[] nArray) {
            super.increment(nArray);
            nArray[0] = nArray[0] + this.size;
        }

        @Override
        public final void emit(byte[] byArray) {
            if (this.size == 5) {
                byArray[this.myOffset] = 29;
                byArray[this.myOffset + 1] = (byte)(this.value >>> 24);
                byArray[this.myOffset + 2] = (byte)(this.value >>> 16);
                byArray[this.myOffset + 3] = (byte)(this.value >>> 8);
                byArray[this.myOffset + 4] = (byte)this.value;
            }
        }
    }

    protected static final class StringItem
    extends Item {
        public String s;

        public StringItem(String string) {
            this.s = string;
        }

        @Override
        public final void increment(int[] nArray) {
            super.increment(nArray);
            nArray[0] = nArray[0] + this.s.length();
        }

        @Override
        public final void emit(byte[] byArray) {
            for (int i2 = 0; i2 < this.s.length(); ++i2) {
                byArray[this.myOffset + i2] = (byte)this.s.charAt(i2);
            }
        }
    }

    protected static final class UInt8Item
    extends Item {
        public char value;

        public UInt8Item(char c2) {
            this.value = c2;
        }

        @Override
        public final void increment(int[] nArray) {
            super.increment(nArray);
            nArray[0] = nArray[0] + 1;
        }

        @Override
        public final void emit(byte[] byArray) {
            byArray[this.myOffset] = (byte)this.value;
        }
    }

    protected static final class UInt16Item
    extends Item {
        public char value;

        public UInt16Item(char c2) {
            this.value = c2;
        }

        @Override
        public final void increment(int[] nArray) {
            super.increment(nArray);
            nArray[0] = nArray[0] + 2;
        }

        @Override
        public final void emit(byte[] byArray) {
            byArray[this.myOffset] = (byte)(this.value >>> 8);
            byArray[this.myOffset + 1] = (byte)this.value;
        }
    }

    protected static final class UInt32Item
    extends Item {
        public int value;

        public UInt32Item(int n2) {
            this.value = n2;
        }

        @Override
        public final void increment(int[] nArray) {
            super.increment(nArray);
            nArray[0] = nArray[0] + 4;
        }

        @Override
        public final void emit(byte[] byArray) {
            byArray[this.myOffset] = (byte)(this.value >>> 24);
            byArray[this.myOffset + 1] = (byte)(this.value >>> 16);
            byArray[this.myOffset + 2] = (byte)(this.value >>> 8);
            byArray[this.myOffset + 3] = (byte)this.value;
        }
    }

    protected static final class UInt24Item
    extends Item {
        public int value;

        public UInt24Item(int n2) {
            this.value = n2;
        }

        @Override
        public final void increment(int[] nArray) {
            super.increment(nArray);
            nArray[0] = nArray[0] + 3;
        }

        @Override
        public final void emit(byte[] byArray) {
            byArray[this.myOffset] = (byte)(this.value >>> 16);
            byArray[this.myOffset + 1] = (byte)(this.value >>> 8);
            byArray[this.myOffset + 2] = (byte)this.value;
        }
    }

    protected static final class DictOffsetItem
    extends OffsetItem {
        public final int size;

        public DictOffsetItem() {
            this.size = 5;
        }

        @Override
        public final void increment(int[] nArray) {
            super.increment(nArray);
            nArray[0] = nArray[0] + this.size;
        }

        @Override
        public final void emit(byte[] byArray) {
            if (this.size == 5) {
                byArray[this.myOffset] = 29;
                byArray[this.myOffset + 1] = (byte)(this.value >>> 24);
                byArray[this.myOffset + 2] = (byte)(this.value >>> 16);
                byArray[this.myOffset + 3] = (byte)(this.value >>> 8);
                byArray[this.myOffset + 4] = (byte)this.value;
            }
        }
    }

    protected static final class SubrMarkerItem
    extends Item {
        private final OffsetItem a;
        private final IndexBaseItem b;

        public SubrMarkerItem(OffsetItem offsetItem, IndexBaseItem indexBaseItem) {
            this.a = offsetItem;
            this.b = indexBaseItem;
        }

        @Override
        public final void xref() {
            this.a.set(this.myOffset - this.b.myOffset);
        }
    }

    protected static final class IndexMarkerItem
    extends Item {
        private final OffsetItem a;
        private final IndexBaseItem b;

        public IndexMarkerItem(OffsetItem offsetItem, IndexBaseItem indexBaseItem) {
            this.a = offsetItem;
            this.b = indexBaseItem;
        }

        @Override
        public final void xref() {
            this.a.set(this.myOffset - this.b.myOffset + 1);
        }
    }

    protected static final class IndexBaseItem
    extends Item {
    }

    protected static final class IndexOffsetItem
    extends OffsetItem {
        public final int size;

        public IndexOffsetItem(int n2, int n3) {
            this.size = n2;
            this.value = n3;
        }

        public IndexOffsetItem(int n2) {
            this.size = n2;
        }

        @Override
        public final void increment(int[] nArray) {
            super.increment(nArray);
            nArray[0] = nArray[0] + this.size;
        }

        @Override
        public final void emit(byte[] byArray) {
            int n2 = 0;
            switch (this.size) {
                case 4: {
                    byArray[this.myOffset] = (byte)(this.value >>> 24);
                    ++n2;
                }
                case 3: {
                    byArray[this.myOffset + n2] = (byte)(this.value >>> 16);
                    ++n2;
                }
                case 2: {
                    byArray[this.myOffset + n2] = (byte)(this.value >>> 8);
                    ++n2;
                }
                case 1: {
                    byArray[this.myOffset + n2] = (byte)this.value;
                }
            }
        }
    }

    protected static final class RangeItem
    extends Item {
        public int offset;
        public int length;
        private final RandomAccessFileOrArray a;

        public RangeItem(RandomAccessFileOrArray randomAccessFileOrArray, int n2, int n3) {
            this.offset = n2;
            this.length = n3;
            this.a = randomAccessFileOrArray;
        }

        @Override
        public final void increment(int[] nArray) {
            super.increment(nArray);
            nArray[0] = nArray[0] + this.length;
        }

        @Override
        public final void emit(byte[] byArray) {
            try {
                this.a.seek(this.offset);
                for (int i2 = this.myOffset; i2 < this.myOffset + this.length; ++i2) {
                    byArray[i2] = this.a.readByte();
                }
                return;
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
    }

    protected static abstract class OffsetItem
    extends Item {
        public int value;

        protected OffsetItem() {
        }

        public void set(int n2) {
            this.value = n2;
        }
    }

    protected static abstract class Item {
        protected int myOffset = -1;

        protected Item() {
        }

        public void increment(int[] nArray) {
            this.myOffset = nArray[0];
        }

        public void emit(byte[] byArray) {
        }

        public void xref() {
        }
    }
}

