/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.fonts.cmaps.CMap;
import com.lowagie.text.pdf.fonts.cmaps.CMapParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CMapAwareDocumentFont
extends DocumentFont {
    private PdfDictionary b;
    private int c;
    private CMap d;
    private char[] e;

    public CMapAwareDocumentFont(PRIndirectReference object) {
        super((PRIndirectReference)object);
        this.b = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)object);
        object = this;
        Object object2 = ((CMapAwareDocumentFont)object).b.get(PdfName.TOUNICODE);
        if (object2 != null) {
            try {
                object2 = PdfReader.getStreamBytes((PRStream)PdfReader.getPdfObjectRelease((PdfObject)object2));
                CMapParser cMapParser = new CMapParser();
                ((CMapAwareDocumentFont)object).d = cMapParser.parse((InputStream)new ByteArrayInputStream((byte[])object2));
            }
            catch (IOException iOException) {
                throw new Error("Unable to process ToUnicode map - " + iOException.getMessage(), iOException);
            }
        }
        if (this.d == null) {
            this.c();
        }
        this.c = super.getWidth(32);
        if (this.c == 0) {
            this.c = this.d();
        }
    }

    private void c() {
        IntHashtable intHashtable = this.b();
        int[] nArray = intHashtable.toOrderedKeys();
        this.e = new char[256];
        for (int n2 : nArray) {
            int n3 = intHashtable.get(n2);
            if (this.e[n3] != '\u0000') continue;
            this.e[n3] = (char)n2;
        }
    }

    private int d() {
        int n2 = 0;
        int n3 = 0;
        int[] nArray = this.widths;
        int n4 = this.widths.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = nArray[i2];
            if (n5 == 0) continue;
            n3 += n5;
            ++n2;
        }
        if (n2 != 0) {
            return n3 / n2;
        }
        return 0;
    }

    @Override
    public int getWidth(int n2) {
        if (n2 == 32) {
            return this.c;
        }
        return super.getWidth(n2);
    }

    private String a(byte[] byArray, int n2, int n3) {
        if (this.hasUnicodeCMAP()) {
            if (n2 + n3 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException(MessageLocalization.getComposedMessage("invalid.index.1", n2 + n3));
            }
            return this.d.lookup(byArray, n2, n3);
        }
        if (n3 == 1) {
            return new String(this.e, 0xFF & byArray[n2], 1);
        }
        throw new Error("Multi-byte glyphs not implemented yet");
    }

    public boolean hasUnicodeCMAP() {
        return this.d != null;
    }

    public boolean hasTwoByteUnicodeCMAP() {
        return this.d != null && this.d.hasTwoByteMappings();
    }

    public String decode(byte[] byArray, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            String string = this.a(byArray, i2, 1);
            if (string == null && i2 + 1 < n2 + n3) {
                string = this.a(byArray, i2, 2);
                ++i2;
            }
            if (string == null) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String decode(String object) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object[i2];
            String string = this.decode((char)object2);
            if (string == null) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String decode(char c2) {
        String string;
        if (this.hasUnicodeCMAP()) {
            string = this.d.lookup(c2);
        } else if (c2 <= '\u00ff') {
            string = new String(this.e, 0xFF & c2, 1);
        } else {
            throw new Error("Multi-byte glyphs not implemented yet");
        }
        return string;
    }

    @Deprecated
    public String encode(byte[] byArray, int n2, int n3) {
        return this.decode(byArray, n2, n3);
    }
}

