/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class FdfReader
extends PdfReader {
    private Map<String, PdfDictionary> c;
    private String d;
    private PdfName e;

    public FdfReader(String string) {
        super(string);
    }

    public FdfReader(byte[] byArray) {
        super(byArray);
    }

    public FdfReader(URL uRL) {
        super(uRL);
    }

    public FdfReader(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    protected void readPdf() {
        this.c = new HashMap<String, PdfDictionary>();
        try {
            this.tokens.checkFdfHeader();
            this.rebuildXref();
            this.readDocObj();
        }
        catch (Throwable throwable) {
            try {
                this.tokens.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            this.tokens.close();
        }
        catch (Exception exception) {}
        this.readFields();
    }

    protected void kidNode(PdfDictionary pdfDictionary, String string) {
        PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.KIDS);
        if (pdfArray == null || pdfArray.isEmpty()) {
            if (string.length() > 0) {
                string = string.substring(1);
            }
            this.c.put(string, pdfDictionary);
            return;
        }
        pdfDictionary.remove(PdfName.KIDS);
        for (int i2 = 0; i2 < pdfArray.size(); ++i2) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            pdfDictionary2.merge(pdfDictionary);
            PdfDictionary pdfDictionary3 = pdfArray.getAsDict(i2);
            PdfString pdfString = pdfDictionary3.getAsString(PdfName.T);
            String string2 = string;
            if (pdfString != null) {
                string2 = string2 + "." + pdfString.toUnicodeString();
            }
            pdfDictionary2.merge(pdfDictionary3);
            pdfDictionary2.remove(PdfName.T);
            this.kidNode(pdfDictionary2, string2);
        }
    }

    protected void readFields() {
        this.catalog = this.trailer.getAsDict(PdfName.ROOT);
        PdfDictionary pdfDictionary = this.catalog.getAsDict(PdfName.FDF);
        if (pdfDictionary == null) {
            return;
        }
        PdfObject pdfObject = pdfDictionary.getAsString(PdfName.F);
        if (pdfObject != null) {
            this.d = pdfObject.toUnicodeString();
        }
        if ((pdfObject = pdfDictionary.getAsArray(PdfName.FIELDS)) == null) {
            return;
        }
        this.e = pdfDictionary.getAsName(PdfName.ENCODING);
        pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.KIDS, pdfObject);
        this.kidNode(pdfDictionary, "");
    }

    @Deprecated
    public HashMap<String, PdfDictionary> getFields() {
        return (HashMap)this.c;
    }

    public Map<String, PdfDictionary> getAllFields() {
        return this.c;
    }

    public PdfDictionary getField(String string) {
        return this.c.get(string);
    }

    public String getFieldValue(String object) {
        if ((object = this.c.get(object)) == null) {
            return null;
        }
        if ((object = FdfReader.getPdfObject(((PdfDictionary)object).get(PdfName.V))) == null) {
            return null;
        }
        if (((PdfObject)object).isName()) {
            return PdfName.decodeName(((PdfObject)object).toString());
        }
        if (((PdfObject)object).isString()) {
            object = (PdfString)object;
            if (this.e == null || ((PdfString)object).getEncoding() != null) {
                return ((PdfString)object).toUnicodeString();
            }
            byte[] byArray = ((PdfObject)object).getBytes();
            if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
                return ((PdfString)object).toUnicodeString();
            }
            try {
                if (this.e.equals(PdfName.SHIFT_JIS)) {
                    return new String(byArray, "SJIS");
                }
                if (this.e.equals(PdfName.UHC)) {
                    return new String(byArray, "MS949");
                }
                if (this.e.equals(PdfName.GBK)) {
                    return new String(byArray, "GBK");
                }
                if (this.e.equals(PdfName.BIGFIVE)) {
                    return new String(byArray, "Big5");
                }
            }
            catch (Exception exception) {}
            return ((PdfString)object).toUnicodeString();
        }
        return null;
    }

    public String getFileSpec() {
        return this.d;
    }
}

