/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Phrase;
import com.lowagie.text.Utilities;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.ArrayList;

public class FontSelector {
    protected ArrayList<Font> fonts = new ArrayList();

    public FontSelector() {
        FontFactory.register("font-fallback/LiberationSans-Regular.ttf", "sans");
        Font font = FontFactory.getFont("sans", "Identity-H");
        this.fonts.add(font);
    }

    public void setDefaultColor(Color color) {
        this.fonts.get(this.fonts.size() - 1).setColor(color);
    }

    public void setDefaultSize(float f2) {
        this.fonts.get(this.fonts.size() - 1).setSize(f2);
    }

    public void addFont(Font font) {
        if (font.getBaseFont() != null) {
            this.fonts.add(this.fonts.size() - 1, font);
            return;
        }
        BaseFont baseFont = font.getCalculatedBaseFont(true);
        font = new Font(baseFont, font.getSize(), font.getCalculatedStyle(), font.getColor());
        this.fonts.add(this.fonts.size() - 1, font);
    }

    public Phrase process(String object) {
        int n2 = this.fonts.size();
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n3 = cArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = -1;
        Phrase phrase = new Phrase();
        block0: for (int i2 = 0; i2 < n3; ++i2) {
            Object object2;
            int n5;
            Object object3 = object[i2];
            if (object3 == 10 || object3 == 13) {
                stringBuilder.append((char)object3);
                continue;
            }
            if (Utilities.isSurrogatePair((char[])object, i2)) {
                n5 = Utilities.convertToUtf32((char[])object, i2);
                for (int i3 = 0; i3 < n2; ++i3) {
                    object2 = this.fonts.get(i3);
                    if (!((Font)object2).getBaseFont().charExists(n5)) continue;
                    if (n4 != i3) {
                        if (stringBuilder.length() > 0 && n4 != -1) {
                            object2 = new Chunk(stringBuilder.toString(), this.fonts.get(n4));
                            phrase.add((Element)object2);
                            stringBuilder.setLength(0);
                        }
                        n4 = i3;
                    }
                    stringBuilder.append((char)object3);
                    if (((Object)object).length <= i2 + 1) continue block0;
                    stringBuilder.append((char)object[++i2]);
                    continue block0;
                }
                continue;
            }
            for (n5 = 0; n5 < n2; ++n5) {
                object2 = this.fonts.get(n5);
                if (!((Font)object2).getBaseFont().charExists((int)object3)) continue;
                if (n4 != n5) {
                    if (stringBuilder.length() > 0 && n4 != -1) {
                        Chunk chunk = new Chunk(stringBuilder.toString(), this.fonts.get(n4));
                        phrase.add(chunk);
                        stringBuilder.setLength(0);
                    }
                    n4 = n5;
                }
                stringBuilder.append((char)object3);
                continue block0;
            }
        }
        if (stringBuilder.length() > 0) {
            Chunk chunk = n4 == -1 ? new Chunk(stringBuilder.toString()) : new Chunk(stringBuilder.toString(), this.fonts.get(n4));
            phrase.add(chunk);
        }
        return phrase;
    }
}

