/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntHashtable
implements Cloneable {
    private transient a[] a;
    private transient int b;
    private int c;
    private float d;

    public IntHashtable() {
        this(150, 0.75f);
    }

    public IntHashtable(int n2) {
        this(n2, 0.75f);
    }

    public IntHashtable(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("illegal.capacity.1", n2));
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("illegal.load.1", String.valueOf(f2)));
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this.d = f2;
        this.a = new a[n2];
        this.c = (int)((float)n2 * f2);
    }

    public int size() {
        return this.b;
    }

    public boolean isEmpty() {
        return this.b == 0;
    }

    public boolean contains(int n2) {
        a[] aArray = this.a;
        int n3 = this.a.length;
        while (n3-- > 0) {
            a a2 = aArray[n3];
            while (a2 != null) {
                if (a2.c == n2) {
                    return true;
                }
                a2 = a2.d;
            }
        }
        return false;
    }

    public boolean containsValue(int n2) {
        return this.contains(n2);
    }

    public boolean containsKey(int n2) {
        Object object = this.a;
        int n3 = (n2 & Integer.MAX_VALUE) % ((a[])object).length;
        object = object[n3];
        while (object != null) {
            if (object.a == n2 && object.b == n2) {
                return true;
            }
            object = object.d;
        }
        return false;
    }

    public int get(int n2) {
        Object object = this.a;
        int n3 = (n2 & Integer.MAX_VALUE) % ((a[])object).length;
        object = object[n3];
        while (object != null) {
            if (object.a == n2 && object.b == n2) {
                return object.c;
            }
            object = object.d;
        }
        return 0;
    }

    protected void rehash() {
        int n2 = this.a.length;
        a[] aArray = this.a;
        int n3 = (n2 << 1) + 1;
        a[] aArray2 = new a[n3];
        this.c = (int)((float)n3 * this.d);
        this.a = aArray2;
        while (n2-- > 0) {
            a a2 = aArray[n2];
            while (a2 != null) {
                a a3 = a2;
                a2 = a2.d;
                int n4 = (a3.a & Integer.MAX_VALUE) % n3;
                a3.d = aArray2[n4];
                aArray2[n4] = a3;
            }
        }
    }

    public int put(int n2, int n3) {
        a[] aArray = this.a;
        int n4 = (n2 & Integer.MAX_VALUE) % aArray.length;
        a a2 = aArray[n4];
        while (a2 != null) {
            if (a2.a == n2 && a2.b == n2) {
                n2 = a2.c;
                a2.c = n3;
                return n2;
            }
            a2 = a2.d;
        }
        if (this.b >= this.c) {
            this.rehash();
            aArray = this.a;
            n4 = (n2 & Integer.MAX_VALUE) % aArray.length;
        }
        int n5 = n2;
        aArray[n4] = a2 = new a(n5, n5, n3, aArray[n4]);
        ++this.b;
        return 0;
    }

    public int remove(int n2) {
        a[] aArray = this.a;
        int n3 = (n2 & Integer.MAX_VALUE) % aArray.length;
        a a2 = aArray[n3];
        a a3 = null;
        while (a2 != null) {
            if (a2.a == n2 && a2.b == n2) {
                if (a3 != null) {
                    a3.d = a2.d;
                } else {
                    aArray[n3] = a2.d;
                }
                --this.b;
                n2 = a2.c;
                a2.c = 0;
                return n2;
            }
            a3 = a2;
            a2 = a2.d;
        }
        return 0;
    }

    public void clear() {
        a[] aArray = this.a;
        int n2 = this.a.length;
        while (--n2 >= 0) {
            aArray[n2] = null;
        }
        this.b = 0;
    }

    public Iterator getEntryIterator() {
        return new b(this.a);
    }

    public int[] toOrderedKeys() {
        int[] nArray = this.getKeys();
        Arrays.sort(nArray);
        return nArray;
    }

    public int[] getKeys() {
        int[] nArray = new int[this.b];
        int n2 = 0;
        int n3 = this.a.length;
        a a2 = null;
        while (true) {
            if (a2 == null) {
                while (n3-- > 0 && (a2 = this.a[n3]) == null) {
                }
            }
            if (a2 == null) break;
            a a3 = a2;
            a2 = a3.d;
            nArray[n2++] = a3.b;
        }
        return nArray;
    }

    public int getOneKey() {
        if (this.b == 0) {
            return 0;
        }
        int n2 = this.a.length;
        a a2 = null;
        while (n2-- > 0 && (a2 = this.a[n2]) == null) {
        }
        if (a2 == null) {
            return 0;
        }
        return a2.b;
    }

    public Object clone() {
        try {
            IntHashtable intHashtable = (IntHashtable)super.clone();
            ((IntHashtable)super.clone()).a = new a[this.a.length];
            int n2 = this.a.length;
            while (n2-- > 0) {
                intHashtable.a[n2] = this.a[n2] != null ? (a)this.a[n2].clone() : null;
            }
            return intHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    static final class b
    implements Iterator {
        private int a;
        private a[] b;
        private a c;

        b(a[] aArray) {
            this.b = aArray;
            this.a = aArray.length;
        }

        @Override
        public final boolean hasNext() {
            if (this.c != null) {
                return true;
            }
            while (this.a-- > 0) {
                this.c = this.b[this.a];
                if (this.c == null) continue;
                return true;
            }
            return false;
        }

        public final Object next() {
            if (this.c == null) {
                while (this.a-- > 0 && (this.c = this.b[this.a]) == null) {
                }
            }
            if (this.c != null) {
                a a2 = this.c;
                this.c = a2.d;
                return a2;
            }
            throw new NoSuchElementException(MessageLocalization.getComposedMessage("inthashtableiterator"));
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("remove.not.supported"));
        }
    }

    static final class a {
        int a;
        int b;
        int c;
        a d;

        protected a(int n2, int n3, int n4, a a2) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
            this.d = a2;
        }

        protected final Object clone() {
            a a2 = new a(this.a, this.b, this.c, this.d != null ? (a)this.d.clone() : null);
            return a2;
        }
    }
}

