/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.error_messages.MessageLocalization;
import java.io.IOException;
import java.io.OutputStream;

public class LZWDecoder {
    private byte[][] a;
    private byte[] b = null;
    private OutputStream c;
    private int d;
    private int e = 9;
    private int f;
    private int g;
    private int h = 0;
    private int i = 0;
    private int[] j = new int[]{511, 1023, 2047, 4095};

    public void decode(byte[] byArray, OutputStream outputStream) {
        int n2;
        if (byArray[0] == 0 && byArray[1] == 1) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("lzw.flavour.not.supported"));
        }
        this.initializeStringTable();
        this.b = byArray;
        this.c = outputStream;
        this.f = 0;
        this.g = 0;
        this.h = 0;
        this.i = 0;
        int n3 = 0;
        while ((n2 = this.getNextCode()) != 257) {
            byte[] byArray2;
            if (n2 == 256) {
                this.initializeStringTable();
                n2 = this.getNextCode();
                if (n2 == 257) break;
                LZWDecoder lZWDecoder = this;
                lZWDecoder.writeString(lZWDecoder.a[n2]);
                n3 = n2;
                continue;
            }
            if (n2 < this.d) {
                byArray2 = this.a[n2];
                this.writeString(byArray2);
                LZWDecoder lZWDecoder = this;
                lZWDecoder.addStringToTable(lZWDecoder.a[n3], byArray2[0]);
                n3 = n2;
                continue;
            }
            byArray2 = this.a[n3];
            byArray2 = this.composeString(byArray2, byArray2[0]);
            this.writeString(byArray2);
            this.addStringToTable(byArray2);
            n3 = n2;
        }
    }

    public void initializeStringTable() {
        this.a = new byte[8192][];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.a[i2] = new byte[1];
            this.a[i2][0] = (byte)i2;
        }
        this.d = 258;
        this.e = 9;
    }

    public void writeString(byte[] byArray) {
        try {
            this.c.write(byArray);
            return;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public void addStringToTable(byte[] byArray, byte by) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = by;
        this.a[this.d++] = byArray2;
        if (this.d == 511) {
            this.e = 10;
            return;
        }
        if (this.d == 1023) {
            this.e = 11;
            return;
        }
        if (this.d == 2047) {
            this.e = 12;
        }
    }

    public void addStringToTable(byte[] byArray) {
        this.a[this.d++] = byArray;
        if (this.d == 511) {
            this.e = 10;
            return;
        }
        if (this.d == 1023) {
            this.e = 11;
            return;
        }
        if (this.d == 2047) {
            this.e = 12;
        }
    }

    public byte[] composeString(byte[] byArray, byte by) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = by;
        return byArray2;
    }

    public int getNextCode() {
        try {
            this.h = this.h << 8 | this.b[this.f++] & 0xFF;
            this.i += 8;
            if (this.i < this.e) {
                this.h = this.h << 8 | this.b[this.f++] & 0xFF;
                this.i += 8;
            }
            int n2 = this.h >> this.i - this.e & this.j[this.e - 9];
            this.i -= this.e;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 257;
        }
    }
}

