/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.FontFactory;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.AttributedString;
import java.text.Bidi;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LayoutProcessor {
    private static final Map<BaseFont, Font> a = new ConcurrentHashMap<BaseFont, Font>();
    private static boolean b = false;
    private static int c = -1;

    private LayoutProcessor() {
        throw new UnsupportedOperationException("static class");
    }

    public static void enable() {
        b = true;
    }

    public static void enable(int n2) {
        if (b) {
            throw new UnsupportedOperationException("LayoutProcessor is already enabled");
        }
        b = true;
        c = n2;
    }

    public static boolean isEnabled() {
        return b;
    }

    public static int getFlags() {
        return c;
    }

    public static boolean isSet(int n2) {
        return (c & n2) == n2;
    }

    public static boolean supportsFont(BaseFont baseFont) {
        boolean bl2 = b && a.get(baseFont) != null;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadFont(BaseFont baseFont, String string) {
        if (!b) {
            return;
        }
        InputStream inputStream = null;
        try {
            Serializable serializable = a.get(baseFont);
            if (serializable == null) {
                serializable = new File(string);
                if (!((File)serializable).exists() && FontFactory.isRegistered(string)) {
                    string = (String)FontFactory.getFontImp().getFontPath(string);
                    serializable = new File(string);
                }
                if ((inputStream = ((File)serializable).canRead() ? new FileInputStream((File)serializable) : (string.startsWith("file:/") || string.startsWith("http://") || string.startsWith("https://") || string.startsWith("jar:") || string.startsWith("wsjar:") ? new URL(string).openStream() : ("-".equals(string) ? System.in : BaseFont.getResourceStream(string)))) == null) {
                    throw new IOException(MessageLocalization.getComposedMessage("1.not.found.as.file.or.resource", string));
                }
                serializable = Font.createFont(0, inputStream);
                if (serializable != null) {
                    a.put(baseFont, (Font)serializable);
                }
            }
            if (inputStream == null) return;
        }
        catch (Exception exception) {
            try {
                throw new RuntimeException(String.format("Font creation failed for %s.", string), exception);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static GlyphVector computeGlyphVector(BaseFont baseFont, float f2, String object) {
        char[] cArray = ((String)object).toCharArray();
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, true);
        int n2 = c;
        if (n2 == -1) {
            object = new AttributedString((String)object);
            n2 = ((Bidi)(object = new Bidi(((AttributedString)object).getIterator()))).isLeftToRight() ? 0 : 1;
        }
        object = a.get(baseFont).deriveFont(f2);
        object = ((Font)object).layoutGlyphVector(fontRenderContext, cArray, 0, cArray.length, n2);
        return object;
    }

    public static Point2D showText(PdfContentByte pdfContentByte, BaseFont object, float f2, String string) {
        object = LayoutProcessor.computeGlyphVector((BaseFont)object, f2, string);
        Cloneable cloneable = object;
        boolean bl2 = false;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i2 = 0; i2 < ((GlyphVector)cloneable).getNumGlyphs(); ++i2) {
            float f5;
            Point2D point2D = ((GlyphVector)cloneable).getGlyphPosition(i2);
            f3 = (float)point2D.getX() - f3;
            f4 = (float)point2D.getY() - f4;
            float f6 = i2 == 0 ? 0.0f : ((GlyphVector)cloneable).getGlyphMetrics(i2 - 1).getAdvanceX();
            float f7 = f5 = i2 == 0 ? 0.0f : ((GlyphVector)cloneable).getGlyphMetrics(i2 - 1).getAdvanceY();
            if (f3 != f6 || f4 != f5) {
                bl2 = true;
                break;
            }
            f3 = (float)point2D.getX();
            f4 = (float)point2D.getY();
        }
        if (!bl2) {
            pdfContentByte.showText((GlyphVector)object);
            Object object2 = object;
            cloneable = ((GlyphVector)object2).getGlyphPosition(((GlyphVector)object2).getNumGlyphs());
            float f8 = (float)((Point2D)cloneable).getX();
            f3 = (float)((Point2D)cloneable).getY();
            pdfContentByte.a(f8, -f3);
            return new Point2D.Double(-f8, f3);
        }
        float f9 = 0.0f;
        float f10 = 0.0f;
        int n2 = 0;
        while (n2 < ((GlyphVector)object).getNumGlyphs()) {
            Point2D point2D = ((GlyphVector)object).getGlyphPosition(n2);
            f9 = (float)point2D.getX() - f9;
            f10 = (float)point2D.getY() - f10;
            pdfContentByte.a(f9, -f10);
            int n3 = n2++;
            pdfContentByte.showText((GlyphVector)object, n3, n3 + 1);
            f9 = (float)point2D.getX();
            f10 = (float)point2D.getY();
        }
        Object object3 = object;
        Point2D point2D = ((GlyphVector)object3).getGlyphPosition(((GlyphVector)object3).getNumGlyphs());
        f4 = (float)point2D.getX() - f9;
        f9 = (float)point2D.getY() - f10;
        pdfContentByte.a(f4, -f9);
        return new Point2D.Double(-point2D.getX(), point2D.getY());
    }
}

