/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.OcspClient;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Random;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class OcspClientBouncyCastle
implements OcspClient {
    private final X509Certificate a;
    private final X509Certificate b;
    private final String c;
    private Proxy d;

    public OcspClientBouncyCastle(X509Certificate x509Certificate, X509Certificate x509Certificate2, String string) {
        this.b = x509Certificate;
        this.a = x509Certificate2;
        this.c = string;
    }

    @Override
    public byte[] getEncoded() {
        try {
            SingleResp singleResp = this.b.getSerialNumber();
            Object object = this.a;
            Object object2 = new BouncyCastleProvider();
            Security.addProvider((Provider)object2);
            object2 = new JcaDigestCalculatorProviderBuilder().setProvider((Provider)object2).build();
            object = new CertificateID(object2.get(CertificateID.HASH_SHA1), (X509CertificateHolder)new JcaX509CertificateHolder((X509Certificate)object), (BigInteger)singleResp);
            singleResp = new OCSPReqBuilder();
            singleResp.addRequest((CertificateID)object);
            object = new ExtensionsGenerator();
            object2 = new byte[16];
            Random random = new Random();
            random.nextBytes((byte[])object2);
            object.addExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1Encodable)new DEROctetString((byte[])object2));
            singleResp.setRequestExtensions(object.generate());
            object = singleResp.build();
            object = object.getEncoded();
            singleResp = new URL(this.c);
            object2 = this.d == null ? Proxy.NO_PROXY : this.d;
            singleResp = (HttpURLConnection)singleResp.openConnection((Proxy)object2);
            singleResp.setRequestProperty("Content-Type", "application/ocsp-request");
            singleResp.setRequestProperty("Accept", "application/ocsp-response");
            singleResp.setDoOutput(true);
            object2 = singleResp.getOutputStream();
            object2 = new DataOutputStream(new BufferedOutputStream((OutputStream)object2));
            ((FilterOutputStream)object2).write((byte[])object);
            ((DataOutputStream)object2).flush();
            ((FilterOutputStream)object2).close();
            if (singleResp.getResponseCode() / 100 != 2) {
                throw new IOException(MessageLocalization.getComposedMessage("invalid.http.response.1", singleResp.getResponseCode()));
            }
            object = (InputStream)singleResp.getContent();
            if ((object = new OCSPResp((InputStream)object)).getStatus() != 0) {
                throw new IOException(MessageLocalization.getComposedMessage("invalid.status.1", object.getStatus()));
            }
            if ((object = (BasicOCSPResp)object.getResponseObject()) != null && ((SingleResp[])(singleResp = object.getResponses())).length == 1) {
                singleResp = singleResp[0];
                if ((singleResp = singleResp.getCertStatus()) == null) {
                    return object.getEncoded();
                }
                if (singleResp instanceof RevokedStatus) {
                    throw new IOException(MessageLocalization.getComposedMessage("ocsp.status.is.revoked"));
                }
                throw new IOException(MessageLocalization.getComposedMessage("ocsp.status.is.unknown"));
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return null;
    }

    public void setProxy(Proxy proxy) {
        this.d = proxy;
    }

    public Proxy getProxy() {
        return this.d;
    }
}

