/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.crypto.AESCipher;
import com.lowagie.text.pdf.crypto.ARCFOUREncryption;
import com.lowagie.text.pdf.crypto.IVGenerator;
import java.io.OutputStream;

public class OutputStreamEncryption
extends OutputStream {
    protected OutputStream out;
    protected ARCFOUREncryption arcfour;
    protected AESCipher cipher;
    private byte[] a = new byte[1];
    private boolean b;
    private boolean c;

    public OutputStreamEncryption(OutputStream object, byte[] byArray, int n2, int n3, int n4) {
        try {
            this.out = object;
            boolean bl2 = this.b = n4 == 4;
            if (!this.b) {
                this.arcfour = new ARCFOUREncryption();
                this.arcfour.prepareARCFOURKey(byArray, n2, n3);
                return;
            }
            object = IVGenerator.getIV();
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            this.cipher = new AESCipher(true, byArray2, (byte[])object);
            this.write((byte[])object);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public OutputStreamEncryption(OutputStream outputStream, byte[] byArray, int n2) {
        this(outputStream, byArray, 0, byArray.length, n2);
    }

    @Override
    public void close() {
        this.finish();
        this.out.close();
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n2) {
        this.a[0] = (byte)n2;
        OutputStreamEncryption outputStreamEncryption = this;
        outputStreamEncryption.write(outputStreamEncryption.a, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (this.b) {
            byte[] byArray2 = this.cipher.update(byArray, n2, n3);
            if (byArray2 == null || byArray2.length == 0) {
                return;
            }
            this.out.write(byArray2, 0, byArray2.length);
            return;
        }
        byte[] byArray3 = new byte[Math.min(n3, 4192)];
        while (n3 > 0) {
            int n4 = Math.min(n3, byArray3.length);
            this.arcfour.encryptARCFOUR(byArray, n2, n4, byArray3, 0);
            this.out.write(byArray3, 0, n4);
            n3 -= n4;
            n2 += n4;
        }
    }

    public void finish() {
        if (!this.c) {
            this.c = true;
            if (this.b) {
                byte[] byArray;
                try {
                    byArray = this.cipher.doFinal();
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                this.out.write(byArray, 0, byArray.length);
            }
        }
    }
}

