/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PRStream
extends PdfStream {
    protected PdfReader reader;
    protected int offset;
    protected int length;
    protected int objNum = 0;
    protected int objGen = 0;

    public PRStream(PRStream pRStream, PdfDictionary pdfDictionary) {
        this.reader = pRStream.reader;
        this.offset = pRStream.offset;
        this.length = pRStream.length;
        this.compressed = pRStream.compressed;
        this.compressionLevel = pRStream.compressionLevel;
        this.streamBytes = pRStream.streamBytes;
        this.bytes = pRStream.bytes;
        this.objNum = pRStream.objNum;
        this.objGen = pRStream.objGen;
        if (pdfDictionary != null) {
            this.putAll(pdfDictionary);
            return;
        }
        this.hashMap.putAll(pRStream.hashMap);
    }

    public PRStream(PRStream pRStream, PdfDictionary pdfDictionary, PdfReader pdfReader) {
        this(pRStream, pdfDictionary);
        this.reader = pdfReader;
    }

    public PRStream(PdfReader pdfReader, int n2) {
        this.reader = pdfReader;
        this.offset = n2;
    }

    public PRStream(PdfReader pdfReader, byte[] byArray) {
        this(pdfReader, byArray, -1);
    }

    public PRStream(PdfReader closeable, byte[] byArray, int n2) {
        this.reader = closeable;
        this.offset = -1;
        if (Document.compress) {
            try {
                closeable = new ByteArrayOutputStream();
                Deflater deflater = new Deflater(n2);
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)closeable, deflater);
                deflaterOutputStream.write(byArray);
                deflaterOutputStream.close();
                deflater.end();
                this.bytes = ((ByteArrayOutputStream)closeable).toByteArray();
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        } else {
            this.bytes = byArray;
        }
        PRStream pRStream = this;
        pRStream.setLength(pRStream.bytes.length);
    }

    public void setData(byte[] byArray, boolean bl2) {
        this.setData(byArray, bl2, -1);
    }

    public void setData(byte[] byArray, boolean bl2, int n2) {
        this.remove(PdfName.FILTER);
        this.offset = -1;
        if (Document.compress && bl2) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Deflater deflater = new Deflater(n2);
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
                deflaterOutputStream.write(byArray);
                deflaterOutputStream.close();
                deflater.end();
                this.bytes = byteArrayOutputStream.toByteArray();
                this.compressionLevel = n2;
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        } else {
            this.bytes = byArray;
        }
        PRStream pRStream = this;
        pRStream.setLength(pRStream.bytes.length);
    }

    public void setData(byte[] byArray) {
        this.setData(byArray, true);
    }

    public void setLength(int n2) {
        this.length = n2;
        this.put(PdfName.LENGTH, new PdfNumber(n2));
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public PdfReader getReader() {
        return this.reader;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    public void setObjNum(int n2, int n3) {
        this.objNum = n2;
        this.objGen = n3;
    }

    final int a() {
        return this.objNum;
    }

    final int b() {
        return this.objGen;
    }

    @Override
    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) {
        byte[] byArray = PdfReader.getStreamBytesRaw(this);
        PdfEncryption pdfEncryption = null;
        if (pdfWriter != null) {
            pdfEncryption = pdfWriter.o();
        }
        PdfObject pdfObject = this.get(PdfName.LENGTH);
        int n2 = byArray.length;
        if (pdfEncryption != null) {
            n2 = pdfEncryption.calculateStreamSize(n2);
        }
        this.put(PdfName.LENGTH, new PdfNumber(n2));
        this.superToPdf(pdfWriter, outputStream);
        this.put(PdfName.LENGTH, pdfObject);
        outputStream.write(g);
        if (this.length > 0) {
            if (pdfEncryption != null && !pdfEncryption.isEmbeddedFilesOnly()) {
                byArray = pdfEncryption.encryptByteArray(byArray);
            }
            outputStream.write(byArray);
        }
        outputStream.write(h);
    }
}

