/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class PdfAcroForm
extends PdfDictionary {
    private PdfWriter a;
    private Map<PdfTemplate, Object> b = new HashMap<PdfTemplate, Object>();
    private PdfArray c = new PdfArray();
    private PdfArray d = new PdfArray();
    private int e = 0;

    public PdfAcroForm(PdfWriter pdfWriter) {
        this.a = pdfWriter;
    }

    public void setNeedAppearances(boolean bl2) {
        this.put(PdfName.NEEDAPPEARANCES, new PdfBoolean(bl2));
    }

    @Deprecated
    public void addFieldTemplates(HashMap hashMap) {
        this.b.putAll(hashMap);
    }

    public void addFieldTemplates(Map<PdfTemplate, Object> map) {
        this.b.putAll(map);
    }

    public void addDocumentField(PdfIndirectReference pdfIndirectReference) {
        this.c.add(pdfIndirectReference);
    }

    public boolean isValid() {
        if (this.c.size() == 0) {
            return false;
        }
        this.put(PdfName.FIELDS, this.c);
        if (this.e != 0) {
            this.put(PdfName.SIGFLAGS, new PdfNumber(this.e));
        }
        if (this.d.size() > 0) {
            this.put(PdfName.CO, this.d);
        }
        if (this.b.isEmpty()) {
            return true;
        }
        PdfDictionary pdfDictionary = new PdfDictionary();
        for (PdfTemplate pdfTemplate : this.b.keySet()) {
            PdfFormField.a(pdfDictionary, (PdfDictionary)pdfTemplate.c());
        }
        this.put(PdfName.DR, pdfDictionary);
        this.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
        PdfDictionary pdfDictionary2 = (PdfDictionary)pdfDictionary.get(PdfName.FONT);
        if (pdfDictionary2 != null) {
            this.a.a(pdfDictionary2);
        }
        return true;
    }

    public void addCalculationOrder(PdfFormField pdfFormField) {
        this.d.add(pdfFormField.getIndirectReference());
    }

    public void setSigFlags(int n2) {
        this.e |= n2;
    }

    public void addFormField(PdfFormField pdfFormField) {
        this.a.addAnnotation(pdfFormField);
    }

    public PdfFormField addHtmlPostButton(String string, String string2, String string3, String object, BaseFont baseFont, float f2, float f3, float f4, float f5, float f6) {
        object = PdfAction.createSubmitForm((String)object, null, 4);
        object = new PdfFormField(this.a, f3, f4, f5, f6, (PdfAction)object);
        this.setButtonParams((PdfFormField)object, 65536, string, string3);
        this.drawButton((PdfFormField)object, string2, baseFont, f2, f3, f4, f5, f6);
        this.addFormField((PdfFormField)object);
        return object;
    }

    public PdfFormField addResetButton(String string, String string2, String string3, BaseFont baseFont, float f2, float f3, float f4, float f5, float f6) {
        PdfDictionary pdfDictionary = PdfAction.createResetForm(null, 0);
        pdfDictionary = new PdfFormField(this.a, f3, f4, f5, f6, (PdfAction)pdfDictionary);
        this.setButtonParams((PdfFormField)pdfDictionary, 65536, string, string3);
        this.drawButton((PdfFormField)pdfDictionary, string2, baseFont, f2, f3, f4, f5, f6);
        this.addFormField((PdfFormField)pdfDictionary);
        return pdfDictionary;
    }

    public PdfFormField addMap(String object, String object2, String string, PdfContentByte pdfContentByte, float f2, float f3, float f4, float f5) {
        object2 = PdfAction.createSubmitForm(string, null, 20);
        object2 = new PdfFormField(this.a, f2, f3, f4, f5, (PdfAction)object2);
        this.setButtonParams((PdfFormField)object2, 65536, (String)object, null);
        object = PdfAppearance.createAppearance(this.a, f4 - f2, f5 - f3);
        ((PdfContentByte)object).add(pdfContentByte);
        ((PdfAnnotation)object2).setAppearance(PdfAnnotation.APPEARANCE_NORMAL, (PdfTemplate)object);
        this.addFormField((PdfFormField)object2);
        return object2;
    }

    public void setButtonParams(PdfFormField pdfFormField, int n2, String string, String string2) {
        pdfFormField.setButton(n2);
        pdfFormField.setFlags(4);
        pdfFormField.setPage();
        pdfFormField.setFieldName(string);
        if (string2 != null) {
            pdfFormField.setValueAsString(string2);
        }
    }

    public void drawButton(PdfFormField pdfFormField, String string, BaseFont baseFont, float f2, float f3, float f4, float f5, float f6) {
        PdfAppearance pdfAppearance = PdfAppearance.createAppearance(this.a, f5 - f3, f6 - f4);
        pdfAppearance.drawButton(0.0f, 0.0f, f5 - f3, f6 - f4, string, baseFont, f2);
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
    }

    public PdfFormField addHiddenField(String string, String string2) {
        PdfFormField pdfFormField = PdfFormField.createEmpty(this.a);
        pdfFormField.setFieldName(string);
        pdfFormField.setValueAsName(string2);
        this.addFormField(pdfFormField);
        return pdfFormField;
    }

    public PdfFormField addSingleLineTextField(String string, String string2, BaseFont baseFont, float f2, float f3, float f4, float f5, float f6) {
        PdfFormField pdfFormField = PdfFormField.createTextField(this.a, false, false, 0);
        this.setTextFieldParams(pdfFormField, string2, string, f3, f4, f5, f6);
        this.drawSingleLineOfText(pdfFormField, string2, baseFont, f2, f3, f4, f5, f6);
        this.addFormField(pdfFormField);
        return pdfFormField;
    }

    public PdfFormField addMultiLineTextField(String string, String string2, BaseFont baseFont, float f2, float f3, float f4, float f5, float f6) {
        PdfFormField pdfFormField = PdfFormField.createTextField(this.a, true, false, 0);
        this.setTextFieldParams(pdfFormField, string2, string, f3, f4, f5, f6);
        this.drawMultiLineOfText(pdfFormField, string2, baseFont, f2, f3, f4, f5, f6);
        this.addFormField(pdfFormField);
        return pdfFormField;
    }

    public PdfFormField addSingleLinePasswordField(String string, String string2, BaseFont baseFont, float f2, float f3, float f4, float f5, float f6) {
        PdfFormField pdfFormField = PdfFormField.createTextField(this.a, false, true, 0);
        this.setTextFieldParams(pdfFormField, string2, string, f3, f4, f5, f6);
        this.drawSingleLineOfText(pdfFormField, string2, baseFont, f2, f3, f4, f5, f6);
        this.addFormField(pdfFormField);
        return pdfFormField;
    }

    public void setTextFieldParams(PdfFormField pdfFormField, String string, String string2, float f2, float f3, float f4, float f5) {
        pdfFormField.setWidget(new Rectangle(f2, f3, f4, f5), PdfAnnotation.HIGHLIGHT_INVERT);
        pdfFormField.setValueAsString(string);
        pdfFormField.setDefaultValueAsString(string);
        pdfFormField.setFieldName(string2);
        pdfFormField.setFlags(4);
        pdfFormField.setPage();
    }

    public void drawSingleLineOfText(PdfFormField pdfFormField, String string, BaseFont baseFont, float f2, float f3, float f4, float f5, float f6) {
        PdfAppearance pdfAppearance = PdfAppearance.createAppearance(this.a, f5 - f3, f6 - f4);
        PdfAppearance pdfAppearance2 = (PdfAppearance)((PdfContentByte)pdfAppearance).getDuplicate();
        ((PdfContentByte)pdfAppearance2).setFontAndSize(baseFont, f2);
        pdfAppearance2.resetRGBColorFill();
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        pdfAppearance.drawTextField(0.0f, 0.0f, f5 - f3, f6 - f4);
        pdfAppearance.beginVariableText();
        pdfAppearance.saveState();
        pdfAppearance.rectangle(3.0f, 3.0f, f5 - f3 - 6.0f, f6 - f4 - 6.0f);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        pdfAppearance.beginText();
        ((PdfContentByte)pdfAppearance).setFontAndSize(baseFont, f2);
        pdfAppearance.resetRGBColorFill();
        pdfAppearance.setTextMatrix(4.0f, (f6 - f4) / 2.0f - f2 * 0.3f);
        pdfAppearance.showText(string);
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
    }

    public void drawMultiLineOfText(PdfFormField pdfFormField, String object, BaseFont baseFont, float f2, float f3, float f4, float f5, float f6) {
        PdfAppearance pdfAppearance = PdfAppearance.createAppearance(this.a, f5 - f3, f6 - f4);
        PdfAppearance pdfAppearance2 = (PdfAppearance)((PdfContentByte)pdfAppearance).getDuplicate();
        ((PdfContentByte)pdfAppearance2).setFontAndSize(baseFont, f2);
        pdfAppearance2.resetRGBColorFill();
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        pdfAppearance.drawTextField(0.0f, 0.0f, f5 - f3, f6 - f4);
        pdfAppearance.beginVariableText();
        pdfAppearance.saveState();
        pdfAppearance.rectangle(3.0f, 3.0f, f5 - f3 - 6.0f, f6 - f4 - 6.0f);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        pdfAppearance.beginText();
        ((PdfContentByte)pdfAppearance).setFontAndSize(baseFont, f2);
        pdfAppearance.resetRGBColorFill();
        pdfAppearance.setTextMatrix(4.0f, 5.0f);
        object = new StringTokenizer((String)object, "\n");
        float f7 = f6 - f4;
        while (((StringTokenizer)object).hasMoreTokens()) {
            pdfAppearance.showTextAligned(0, ((StringTokenizer)object).nextToken(), 3.0f, f7 -= f2 * 1.2f, 0.0f);
        }
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
    }

    public PdfFormField addCheckBox(String string, String string2, boolean bl2, float f2, float f3, float f4, float f5) {
        PdfFormField pdfFormField = PdfFormField.createCheckBox(this.a);
        this.setCheckBoxParams(pdfFormField, string, string2, bl2, f2, f3, f4, f5);
        this.drawCheckBoxAppearences(pdfFormField, string2, f2, f3, f4, f5);
        this.addFormField(pdfFormField);
        return pdfFormField;
    }

    public void setCheckBoxParams(PdfFormField pdfFormField, String string, String string2, boolean bl2, float f2, float f3, float f4, float f5) {
        pdfFormField.setWidget(new Rectangle(f2, f3, f4, f5), PdfAnnotation.HIGHLIGHT_TOGGLE);
        pdfFormField.setFieldName(string);
        if (bl2) {
            pdfFormField.setValueAsName(string2);
            pdfFormField.setAppearanceState(string2);
        } else {
            pdfFormField.setValueAsName("Off");
            pdfFormField.setAppearanceState("Off");
        }
        pdfFormField.setFlags(4);
        pdfFormField.setPage();
        pdfFormField.setBorderStyle(new PdfBorderDictionary(1.0f, 0));
    }

    public void drawCheckBoxAppearences(PdfFormField pdfFormField, String object, float f2, float f3, float f4, float f5) {
        BaseFont baseFont;
        try {
            baseFont = BaseFont.createFont("ZapfDingbats", "Cp1252", false);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        f3 = f5 - f3;
        PdfAppearance pdfAppearance = PdfAppearance.createAppearance(this.a, f4 - f2, f3);
        PdfAppearance pdfAppearance2 = (PdfAppearance)((PdfContentByte)pdfAppearance).getDuplicate();
        ((PdfContentByte)pdfAppearance2).setFontAndSize(baseFont, f3);
        pdfAppearance2.resetRGBColorFill();
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        pdfAppearance.drawTextField(0.0f, 0.0f, f4 - f2, f3);
        pdfAppearance.saveState();
        pdfAppearance.resetRGBColorFill();
        pdfAppearance.beginText();
        ((PdfContentByte)pdfAppearance).setFontAndSize(baseFont, f3);
        pdfAppearance.showTextAligned(1, "4", (f4 - f2) / 2.0f, f3 / 2.0f - f3 * 0.3f, 0.0f);
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, (String)object, pdfAppearance);
        object = PdfAppearance.createAppearance(this.a, f4 - f2, f3);
        ((PdfContentByte)object).drawTextField(0.0f, 0.0f, f4 - f2, f3);
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "Off", (PdfTemplate)object);
    }

    public PdfFormField getRadioGroup(String string, String string2, boolean bl2) {
        PdfFormField pdfFormField = PdfFormField.createRadioButton(this.a, bl2);
        pdfFormField.setFieldName(string);
        pdfFormField.setValueAsName(string2);
        return pdfFormField;
    }

    public void addRadioGroup(PdfFormField pdfFormField) {
        this.addFormField(pdfFormField);
    }

    public PdfFormField addRadioButton(PdfFormField pdfFormField, String string, float f2, float f3, float f4, float f5) {
        PdfFormField pdfFormField2 = PdfFormField.createEmpty(this.a);
        pdfFormField2.setWidget(new Rectangle(f2, f3, f4, f5), PdfAnnotation.HIGHLIGHT_TOGGLE);
        String string2 = pdfFormField.get(PdfName.V).toString().substring(1);
        if (string2.equals(string)) {
            pdfFormField2.setAppearanceState(string);
        } else {
            pdfFormField2.setAppearanceState("Off");
        }
        this.drawRadioAppearences(pdfFormField2, string, f2, f3, f4, f5);
        pdfFormField.addKid(pdfFormField2);
        return pdfFormField2;
    }

    public void drawRadioAppearences(PdfFormField pdfFormField, String object, float f2, float f3, float f4, float f5) {
        PdfAppearance pdfAppearance = PdfAppearance.createAppearance(this.a, f4 - f2, f5 - f3);
        pdfAppearance.drawRadioField(0.0f, 0.0f, f4 - f2, f5 - f3, true);
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, (String)object, pdfAppearance);
        object = PdfAppearance.createAppearance(this.a, f4 - f2, f5 - f3);
        ((PdfContentByte)object).drawRadioField(0.0f, 0.0f, f4 - f2, f5 - f3, false);
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "Off", (PdfTemplate)object);
    }

    public PdfFormField addSelectList(String charSequence, String[] stringArray, String string, BaseFont baseFont, float f2, float f3, float f4, float f5, float f6) {
        PdfFormField pdfFormField = PdfFormField.createList(this.a, stringArray, 0);
        this.setChoiceParams(pdfFormField, (String)charSequence, string, f3, f4, f5, f6);
        charSequence = new StringBuilder();
        for (String string2 : stringArray) {
            ((StringBuilder)charSequence).append(string2).append('\n');
        }
        this.drawMultiLineOfText(pdfFormField, ((StringBuilder)charSequence).toString(), baseFont, f2, f3, f4, f5, f6);
        this.addFormField(pdfFormField);
        return pdfFormField;
    }

    public PdfFormField addSelectList(String charSequence, String[][] stringArray, String string, BaseFont baseFont, float f2, float f3, float f4, float f5, float f6) {
        PdfFormField pdfFormField = PdfFormField.createList(this.a, stringArray, 0);
        this.setChoiceParams(pdfFormField, (String)charSequence, string, f3, f4, f5, f6);
        charSequence = new StringBuilder();
        for (String[] stringArray2 : stringArray) {
            ((StringBuilder)charSequence).append(stringArray2[1]).append('\n');
        }
        this.drawMultiLineOfText(pdfFormField, ((StringBuilder)charSequence).toString(), baseFont, f2, f3, f4, f5, f6);
        this.addFormField(pdfFormField);
        return pdfFormField;
    }

    public PdfFormField addComboBox(String string, String[] stringArray, String string2, boolean bl2, BaseFont baseFont, float f2, float f3, float f4, float f5, float f6) {
        PdfFormField pdfFormField = PdfFormField.createCombo(this.a, bl2, stringArray, 0);
        this.setChoiceParams(pdfFormField, string, string2, f3, f4, f5, f6);
        if (string2 == null) {
            string2 = stringArray[0];
        }
        this.drawSingleLineOfText(pdfFormField, string2, baseFont, f2, f3, f4, f5, f6);
        this.addFormField(pdfFormField);
        return pdfFormField;
    }

    public PdfFormField addComboBox(String string, String[][] stringArray, String string2, boolean bl2, BaseFont baseFont, float f2, float f3, float f4, float f5, float f6) {
        PdfFormField pdfFormField = PdfFormField.createCombo(this.a, bl2, stringArray, 0);
        this.setChoiceParams(pdfFormField, string, string2, f3, f4, f5, f6);
        string = null;
        String[][] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String[] stringArray3 = stringArray2[i2];
            if (!stringArray3[0].equals(string2)) continue;
            string = stringArray3[1];
            break;
        }
        if (string == null) {
            string = stringArray[0][1];
        }
        this.drawSingleLineOfText(pdfFormField, string, baseFont, f2, f3, f4, f5, f6);
        this.addFormField(pdfFormField);
        return pdfFormField;
    }

    public void setChoiceParams(PdfFormField pdfFormField, String string, String string2, float f2, float f3, float f4, float f5) {
        pdfFormField.setWidget(new Rectangle(f2, f3, f4, f5), PdfAnnotation.HIGHLIGHT_INVERT);
        if (string2 != null) {
            pdfFormField.setValueAsString(string2);
            pdfFormField.setDefaultValueAsString(string2);
        }
        pdfFormField.setFieldName(string);
        pdfFormField.setFlags(4);
        pdfFormField.setPage();
        pdfFormField.setBorderStyle(new PdfBorderDictionary(2.0f, 0));
    }

    public PdfFormField addSignature(String string, float f2, float f3, float f4, float f5) {
        PdfFormField pdfFormField = PdfFormField.createSignature(this.a);
        this.setSignatureParams(pdfFormField, string, f2, f3, f4, f5);
        this.drawSignatureAppearences(pdfFormField, f2, f3, f4, f5);
        this.addFormField(pdfFormField);
        return pdfFormField;
    }

    public void setSignatureParams(PdfFormField pdfFormField, String string, float f2, float f3, float f4, float f5) {
        pdfFormField.setWidget(new Rectangle(f2, f3, f4, f5), PdfAnnotation.HIGHLIGHT_INVERT);
        pdfFormField.setFieldName(string);
        pdfFormField.setFlags(4);
        pdfFormField.setPage();
        pdfFormField.setMKBorderColor(Color.black);
        pdfFormField.setMKBackgroundColor(Color.white);
    }

    public void drawSignatureAppearences(PdfFormField pdfFormField, float f2, float f3, float f4, float f5) {
        PdfAppearance pdfAppearance = PdfAppearance.createAppearance(this.a, f4 - f2, f5 - f3);
        pdfAppearance.setGrayFill(1.0f);
        pdfAppearance.rectangle(0.0f, 0.0f, f4 - f2, f5 - f3);
        pdfAppearance.fill();
        pdfAppearance.setGrayStroke(0.0f);
        pdfAppearance.setLineWidth(1.0f);
        pdfAppearance.rectangle(0.5f, 0.5f, f4 - f2 - 0.5f, f5 - f3 - 0.5f);
        pdfAppearance.closePathStroke();
        pdfAppearance.saveState();
        pdfAppearance.rectangle(1.0f, 1.0f, f4 - f2 - 2.0f, f5 - f3 - 2.0f);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        pdfAppearance.restoreState();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
    }
}

