/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLayer;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRendition;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.collection.PdfTargetDictionary;
import java.net.URL;
import java.util.List;

public class PdfAction
extends PdfDictionary {
    public static final int FIRSTPAGE = 1;
    public static final int PREVPAGE = 2;
    public static final int NEXTPAGE = 3;
    public static final int LASTPAGE = 4;
    public static final int PRINTDIALOG = 5;
    public static final int SUBMIT_EXCLUDE = 1;
    public static final int SUBMIT_INCLUDE_NO_VALUE_FIELDS = 2;
    public static final int SUBMIT_HTML_FORMAT = 4;
    public static final int SUBMIT_HTML_GET = 8;
    public static final int SUBMIT_COORDINATES = 16;
    public static final int SUBMIT_XFDF = 32;
    public static final int SUBMIT_INCLUDE_APPEND_SAVES = 64;
    public static final int SUBMIT_INCLUDE_ANNOTATIONS = 128;
    public static final int SUBMIT_PDF = 256;
    public static final int SUBMIT_CANONICAL_FORMAT = 512;
    public static final int SUBMIT_EXCL_NON_USER_ANNOTS = 1024;
    public static final int SUBMIT_EXCL_F_KEY = 2048;
    public static final int SUBMIT_EMBED_FORM = 8196;
    public static final int RESET_EXCLUDE = 1;

    public PdfAction() {
    }

    public PdfAction(URL uRL) {
        this(uRL.toExternalForm());
    }

    public PdfAction(URL uRL, boolean bl2) {
        this(uRL.toExternalForm(), bl2);
    }

    public PdfAction(String string) {
        this(string, false);
    }

    public PdfAction(String string, boolean bl2) {
        this.put(PdfName.S, PdfName.URI);
        this.put(PdfName.URI, new PdfString(string));
        if (bl2) {
            this.put(PdfName.ISMAP, PdfBoolean.PDFTRUE);
        }
    }

    PdfAction(PdfIndirectReference pdfIndirectReference) {
        this.put(PdfName.S, PdfName.GOTO);
        this.put(PdfName.D, pdfIndirectReference);
    }

    public PdfAction(String string, String string2) {
        this.put(PdfName.S, PdfName.GOTOR);
        this.put(PdfName.F, new PdfString(string));
        this.put(PdfName.D, new PdfString(string2));
    }

    public PdfAction(String string, int n2) {
        this.put(PdfName.S, PdfName.GOTOR);
        this.put(PdfName.F, new PdfString(string));
        this.put(PdfName.D, new PdfLiteral("[" + (n2 - 1) + " /FitH 10000]"));
    }

    public PdfAction(int n2) {
        this.put(PdfName.S, PdfName.NAMED);
        switch (n2) {
            case 1: {
                this.put(PdfName.N, PdfName.FIRSTPAGE);
                return;
            }
            case 4: {
                this.put(PdfName.N, PdfName.LASTPAGE);
                return;
            }
            case 3: {
                this.put(PdfName.N, PdfName.NEXTPAGE);
                return;
            }
            case 2: {
                this.put(PdfName.N, PdfName.PREVPAGE);
                return;
            }
            case 5: {
                this.put(PdfName.S, PdfName.JAVASCRIPT);
                this.put(PdfName.JS, new PdfString("this.print(true);\r"));
                return;
            }
        }
        throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.named.action"));
    }

    public PdfAction(String string, String string2, String string3, String string4) {
        this.put(PdfName.S, PdfName.LAUNCH);
        if (string2 == null && string3 == null && string4 == null) {
            this.put(PdfName.F, new PdfString(string));
            return;
        }
        PdfDictionary pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.F, new PdfString(string));
        if (string2 != null) {
            pdfDictionary.put(PdfName.P, new PdfString(string2));
        }
        if (string3 != null) {
            pdfDictionary.put(PdfName.O, new PdfString(string3));
        }
        if (string4 != null) {
            pdfDictionary.put(PdfName.D, new PdfString(string4));
        }
        this.put(PdfName.WIN, pdfDictionary);
    }

    public static PdfAction createLaunch(String string, String string2, String string3, String string4) {
        return new PdfAction(string, string2, string3, string4);
    }

    public static PdfAction rendition(String string, PdfFileSpecification pdfFileSpecification, String string2, PdfIndirectReference pdfIndirectReference) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.RENDITION);
        pdfAction.put(PdfName.R, new PdfRendition(string, pdfFileSpecification, string2));
        pdfAction.put(new PdfName("OP"), new PdfNumber(0));
        pdfAction.put(new PdfName("AN"), pdfIndirectReference);
        return pdfAction;
    }

    public static PdfAction javaScript(String string, PdfWriter pdfWriter, boolean bl2) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.JAVASCRIPT);
        if (bl2 && string.length() < 50) {
            pdfAction.put(PdfName.JS, new PdfString(string, "UnicodeBig"));
        } else if (!bl2 && string.length() < 100) {
            pdfAction.put(PdfName.JS, new PdfString(string));
        } else {
            try {
                Object object = PdfEncodings.convertToBytes(string, bl2 ? "UnicodeBig" : "PDF");
                PdfStream pdfStream = new PdfStream((byte[])object);
                object = pdfStream;
                pdfStream.flateCompress(pdfWriter.getCompressionLevel());
                pdfAction.put(PdfName.JS, pdfWriter.addToBody((PdfObject)object).getIndirectReference());
            }
            catch (Exception exception) {
                pdfAction.put(PdfName.JS, new PdfString(string));
            }
        }
        return pdfAction;
    }

    public static PdfAction javaScript(String string, PdfWriter pdfWriter) {
        return PdfAction.javaScript(string, pdfWriter, false);
    }

    private static PdfAction a(PdfObject pdfObject, boolean bl2) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.HIDE);
        pdfAction.put(PdfName.T, pdfObject);
        if (!bl2) {
            pdfAction.put(PdfName.H, PdfBoolean.PDFFALSE);
        }
        return pdfAction;
    }

    public static PdfAction createHide(PdfAnnotation pdfAnnotation, boolean bl2) {
        return PdfAction.a(pdfAnnotation.getIndirectReference(), bl2);
    }

    public static PdfAction createHide(String string, boolean bl2) {
        return PdfAction.a(new PdfString(string), bl2);
    }

    private static PdfArray a(Object[] objectArray) {
        PdfArray pdfArray = new PdfArray();
        for (Object object : objectArray) {
            if (object instanceof String) {
                pdfArray.add(new PdfString((String)object));
                continue;
            }
            if (object instanceof PdfAnnotation) {
                pdfArray.add(((PdfAnnotation)object).getIndirectReference());
                continue;
            }
            throw new RuntimeException(MessageLocalization.getComposedMessage("the.array.must.contain.string.or.pdfannotation"));
        }
        return pdfArray;
    }

    public static PdfAction createHide(Object[] objectArray, boolean bl2) {
        return PdfAction.a(PdfAction.a(objectArray), bl2);
    }

    public static PdfAction createSubmitForm(String string, Object[] objectArray, int n2) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.SUBMITFORM);
        PdfDictionary pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.F, new PdfString(string));
        pdfDictionary.put(PdfName.FS, PdfName.URL);
        pdfAction.put(PdfName.F, pdfDictionary);
        if (objectArray != null) {
            pdfAction.put(PdfName.FIELDS, PdfAction.a(objectArray));
        }
        pdfAction.put(PdfName.FLAGS, new PdfNumber(n2));
        return pdfAction;
    }

    public static PdfAction createResetForm(Object[] objectArray, int n2) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.RESETFORM);
        if (objectArray != null) {
            pdfAction.put(PdfName.FIELDS, PdfAction.a(objectArray));
        }
        pdfAction.put(PdfName.FLAGS, new PdfNumber(n2));
        return pdfAction;
    }

    public static PdfAction createImportData(String string) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.IMPORTDATA);
        pdfAction.put(PdfName.F, new PdfString(string));
        return pdfAction;
    }

    public void next(PdfAction pdfAction) {
        PdfObject pdfObject = this.get(PdfName.NEXT);
        if (pdfObject == null) {
            this.put(PdfName.NEXT, pdfAction);
            return;
        }
        if (pdfObject.isDictionary()) {
            pdfObject = new PdfArray(pdfObject);
            ((PdfArray)pdfObject).add(pdfAction);
            this.put(PdfName.NEXT, pdfObject);
            return;
        }
        ((PdfArray)pdfObject).add(pdfAction);
    }

    public static PdfAction gotoLocalPage(int n2, PdfDestination pdfDestination, PdfWriter pdfWriter) {
        PdfObject pdfObject = pdfWriter.getPageReference(n2);
        pdfDestination.addPage((PdfIndirectReference)pdfObject);
        pdfObject = new PdfAction();
        ((PdfDictionary)pdfObject).put(PdfName.S, PdfName.GOTO);
        ((PdfDictionary)pdfObject).put(PdfName.D, pdfDestination);
        return pdfObject;
    }

    public static PdfAction gotoLocalPage(String string, boolean bl2) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.GOTO);
        if (bl2) {
            pdfAction.put(PdfName.D, new PdfName(string));
        } else {
            pdfAction.put(PdfName.D, new PdfString(string, null));
        }
        return pdfAction;
    }

    public static PdfAction gotoRemotePage(String string, String string2, boolean bl2, boolean bl3) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.F, new PdfString(string));
        pdfAction.put(PdfName.S, PdfName.GOTOR);
        if (bl2) {
            pdfAction.put(PdfName.D, new PdfName(string2));
        } else {
            pdfAction.put(PdfName.D, new PdfString(string2, null));
        }
        if (bl3) {
            pdfAction.put(PdfName.NEWWINDOW, PdfBoolean.PDFTRUE);
        }
        return pdfAction;
    }

    public static PdfAction gotoEmbedded(String string, PdfTargetDictionary pdfTargetDictionary, String string2, boolean bl2, boolean bl3) {
        if (bl2) {
            return PdfAction.gotoEmbedded(string, pdfTargetDictionary, new PdfName(string2), bl3);
        }
        return PdfAction.gotoEmbedded(string, pdfTargetDictionary, new PdfString(string2, null), bl3);
    }

    public static PdfAction gotoEmbedded(String string, PdfTargetDictionary pdfTargetDictionary, PdfObject pdfObject, boolean bl2) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.GOTOE);
        pdfAction.put(PdfName.T, pdfTargetDictionary);
        pdfAction.put(PdfName.D, pdfObject);
        pdfAction.put(PdfName.NEWWINDOW, new PdfBoolean(bl2));
        if (string != null) {
            pdfAction.put(PdfName.F, new PdfString(string));
        }
        return pdfAction;
    }

    public static PdfAction setOCGstate(List<Object> object, boolean bl2) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.SETOCGSTATE);
        PdfArray pdfArray = new PdfArray();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            if (object2 == null) continue;
            if (object2 instanceof PdfIndirectReference) {
                pdfArray.add((PdfIndirectReference)object2);
                continue;
            }
            if (object2 instanceof PdfLayer) {
                pdfArray.add(((PdfLayer)object2).getRef());
                continue;
            }
            if (object2 instanceof PdfName) {
                pdfArray.add((PdfName)object2);
                continue;
            }
            if (object2 instanceof String) {
                if (((String)(object2 = (String)object2)).equalsIgnoreCase("on")) {
                    object2 = PdfName.ON;
                } else if (((String)object2).equalsIgnoreCase("off")) {
                    object2 = PdfName.OFF;
                } else if (((String)object2).equalsIgnoreCase("toggle")) {
                    object2 = PdfName.TOGGLE;
                } else {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("a.string.1.was.passed.in.state.only.on.off.and.toggle.are.allowed", object2));
                }
                pdfArray.add((PdfObject)object2);
                continue;
            }
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("invalid.type.was.passed.in.state.1", object2.getClass().getName()));
        }
        pdfAction.put(PdfName.STATE, pdfArray);
        if (!bl2) {
            pdfAction.put(PdfName.PRESERVERB, PdfBoolean.PDFFALSE);
        }
        return pdfAction;
    }
}

