/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfBorderArray;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfOCG;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.f;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class PdfAnnotation
extends PdfDictionary {
    public static final PdfName HIGHLIGHT_NONE = PdfName.N;
    public static final PdfName HIGHLIGHT_INVERT = PdfName.I;
    public static final PdfName HIGHLIGHT_OUTLINE = PdfName.O;
    public static final PdfName HIGHLIGHT_PUSH = PdfName.P;
    public static final PdfName HIGHLIGHT_TOGGLE = PdfName.T;
    public static final int FLAGS_INVISIBLE = 1;
    public static final int FLAGS_HIDDEN = 2;
    public static final int FLAGS_PRINT = 4;
    public static final int FLAGS_NOZOOM = 8;
    public static final int FLAGS_NOROTATE = 16;
    public static final int FLAGS_NOVIEW = 32;
    public static final int FLAGS_READONLY = 64;
    public static final int FLAGS_LOCKED = 128;
    public static final int FLAGS_TOGGLENOVIEW = 256;
    public static final PdfName APPEARANCE_NORMAL = PdfName.N;
    public static final PdfName APPEARANCE_ROLLOVER = PdfName.R;
    public static final PdfName APPEARANCE_DOWN = PdfName.D;
    public static final PdfName AA_ENTER = PdfName.E;
    public static final PdfName AA_EXIT = PdfName.X;
    public static final PdfName AA_DOWN = PdfName.D;
    public static final PdfName AA_UP = PdfName.U;
    public static final PdfName AA_FOCUS = PdfName.FO;
    public static final PdfName AA_BLUR = PdfName.BL;
    public static final PdfName AA_JS_KEY = PdfName.K;
    public static final PdfName AA_JS_FORMAT = PdfName.F;
    public static final PdfName AA_JS_CHANGE = PdfName.V;
    public static final PdfName AA_JS_OTHER_CHANGE = PdfName.C;
    public static final int MARKUP_HIGHLIGHT = 0;
    public static final int MARKUP_UNDERLINE = 1;
    public static final int MARKUP_STRIKEOUT = 2;
    public static final int MARKUP_SQUIGGLY = 3;
    protected PdfWriter writer;
    protected PdfIndirectReference reference;
    protected Map<PdfTemplate, Object> templates;
    protected boolean form = false;
    protected boolean annotation = true;
    protected boolean used = false;
    private int a = -1;

    public PdfAnnotation(PdfWriter pdfWriter, Rectangle rectangle) {
        this.writer = pdfWriter;
        if (rectangle != null) {
            this.put(PdfName.RECT, new PdfRectangle(rectangle));
        }
    }

    public PdfAnnotation(PdfWriter pdfWriter, float f2, float f3, float f4, float f5, PdfString pdfString, PdfString pdfString2) {
        this.writer = pdfWriter;
        this.put(PdfName.SUBTYPE, PdfName.TEXT);
        this.put(PdfName.T, pdfString);
        this.put(PdfName.RECT, new PdfRectangle(f2, f3, f4, f5));
        this.put(PdfName.CONTENTS, pdfString2);
    }

    public PdfAnnotation(PdfWriter pdfWriter, float f2, float f3, float f4, float f5, PdfAction pdfAction) {
        this.writer = pdfWriter;
        this.put(PdfName.SUBTYPE, PdfName.LINK);
        this.put(PdfName.RECT, new PdfRectangle(f2, f3, f4, f5));
        this.put(PdfName.A, pdfAction);
        this.put(PdfName.BORDER, new PdfBorderArray(0.0f, 0.0f, 0.0f));
        this.put(PdfName.C, new f(0, 0, 255));
    }

    public static PdfAnnotation createScreen(PdfWriter object, Rectangle object2, String object3, PdfFileSpecification pdfFileSpecification, String string, boolean bl2) {
        object2 = new PdfAnnotation((PdfWriter)object, (Rectangle)object2);
        ((PdfDictionary)object2).put(PdfName.SUBTYPE, PdfName.SCREEN);
        ((PdfDictionary)object2).put(PdfName.F, new PdfNumber(4));
        ((PdfDictionary)object2).put(PdfName.TYPE, PdfName.ANNOT);
        ((PdfAnnotation)object2).setPage();
        PdfIndirectReference pdfIndirectReference = ((PdfAnnotation)object2).getIndirectReference();
        object3 = PdfAction.rendition((String)object3, pdfFileSpecification, string, pdfIndirectReference);
        object = ((PdfWriter)object).addToBody((PdfObject)object3).getIndirectReference();
        if (bl2) {
            object3 = new PdfDictionary();
            ((PdfDictionary)object3).put(new PdfName("PV"), (PdfObject)object);
            ((PdfDictionary)object2).put(PdfName.AA, (PdfObject)object3);
        }
        ((PdfDictionary)object2).put(PdfName.A, (PdfObject)object);
        return object2;
    }

    public PdfIndirectReference getIndirectReference() {
        if (this.reference == null) {
            this.reference = this.writer.getPdfIndirectReference();
        }
        return this.reference;
    }

    public static PdfAnnotation createText(PdfWriter object, Rectangle rectangle, String string, String string2, boolean bl2, String string3) {
        object = new PdfAnnotation((PdfWriter)object, rectangle);
        ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.TEXT);
        if (string != null) {
            ((PdfDictionary)object).put(PdfName.T, new PdfString(string, "UnicodeBig"));
        }
        if (string2 != null) {
            ((PdfDictionary)object).put(PdfName.CONTENTS, new PdfString(string2, "UnicodeBig"));
        }
        if (bl2) {
            ((PdfDictionary)object).put(PdfName.OPEN, PdfBoolean.PDFTRUE);
        }
        if (string3 != null) {
            ((PdfDictionary)object).put(PdfName.NAME, new PdfName(string3));
        }
        return object;
    }

    protected static PdfAnnotation createLink(PdfWriter object, Rectangle rectangle, PdfName pdfName) {
        object = new PdfAnnotation((PdfWriter)object, rectangle);
        ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.LINK);
        if (!pdfName.equals(HIGHLIGHT_INVERT)) {
            ((PdfDictionary)object).put(PdfName.H, pdfName);
        }
        return object;
    }

    public static PdfAnnotation createLink(PdfWriter object, Rectangle rectangle, PdfName pdfName, PdfAction pdfAction) {
        object = PdfAnnotation.createLink((PdfWriter)object, rectangle, pdfName);
        ((PdfDictionary)object).putEx(PdfName.A, pdfAction);
        return object;
    }

    public static PdfAnnotation createLink(PdfWriter object, Rectangle rectangle, PdfName pdfName, String string) {
        object = PdfAnnotation.createLink((PdfWriter)object, rectangle, pdfName);
        ((PdfDictionary)object).put(PdfName.DEST, new PdfString(string));
        return object;
    }

    public static PdfAnnotation createLink(PdfWriter object, Rectangle object2, PdfName pdfName, int n2, PdfDestination pdfDestination) {
        object2 = PdfAnnotation.createLink((PdfWriter)object, (Rectangle)object2, pdfName);
        object = ((PdfWriter)object).getPageReference(n2);
        pdfDestination.addPage((PdfIndirectReference)object);
        ((PdfDictionary)object2).put(PdfName.DEST, pdfDestination);
        return object2;
    }

    public static PdfAnnotation createFreeText(PdfWriter object, Rectangle rectangle, String string, PdfContentByte pdfContentByte) {
        object = new PdfAnnotation((PdfWriter)object, rectangle);
        ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.FREETEXT);
        ((PdfDictionary)object).put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        ((PdfAnnotation)object).setDefaultAppearanceString(pdfContentByte);
        return object;
    }

    public static PdfAnnotation createLine(PdfWriter object, Rectangle object2, String string, float f2, float f3, float f4, float f5) {
        object = new PdfAnnotation((PdfWriter)object, (Rectangle)object2);
        ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.LINE);
        ((PdfDictionary)object).put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        object2 = new PdfArray(new PdfNumber(f2));
        ((PdfArray)object2).add(new PdfNumber(f3));
        ((PdfArray)object2).add(new PdfNumber(f4));
        ((PdfArray)object2).add(new PdfNumber(f5));
        ((PdfDictionary)object).put(PdfName.L, (PdfObject)object2);
        return object;
    }

    public static PdfAnnotation createSquareCircle(PdfWriter object, Rectangle rectangle, String string, boolean bl2) {
        object = new PdfAnnotation((PdfWriter)object, rectangle);
        if (bl2) {
            ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.SQUARE);
        } else {
            ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.CIRCLE);
        }
        ((PdfDictionary)object).put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        return object;
    }

    public static PdfAnnotation createMarkup(PdfWriter object, Rectangle object2, String object3, int n2, float[] fArray) {
        object = new PdfAnnotation((PdfWriter)object, (Rectangle)object2);
        object2 = PdfName.HIGHLIGHT;
        switch (n2) {
            case 1: {
                object2 = PdfName.UNDERLINE;
                break;
            }
            case 2: {
                object2 = PdfName.STRIKEOUT;
                break;
            }
            case 3: {
                object2 = PdfName.SQUIGGLY;
            }
        }
        ((PdfDictionary)object).put(PdfName.SUBTYPE, (PdfObject)object2);
        ((PdfDictionary)object).put(PdfName.CONTENTS, new PdfString((String)object3, "UnicodeBig"));
        object2 = new PdfArray();
        object3 = fArray;
        n2 = fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object4 = object3[i2];
            ((PdfArray)object2).add(new PdfNumber((float)object4));
        }
        ((PdfDictionary)object).put(PdfName.QUADPOINTS, (PdfObject)object2);
        return object;
    }

    public static PdfAnnotation createStamp(PdfWriter object, Rectangle rectangle, String string, String string2) {
        object = new PdfAnnotation((PdfWriter)object, rectangle);
        ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.STAMP);
        ((PdfDictionary)object).put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        ((PdfDictionary)object).put(PdfName.NAME, new PdfName(string2));
        return object;
    }

    public static PdfAnnotation createInk(PdfWriter object, Rectangle object2, String object3, float[][] fArray) {
        object = new PdfAnnotation((PdfWriter)object, (Rectangle)object2);
        ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.INK);
        ((PdfDictionary)object).put(PdfName.CONTENTS, new PdfString((String)object3, "UnicodeBig"));
        object2 = new PdfArray();
        object3 = fArray;
        int n2 = fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object4 = object3[i2];
            PdfArray pdfArray = new PdfArray();
            Object object5 = object4;
            object4 = object5;
            object4 = object5;
            int n3 = ((Object)object5).length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Object object6 = object4[i3];
                pdfArray.add(new PdfNumber((float)object6));
            }
            ((PdfArray)object2).add(pdfArray);
        }
        ((PdfDictionary)object).put(PdfName.INKLIST, (PdfObject)object2);
        return object;
    }

    public static PdfAnnotation createFileAttachment(PdfWriter pdfWriter, Rectangle rectangle, String string, byte[] byArray, String string2, String string3) {
        return PdfAnnotation.createFileAttachment(pdfWriter, rectangle, string, PdfFileSpecification.fileEmbedded(pdfWriter, string2, string3, byArray));
    }

    public static PdfAnnotation createFileAttachment(PdfWriter object, Rectangle rectangle, String string, PdfFileSpecification pdfFileSpecification) {
        object = new PdfAnnotation((PdfWriter)object, rectangle);
        ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.FILEATTACHMENT);
        if (string != null) {
            ((PdfDictionary)object).put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        }
        ((PdfDictionary)object).put(PdfName.FS, pdfFileSpecification.getReference());
        return object;
    }

    public static PdfAnnotation createPopup(PdfWriter object, Rectangle rectangle, String string, boolean bl2) {
        object = new PdfAnnotation((PdfWriter)object, rectangle);
        ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.POPUP);
        if (string != null) {
            ((PdfDictionary)object).put(PdfName.CONTENTS, new PdfString(string, "UnicodeBig"));
        }
        if (bl2) {
            ((PdfDictionary)object).put(PdfName.OPEN, PdfBoolean.PDFTRUE);
        }
        return object;
    }

    public void setDefaultAppearanceString(PdfContentByte object) {
        byte[] byArray = ((PdfContentByte)object).getInternalBuffer().toByteArray();
        object = byArray;
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (object[i2] != 10) continue;
            object[i2] = 32;
        }
        this.put(PdfName.DA, new PdfString((byte[])object));
    }

    public void setFlags(int n2) {
        if (n2 == 0) {
            this.remove(PdfName.F);
            return;
        }
        this.put(PdfName.F, new PdfNumber(n2));
    }

    public void setBorder(PdfBorderArray pdfBorderArray) {
        this.put(PdfName.BORDER, pdfBorderArray);
    }

    public void setBorderStyle(PdfBorderDictionary pdfBorderDictionary) {
        this.put(PdfName.BS, pdfBorderDictionary);
    }

    public void setHighlighting(PdfName pdfName) {
        if (pdfName.equals(HIGHLIGHT_INVERT)) {
            this.remove(PdfName.H);
            return;
        }
        this.put(PdfName.H, pdfName);
    }

    public void setAppearance(PdfName pdfName, PdfTemplate pdfTemplate) {
        PdfDictionary pdfDictionary = (PdfDictionary)this.get(PdfName.AP);
        if (pdfDictionary == null) {
            pdfDictionary = new PdfDictionary();
        }
        pdfDictionary.put(pdfName, pdfTemplate.getIndirectReference());
        this.put(PdfName.AP, pdfDictionary);
        if (!this.form) {
            return;
        }
        if (this.templates == null) {
            this.templates = new HashMap<PdfTemplate, Object>();
        }
        this.templates.put(pdfTemplate, null);
    }

    public void setAppearance(PdfName pdfName, String string, PdfTemplate pdfTemplate) {
        PdfObject pdfObject;
        PdfDictionary pdfDictionary = (PdfDictionary)this.get(PdfName.AP);
        if (pdfDictionary == null) {
            pdfDictionary = new PdfDictionary();
        }
        pdfObject = (pdfObject = pdfDictionary.get(pdfName)) != null && pdfObject.isDictionary() ? (PdfDictionary)pdfObject : new PdfDictionary();
        ((PdfDictionary)pdfObject).put(new PdfName(string), pdfTemplate.getIndirectReference());
        pdfDictionary.put(pdfName, pdfObject);
        this.put(PdfName.AP, pdfDictionary);
        if (!this.form) {
            return;
        }
        if (this.templates == null) {
            this.templates = new HashMap<PdfTemplate, Object>();
        }
        this.templates.put(pdfTemplate, null);
    }

    public void setAppearanceState(String string) {
        if (string == null) {
            this.remove(PdfName.AS);
            return;
        }
        this.put(PdfName.AS, new PdfName(string));
    }

    public void setColor(Color color) {
        this.put(PdfName.C, new f(color));
    }

    public void setTitle(String string) {
        if (string == null) {
            this.remove(PdfName.T);
            return;
        }
        this.put(PdfName.T, new PdfString(string, "UnicodeBig"));
    }

    public void setPopup(PdfAnnotation pdfAnnotation) {
        this.put(PdfName.POPUP, pdfAnnotation.getIndirectReference());
        pdfAnnotation.put(PdfName.PARENT, this.getIndirectReference());
    }

    public void setAction(PdfAction pdfAction) {
        this.put(PdfName.A, pdfAction);
    }

    public void setAdditionalActions(PdfName pdfName, PdfAction pdfAction) {
        PdfObject pdfObject = this.get(PdfName.AA);
        pdfObject = pdfObject != null && pdfObject.isDictionary() ? (PdfDictionary)pdfObject : new PdfDictionary();
        ((PdfDictionary)pdfObject).put(pdfName, pdfAction);
        this.put(PdfName.AA, pdfObject);
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed() {
        this.used = true;
    }

    public HashMap<PdfTemplate, Object> getTemplates() {
        return (HashMap)this.templates;
    }

    public boolean isForm() {
        return this.form;
    }

    public boolean isAnnotation() {
        return this.annotation;
    }

    public void setPage(int n2) {
        this.put(PdfName.P, this.writer.getPageReference(n2));
    }

    public void setPage() {
        this.put(PdfName.P, this.writer.m());
    }

    public int getPlaceInPage() {
        return this.a;
    }

    public void setPlaceInPage(int n2) {
        this.a = n2;
    }

    public void setRotate(int n2) {
        this.put(PdfName.ROTATE, new PdfNumber(n2));
    }

    private PdfDictionary a() {
        PdfDictionary pdfDictionary = (PdfDictionary)this.get(PdfName.MK);
        if (pdfDictionary == null) {
            pdfDictionary = new PdfDictionary();
            this.put(PdfName.MK, pdfDictionary);
        }
        return pdfDictionary;
    }

    public void setMKRotation(int n2) {
        this.a().put(PdfName.R, new PdfNumber(n2));
    }

    public static PdfArray getMKColor(Color color) {
        PdfArray pdfArray = new PdfArray();
        int n2 = ExtendedColor.getType(color);
        switch (n2) {
            case 1: {
                pdfArray.add(new PdfNumber(((GrayColor)color).getGray()));
                break;
            }
            case 2: {
                color = (CMYKColor)color;
                pdfArray.add(new PdfNumber(((CMYKColor)color).getCyan()));
                pdfArray.add(new PdfNumber(((CMYKColor)color).getMagenta()));
                pdfArray.add(new PdfNumber(((CMYKColor)color).getYellow()));
                pdfArray.add(new PdfNumber(((CMYKColor)color).getBlack()));
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new RuntimeException(MessageLocalization.getComposedMessage("separations.patterns.and.shadings.are.not.allowed.in.mk.dictionary"));
            }
            default: {
                pdfArray.add(new PdfNumber((float)color.getRed() / 255.0f));
                pdfArray.add(new PdfNumber((float)color.getGreen() / 255.0f));
                pdfArray.add(new PdfNumber((float)color.getBlue() / 255.0f));
            }
        }
        return pdfArray;
    }

    public void setMKBorderColor(Color color) {
        if (color == null) {
            this.a().remove(PdfName.BC);
            return;
        }
        this.a().put(PdfName.BC, PdfAnnotation.getMKColor(color));
    }

    public void setMKBackgroundColor(Color color) {
        if (color == null) {
            this.a().remove(PdfName.BG);
            return;
        }
        this.a().put(PdfName.BG, PdfAnnotation.getMKColor(color));
    }

    public void setMKNormalCaption(String string) {
        this.a().put(PdfName.CA, new PdfString(string, "UnicodeBig"));
    }

    public void setMKRolloverCaption(String string) {
        this.a().put(PdfName.RC, new PdfString(string, "UnicodeBig"));
    }

    public void setMKAlternateCaption(String string) {
        this.a().put(PdfName.AC, new PdfString(string, "UnicodeBig"));
    }

    public void setMKNormalIcon(PdfTemplate pdfTemplate) {
        this.a().put(PdfName.I, pdfTemplate.getIndirectReference());
    }

    public void setMKRolloverIcon(PdfTemplate pdfTemplate) {
        this.a().put(PdfName.RI, pdfTemplate.getIndirectReference());
    }

    public void setMKAlternateIcon(PdfTemplate pdfTemplate) {
        this.a().put(PdfName.IX, pdfTemplate.getIndirectReference());
    }

    public void setMKIconFit(PdfName pdfObject, PdfName pdfName, float f2, float f3, boolean bl2) {
        PdfDictionary pdfDictionary = new PdfDictionary();
        if (!pdfObject.equals(PdfName.A)) {
            pdfDictionary.put(PdfName.SW, pdfObject);
        }
        if (!pdfName.equals(PdfName.P)) {
            pdfDictionary.put(PdfName.S, pdfName);
        }
        if (f2 != 0.5f || f3 != 0.5f) {
            pdfObject = new PdfArray(new PdfNumber(f2));
            ((PdfArray)pdfObject).add(new PdfNumber(f3));
            pdfDictionary.put(PdfName.A, pdfObject);
        }
        if (bl2) {
            pdfDictionary.put(PdfName.FB, PdfBoolean.PDFTRUE);
        }
        this.a().put(PdfName.IF, pdfDictionary);
    }

    public void setMKTextPosition(int n2) {
        this.a().put(PdfName.TP, new PdfNumber(n2));
    }

    public void setLayer(PdfOCG pdfOCG) {
        this.put(PdfName.OC, pdfOCG.getRef());
    }

    public void setName(String string) {
        this.put(PdfName.NM, new PdfString(string));
    }

    public static class PdfImportedLink {
        private float a;
        private float b;
        private float c;
        private float d;
        private HashMap<PdfName, PdfObject> e = new HashMap();
        private PdfArray f;
        private int g = 0;

        PdfImportedLink(PdfDictionary pdfObject) {
            this.e.putAll(((PdfDictionary)pdfObject).hashMap);
            try {
                this.f = (PdfArray)this.e.remove(PdfName.DEST);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("you.have.to.consolidate.the.named.destinations.of.your.reader"));
            }
            if (this.f != null) {
                this.f = new PdfArray(this.f);
            }
            pdfObject = (PdfArray)this.e.remove(PdfName.RECT);
            this.a = ((PdfArray)pdfObject).getAsNumber(0).floatValue();
            this.b = ((PdfArray)pdfObject).getAsNumber(1).floatValue();
            this.c = ((PdfArray)pdfObject).getAsNumber(2).floatValue();
            this.d = ((PdfArray)pdfObject).getAsNumber(3).floatValue();
        }

        public boolean isInternal() {
            return this.f != null;
        }

        public int getDestinationPage() {
            if (!this.isInternal()) {
                return 0;
            }
            PdfIndirectReference pdfIndirectReference = this.f.getAsIndirectObject(0);
            pdfIndirectReference = (PRIndirectReference)pdfIndirectReference;
            PdfReader pdfReader = ((PRIndirectReference)pdfIndirectReference).getReader();
            for (int i2 = 1; i2 <= pdfReader.getNumberOfPages(); ++i2) {
                PRIndirectReference pRIndirectReference = pdfReader.getPageOrigRef(i2);
                if (pRIndirectReference.getGeneration() != pdfIndirectReference.getGeneration() || pRIndirectReference.getNumber() != pdfIndirectReference.getNumber()) continue;
                return i2;
            }
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("page.not.found"));
        }

        public void setDestinationPage(int n2) {
            if (!this.isInternal()) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("cannot.change.destination.of.external.link"));
            }
            this.g = n2;
        }

        public void transformDestination(float f2, float f3, float f4, float f5, float f6, float f7) {
            if (!this.isInternal()) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("cannot.change.destination.of.external.link"));
            }
            if (this.f.getAsName(1).equals(PdfName.XYZ)) {
                float f8 = this.f.getAsNumber(2).floatValue();
                float f9 = this.f.getAsNumber(3).floatValue();
                f2 = f8 * f2 + f9 * f4 + f6;
                f3 = f8 * f3 + f9 * f5 + f7;
                this.f.set(2, new PdfNumber(f2));
                this.f.set(3, new PdfNumber(f3));
            }
        }

        public void transformRect(float f2, float f3, float f4, float f5, float f6, float f7) {
            float f8 = this.a * f2 + this.b * f4 + f6;
            float f9 = this.a * f3 + this.b * f5 + f7;
            this.a = f8;
            this.b = f9;
            f8 = this.c * f2 + this.d * f4 + f6;
            f9 = this.c * f3 + this.d * f5 + f7;
            this.c = f8;
            this.d = f9;
        }

        public PdfAnnotation createAnnotation(PdfWriter object) {
            PdfAnnotation pdfAnnotation = new PdfAnnotation((PdfWriter)object, new Rectangle(this.a, this.b, this.c, this.d));
            if (this.g != 0) {
                object = ((PdfWriter)object).getPageReference(this.g);
                this.f.set(0, (PdfObject)object);
            }
            if (this.f != null) {
                pdfAnnotation.put(PdfName.DEST, this.f);
            }
            pdfAnnotation.hashMap.putAll(this.e);
            return pdfAnnotation;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Imported link: location [");
            stringBuilder.append(this.a);
            stringBuilder.append(' ');
            stringBuilder.append(this.b);
            stringBuilder.append(' ');
            stringBuilder.append(this.c);
            stringBuilder.append(' ');
            stringBuilder.append(this.d);
            stringBuilder.append("] destination ");
            stringBuilder.append(this.f);
            stringBuilder.append(" parameters ");
            stringBuilder.append(this.e);
            return stringBuilder.toString();
        }
    }
}

