/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PdfObject;

public class PdfBoolean
extends PdfObject {
    public static final PdfBoolean PDFTRUE = new PdfBoolean(true);
    public static final PdfBoolean PDFFALSE = new PdfBoolean(false);
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private boolean a;

    public PdfBoolean(boolean bl2) {
        super(1);
        if (bl2) {
            this.setContent(TRUE);
        } else {
            this.setContent(FALSE);
        }
        this.a = bl2;
    }

    public PdfBoolean(String string) {
        super(1, string);
        if (string.equals(TRUE)) {
            this.a = true;
            return;
        }
        if (string.equals(FALSE)) {
            this.a = false;
            return;
        }
        throw new BadPdfFormatException(MessageLocalization.getComposedMessage("the.value.has.to.be.true.of.false.instead.of.1", string));
    }

    public boolean booleanValue() {
        return this.a;
    }

    @Override
    public String toString() {
        if (this.a) {
            return TRUE;
        }
        return FALSE;
    }
}

