/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;

public class PdfBorderDictionary
extends PdfDictionary {
    public static final int STYLE_SOLID = 0;
    public static final int STYLE_DASHED = 1;
    public static final int STYLE_BEVELED = 2;
    public static final int STYLE_INSET = 3;
    public static final int STYLE_UNDERLINE = 4;

    public PdfBorderDictionary(float f2, int n2, PdfDashPattern pdfDashPattern) {
        this.put(PdfName.W, new PdfNumber(f2));
        switch (n2) {
            case 0: {
                PdfName pdfName = PdfName.S;
                this.put(pdfName, pdfName);
                return;
            }
            case 1: {
                if (pdfDashPattern != null) {
                    this.put(PdfName.D, pdfDashPattern);
                }
                this.put(PdfName.S, PdfName.D);
                return;
            }
            case 2: {
                this.put(PdfName.S, PdfName.B);
                return;
            }
            case 3: {
                this.put(PdfName.S, PdfName.I);
                return;
            }
            case 4: {
                this.put(PdfName.S, PdfName.U);
                return;
            }
        }
        throw new IllegalArgumentException(MessageLocalization.getComposedMessage("invalid.border.style"));
    }

    public PdfBorderDictionary(float f2, int n2) {
        this(f2, n2, null);
    }
}

