/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.Utilities;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultSplitCharacter;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.j;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PdfChunk {
    private static final char[] a = new char[]{' '};
    private static final PdfChunk[] b = new PdfChunk[1];
    private static final Map<String, Object> c = new HashMap<String, Object>();
    private static final Map<String, Object> d = new HashMap<String, Object>();
    protected String value = "";
    protected String encoding = "Cp1252";
    protected j font;
    protected BaseFont baseFont;
    protected SplitCharacter splitCharacter;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected Map<String, Object> noStroke = new HashMap<String, Object>();
    protected boolean newlineSplit;
    protected Image image;
    protected float offsetX;
    protected float offsetY;
    protected boolean changeLeading = false;

    PdfChunk(String objectArray, PdfChunk pdfChunk) {
        PdfChunk.b[0] = this;
        this.value = objectArray;
        this.font = pdfChunk.font;
        this.attributes = pdfChunk.attributes;
        this.noStroke = pdfChunk.noStroke;
        this.baseFont = pdfChunk.baseFont;
        objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.encoding = this.font.b().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = DefaultSplitCharacter.DEFAULT;
        }
    }

    PdfChunk(Chunk chunk, PdfAction pdfAction) {
        PdfChunk.b[0] = this;
        this.value = chunk.getContent();
        Font font = chunk.getFont();
        float f2 = font.getSize();
        if (f2 == -1.0f) {
            f2 = 12.0f;
        }
        this.baseFont = font.getBaseFont();
        int n3 = font.getStyle();
        if (n3 == -1) {
            n3 = 0;
        }
        if (this.baseFont == null) {
            if (chunk.getContent().chars().allMatch(n2 -> n2 >= 32 && n2 <= 255 || n2 == 9)) {
                this.baseFont = font.getCalculatedBaseFont(false);
            } else {
                try {
                    this.baseFont = BaseFont.createFont("font-fallback/LiberationSans-Regular.ttf", "Identity-H", true);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        } else {
            if ((n3 & 1) != 0) {
                this.attributes.put("TEXTRENDERMODE", new Object[]{2, Float.valueOf(f2 / 30.0f), null});
            }
            if ((n3 & 2) != 0) {
                this.attributes.put("SKEW", new float[]{0.0f, 0.21256f});
            }
        }
        this.font = new j(this.baseFont, f2);
        Map<String, Object> map = chunk.getChunkAttributes();
        if (map != null) {
            for (Map.Entry<String, Object> object2 : map.entrySet()) {
                String string = object2.getKey();
                if (c.containsKey(string)) {
                    this.attributes.put(string, object2.getValue());
                    continue;
                }
                if (!d.containsKey(string)) continue;
                this.noStroke.put(string, object2.getValue());
            }
            if ("".equals(map.get("GENERICTAG"))) {
                this.attributes.put("GENERICTAG", chunk.getContent());
            }
        }
        if (font.isUnderlined()) {
            Object[] objectArray = new Object[]{null, new float[]{0.0f, 0.06666667f, 0.0f, -0.33333334f, 0.0f}};
            Object[][] objectArray2 = Utilities.addToArray((Object[][])this.attributes.get("UNDERLINE"), objectArray);
            this.attributes.put("UNDERLINE", objectArray2);
        }
        if (font.isStrikethru()) {
            Object[] objectArray = new Object[]{null, new float[]{0.0f, 0.06666667f, 0.0f, 0.33333334f, 0.0f}};
            Object[][] objectArray3 = Utilities.addToArray((Object[][])this.attributes.get("UNDERLINE"), objectArray);
            this.attributes.put("UNDERLINE", objectArray3);
        }
        if (pdfAction != null) {
            this.attributes.put("ACTION", pdfAction);
        }
        this.noStroke.put("COLOR", font.getColor());
        this.noStroke.put("ENCODING", this.font.b().getEncoding());
        Object[] objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.attributes.remove("HSCALE");
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.font.a(this.image);
        Float f3 = (Float)this.attributes.get("HSCALE");
        if (f3 != null) {
            this.font.a(f3.floatValue());
        }
        this.encoding = this.font.b().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = DefaultSplitCharacter.DEFAULT;
        }
    }

    public int getUnicodeEquivalent(int n2) {
        return this.baseFont.getUnicodeEquivalent(n2);
    }

    protected int getWord(String string, int n2) {
        int n3 = string.length();
        while (n2 < n3 && Character.isLetter(string.charAt(n2))) {
            ++n2;
        }
        return n2;
    }

    final PdfChunk a(float f2) {
        int n2;
        int n3;
        this.newlineSplit = false;
        if (this.image != null) {
            if (this.image.getScaledWidth() > f2) {
                PdfChunk pdfChunk = new PdfChunk("\ufffc", this);
                this.value = "";
                this.attributes = new HashMap<String, Object>();
                this.image = null;
                this.font = j.c();
                return pdfChunk;
            }
            return null;
        }
        Object object = (HyphenationEvent)this.noStroke.get("HYPHENATION");
        int n4 = -1;
        float f3 = 0.0f;
        int n5 = -1;
        float f4 = 0.0f;
        int n6 = this.value.length();
        char[] cArray = this.value.toCharArray();
        BaseFont baseFont = this.font.b();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(32) != 32) {
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = cArray[n3];
                char c2 = (char)baseFont.getUnicodeEquivalent(n2);
                if (c2 == '\n') {
                    this.newlineSplit = true;
                    String string = this.value.substring(n3 + 1);
                    this.value = this.value.substring(0, n3);
                    if (this.value.length() <= 0) {
                        this.value = "\u0001";
                    }
                    return new PdfChunk(string, this);
                }
                f3 += this.a(n2);
                if (c2 == ' ') {
                    n5 = n3 + 1;
                    f4 = f3;
                }
                if (!(f3 > f2)) {
                    if (!this.splitCharacter.isSplitCharacter(0, n3, n6, cArray, b)) continue;
                    n4 = n3 + 1;
                    continue;
                }
                break;
            }
        } else {
            while (n3 < n6) {
                char c3 = cArray[n3];
                if (c3 == '\r' || c3 == '\n') {
                    this.newlineSplit = true;
                    int n7 = 1;
                    if (c3 == '\r' && n3 + 1 < n6 && cArray[n3 + 1] == '\n') {
                        n7 = 2;
                    }
                    String string = this.value.substring(n3 + n7);
                    this.value = this.value.substring(0, n3);
                    if (this.value.length() <= 0) {
                        this.value = " ";
                    }
                    return new PdfChunk(string, this);
                }
                boolean bl2 = Utilities.isSurrogatePair(cArray, n3);
                f3 = bl2 ? (f3 += this.a(Utilities.convertToUtf32(cArray[n3], cArray[n3 + 1]))) : (f3 += this.a(c3));
                if (c3 == ' ') {
                    n5 = n3 + 1;
                    f4 = f3;
                }
                if (bl2) {
                    ++n3;
                }
                if (!(f3 > f2)) {
                    if (this.splitCharacter.isSplitCharacter(0, n3, n6, cArray, null)) {
                        n4 = n3 + 1;
                    }
                    ++n3;
                    continue;
                }
                break;
            }
        }
        if (n3 == n6) {
            return null;
        }
        if (n4 < 0) {
            String string = this.value;
            this.value = "";
            return new PdfChunk(string, this);
        }
        if (n5 > n4 && this.splitCharacter.isSplitCharacter(0, 0, 1, a, null)) {
            n4 = n5;
        }
        if (object != null && n5 >= 0 && n5 < n3) {
            PdfChunk pdfChunk = this;
            n2 = pdfChunk.getWord(pdfChunk.value, n5);
            if (n2 > n5) {
                String string = object.getHyphenatedWordPre(this.value.substring(n5, n2), this.font.b(), this.font.a(), f2 - f4);
                object = object.getHyphenatedWordPost();
                if (string.length() > 0) {
                    object = (String)object + this.value.substring(n2);
                    this.value = this.d(this.value.substring(0, n5) + string);
                    return new PdfChunk((String)object, this);
                }
            }
        }
        String string = this.value.substring(n4);
        this.value = this.d(this.value.substring(0, n4));
        return new PdfChunk(string, this);
    }

    final PdfChunk b(float f2) {
        int n2;
        j j2;
        if (this.image != null) {
            if (this.image.getScaledWidth() > f2) {
                PdfChunk pdfChunk = new PdfChunk("", this);
                this.value = "";
                this.attributes.remove("IMAGE");
                this.image = null;
                this.font = j.c();
                return pdfChunk;
            }
            return null;
        }
        float f3 = 0.0f;
        Object object = this.font;
        if (f2 < j2.a(32)) {
            object = this.value.substring(1);
            this.value = this.value.substring(0, 1);
            return new PdfChunk((String)object, this);
        }
        int n3 = this.value.length();
        boolean bl2 = false;
        for (n2 = 0; n2 < n3; ++n2) {
            bl2 = Utilities.isSurrogatePair(this.value, n2);
            if (bl2) {
                PdfChunk pdfChunk = this;
                f3 += pdfChunk.a(Utilities.convertToUtf32(pdfChunk.value, n2));
            } else {
                PdfChunk pdfChunk = this;
                f3 += pdfChunk.a(pdfChunk.value.charAt(n2));
            }
            if (f3 > f2) break;
            if (!bl2) continue;
            ++n2;
        }
        if (n2 == n3) {
            return null;
        }
        if (n2 == 0) {
            n2 = 1;
            if (bl2) {
                ++n2;
            }
        }
        String string = this.value.substring(n2);
        this.value = this.value.substring(0, n2);
        return new PdfChunk(string, this);
    }

    final j a() {
        return this.font;
    }

    final Color b() {
        return (Color)this.noStroke.get("COLOR");
    }

    final float c() {
        if (this.b("CHAR_SPACING")) {
            Float f2 = (Float)this.a("CHAR_SPACING");
            return this.font.a(this.value) + (float)this.value.length() * f2.floatValue();
        }
        return this.font.a(this.value);
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit;
    }

    public float getWidthCorrected(float f2, float f3) {
        if (this.image != null) {
            return this.image.getScaledWidth() + f2;
        }
        int n2 = 0;
        int n3 = -1;
        while ((n3 = this.value.indexOf(32, n3 + 1)) >= 0) {
            ++n2;
        }
        return this.c() + ((float)this.value.length() * f2 + (float)n2 * f3);
    }

    public float getTextRise() {
        Float f2 = (Float)this.a("SUBSUPSCRIPT");
        if (f2 != null) {
            return f2.floatValue();
        }
        return 0.0f;
    }

    public float trimLastSpace() {
        BaseFont baseFont = this.font.b();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(32) != 32) {
            if (this.value.length() > 1 && this.value.endsWith("\u0001")) {
                this.value = this.value.substring(0, this.value.length() - 1);
                return this.font.a(1);
            }
        } else if (this.value.length() > 1 && this.value.endsWith(" ")) {
            this.value = this.value.substring(0, this.value.length() - 1);
            return this.font.a(32);
        }
        return 0.0f;
    }

    public float trimFirstSpace() {
        BaseFont baseFont = this.font.b();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(32) != 32) {
            if (this.value.length() > 1 && this.value.startsWith("\u0001")) {
                this.value = this.value.substring(1);
                return this.font.a(1);
            }
        } else if (this.value.length() > 1 && this.value.startsWith(" ")) {
            this.value = this.value.substring(1);
            return this.font.a(32);
        }
        return 0.0f;
    }

    final Object a(String string) {
        if (this.attributes.containsKey(string)) {
            return this.attributes.get(string);
        }
        return this.noStroke.get(string);
    }

    final boolean b(String string) {
        if (this.attributes.containsKey(string)) {
            return true;
        }
        return this.noStroke.containsKey(string);
    }

    final boolean d() {
        return !this.attributes.isEmpty();
    }

    final boolean e() {
        return this.b("SEPARATOR");
    }

    final boolean f() {
        if (this.b("SEPARATOR")) {
            Object[] objectArray = (Object[])this.a("SEPARATOR");
            return (Boolean)objectArray[1] == false;
        }
        return false;
    }

    final boolean g() {
        if (this.b("SEPARATOR")) {
            Object[] objectArray = (Object[])this.a("SEPARATOR");
            return (Boolean)objectArray[1];
        }
        return false;
    }

    final boolean h() {
        return this.b("TAB");
    }

    final void c(float f2) {
        Object[] objectArray = (Object[])this.attributes.get("TAB");
        if (objectArray != null) {
            this.attributes.put("TAB", new Object[]{objectArray[0], objectArray[1], objectArray[2], Float.valueOf(f2)});
        }
    }

    final boolean i() {
        return this.image != null;
    }

    final Image j() {
        return this.image;
    }

    final float k() {
        return this.offsetX;
    }

    final float l() {
        return this.offsetY;
    }

    final void c(String string) {
        this.value = string;
    }

    public String toString() {
        return this.value;
    }

    final boolean m() {
        return this.encoding.equals("UnicodeBigUnmarked") || this.encoding.equals("Identity-H");
    }

    final int n() {
        return this.value.length();
    }

    final int o() {
        if (!"Identity-H".equals(this.encoding)) {
            return this.value.length();
        }
        int n2 = 0;
        int n3 = this.value.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (Utilities.isSurrogateHigh(this.value.charAt(i2))) {
                ++i2;
            }
            ++n2;
        }
        return n2;
    }

    final boolean a(int n2, int n3, int n4, char[] cArray, PdfChunk[] pdfChunkArray) {
        return this.splitCharacter.isSplitCharacter(n2, n3, n4, cArray, pdfChunkArray);
    }

    private String d(String string) {
        BaseFont baseFont = this.font.b();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(32) != 32) {
            while (string.endsWith("\u0001")) {
                string = string.substring(0, string.length() - 1);
            }
        } else {
            while (string.endsWith(" ") || string.endsWith("\t")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public boolean changeLeading() {
        return this.changeLeading;
    }

    final float a(int n2) {
        if (PdfChunk.noPrint(n2)) {
            return 0.0f;
        }
        if (this.b("CHAR_SPACING")) {
            Float f2 = (Float)this.a("CHAR_SPACING");
            return this.font.a(n2) + f2.floatValue();
        }
        return this.font.a(n2);
    }

    public static boolean noPrint(int n2) {
        return n2 >= 8203 && n2 <= 8207 || n2 >= 8234 && n2 <= 8238;
    }

    static {
        c.put("ACTION", null);
        c.put("UNDERLINE", null);
        c.put("REMOTEGOTO", null);
        c.put("LOCALGOTO", null);
        c.put("LOCALDESTINATION", null);
        c.put("GENERICTAG", null);
        c.put("NEWPAGE", null);
        c.put("IMAGE", null);
        c.put("BACKGROUND", null);
        c.put("PDFANNOTATION", null);
        c.put("SKEW", null);
        c.put("HSCALE", null);
        c.put("SEPARATOR", null);
        c.put("TAB", null);
        c.put("CHAR_SPACING", null);
        d.put("SUBSUPSCRIPT", null);
        d.put("SPLITCHARACTER", null);
        d.put("HYPHENATION", null);
        d.put("TEXTRENDERMODE", null);
    }
}

