/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Annotation;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.ImgJBIG2;
import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.exceptions.IllegalPdfSyntaxException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.LayoutProcessor;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PatternColor;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfImage;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLayer;
import com.lowagie.text.pdf.PdfLayerMembership;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfOCG;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPSXObject;
import com.lowagie.text.pdf.PdfPatternPainter;
import com.lowagie.text.pdf.PdfPrinterGraphics2D;
import com.lowagie.text.pdf.PdfShading;
import com.lowagie.text.pdf.PdfShadingPattern;
import com.lowagie.text.pdf.PdfSpotColor;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfStructureElement;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTextArray;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RGBColor;
import com.lowagie.text.pdf.ShadingColor;
import com.lowagie.text.pdf.SpotColor;
import com.lowagie.text.pdf.b;
import com.lowagie.text.pdf.d;
import com.lowagie.text.pdf.e;
import com.lowagie.text.pdf.internal.PdfAnnotationsImp;
import com.lowagie.text.pdf.internal.PdfXConformanceImp;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PdfContentByte {
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 2;
    public static final int LINE_CAP_BUTT = 0;
    public static final int LINE_CAP_ROUND = 1;
    public static final int LINE_CAP_PROJECTING_SQUARE = 2;
    public static final int LINE_JOIN_MITER = 0;
    public static final int LINE_JOIN_ROUND = 1;
    public static final int LINE_JOIN_BEVEL = 2;
    public static final int TEXT_RENDER_MODE_FILL = 0;
    public static final int TEXT_RENDER_MODE_STROKE = 1;
    public static final int TEXT_RENDER_MODE_FILL_STROKE = 2;
    public static final int TEXT_RENDER_MODE_INVISIBLE = 3;
    public static final int TEXT_RENDER_MODE_FILL_CLIP = 4;
    public static final int TEXT_RENDER_MODE_STROKE_CLIP = 5;
    public static final int TEXT_RENDER_MODE_FILL_STROKE_CLIP = 6;
    public static final int TEXT_RENDER_MODE_CLIP = 7;
    private static final float[] a = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    protected ByteBuffer content = new ByteBuffer();
    protected PdfWriter writer;
    protected PdfDocument pdf;
    protected a state = new a();
    private static final Map<PdfName, String> b = new HashMap<PdfName, String>();
    protected List<a> stateList = new ArrayList<a>();
    protected int separator = 10;
    private int c = 0;
    private boolean d = false;
    protected List<Integer> layerDepth;
    private int e = 255;
    private int f = 255;
    private Point2D g = null;

    public PdfContentByte(PdfWriter pdfWriter) {
        if (pdfWriter != null) {
            this.writer = pdfWriter;
            this.pdf = this.writer.i();
        }
    }

    public String toString() {
        return this.content.toString();
    }

    public ByteBuffer getInternalBuffer() {
        return this.content;
    }

    public byte[] toPdf(PdfWriter pdfWriter) {
        this.sanityCheck();
        return this.content.toByteArray();
    }

    public void add(PdfContentByte pdfContentByte) {
        if (pdfContentByte.writer != null && this.writer != pdfContentByte.writer) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("inconsistent.writers.are.you.mixing.two.documents"));
        }
        this.content.append(pdfContentByte.content);
    }

    public float getXTLM() {
        return this.state.d;
    }

    public float getYTLM() {
        return this.state.e;
    }

    public float getLeading() {
        return this.state.f;
    }

    public float getCharacterSpacing() {
        return this.state.h;
    }

    public float getWordSpacing() {
        return this.state.i;
    }

    public float getHorizontalScaling() {
        return this.state.g;
    }

    public void setFlatness(float f2) {
        if (f2 >= 0.0f && f2 <= 100.0f) {
            this.content.append(f2).append(" i").append_i(this.separator);
        }
    }

    public void setLineCap(int n2) {
        if (n2 >= 0 && n2 <= 2) {
            this.content.append(n2).append(" J").append_i(this.separator);
        }
    }

    public void setLineDash(float f2) {
        this.content.append("[] ").append(f2).append(" d").append_i(this.separator);
    }

    public void setLineDash(float f2, float f3) {
        this.content.append("[").append(f2).append("] ").append(f3).append(" d").append_i(this.separator);
    }

    public void setLineDash(float f2, float f3, float f4) {
        this.content.append("[").append(f2).append(' ').append(f3).append("] ").append(f4).append(" d").append_i(this.separator);
    }

    public final void setLineDash(float[] fArray, float f2) {
        this.content.append("[");
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            this.content.append(fArray[i2]);
            if (i2 >= fArray.length - 1) continue;
            this.content.append(' ');
        }
        this.content.append("] ").append(f2).append(" d").append_i(this.separator);
    }

    public void setLineJoin(int n2) {
        if (n2 >= 0 && n2 <= 2) {
            this.content.append(n2).append(" j").append_i(this.separator);
        }
    }

    public void setLineWidth(float f2) {
        this.content.append(f2).append(" w").append_i(this.separator);
    }

    public void setMiterLimit(float f2) {
        if (f2 > 1.0f) {
            this.content.append(f2).append(" M").append_i(this.separator);
        }
    }

    public void clip() {
        this.content.append("W").append_i(this.separator);
    }

    public void eoClip() {
        this.content.append("W*").append_i(this.separator);
    }

    public void setGrayFill(float f2) {
        this.setGrayFill(f2, 1.0f);
    }

    public void setGrayFill(float f2, float f3) {
        this.b(new GrayColor(f2, f3));
        this.content.append(f2).append(" g").append_i(this.separator);
    }

    public void resetGrayFill() {
        this.b(GrayColor.GRAYBLACK);
        this.content.append("0 g").append_i(this.separator);
    }

    public void setGrayStroke(float f2) {
        this.setGrayStroke(f2, 1.0f);
    }

    public void setGrayStroke(float f2, float f3) {
        this.a(new GrayColor(f2, f3));
        this.content.append(f2).append(" G").append_i(this.separator);
    }

    public void resetGrayStroke() {
        this.a(GrayColor.GRAYBLACK);
        this.content.append("0 G").append_i(this.separator);
    }

    private void a(int n2, int n3, int n4) {
        this.a((float)(n2 & 0xFF) / 255.0f, (float)(n3 & 0xFF) / 255.0f, (float)(n4 & 0xFF) / 255.0f);
    }

    private void a(float f2, float f3, float f4) {
        PdfXConformanceImp.checkPDFXConformance(this.writer, 3, null);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        } else if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.content.append(f2).append(' ').append(f3).append(' ').append(f4);
    }

    public void setRGBColorFillF(float f2, float f3, float f4) {
        this.setRGBColorFillF(f2, f3, f4, 1.0f);
    }

    public void setRGBColorFillF(float f2, float f3, float f4, float f5) {
        this.b(new RGBColor(f2, f3, f4, f5));
        this.a(f2, f3, f4);
        this.content.append(" rg").append_i(this.separator);
    }

    public void resetRGBColorFill() {
        this.resetGrayFill();
    }

    public void setRGBColorStrokeF(float f2, float f3, float f4) {
        this.a(new RGBColor(f2, f3, f4));
        this.a(f2, f3, f4);
        this.content.append(" RG").append_i(this.separator);
    }

    public void resetRGBColorStroke() {
        this.resetGrayStroke();
    }

    private void a(int n2, int n3, int n4, int n5) {
        this.a((float)(n2 & 0xFF) / 255.0f, (float)(n3 & 0xFF) / 255.0f, (float)(n4 & 0xFF) / 255.0f, (float)(n5 & 0xFF) / 255.0f);
    }

    private void a(float f2, float f3, float f4, float f5) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        } else if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        if (f5 < 0.0f) {
            f5 = 0.0f;
        } else if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        this.content.append(f2).append(' ').append(f3).append(' ').append(f4).append(' ').append(f5);
    }

    public void setCMYKColorFillF(float f2, float f3, float f4, float f5) {
        this.setCMYKColorFillF(f2, f3, f4, f5, 1.0f);
    }

    public void setCMYKColorFillF(float f2, float f3, float f4, float f5, float f6) {
        this.b(new CMYKColor(f2, f3, f4, f5, f6));
        this.a(f2, f3, f4, f5);
        this.content.append(" k").append_i(this.separator);
    }

    public void resetCMYKColorFill() {
        this.b(new CMYKColor(0.0f, 0.0f, 0.0f, 1.0f));
        this.a(0.0f, 0.0f, 0.0f, 1.0f);
        this.content.append(" k").append_i(this.separator);
    }

    public void setCMYKColorStrokeF(float f2, float f3, float f4, float f5) {
        this.setCMYKColorStrokeF(f2, f3, f4, f5, 1.0f);
    }

    public void setCMYKColorStrokeF(float f2, float f3, float f4, float f5, float f6) {
        this.a(new CMYKColor(f2, f3, f4, f5, f6));
        this.a(f2, f3, f4, f5);
        this.content.append(" K").append_i(this.separator);
    }

    public void resetCMYKColorStroke() {
        this.a(new CMYKColor(0.0f, 0.0f, 0.0f, 1.0f));
        this.a(0.0f, 0.0f, 0.0f, 1.0f);
        this.content.append(" K").append_i(this.separator);
    }

    public void moveTo(float f2, float f3) {
        this.content.append(f2).append(' ').append(f3).append(" m").append_i(this.separator);
    }

    public void lineTo(float f2, float f3) {
        this.content.append(f2).append(' ').append(f3).append(" l").append_i(this.separator);
    }

    public void curveTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.content.append(f2).append(' ').append(f3).append(' ').append(f4).append(' ').append(f5).append(' ').append(f6).append(' ').append(f7).append(" c").append_i(this.separator);
    }

    public void curveTo(float f2, float f3, float f4, float f5) {
        this.content.append(f2).append(' ').append(f3).append(' ').append(f4).append(' ').append(f5).append(" v").append_i(this.separator);
    }

    public void curveFromTo(float f2, float f3, float f4, float f5) {
        this.content.append(f2).append(' ').append(f3).append(' ').append(f4).append(' ').append(f5).append(" y").append_i(this.separator);
    }

    public void circle(float f2, float f3, float f4) {
        this.moveTo(f2 + f4, f3);
        this.curveTo(f2 + f4, f3 + f4 * 0.55191505f, f2 + f4 * 0.55191505f, f3 + f4, f2, f3 + f4);
        this.curveTo(f2 - f4 * 0.55191505f, f3 + f4, f2 - f4, f3 + f4 * 0.55191505f, f2 - f4, f3);
        this.curveTo(f2 - f4, f3 - f4 * 0.55191505f, f2 - f4 * 0.55191505f, f3 - f4, f2, f3 - f4);
        this.curveTo(f2 + f4 * 0.55191505f, f3 - f4, f2 + f4, f3 - f4 * 0.55191505f, f2 + f4, f3);
    }

    public void rectangle(float f2, float f3, float f4, float f5) {
        this.content.append(f2).append(' ').append(f3).append(' ').append(f4).append(' ').append(f5).append(" re").append_i(this.separator);
    }

    private static boolean a(Color color, Color color2) {
        if (color == null && color2 == null) {
            return true;
        }
        if (color == null || color2 == null) {
            return false;
        }
        if (color instanceof ExtendedColor) {
            return color.equals(color2);
        }
        return color2.equals(color);
    }

    public void variableRectangle(Rectangle object) {
        boolean bl2;
        boolean bl3;
        float f2 = ((Rectangle)object).getTop();
        float f3 = ((Rectangle)object).getBottom();
        float f4 = ((Rectangle)object).getRight();
        float f5 = ((Rectangle)object).getLeft();
        float f6 = ((Rectangle)object).getBorderWidthTop();
        float f7 = ((Rectangle)object).getBorderWidthBottom();
        float f8 = ((Rectangle)object).getBorderWidthRight();
        float f9 = ((Rectangle)object).getBorderWidthLeft();
        Color color = ((Rectangle)object).getBorderColorTop();
        Color color2 = ((Rectangle)object).getBorderColorBottom();
        Color color3 = ((Rectangle)object).getBorderColorRight();
        object = ((Rectangle)object).getBorderColorLeft();
        this.saveState();
        this.setLineCap(0);
        this.setLineJoin(0);
        float f10 = 0.0f;
        boolean bl4 = false;
        Color color4 = null;
        boolean bl5 = false;
        Color color5 = null;
        if (f6 > 0.0f) {
            f10 = f6;
            this.setLineWidth(f10);
            bl4 = true;
            if (color == null) {
                this.resetRGBColorStroke();
            } else {
                this.setColorStroke(color);
            }
            color4 = color;
            this.moveTo(f5, f2 - f6 / 2.0f);
            this.lineTo(f4, f2 - f6 / 2.0f);
            this.stroke();
        }
        if (f7 > 0.0f) {
            if (f7 != f10) {
                f10 = f7;
                this.setLineWidth(f10);
            }
            if (!bl4 || !PdfContentByte.a(color4, color2)) {
                bl4 = true;
                if (color2 == null) {
                    this.resetRGBColorStroke();
                } else {
                    this.setColorStroke(color2);
                }
                color4 = color2;
            }
            this.moveTo(f4, f3 + f7 / 2.0f);
            this.lineTo(f5, f3 + f7 / 2.0f);
            this.stroke();
        }
        if (f8 > 0.0f) {
            if (f8 != f10) {
                f10 = f8;
                this.setLineWidth(f10);
            }
            if (!bl4 || !PdfContentByte.a(color4, color3)) {
                bl4 = true;
                if (color3 == null) {
                    this.resetRGBColorStroke();
                } else {
                    this.setColorStroke(color3);
                }
                color4 = color3;
            }
            bl3 = PdfContentByte.a(color, color3);
            bl2 = PdfContentByte.a(color2, color3);
            this.moveTo(f4 - f8 / 2.0f, bl3 ? f2 : f2 - f6);
            this.lineTo(f4 - f8 / 2.0f, bl2 ? f3 : f3 + f7);
            this.stroke();
            if (!bl3 || !bl2) {
                bl5 = true;
                if (color3 == null) {
                    this.resetRGBColorFill();
                } else {
                    this.setColorFill(color3);
                }
                color5 = color3;
                if (!bl3) {
                    this.moveTo(f4, f2);
                    this.lineTo(f4, f2 - f6);
                    this.lineTo(f4 - f8, f2 - f6);
                    this.fill();
                }
                if (!bl2) {
                    this.moveTo(f4, f3);
                    this.lineTo(f4, f3 + f7);
                    this.lineTo(f4 - f8, f3 + f7);
                    this.fill();
                }
            }
        }
        if (f9 > 0.0f) {
            if (f9 != f10) {
                this.setLineWidth(f9);
            }
            if (!bl4 || !PdfContentByte.a(color4, (Color)object)) {
                if (object == null) {
                    this.resetRGBColorStroke();
                } else {
                    this.setColorStroke((Color)object);
                }
            }
            bl3 = PdfContentByte.a(color, (Color)object);
            bl2 = PdfContentByte.a(color2, (Color)object);
            this.moveTo(f5 + f9 / 2.0f, bl3 ? f2 : f2 - f6);
            this.lineTo(f5 + f9 / 2.0f, bl2 ? f3 : f3 + f7);
            this.stroke();
            if (!bl3 || !bl2) {
                if (!bl5 || !PdfContentByte.a(color5, (Color)object)) {
                    if (object == null) {
                        this.resetRGBColorFill();
                    } else {
                        this.setColorFill((Color)object);
                    }
                }
                if (!bl3) {
                    this.moveTo(f5, f2);
                    this.lineTo(f5, f2 - f6);
                    this.lineTo(f5 + f9, f2 - f6);
                    this.fill();
                }
                if (!bl2) {
                    this.moveTo(f5, f3);
                    this.lineTo(f5, f3 + f7);
                    this.lineTo(f5 + f9, f3 + f7);
                    this.fill();
                }
            }
        }
        this.restoreState();
    }

    public void rectangle(Rectangle rectangle) {
        float f2 = rectangle.getLeft();
        float f3 = rectangle.getBottom();
        float f4 = rectangle.getRight();
        float f5 = rectangle.getTop();
        Color color = rectangle.getBackgroundColor();
        if (color != null) {
            this.saveState();
            this.setColorFill(color);
            this.rectangle(f2, f3, f4 - f2, f5 - f3);
            this.fill();
            this.restoreState();
        }
        if (!rectangle.hasBorders()) {
            return;
        }
        if (rectangle.isUseVariableBorders()) {
            this.variableRectangle(rectangle);
            return;
        }
        if (rectangle.getBorderWidth() != -1.0f) {
            this.setLineWidth(rectangle.getBorderWidth());
        }
        if ((color = rectangle.getBorderColor()) != null) {
            this.setColorStroke(color);
        }
        if (rectangle.hasBorder(15)) {
            this.rectangle(f2, f3, f4 - f2, f5 - f3);
        } else {
            if (rectangle.hasBorder(8)) {
                this.moveTo(f4, f3);
                this.lineTo(f4, f5);
            }
            if (rectangle.hasBorder(4)) {
                this.moveTo(f2, f3);
                this.lineTo(f2, f5);
            }
            if (rectangle.hasBorder(2)) {
                this.moveTo(f2, f3);
                this.lineTo(f4, f3);
            }
            if (rectangle.hasBorder(1)) {
                this.moveTo(f2, f5);
                this.lineTo(f4, f5);
            }
        }
        this.stroke();
        if (color != null) {
            this.resetRGBColorStroke();
        }
    }

    public void closePath() {
        this.content.append("h").append_i(this.separator);
    }

    public void newPath() {
        this.content.append("n").append_i(this.separator);
    }

    public void stroke() {
        this.content.append("S").append_i(this.separator);
    }

    public void closePathStroke() {
        this.content.append("s").append_i(this.separator);
    }

    public void fill() {
        this.content.append("f").append_i(this.separator);
    }

    public void eoFill() {
        this.content.append("f*").append_i(this.separator);
    }

    public void fillStroke() {
        this.content.append("B").append_i(this.separator);
    }

    public void closePathFillStroke() {
        this.content.append("b").append_i(this.separator);
    }

    public void eoFillStroke() {
        this.content.append("B*").append_i(this.separator);
    }

    public void closePathEoFillStroke() {
        this.content.append("b*").append_i(this.separator);
    }

    public void addImage(Image image) {
        this.addImage(image, false);
    }

    public void addImage(Image image, boolean bl2) {
        if (!image.hasAbsoluteY()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("the.image.must.have.absolute.positioning"));
        }
        float[] fArray = image.matrix();
        float[] fArray2 = fArray;
        fArray[4] = image.getAbsoluteX() - fArray2[4];
        fArray2[5] = image.getAbsoluteY() - fArray2[5];
        this.addImage(image, fArray2[0], fArray2[1], fArray2[2], fArray2[3], fArray2[4], fArray2[5], bl2);
    }

    public void addImage(Image image, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.addImage(image, f2, f3, f4, f5, f6, f7, false);
    }

    /*
     * WARNING - void declaration
     */
    public void addImage(Image image, float f2, float f3, float f4, float f5, float f6, float f7, boolean bl2) {
        try {
            void var10_26;
            Annotation annotation;
            float f8;
            Object object;
            if (image.getLayer() != null) {
                this.beginLayer(image.getLayer());
            }
            if (image.isImgTemplate()) {
                this.writer.addDirectImageSimple(image);
                object = image.getTemplateData();
                f8 = ((PdfTemplate)object).getWidth();
                float f9 = ((PdfTemplate)object).getHeight();
                this.addTemplate((PdfTemplate)object, f2 / f8, f3 / f8, f4 / f9, f5 / f9, f6, f7);
            } else {
                this.content.append("q ");
                this.content.append(f2).append(' ');
                this.content.append(f3).append(' ');
                this.content.append(f4).append(' ');
                this.content.append(f5).append(' ');
                this.content.append(f6).append(' ');
                this.content.append(f7).append(" cm");
                if (bl2) {
                    this.content.append("\nBI\n");
                    object = new PdfImage(image, "", null);
                    if (image instanceof ImgJBIG2) {
                        byte[] byArray = ((ImgJBIG2)image).getGlobalBytes();
                        Object object2 = byArray;
                        if (byArray != null) {
                            PdfDictionary object3 = new PdfDictionary();
                            object3.put(PdfName.JBIG2GLOBALS, this.writer.getReferenceJBIG2Globals((byte[])object2));
                            ((PdfDictionary)object).put(PdfName.DECODEPARMS, object3);
                        }
                    }
                    for (PdfName i2 : ((PdfDictionary)object).getKeys()) {
                        PdfObject pdfObject;
                        PdfObject pdfObject2 = ((PdfDictionary)object).get(i2);
                        String string = b.get(i2);
                        if (string == null) continue;
                        this.content.append(string);
                        boolean bl3 = true;
                        if (i2.equals(PdfName.COLORSPACE) && pdfObject2.isArray() && ((PdfArray)(pdfObject = (PdfArray)pdfObject2)).size() == 4 && PdfName.INDEXED.equals(((PdfArray)pdfObject).getAsName(0)) && ((PdfArray)pdfObject).getPdfObject(1).isName() && ((PdfArray)pdfObject).getPdfObject(2).isNumber() && ((PdfArray)pdfObject).getPdfObject(3).isString()) {
                            bl3 = false;
                        }
                        if (bl3 && i2.equals(PdfName.COLORSPACE) && !pdfObject2.isName()) {
                            pdfObject = this.writer.p();
                            e f11 = this.b();
                            f11.c((PdfName)pdfObject, this.writer.addToBody(pdfObject2).getIndirectReference());
                            pdfObject2 = pdfObject;
                        }
                        pdfObject2.toPdf(null, this.content);
                        this.content.append('\n');
                    }
                    this.content.append("ID\n");
                    ((PdfStream)object).writeContent(this.content);
                    this.content.append("\nEI\nQ").append_i(this.separator);
                } else {
                    e e2 = this.b();
                    Image image2 = image.getImageMask();
                    if (image2 != null) {
                        PdfName pdfName = this.writer.addDirectImageSimple(image2);
                        e2.b(pdfName, this.writer.a(pdfName));
                    }
                    object = this.writer.addDirectImageSimple(image);
                    object = e2.b((PdfName)object, this.writer.a((PdfName)object));
                    this.content.append(' ').append(((PdfObject)object).getBytes()).append(" Do Q").append_i(this.separator);
                }
            }
            if (image.hasBorders()) {
                this.saveState();
                float f10 = image.getWidth();
                f8 = image.getHeight();
                this.concatCTM(f2 / f10, f3 / f10, f4 / f8, f5 / f8, f6, f7);
                this.rectangle(image);
                this.restoreState();
            }
            if (image.getLayer() != null) {
                this.endLayer();
            }
            if ((annotation = image.getAnnotation()) == null) {
                return;
            }
            float[] fArray = new float[a.length];
            boolean bl4 = false;
            while (var10_26 < a.length) {
                fArray[var10_26] = f2 * a[var10_26] + f4 * a[var10_26 + true] + f6;
                fArray[var10_26 + true] = f3 * a[var10_26] + f5 * a[var10_26 + true] + f7;
                var10_26 += 2;
            }
            float f9 = fArray[0];
            float f10 = fArray[1];
            float f11 = f9;
            float f12 = f10;
            for (int i2 = 2; i2 < fArray.length; i2 += 2) {
                f9 = Math.min(f9, fArray[i2]);
                f10 = Math.min(f10, fArray[i2 + 1]);
                f11 = Math.max(f11, fArray[i2]);
                f12 = Math.max(f12, fArray[i2 + 1]);
            }
            annotation = new Annotation(annotation);
            annotation.setDimensions(f9, f10, f11, f12);
            PdfAnnotation pdfAnnotation = PdfAnnotationsImp.convertAnnotation(this.writer, annotation, new Rectangle(f9, f10, f11, f12));
            if (pdfAnnotation == null) {
                return;
            }
            this.a(pdfAnnotation);
            return;
        }
        catch (Exception exception) {
            throw new DocumentException(exception);
        }
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean bl2) {
        this.content.reset();
        if (bl2) {
            this.sanityCheck();
        }
        this.state = new a();
    }

    public void beginText() {
        if (this.d) {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.begin.end.text.operators"));
        }
        this.d = true;
        this.state.d = 0.0f;
        this.state.e = 0.0f;
        this.g = null;
        this.content.append("BT").append_i(this.separator);
    }

    public void endText() {
        if (!this.d) {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.begin.end.text.operators"));
        }
        this.d = false;
        this.content.append("ET").append_i(this.separator);
    }

    public void saveState() {
        this.content.append("q").append_i(this.separator);
        if (this.state != null) {
            this.stateList.add(new a(this.state));
        }
    }

    public void restoreState() {
        this.content.append("Q").append_i(this.separator);
        int n2 = this.stateList.size() - 1;
        if (n2 < 0) {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.save.restore.state.operators"));
        }
        if (this.stateList.get(n2) != null) {
            a a2 = this.stateList.get(n2);
            a a3 = this.state;
            a3.a(a2);
        }
        this.stateList.remove(n2);
    }

    public void setCharacterSpacing(float f2) {
        if (this.state != null) {
            this.state.h = f2;
        }
        this.content.append(f2).append(" Tc").append_i(this.separator);
    }

    public void setWordSpacing(float f2) {
        if (this.state != null) {
            this.state.i = f2;
        }
        this.content.append(f2).append(" Tw").append_i(this.separator);
    }

    public void setHorizontalScaling(float f2) {
        if (this.state != null) {
            this.state.g = f2;
        }
        this.content.append(f2).append(" Tz").append_i(this.separator);
    }

    public void setLeading(float f2) {
        if (this.state != null) {
            this.state.f = f2;
        }
        this.content.append(f2).append(" TL").append_i(this.separator);
    }

    public void setFontAndSize(BaseFont object, float f2) {
        this.checkWriter();
        if (f2 < 1.0E-4f && f2 > -1.0E-4f) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("font.size.too.small.1", String.valueOf(f2)));
        }
        this.state.c = f2;
        this.state.a = this.writer.a((BaseFont)object);
        object = this.b();
        Object object2 = this.state.a;
        Object object3 = object2 = ((d)object2).b;
        object2 = this.state.a;
        object2 = ((e)object).a((PdfName)object3, ((d)object2).a);
        this.content.append(((PdfObject)object2).getBytes()).append(' ').append(f2).append(" Tf").append_i(this.separator);
    }

    public void setTextRenderingMode(int n2) {
        this.content.append(n2).append(" Tr").append_i(this.separator);
    }

    public void setTextRise(float f2) {
        this.content.append(f2).append(" Ts").append_i(this.separator);
    }

    private void a(String object) {
        if (this.state.a == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("font.and.size.must.be.set.before.writing.any.text"));
        }
        byte[] byArray = this.state.a.a((String)object, this.getPdfDocument().getDocumentLanguage());
        object = byArray;
        PdfContentByte.a(byArray, this.content);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void showText(String object) {
        if (this.state.a == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("font.and.size.must.be.set.before.writing.any.text"));
        }
        Object object2 = this.state.a;
        object2 = ((d)object2).c;
        if (!LayoutProcessor.supportsFont((BaseFont)object2)) {
            this.showTextBasic((String)object);
            return;
        }
        object = LayoutProcessor.showText(this, (BaseFont)object2, this.state.c, (String)object);
        if (this.g == null) {
            this.g = object;
            return;
        }
        this.g.setLocation(this.g.getX() + ((Point2D)object).getX(), this.g.getY() + ((Point2D)object).getY());
    }

    public void showTextBasic(String string) {
        this.a(string);
        this.content.append("Tj").append_i(this.separator);
    }

    public void showText(GlyphVector glyphVector) {
        this.showText(glyphVector, 0, glyphVector.getNumGlyphs());
    }

    public void showText(GlyphVector object, int n2, int n3) {
        if (this.state.a == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("font.and.size.must.be.set.before.writing.any.text"));
        }
        byte[] byArray = this.state.a.a((GlyphVector)object, n2, n3);
        object = byArray;
        PdfContentByte.a(byArray, this.content);
        this.content.append("Tj").append_i(this.separator);
    }

    public static PdfTextArray getKernArray(String object, BaseFont baseFont) {
        PdfTextArray pdfTextArray = new PdfTextArray();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = ((String)object).length() - 1;
        object = ((String)object).toCharArray();
        if (n2 >= 0) {
            stringBuilder.append((char[])object, 0, 1);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object[i2 + 1];
            int n3 = baseFont.getKerning((int)object[i2], (int)object2);
            if (n3 == 0) {
                stringBuilder.append((char)object2);
                continue;
            }
            pdfTextArray.add(stringBuilder.toString());
            stringBuilder.setLength(0);
            stringBuilder.append((char[])object, i2 + 1, 1);
            pdfTextArray.add(-n3);
        }
        pdfTextArray.add(stringBuilder.toString());
        return pdfTextArray;
    }

    public void showTextKerned(String string) {
        if (this.state.a == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("font.and.size.must.be.set.before.writing.any.text"));
        }
        Object object = this.state.a;
        object = ((d)object).c;
        if (((BaseFont)object).hasKernPairs()) {
            this.showText(PdfContentByte.getKernArray(string, (BaseFont)object));
            return;
        }
        this.showText(string);
    }

    public void newlineShowText(String string) {
        this.state.e -= this.state.f;
        this.a(string);
        this.content.append("'").append_i(this.separator);
    }

    public void newlineShowText(float f2, float f3, String string) {
        this.state.e -= this.state.f;
        this.content.append(f2).append(' ').append(f3);
        this.a(string);
        this.content.append("\"").append_i(this.separator);
        this.state.h = f3;
        this.state.i = f2;
    }

    public void setTextMatrix(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.state.d = f6;
        this.state.e = f7;
        this.content.append(f2).append(' ').append(f3).append_i(32).append(f4).append_i(32).append(f5).append_i(32).append(f6).append_i(32).append(f7).append(" Tm").append_i(this.separator);
    }

    public void setTextMatrix(float f2, float f3) {
        this.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, f2, f3);
    }

    public void moveText(float f2, float f3) {
        if (this.g != null) {
            f2 = (float)((double)f2 + this.g.getX());
            f3 = (float)((double)f3 + this.g.getY());
            this.g = null;
        }
        this.a(f2, f3);
    }

    final void a(float f2, float f3) {
        this.state.d += f2;
        this.state.e += f3;
        this.content.append(f2).append(' ').append(f3).append(" Td").append_i(this.separator);
    }

    public void moveTextWithLeading(float f2, float f3) {
        if (this.g != null) {
            f2 = (float)((double)f2 + this.g.getX());
            f3 = (float)((double)f3 + this.g.getY());
            this.g = null;
        }
        this.state.d += f2;
        this.state.e += f3;
        this.state.f = -f3;
        this.content.append(f2).append(' ').append(f3).append(" TD").append_i(this.separator);
    }

    public void newlineText() {
        if (this.state != null) {
            this.state.e -= this.state.f;
        }
        this.content.append("T*").append_i(this.separator);
    }

    final int a() {
        return this.content.size();
    }

    static byte[] a(byte[] byArray) {
        ByteBuffer byteBuffer = new ByteBuffer();
        PdfContentByte.a(byArray, byteBuffer);
        return byteBuffer.toByteArray();
    }

    private static void a(byte[] byArray, ByteBuffer byteBuffer) {
        byteBuffer.append_i(40);
        block8: for (byte by : byArray) {
            switch (by) {
                case 13: {
                    byteBuffer.append("\\r");
                    continue block8;
                }
                case 10: {
                    byteBuffer.append("\\n");
                    continue block8;
                }
                case 9: {
                    byteBuffer.append("\\t");
                    continue block8;
                }
                case 8: {
                    byteBuffer.append("\\b");
                    continue block8;
                }
                case 12: {
                    byteBuffer.append("\\f");
                    continue block8;
                }
                case 40: 
                case 41: 
                case 92: {
                    byteBuffer.append_i(92).append_i(by);
                    continue block8;
                }
                default: {
                    byteBuffer.append_i(by);
                }
            }
        }
        byteBuffer.append(")");
    }

    public void addOutline(PdfOutline object, String object2) {
        this.checkWriter();
        String string = object2;
        object2 = object;
        object = this.pdf;
        ((PdfDocument)object).a(string, ((PdfOutline)object2).getPdfDestination());
    }

    public PdfOutline getRootOutline() {
        this.checkWriter();
        return this.pdf.getRootOutline();
    }

    public float getEffectiveStringWidth(String string, boolean bl2) {
        Object object = this.state.a;
        object = ((d)object).c;
        float f2 = bl2 ? ((BaseFont)object).getWidthPointKerned(string, this.state.c) : ((BaseFont)object).getWidthPoint(string, this.state.c);
        if (this.state.h != 0.0f && string.length() > 1) {
            f2 += this.state.h * (float)(string.length() - 1);
        }
        int n2 = ((BaseFont)object).getFontType();
        if (this.state.i != 0.0f && (n2 == 0 || n2 == 1 || n2 == 5)) {
            for (n2 = 0; n2 < string.length() - 1; ++n2) {
                if (string.charAt(n2) != ' ') continue;
                f2 += this.state.i;
            }
        }
        if ((double)this.state.g != 100.0) {
            f2 = f2 * this.state.g / 100.0f;
        }
        return f2;
    }

    public void showTextAligned(int n2, String string, float f2, float f3, float f4) {
        this.a(n2, string, f2, f3, f4, false);
    }

    private void a(int n2, String string, float f2, float f3, float f4, boolean bl2) {
        if (this.state.a == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("font.and.size.must.be.set.before.writing.any.text"));
        }
        if (f4 == 0.0f) {
            switch (n2) {
                case 1: {
                    f2 -= this.getEffectiveStringWidth(string, bl2) / 2.0f;
                    break;
                }
                case 2: {
                    f2 -= this.getEffectiveStringWidth(string, bl2);
                }
            }
            this.setTextMatrix(f2, f3);
            if (bl2) {
                this.showTextKerned(string);
                return;
            }
            this.showText(string);
            return;
        }
        double d2 = (double)f4 * Math.PI / 180.0;
        f4 = (float)Math.cos(d2);
        float f5 = (float)Math.sin(d2);
        switch (n2) {
            case 1: {
                float f6 = this.getEffectiveStringWidth(string, bl2) / 2.0f;
                f2 -= f6 * f4;
                f3 -= f6 * f5;
                break;
            }
            case 2: {
                float f7 = this.getEffectiveStringWidth(string, bl2);
                f2 -= f7 * f4;
                f3 -= f7 * f5;
            }
        }
        float f8 = f5;
        this.setTextMatrix(f4, f8, -f8, f4, f2, f3);
        if (bl2) {
            this.showTextKerned(string);
        } else {
            this.showText(string);
        }
        this.setTextMatrix(0.0f, 0.0f);
    }

    public void showTextAlignedKerned(int n2, String string, float f2, float f3, float f4) {
        this.a(n2, string, f2, f3, f4, true);
    }

    public void concatCTM(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.content.append(f2).append(' ').append(f3).append(' ').append(f4).append(' ');
        this.content.append(f5).append(' ').append(f6).append(' ').append(f7).append(" cm").append_i(this.separator);
    }

    public static List<float[]> bezierArc(float f2, float f3, float f4, float f5, float f6, float f7) {
        int n2;
        float f8;
        if (f2 > f4) {
            f8 = f2;
            f2 = f4;
            f4 = f8;
        }
        if (f5 > f3) {
            f8 = f3;
            f3 = f5;
            f5 = f8;
        }
        if (Math.abs(f7) <= 90.0f) {
            n2 = 1;
        } else {
            n2 = (int)Math.ceil(Math.abs(f7) / 90.0f);
            f7 /= (float)n2;
        }
        float f9 = (f2 + f4) / 2.0f;
        float f10 = (f3 + f5) / 2.0f;
        f2 = (f4 - f2) / 2.0f;
        f3 = (f5 - f3) / 2.0f;
        f4 = (float)((double)f7 * Math.PI / 360.0);
        f4 = Math.abs((float)(1.3333333333333333 * (1.0 - Math.cos(f4)) / Math.sin(f4)));
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        for (int i2 = 0; i2 < n2; ++i2) {
            float f11 = (float)((double)(f6 + (float)i2 * f7) * Math.PI / 180.0);
            float f12 = (float)((double)(f6 + (float)(i2 + 1) * f7) * Math.PI / 180.0);
            float f13 = (float)Math.cos(f11);
            float f14 = (float)Math.cos(f12);
            f11 = (float)Math.sin(f11);
            f12 = (float)Math.sin(f12);
            if (f7 > 0.0f) {
                arrayList.add(new float[]{f9 + f2 * f13, f10 - f3 * f11, f9 + f2 * (f13 - f4 * f11), f10 - f3 * (f11 + f4 * f13), f9 + f2 * (f14 + f4 * f12), f10 - f3 * (f12 - f4 * f14), f9 + f2 * f14, f10 - f3 * f12});
                continue;
            }
            arrayList.add(new float[]{f9 + f2 * f13, f10 - f3 * f11, f9 + f2 * (f13 + f4 * f11), f10 - f3 * (f11 - f4 * f13), f9 + f2 * (f14 - f4 * f12), f10 - f3 * (f12 + f4 * f14), f9 + f2 * f14, f10 - f3 * f12});
        }
        return arrayList;
    }

    public void arc(float f2, float f3, float f4, float f5, float f6, float f7) {
        List<float[]> list = PdfContentByte.bezierArc(f2, f3, f4, f5, f6, f7);
        if (list.isEmpty()) {
            return;
        }
        float[] fArray2 = list.get(0);
        this.moveTo(fArray2[0], fArray2[1]);
        for (float[] fArray2 : list) {
            this.curveTo(fArray2[2], fArray2[3], fArray2[4], fArray2[5], fArray2[6], fArray2[7]);
        }
    }

    public void ellipse(float f2, float f3, float f4, float f5) {
        this.arc(f2, f3, f4, f5, 0.0f, 360.0f);
    }

    public PdfPatternPainter createPattern(float f2, float f3, float f4, float f5) {
        this.checkWriter();
        if (f4 == 0.0f || f5 == 0.0f) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("xstep.or.ystep.can.not.be.zero"));
        }
        PdfPatternPainter pdfPatternPainter = new PdfPatternPainter(this.writer);
        pdfPatternPainter.setWidth(f2);
        pdfPatternPainter.setHeight(f3);
        pdfPatternPainter.setXStep(f4);
        pdfPatternPainter.setYStep(f5);
        this.writer.a(pdfPatternPainter);
        return pdfPatternPainter;
    }

    public PdfPatternPainter createPattern(float f2, float f3) {
        return this.createPattern(f2, f3, f2, f3);
    }

    public PdfPatternPainter createPattern(float f2, float f3, float f4, float f5, Color object) {
        this.checkWriter();
        if (f4 == 0.0f || f5 == 0.0f) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("xstep.or.ystep.can.not.be.zero"));
        }
        object = new PdfPatternPainter(this.writer, (Color)object);
        ((PdfTemplate)object).setWidth(f2);
        ((PdfTemplate)object).setHeight(f3);
        ((PdfPatternPainter)object).setXStep(f4);
        ((PdfPatternPainter)object).setYStep(f5);
        this.writer.a((PdfPatternPainter)object);
        return object;
    }

    public PdfPatternPainter createPattern(float f2, float f3, Color color) {
        return this.createPattern(f2, f3, f2, f3, color);
    }

    public PdfTemplate createTemplate(float f2, float f3) {
        PdfContentByte pdfContentByte = null;
        float f4 = f3;
        f3 = f2;
        pdfContentByte = this;
        pdfContentByte.checkWriter();
        PdfTemplate pdfTemplate = new PdfTemplate(pdfContentByte.writer);
        pdfTemplate.setWidth(f3);
        pdfTemplate.setHeight(f4);
        pdfContentByte.writer.a(pdfTemplate, null);
        return pdfTemplate;
    }

    public PdfAppearance createAppearance(float f2, float f3) {
        PdfContentByte pdfContentByte = null;
        float f4 = f3;
        f3 = f2;
        pdfContentByte = this;
        pdfContentByte.checkWriter();
        PdfAppearance pdfAppearance = new PdfAppearance(pdfContentByte.writer);
        pdfAppearance.setWidth(f3);
        pdfAppearance.setHeight(f4);
        pdfContentByte.writer.a(pdfAppearance, null);
        return pdfAppearance;
    }

    public void addPSXObject(PdfPSXObject pdfPSXObject) {
        this.checkWriter();
        PdfName pdfName = this.writer.a(pdfPSXObject, null);
        e e2 = this.b();
        pdfName = e2.b(pdfName, pdfPSXObject.getIndirectReference());
        this.content.append(pdfName.getBytes()).append(" Do").append_i(this.separator);
    }

    public void addTemplate(PdfTemplate pdfTemplate, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.checkWriter();
        Object object = pdfTemplate;
        if (((PdfTemplate)object).getType() == 3) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.use.of.a.pattern.a.template.was.expected"));
        }
        object = this.writer.a(pdfTemplate, null);
        e e2 = this.b();
        object = e2.b((PdfName)object, pdfTemplate.getIndirectReference());
        this.content.append("q ");
        this.content.append(f2).append(' ');
        this.content.append(f3).append(' ');
        this.content.append(f4).append(' ');
        this.content.append(f5).append(' ');
        this.content.append(f6).append(' ');
        this.content.append(f7).append(" cm ");
        this.content.append(((PdfObject)object).getBytes()).append(" Do Q").append_i(this.separator);
    }

    final void a(PRIndirectReference pRIndirectReference, PdfName pdfName, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.checkWriter();
        e e2 = this.b();
        pdfName = e2.b(pdfName, pRIndirectReference);
        this.content.append("q ");
        this.content.append(f2).append(' ');
        this.content.append(0.0f).append(' ');
        this.content.append(0.0f).append(' ');
        this.content.append(f5).append(' ');
        this.content.append(f6).append(' ');
        this.content.append(f7).append(" cm ");
        this.content.append(pdfName.getBytes()).append(" Do Q").append_i(this.separator);
    }

    public void addTemplate(PdfTemplate pdfTemplate, float f2, float f3) {
        this.addTemplate(pdfTemplate, 1.0f, 0.0f, 0.0f, 1.0f, f2, f3);
    }

    public void setCMYKColorFill(int n2, int n3, int n4, int n5) {
        this.a(n2, n3, n4, n5);
        this.content.append(" k").append_i(this.separator);
    }

    public void setCMYKColorStroke(int n2, int n3, int n4, int n5) {
        this.a(n2, n3, n4, n5);
        this.content.append(" K").append_i(this.separator);
    }

    public void setRGBColorFill(int n2, int n3, int n4) {
        this.setRGBColorFill(n2, n3, n4, 255);
    }

    public void setRGBColorFill(int n2, int n3, int n4, int n5) {
        this.b(new RGBColor(n2, n3, n4, n5));
        this.a(n2, n3, n4);
        this.content.append(" rg").append_i(this.separator);
    }

    public void setRGBColorStroke(int n2, int n3, int n4) {
        this.setRGBColorStroke(n2, n3, n4, 255);
    }

    public void setRGBColorStroke(int n2, int n3, int n4, int n5) {
        this.a(new RGBColor(n2, n3, n4, n5));
        this.a(n2, n3, n4);
        this.content.append(" RG").append_i(this.separator);
    }

    public void setColorStroke(Color color) {
        PdfXConformanceImp.checkPDFXConformance(this.writer, 1, color);
        int n2 = ExtendedColor.getType(color);
        switch (n2) {
            case 1: {
                color = (GrayColor)color;
                this.setGrayStroke(((GrayColor)color).getGray(), color.getAlpha());
                return;
            }
            case 2: {
                color = (CMYKColor)color;
                this.setCMYKColorStrokeF(((CMYKColor)color).getCyan(), ((CMYKColor)color).getMagenta(), ((CMYKColor)color).getYellow(), ((CMYKColor)color).getBlack(), color.getAlpha());
                return;
            }
            case 3: {
                color = (SpotColor)color;
                this.setColorStroke(((SpotColor)color).getPdfSpotColor(), ((SpotColor)color).getTint());
                return;
            }
            case 4: {
                color = (PatternColor)color;
                this.setPatternStroke(((PatternColor)color).getPainter());
                return;
            }
            case 5: {
                color = (ShadingColor)color;
                this.setShadingStroke(((ShadingColor)color).getPdfShadingPattern());
                return;
            }
        }
        this.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private void a(ExtendedColor extendedColor) {
        if (this.f != extendedColor.getAlpha()) {
            PdfGState pdfGState = new PdfGState();
            pdfGState.setStrokeOpacity((float)extendedColor.getAlpha() / 255.0f);
            this.setGState(pdfGState);
            this.f = extendedColor.getAlpha();
        }
        if (this.state != null) {
            this.state.k = extendedColor;
        }
    }

    public void setColorFill(Color color) {
        PdfXConformanceImp.checkPDFXConformance(this.writer, 1, color);
        int n2 = ExtendedColor.getType(color);
        switch (n2) {
            case 1: {
                GrayColor grayColor = (GrayColor)color;
                this.setGrayFill(grayColor.getGray(), (float)color.getAlpha() / 255.0f);
                return;
            }
            case 2: {
                CMYKColor cMYKColor = (CMYKColor)color;
                this.setCMYKColorFillF(cMYKColor.getCyan(), cMYKColor.getMagenta(), cMYKColor.getYellow(), cMYKColor.getBlack(), (float)cMYKColor.getAlpha() / 255.0f);
                return;
            }
            case 3: {
                SpotColor spotColor = (SpotColor)color;
                this.setColorFill(spotColor.getPdfSpotColor(), spotColor.getTint());
                return;
            }
            case 4: {
                PatternColor patternColor = (PatternColor)color;
                this.setPatternFill(patternColor.getPainter());
                return;
            }
            case 5: {
                ShadingColor shadingColor = (ShadingColor)color;
                this.setShadingFill(shadingColor.getPdfShadingPattern());
                return;
            }
        }
        this.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private void b(ExtendedColor extendedColor) {
        if (this.e != extendedColor.getAlpha()) {
            PdfGState pdfGState = new PdfGState();
            pdfGState.setFillOpacity((float)extendedColor.getAlpha() / 255.0f);
            this.setGState(pdfGState);
            this.e = extendedColor.getAlpha();
        }
        if (this.state != null) {
            this.state.j = extendedColor;
        }
    }

    public void setColorFill(PdfSpotColor object, float f2) {
        this.checkWriter();
        this.b(new SpotColor((PdfSpotColor)object, f2));
        this.state.b = this.writer.a((PdfSpotColor)object);
        object = this.b();
        Object object2 = this.state.b;
        Object object3 = object2 = ((b)object2).b;
        object2 = this.state.b;
        object2 = ((e)object).c((PdfName)object3, ((b)object2).a);
        this.content.append(((PdfObject)object2).getBytes()).append(" cs ").append(f2).append(" scn").append_i(this.separator);
    }

    public void setColorStroke(PdfSpotColor object, float f2) {
        this.checkWriter();
        this.a(new SpotColor((PdfSpotColor)object, f2));
        this.state.b = this.writer.a((PdfSpotColor)object);
        object = this.b();
        Object object2 = this.state.b;
        Object object3 = object2 = ((b)object2).b;
        object2 = this.state.b;
        object2 = ((e)object).c((PdfName)object3, ((b)object2).a);
        this.content.append(((PdfObject)object2).getBytes()).append(" CS ").append(f2).append(" SCN").append_i(this.separator);
    }

    public void setPatternFill(PdfPatternPainter pdfPatternPainter) {
        if (pdfPatternPainter.isStencil()) {
            PdfPatternPainter pdfPatternPainter2 = pdfPatternPainter;
            this.setPatternFill(pdfPatternPainter2, pdfPatternPainter2.getDefaultColor());
            return;
        }
        this.checkWriter();
        this.b(new PatternColor(pdfPatternPainter));
        e e2 = this.b();
        PdfName pdfName = this.writer.a(pdfPatternPainter);
        pdfName = e2.e(pdfName, pdfPatternPainter.getIndirectReference());
        this.content.append(PdfName.PATTERN.getBytes()).append(" cs ").append(pdfName.getBytes()).append(" scn").append_i(this.separator);
    }

    private void a(Color color, float f2) {
        PdfXConformanceImp.checkPDFXConformance(this.writer, 1, color);
        int n2 = ExtendedColor.getType(color);
        switch (n2) {
            case 0: {
                this.content.append((float)color.getRed() / 255.0f);
                this.content.append(' ');
                this.content.append((float)color.getGreen() / 255.0f);
                this.content.append(' ');
                this.content.append((float)color.getBlue() / 255.0f);
                return;
            }
            case 1: {
                this.content.append(((GrayColor)color).getGray());
                return;
            }
            case 2: {
                color = (CMYKColor)color;
                this.content.append(((CMYKColor)color).getCyan()).append(' ').append(((CMYKColor)color).getMagenta());
                this.content.append(' ').append(((CMYKColor)color).getYellow()).append(' ').append(((CMYKColor)color).getBlack());
                return;
            }
            case 3: {
                this.content.append(f2);
                return;
            }
        }
        throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.color.type"));
    }

    public void setPatternFill(PdfPatternPainter pdfPatternPainter, Color color) {
        if (ExtendedColor.getType(color) == 3) {
            Color color2 = color;
            this.setPatternFill(pdfPatternPainter, color2, ((SpotColor)color2).getTint());
            return;
        }
        this.setPatternFill(pdfPatternPainter, color, 0.0f);
    }

    public void setPatternFill(PdfPatternPainter object, Color color, float f2) {
        this.checkWriter();
        if (!((PdfPatternPainter)object).isStencil()) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("an.uncolored.pattern.was.expected"));
        }
        this.b(new RGBColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        Object object2 = this.b();
        PdfName pdfName = this.writer.a((PdfPatternPainter)object);
        pdfName = ((e)object2).e(pdfName, ((PdfTemplate)object).getIndirectReference());
        object = this.writer.a(color);
        e e2 = object2;
        Object object3 = object;
        object2 = object3;
        object2 = object;
        object = e2.c(((b)object3).b, ((b)object2).a);
        this.content.append(((PdfObject)object).getBytes()).append(" cs").append_i(this.separator);
        this.a(color, f2);
        this.content.append(' ').append(pdfName.getBytes()).append(" scn").append_i(this.separator);
    }

    public void setPatternStroke(PdfPatternPainter pdfPatternPainter, Color color) {
        if (ExtendedColor.getType(color) == 3) {
            Color color2 = color;
            this.setPatternStroke(pdfPatternPainter, color2, ((SpotColor)color2).getTint());
            return;
        }
        this.setPatternStroke(pdfPatternPainter, color, 0.0f);
    }

    public void setPatternStroke(PdfPatternPainter object, Color color, float f2) {
        this.checkWriter();
        if (!((PdfPatternPainter)object).isStencil()) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("an.uncolored.pattern.was.expected"));
        }
        this.a(new PatternColor((PdfPatternPainter)object));
        Object object2 = this.b();
        PdfName pdfName = this.writer.a((PdfPatternPainter)object);
        pdfName = ((e)object2).e(pdfName, ((PdfTemplate)object).getIndirectReference());
        object = this.writer.a(color);
        e e2 = object2;
        Object object3 = object;
        object2 = object3;
        object2 = object;
        object = e2.c(((b)object3).b, ((b)object2).a);
        this.content.append(((PdfObject)object).getBytes()).append(" CS").append_i(this.separator);
        this.a(color, f2);
        this.content.append(' ').append(pdfName.getBytes()).append(" SCN").append_i(this.separator);
    }

    public void setPatternStroke(PdfPatternPainter pdfPatternPainter) {
        if (pdfPatternPainter.isStencil()) {
            PdfPatternPainter pdfPatternPainter2 = pdfPatternPainter;
            this.setPatternStroke(pdfPatternPainter2, pdfPatternPainter2.getDefaultColor());
            return;
        }
        this.checkWriter();
        this.a(new PatternColor(pdfPatternPainter));
        e e2 = this.b();
        PdfName pdfName = this.writer.a(pdfPatternPainter);
        pdfName = e2.e(pdfName, pdfPatternPainter.getIndirectReference());
        this.content.append(PdfName.PATTERN.getBytes()).append(" CS ").append(pdfName.getBytes()).append(" SCN").append_i(this.separator);
    }

    public void paintShading(PdfShading object) {
        this.writer.a((PdfShading)object);
        Object object2 = this.b();
        PdfName pdfName = ((e)object2).d(((PdfShading)object).a(), ((PdfShading)object).b());
        this.content.append(pdfName.getBytes()).append(" sh").append_i(this.separator);
        object = ((PdfShading)object).e();
        if (object != null) {
            e e2 = object2;
            Object object3 = object;
            object2 = object3;
            object2 = object;
            e2.c(((b)object3).b, ((b)object2).a);
        }
    }

    public void paintShading(PdfShadingPattern pdfShadingPattern) {
        this.paintShading(pdfShadingPattern.getShading());
    }

    public void setShadingFill(PdfShadingPattern object) {
        this.checkWriter();
        this.b(new ShadingColor((PdfShadingPattern)object));
        this.writer.a((PdfShadingPattern)object);
        Object object2 = this.b();
        PdfName pdfName = ((e)object2).e(((PdfShadingPattern)object).a(), ((PdfShadingPattern)object).b());
        this.content.append(PdfName.PATTERN.getBytes()).append(" cs ").append(pdfName.getBytes()).append(" scn").append_i(this.separator);
        object = ((PdfShadingPattern)object).d();
        if (object != null) {
            e e2 = object2;
            Object object3 = object;
            object2 = object3;
            object2 = object;
            e2.c(((b)object3).b, ((b)object2).a);
        }
    }

    public void setShadingStroke(PdfShadingPattern object) {
        this.checkWriter();
        this.a(new ShadingColor((PdfShadingPattern)object));
        this.writer.a((PdfShadingPattern)object);
        Object object2 = this.b();
        PdfName pdfName = ((e)object2).e(((PdfShadingPattern)object).a(), ((PdfShadingPattern)object).b());
        this.content.append(PdfName.PATTERN.getBytes()).append(" CS ").append(pdfName.getBytes()).append(" SCN").append_i(this.separator);
        object = ((PdfShadingPattern)object).d();
        if (object != null) {
            e e2 = object2;
            Object object3 = object;
            object2 = object3;
            object2 = object;
            e2.c(((b)object3).b, ((b)object2).a);
        }
    }

    protected void checkWriter() {
        if (this.writer == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("the.writer.in.pdfcontentbyte.is.null"));
        }
    }

    public void showText(PdfTextArray iterator) {
        if (this.state.a == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("font.and.size.must.be.set.before.writing.any.text"));
        }
        this.content.append("[");
        iterator = ((PdfTextArray)((Object)iterator)).a();
        boolean bl2 = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 instanceof String) {
                this.a((String)e2);
                bl2 = false;
                continue;
            }
            if (bl2) {
                this.content.append(' ');
            } else {
                bl2 = true;
            }
            this.content.append(((Float)e2).floatValue());
        }
        this.content.append("]TJ").append_i(this.separator);
    }

    public PdfWriter getPdfWriter() {
        return this.writer;
    }

    public PdfDocument getPdfDocument() {
        return this.pdf;
    }

    public void localGoto(String string, float f2, float f3, float f4, float f5) {
        this.pdf.a(string, f2, f3, f4, f5);
    }

    public boolean localDestination(String string, PdfDestination pdfDestination) {
        return this.pdf.a(string, pdfDestination);
    }

    public PdfContentByte getDuplicate() {
        return new PdfContentByte(this.writer);
    }

    public void remoteGoto(String string, String string2, float f2, float f3, float f4, float f5) {
        this.pdf.a(string, string2, f2, f3, f4, f5);
    }

    public void remoteGoto(String string, int n2, float f2, float f3, float f4, float f5) {
        this.pdf.a(string, n2, f2, f3, f4, f5);
    }

    public void roundRectangle(float f2, float f3, float f4, float f5, float f6) {
        if (f4 < 0.0f) {
            f2 += f4;
            f4 = -f4;
        }
        if (f5 < 0.0f) {
            f3 += f5;
            f5 = -f5;
        }
        if (f6 < 0.0f) {
            f6 = -f6;
        }
        this.moveTo(f2 + f6, f3);
        this.lineTo(f2 + f4 - f6, f3);
        this.curveTo(f2 + f4 - f6 * 0.4477f, f3, f2 + f4, f3 + f6 * 0.4477f, f2 + f4, f3 + f6);
        this.lineTo(f2 + f4, f3 + f5 - f6);
        this.curveTo(f2 + f4, f3 + f5 - f6 * 0.4477f, f2 + f4 - f6 * 0.4477f, f3 + f5, f2 + f4 - f6, f3 + f5);
        this.lineTo(f2 + f6, f3 + f5);
        this.curveTo(f2 + f6 * 0.4477f, f3 + f5, f2, f3 + f5 - f6 * 0.4477f, f2, f3 + f5 - f6);
        this.lineTo(f2, f3 + f6);
        this.curveTo(f2, f3 + f6 * 0.4477f, f2 + f6 * 0.4477f, f3, f2 + f6, f3);
    }

    public void setAction(PdfAction pdfAction, float f2, float f3, float f4, float f5) {
        this.pdf.a(pdfAction, f2, f3, f4, f5);
    }

    public void setLiteral(String string) {
        this.content.append(string);
    }

    public void setLiteral(char c2) {
        this.content.append(c2);
    }

    public void setLiteral(float f2) {
        this.content.append(f2);
    }

    public void drawRadioField(float f2, float f3, float f4, float f5, boolean bl2) {
        float f6;
        if (f2 > f4) {
            f6 = f2;
            f2 = f4;
            f4 = f6;
        }
        if (f3 > f5) {
            f6 = f3;
            f3 = f5;
            f5 = f6;
        }
        this.saveState();
        this.setLineWidth(1.0f);
        this.setLineCap(1);
        this.setColorStroke(new Color(192, 192, 192));
        this.arc(f2 + 1.0f, f3 + 1.0f, f4 - 1.0f, f5 - 1.0f, 0.0f, 360.0f);
        this.stroke();
        this.setLineWidth(1.0f);
        this.setLineCap(1);
        this.setColorStroke(new Color(160, 160, 160));
        this.arc(f2 + 0.5f, f3 + 0.5f, f4 - 0.5f, f5 - 0.5f, 45.0f, 180.0f);
        this.stroke();
        this.setLineWidth(1.0f);
        this.setLineCap(1);
        this.setColorStroke(new Color(0, 0, 0));
        this.arc(f2 + 1.5f, f3 + 1.5f, f4 - 1.5f, f5 - 1.5f, 45.0f, 180.0f);
        this.stroke();
        if (bl2) {
            this.setLineWidth(1.0f);
            this.setLineCap(1);
            this.setColorFill(new Color(0, 0, 0));
            this.arc(f2 + 4.0f, f3 + 4.0f, f4 - 4.0f, f5 - 4.0f, 0.0f, 360.0f);
            this.fill();
        }
        this.restoreState();
    }

    public void drawTextField(float f2, float f3, float f4, float f5) {
        float f6;
        if (f2 > f4) {
            f6 = f2;
            f2 = f4;
            f4 = f6;
        }
        if (f3 > f5) {
            f6 = f3;
            f3 = f5;
            f5 = f6;
        }
        this.saveState();
        this.setColorStroke(new Color(192, 192, 192));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.rectangle(f2, f3, f4 - f2, f5 - f3);
        this.stroke();
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.setColorFill(new Color(255, 255, 255));
        this.rectangle(f2 + 0.5f, f3 + 0.5f, f4 - f2 - 1.0f, f5 - f3 - 1.0f);
        this.fill();
        this.setColorStroke(new Color(192, 192, 192));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(f2 + 1.0f, f3 + 1.5f);
        this.lineTo(f4 - 1.5f, f3 + 1.5f);
        this.lineTo(f4 - 1.5f, f5 - 1.0f);
        this.stroke();
        this.setColorStroke(new Color(160, 160, 160));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(f2 + 1.0f, f3 + 1.0f);
        this.lineTo(f2 + 1.0f, f5 - 1.0f);
        this.lineTo(f4 - 1.0f, f5 - 1.0f);
        this.stroke();
        this.setColorStroke(new Color(0, 0, 0));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(f2 + 2.0f, f3 + 2.0f);
        this.lineTo(f2 + 2.0f, f5 - 2.0f);
        this.lineTo(f4 - 2.0f, f5 - 2.0f);
        this.stroke();
        this.restoreState();
    }

    public void drawButton(float f2, float f3, float f4, float f5, String string, BaseFont baseFont, float f6) {
        float f7;
        if (f2 > f4) {
            f7 = f2;
            f2 = f4;
            f4 = f7;
        }
        if (f3 > f5) {
            f7 = f3;
            f3 = f5;
            f5 = f7;
        }
        this.saveState();
        this.setColorStroke(new Color(0, 0, 0));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.rectangle(f2, f3, f4 - f2, f5 - f3);
        this.stroke();
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.setColorFill(new Color(192, 192, 192));
        this.rectangle(f2 + 0.5f, f3 + 0.5f, f4 - f2 - 1.0f, f5 - f3 - 1.0f);
        this.fill();
        this.setColorStroke(new Color(255, 255, 255));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(f2 + 1.0f, f3 + 1.0f);
        this.lineTo(f2 + 1.0f, f5 - 1.0f);
        this.lineTo(f4 - 1.0f, f5 - 1.0f);
        this.stroke();
        this.setColorStroke(new Color(160, 160, 160));
        this.setLineWidth(1.0f);
        this.setLineCap(0);
        this.moveTo(f2 + 1.0f, f3 + 1.0f);
        this.lineTo(f4 - 1.0f, f3 + 1.0f);
        this.lineTo(f4 - 1.0f, f5 - 1.0f);
        this.stroke();
        this.resetRGBColorFill();
        this.beginText();
        this.setFontAndSize(baseFont, f6);
        this.showTextAligned(1, string, f2 + (f4 - f2) / 2.0f, f3 + (f5 - f3 - f6) / 2.0f, 0.0f);
        this.endText();
        this.restoreState();
    }

    public Graphics2D createGraphicsShapes(float f2, float f3) {
        return new PdfGraphics2D(this, f2, f3, null, true, false, 0.0f);
    }

    public Graphics2D createPrinterGraphicsShapes(float f2, float f3, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, f2, f3, null, true, false, 0.0f, printerJob);
    }

    public Graphics2D createGraphics(float f2, float f3) {
        return new PdfGraphics2D(this, f2, f3, null, false, false, 0.0f);
    }

    public Graphics2D createPrinterGraphics(float f2, float f3, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, f2, f3, null, false, false, 0.0f, printerJob);
    }

    public Graphics2D createGraphics(float f2, float f3, boolean bl2, float f4) {
        return new PdfGraphics2D(this, f2, f3, null, false, bl2, f4);
    }

    public Graphics2D createPrinterGraphics(float f2, float f3, boolean bl2, float f4, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, f2, f3, null, false, bl2, f4, printerJob);
    }

    public Graphics2D createGraphicsShapes(float f2, float f3, boolean bl2, float f4) {
        return new PdfGraphics2D(this, f2, f3, null, true, bl2, f4);
    }

    public Graphics2D createPrinterGraphicsShapes(float f2, float f3, boolean bl2, float f4, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, f2, f3, null, true, bl2, f4, printerJob);
    }

    public Graphics2D createGraphics(float f2, float f3, FontMapper fontMapper) {
        return new PdfGraphics2D(this, f2, f3, fontMapper, false, false, 0.0f);
    }

    public Graphics2D createPrinterGraphics(float f2, float f3, FontMapper fontMapper, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, f2, f3, fontMapper, false, false, 0.0f, printerJob);
    }

    public Graphics2D createGraphics(float f2, float f3, FontMapper fontMapper, boolean bl2, float f4) {
        return new PdfGraphics2D(this, f2, f3, fontMapper, false, bl2, f4);
    }

    public Graphics2D createPrinterGraphics(float f2, float f3, FontMapper fontMapper, boolean bl2, float f4, PrinterJob printerJob) {
        return new PdfPrinterGraphics2D(this, f2, f3, fontMapper, false, bl2, f4, printerJob);
    }

    e b() {
        return this.pdf.g();
    }

    public void setGState(PdfGState pdfGState) {
        if (this.writer == null) {
            return;
        }
        Object object = this.writer.a(pdfGState);
        e e2 = this.b();
        object = e2.f((PdfName)object[0], (PdfIndirectReference)object[1]);
        if (this.state != null) {
            this.state.l = pdfGState;
        }
        this.content.append(((PdfObject)object).getBytes()).append(" gs").append_i(this.separator);
    }

    public void beginLayer(PdfOCG pdfOCG) {
        if (pdfOCG instanceof PdfLayer && ((PdfLayer)pdfOCG).a() != null) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("a.title.is.not.a.layer"));
        }
        if (this.layerDepth == null) {
            this.layerDepth = new ArrayList<Integer>();
        }
        if (pdfOCG instanceof PdfLayerMembership) {
            this.layerDepth.add(1);
            this.a(pdfOCG);
            return;
        }
        int n2 = 0;
        for (pdfOCG = (PdfLayer)pdfOCG; pdfOCG != null; pdfOCG = ((PdfLayer)pdfOCG).getParent()) {
            if (((PdfLayer)pdfOCG).a() != null) continue;
            this.a(pdfOCG);
            ++n2;
        }
        this.layerDepth.add(n2);
    }

    private void a(PdfOCG pdfOCG) {
        PdfOCG pdfOCG2 = pdfOCG;
        PdfName pdfName = (PdfName)this.writer.a(pdfOCG2, pdfOCG2.getRef())[0];
        e e2 = this.b();
        pdfName = e2.g(pdfName, pdfOCG.getRef());
        this.content.append("/OC ").append(pdfName.getBytes()).append(" BDC").append_i(this.separator);
    }

    public void endLayer() {
        int n2;
        if (this.layerDepth != null && !this.layerDepth.isEmpty()) {
            n2 = this.layerDepth.get(this.layerDepth.size() - 1);
            this.layerDepth.remove(this.layerDepth.size() - 1);
        } else {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.layer.operators"));
        }
        while (n2-- > 0) {
            this.content.append("EMC").append_i(this.separator);
        }
    }

    public void transform(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.content.append(dArray[0]).append(' ').append(dArray[1]).append(' ').append(dArray[2]).append(' ');
        this.content.append(dArray[3]).append(' ').append(dArray[4]).append(' ').append(dArray[5]).append(" cm").append_i(this.separator);
    }

    void a(PdfAnnotation pdfAnnotation) {
        this.writer.addAnnotation(pdfAnnotation);
    }

    public void setDefaultColorspace(PdfName pdfName, PdfObject pdfObject) {
        e e2 = this.b();
        e2.a(pdfName, pdfObject);
    }

    public void beginMarkedContentSequence(PdfStructureElement pdfStructureElement) {
        PdfDictionary pdfDictionary = new PdfDictionary();
        this.beginMarkedContentSequence(pdfStructureElement, pdfDictionary);
    }

    public void beginMarkedContentSequence(PdfStructureElement pdfStructureElement, PdfDictionary pdfDictionary) {
        PdfObject pdfObject = pdfStructureElement.get(PdfName.K);
        int n2 = this.pdf.d();
        if (pdfObject != null) {
            PdfArray pdfArray;
            if (pdfObject.isNumber()) {
                pdfArray = new PdfArray();
                pdfArray.add(pdfObject);
                pdfStructureElement.put(PdfName.K, pdfArray);
            } else if (pdfObject.isArray()) {
                pdfArray = (PdfArray)pdfObject;
                if (!pdfArray.getPdfObject(0).isNumber()) {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.structure.has.kids"));
                }
            } else {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("unknown.object.at.k.1", pdfObject.getClass().toString()));
            }
            pdfObject = new PdfDictionary(PdfName.MCR);
            ((PdfDictionary)pdfObject).put(PdfName.PG, this.writer.m());
            ((PdfDictionary)pdfObject).put(PdfName.MCID, new PdfNumber(n2));
            pdfArray.add(pdfObject);
            pdfStructureElement.a(this.writer.getPageNumber() - 1, -1);
        } else {
            pdfStructureElement.a(this.writer.getPageNumber() - 1, n2);
            pdfStructureElement.put(PdfName.PG, this.writer.m());
        }
        this.pdf.e();
        ++this.c;
        pdfDictionary.put(PdfName.MCID, new PdfNumber(n2));
        this.content.append(pdfStructureElement.get(PdfName.S).getBytes()).append(" ");
        try {
            ((PdfObject)pdfDictionary).toPdf(this.writer, this.content);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        this.content.append(" BDC").append_i(this.separator);
    }

    public void endMarkedContentSequence() {
        if (this.c == 0) {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.begin.end.marked.content.operators"));
        }
        --this.c;
        this.content.append("EMC").append_i(this.separator);
    }

    public void beginMarkedContentSequence(PdfName pdfObjectArray, PdfDictionary pdfObject, boolean bl2) {
        if (pdfObject == null) {
            this.content.append(pdfObjectArray.getBytes()).append(" BMC").append_i(this.separator);
            return;
        }
        this.content.append(pdfObjectArray.getBytes()).append(' ');
        if (bl2) {
            try {
                pdfObject.toPdf(this.writer, this.content);
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        } else {
            pdfObjectArray = this.writer.b((PdfDictionary)pdfObject) ? this.writer.a(pdfObject, null) : this.writer.a(pdfObject, this.writer.getPdfIndirectReference());
            pdfObject = (PdfName)pdfObjectArray[0];
            e e2 = this.b();
            pdfObject = e2.g((PdfName)pdfObject, (PdfIndirectReference)pdfObjectArray[1]);
            this.content.append(pdfObject.getBytes());
        }
        this.content.append(" BDC").append_i(this.separator);
        ++this.c;
    }

    public void beginMarkedContentSequence(PdfName pdfName) {
        this.beginMarkedContentSequence(pdfName, null, false);
    }

    public void sanityCheck() {
        if (this.c != 0) {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.marked.content.operators"));
        }
        if (this.d) {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.begin.end.text.operators"));
        }
        if (this.layerDepth != null && !this.layerDepth.isEmpty()) {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.layer.operators"));
        }
        if (!this.stateList.isEmpty()) {
            throw new IllegalPdfSyntaxException(MessageLocalization.getComposedMessage("unbalanced.save.restore.state.operators"));
        }
    }

    static {
        b.put(PdfName.BITSPERCOMPONENT, "/BPC ");
        b.put(PdfName.COLORSPACE, "/CS ");
        b.put(PdfName.DECODE, "/D ");
        b.put(PdfName.DECODEPARMS, "/DP ");
        b.put(PdfName.FILTER, "/F ");
        b.put(PdfName.HEIGHT, "/H ");
        b.put(PdfName.IMAGEMASK, "/IM ");
        b.put(PdfName.INTENT, "/Intent ");
        b.put(PdfName.INTERPOLATE, "/I ");
        b.put(PdfName.WIDTH, "/W ");
    }

    static class a {
        d a;
        b b;
        float c;
        protected float d = 0.0f;
        protected float e = 0.0f;
        protected float f = 0.0f;
        protected float g = 100.0f;
        protected float h = 0.0f;
        protected float i = 0.0f;
        protected ExtendedColor j = GrayColor.GRAYBLACK;
        protected ExtendedColor k = GrayColor.GRAYBLACK;
        protected PdfObject l = null;

        a() {
        }

        a(a a2) {
            this.a(a2);
        }

        final void a(a a2) {
            this.a = a2.a;
            this.b = a2.b;
            this.c = a2.c;
            this.d = a2.d;
            this.e = a2.e;
            this.f = a2.f;
            this.g = a2.g;
            this.h = a2.h;
            this.i = a2.i;
            this.j = a2.j;
            this.k = a2.k;
            this.l = a2.l;
        }
    }
}

