/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PdfContentParser {
    public static final int COMMAND_TYPE = 200;
    private PRTokeniser a;

    public PdfContentParser(PRTokeniser pRTokeniser) {
        this.a = pRTokeniser;
    }

    public List<PdfObject> parse(List<PdfObject> list) {
        PdfObject pdfObject;
        if (list == null) {
            list = new ArrayList<PdfObject>();
        } else {
            list.clear();
        }
        while ((pdfObject = this.readPRObject()) != null) {
            list.add(pdfObject);
            if (pdfObject.type() != 200) continue;
        }
        return list;
    }

    public PRTokeniser getTokeniser() {
        return this.a;
    }

    public void setTokeniser(PRTokeniser pRTokeniser) {
        this.a = pRTokeniser;
    }

    public PdfDictionary readDictionary() {
        PdfDictionary pdfDictionary = new PdfDictionary();
        while (true) {
            if (!this.nextValidToken()) {
                throw new IOException(MessageLocalization.getComposedMessage("unexpected.end.of.file"));
            }
            if (this.a.getTokenType() == 8) break;
            if (this.a.getTokenType() != 3) {
                throw new IOException(MessageLocalization.getComposedMessage("dictionary.key.is.not.a.name"));
            }
            PdfName pdfName = new PdfName(this.a.getStringValue(), false);
            PdfObject pdfObject = this.readPRObject();
            int n2 = pdfObject.type();
            if (-n2 == 8) {
                throw new IOException(MessageLocalization.getComposedMessage("unexpected.gt.gt"));
            }
            if (-n2 == 6) {
                throw new IOException(MessageLocalization.getComposedMessage("unexpected.close.bracket"));
            }
            pdfDictionary.put(pdfName, pdfObject);
        }
        return pdfDictionary;
    }

    public PdfArray readArray() {
        PdfObject pdfObject;
        int n2;
        PdfArray pdfArray = new PdfArray();
        while (-(n2 = (pdfObject = this.readPRObject()).type()) != 6) {
            if (-n2 == 8) {
                throw new IOException(MessageLocalization.getComposedMessage("unexpected.gt.gt"));
            }
            pdfArray.add(pdfObject);
        }
        return pdfArray;
    }

    public PdfObject readPRObject() {
        if (!this.nextValidToken()) {
            return null;
        }
        int n2 = this.a.getTokenType();
        switch (n2) {
            case 7: {
                PdfDictionary pdfDictionary = this.readDictionary();
                return pdfDictionary;
            }
            case 5: {
                return this.readArray();
            }
            case 2: {
                PdfString pdfString = new PdfString(this.a.getStringValue(), null).setHexWriting(this.a.isHexString());
                return pdfString;
            }
            case 3: {
                return new PdfName(this.a.getStringValue(), false);
            }
            case 1: {
                return new PdfNumber(this.a.getStringValue());
            }
            case 10: {
                return new PdfLiteral(200, this.a.getStringValue());
            }
        }
        return new PdfLiteral(-n2, this.a.getStringValue());
    }

    public boolean nextValidToken() {
        while (this.a.nextToken()) {
            if (this.a.getTokenType() == 4) continue;
            return true;
        }
        return false;
    }
}

