/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.e;
import com.lowagie.text.pdf.g;
import com.lowagie.text.pdf.k;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PdfCopy
extends PdfWriter {
    protected HashMap<RefKey, a> indirects;
    protected HashMap<PdfReader, HashMap<RefKey, a>> indirectMap;
    protected PdfReader reader;
    protected PdfIndirectReference acroForm;
    protected int[] namePtr = new int[]{0};
    private boolean a = true;
    protected PdfArray fieldArray;
    protected HashMap<PdfTemplate, Object> fieldTemplates;

    public PdfCopy(Document document, OutputStream outputStream) {
        super(new PdfDocument(), outputStream);
        this.document.setDocumentLanguage(document.getDocumentLanguage());
        document.addDocListener(this.pdf);
        this.pdf.addWriter(this);
        this.indirectMap = new HashMap();
    }

    public boolean isRotateContents() {
        return this.a;
    }

    public void setRotateContents(boolean bl2) {
        this.a = bl2;
    }

    @Override
    public PdfImportedPage getImportedPage(PdfReader pdfReader, int n2) {
        if (this.currentPdfReaderInstance != null) {
            k k2 = this.currentPdfReaderInstance;
            if (k2.c != pdfReader) {
                try {
                    k2 = this.currentPdfReaderInstance;
                    k2.c.close();
                    k2 = this.currentPdfReaderInstance;
                    k2.d.close();
                }
                catch (IOException iOException) {}
                this.currentPdfReaderInstance = pdfReader.getPdfReaderInstance(this);
            }
        } else {
            this.currentPdfReaderInstance = pdfReader.getPdfReaderInstance(this);
        }
        return this.currentPdfReaderInstance.a(n2);
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference pdfObject) {
        PdfIndirectReference pdfIndirectReference;
        Object object = new RefKey((PRIndirectReference)pdfObject);
        a a2 = this.indirects.get(object);
        if (a2 != null) {
            object = a2;
            pdfIndirectReference = ((a)object).a;
            object = a2;
            if (((a)object).b) {
                return pdfIndirectReference;
            }
        } else {
            pdfIndirectReference = this.body.a();
            a2 = new a(pdfIndirectReference);
            this.indirects.put((RefKey)object, a2);
        }
        if ((pdfObject = PdfReader.getPdfObjectRelease(pdfObject)) != null && pdfObject.isDictionary() && PdfName.PAGE.equals(object = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.TYPE)))) {
            return pdfIndirectReference;
        }
        object = a2;
        a2.b = true;
        pdfObject = this.copyObject(pdfObject);
        this.addToBody(pdfObject, pdfIndirectReference);
        return pdfIndirectReference;
    }

    protected PdfDictionary copyDictionary(PdfDictionary pdfDictionary) {
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.TYPE));
        for (PdfName pdfName : pdfDictionary.getKeys()) {
            PdfObject pdfObject2 = pdfDictionary.get(pdfName);
            if (PdfName.PAGE.equals(pdfObject) && (pdfName.equals(PdfName.B) || pdfName.equals(PdfName.PARENT))) continue;
            pdfDictionary2.put(pdfName, this.copyObject(pdfObject2));
        }
        return pdfDictionary2;
    }

    protected PdfStream copyStream(PRStream pRStream) {
        PRStream pRStream2 = new PRStream(pRStream, null);
        for (PdfName pdfName : pRStream.getKeys()) {
            PdfObject pdfObject = pRStream.get(pdfName);
            pRStream2.put(pdfName, this.copyObject(pdfObject));
        }
        return pRStream2;
    }

    protected PdfArray copyArray(PdfArray object) {
        PdfArray pdfArray = new PdfArray();
        for (PdfObject pdfObject : ((PdfArray)object).getElements()) {
            pdfArray.add(this.copyObject(pdfObject));
        }
        return pdfArray;
    }

    protected PdfObject copyObject(PdfObject object) {
        if (object == null) {
            return PdfNull.PDFNULL;
        }
        switch (((PdfObject)object).type) {
            case 6: {
                return this.copyDictionary((PdfDictionary)object);
            }
            case 10: {
                return this.copyIndirect((PRIndirectReference)object);
            }
            case 5: {
                return this.copyArray((PdfArray)object);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return object;
            }
            case 7: {
                return this.copyStream((PRStream)object);
            }
        }
        if (((PdfObject)object).type < 0) {
            if (((String)(object = ((PdfObject)object).toString())).equals("true") || ((String)object).equals("false")) {
                return new PdfBoolean((String)object);
            }
            return new PdfLiteral((String)object);
        }
        System.out.println("CANNOT COPY type " + ((PdfObject)object).type);
        return null;
    }

    protected int setFromIPage(PdfImportedPage object) {
        int n2 = ((PdfImportedPage)object).getPageNumber();
        this.currentPdfReaderInstance = ((PdfImportedPage)object).a;
        object = this.currentPdfReaderInstance;
        this.reader = ((k)object).c;
        PdfCopy pdfCopy = this;
        pdfCopy.setFromReader(pdfCopy.reader);
        return n2;
    }

    protected void setFromReader(PdfReader object) {
        this.reader = object;
        this.indirects = this.indirectMap.get(object);
        if (this.indirects == null) {
            this.indirects = new HashMap();
            this.indirectMap.put((PdfReader)object, this.indirects);
            object = ((PdfReader)object).getCatalog();
            object = ((PdfDictionary)object).get(PdfName.ACROFORM);
            if (object == null || ((PdfObject)object).type() != 10) {
                return;
            }
            object = (PRIndirectReference)object;
            if (this.acroForm == null) {
                this.acroForm = this.body.a();
            }
            this.indirects.put(new RefKey((PRIndirectReference)object), new a(this.acroForm));
        }
    }

    public void addPage(PdfImportedPage pdfImportedPage) {
        int n2 = this.setFromIPage(pdfImportedPage);
        PdfDictionary pdfDictionary = this.reader.getPageN(n2);
        Object object = this.reader.getPageOrigRef(n2);
        this.reader.releasePage(n2);
        Object object2 = new RefKey((PRIndirectReference)object);
        a a2 = this.indirects.get(object2);
        if (a2 != null) {
            object = a2;
            if (!((a)object).b) {
                object = a2;
                this.pageReferences.add(((a)object).a);
                object = a2;
                a2.b = true;
            }
        }
        object = this.m();
        if (a2 == null) {
            a2 = new a((PdfIndirectReference)object);
            this.indirects.put((RefKey)object2, a2);
        }
        object = a2;
        a2.b = true;
        object2 = this.copyDictionary(pdfDictionary);
        this.root.a((PdfDictionary)object2);
        ++this.currentPageNumber;
    }

    public void addPage(Rectangle object, int n2) {
        object = new PdfRectangle((Rectangle)object, n2);
        e e2 = new e();
        object = new PdfPage((PdfRectangle)object, new HashMap(), e2.a(), 0);
        ((PdfDictionary)object).put(PdfName.TABS, this.getTabs());
        this.root.a((PdfDictionary)object);
        ++this.currentPageNumber;
    }

    public void copyAcroForm(PdfReader object) {
        PdfIndirectReference pdfIndirectReference;
        this.setFromReader((PdfReader)object);
        object = ((PdfReader)object).getCatalog();
        PRIndirectReference pRIndirectReference = null;
        object = ((PdfDictionary)object).get(PdfName.ACROFORM);
        if (object != null && ((PdfObject)object).type() == 10) {
            pRIndirectReference = (PRIndirectReference)object;
        }
        if (pRIndirectReference == null) {
            return;
        }
        object = new RefKey(pRIndirectReference);
        a a2 = this.indirects.get(object);
        if (a2 != null) {
            object = a2;
            this.acroForm = pdfIndirectReference = ((a)object).a;
        } else {
            this.acroForm = pdfIndirectReference = this.body.a();
            a2 = new a(pdfIndirectReference);
            this.indirects.put((RefKey)object, a2);
        }
        object = a2;
        if (!((a)object).b) {
            object = a2;
            a2.b = true;
            object = this.copyDictionary((PdfDictionary)PdfReader.getPdfObject(pRIndirectReference));
            this.addToBody((PdfObject)object, pdfIndirectReference);
        }
    }

    @Override
    protected PdfDictionary getCatalog(PdfIndirectReference pdfObject) {
        try {
            pdfObject = this.pdf.a((PdfIndirectReference)pdfObject);
            if (this.fieldArray == null) {
                if (this.acroForm != null) {
                    ((PdfDictionary)pdfObject).put(PdfName.ACROFORM, this.acroForm);
                }
            } else {
                PdfObject pdfObject2 = pdfObject;
                PdfCopy pdfCopy = this;
                if (pdfCopy.fieldArray != null) {
                    Object object = new PdfDictionary();
                    ((PdfDictionary)pdfObject2).put(PdfName.ACROFORM, (PdfObject)object);
                    ((PdfDictionary)object).put(PdfName.FIELDS, pdfCopy.fieldArray);
                    ((PdfDictionary)object).put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
                    if (!pdfCopy.fieldTemplates.isEmpty()) {
                        pdfObject2 = new PdfDictionary();
                        ((PdfDictionary)object).put(PdfName.DR, pdfObject2);
                        for (Object e2 : pdfCopy.fieldTemplates.keySet()) {
                            PdfTemplate object22 = (PdfTemplate)e2;
                            PdfFormField.a((PdfDictionary)pdfObject2, (PdfDictionary)object22.c());
                        }
                        object = ((PdfDictionary)pdfObject2).getAsDict(PdfName.FONT);
                        if (object == null) {
                            object = new PdfDictionary();
                            ((PdfDictionary)pdfObject2).put(PdfName.FONT, (PdfObject)object);
                        }
                        if (!((PdfDictionary)object).contains(PdfName.HELV)) {
                            PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
                            pdfDictionary.put(PdfName.BASEFONT, PdfName.HELVETICA);
                            pdfDictionary.put(PdfName.ENCODING, PdfName.WIN_ANSI_ENCODING);
                            pdfDictionary.put(PdfName.NAME, PdfName.HELV);
                            pdfDictionary.put(PdfName.SUBTYPE, PdfName.TYPE1);
                            ((PdfDictionary)object).put(PdfName.HELV, pdfCopy.addToBody(pdfDictionary).getIndirectReference());
                        }
                        if (!((PdfDictionary)object).contains(PdfName.ZADB)) {
                            PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
                            pdfDictionary.put(PdfName.BASEFONT, PdfName.ZAPFDINGBATS);
                            pdfDictionary.put(PdfName.NAME, PdfName.ZADB);
                            pdfDictionary.put(PdfName.SUBTYPE, PdfName.TYPE1);
                            ((PdfDictionary)object).put(PdfName.ZADB, pdfCopy.addToBody(pdfDictionary).getIndirectReference());
                        }
                    }
                }
            }
            return pdfObject;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    @Override
    public void close() {
        if (this.open) {
            k k2 = this.currentPdfReaderInstance;
            ((Document)this.pdf).close();
            super.close();
            if (k2 != null) {
                try {
                    k k3 = k2;
                    k3.c.close();
                    k3 = k2;
                    k3.d.close();
                    return;
                }
                catch (IOException iOException) {}
            }
        }
    }

    public PdfIndirectReference add(PdfOutline pdfOutline) {
        return null;
    }

    @Override
    public void addAnnotation(PdfAnnotation pdfAnnotation) {
    }

    @Override
    final PdfIndirectReference a(PdfPage pdfPage, g g2) {
        return null;
    }

    @Override
    public void freeReader(PdfReader pdfReader) {
        this.indirectMap.remove(pdfReader);
        if (this.currentPdfReaderInstance != null) {
            k k2 = this.currentPdfReaderInstance;
            if (k2.c == pdfReader) {
                try {
                    k2 = this.currentPdfReaderInstance;
                    k2.c.close();
                    k2 = this.currentPdfReaderInstance;
                    k2.d.close();
                }
                catch (IOException iOException) {}
                this.currentPdfReaderInstance = null;
            }
        }
    }

    public PageStamp createPageStamp(PdfImportedPage object) {
        int n2 = ((PdfImportedPage)object).getPageNumber();
        object = ((PdfImportedPage)object).a;
        object = ((k)object).c;
        PdfDictionary pdfDictionary = ((PdfReader)object).getPageN(n2);
        return new PageStamp((PdfReader)object, pdfDictionary, this);
    }

    public static class StampContent
    extends PdfContentByte {
        private e a;

        StampContent(PdfWriter pdfWriter, e e2) {
            super(pdfWriter);
            this.a = e2;
        }

        @Override
        public PdfContentByte getDuplicate() {
            return new StampContent(this.writer, this.a);
        }

        @Override
        final e b() {
            return this.a;
        }
    }

    public static class PageStamp {
        private PdfDictionary a;
        private StampContent b;
        private StampContent c;
        private e d;
        private PdfReader e;
        private PdfCopy f;

        PageStamp(PdfReader pdfReader, PdfDictionary pdfDictionary, PdfCopy pdfCopy) {
            this.a = pdfDictionary;
            this.e = pdfReader;
            this.f = pdfCopy;
        }

        public PdfContentByte getUnderContent() {
            if (this.b == null) {
                if (this.d == null) {
                    this.d = new e();
                    PdfDictionary pdfDictionary = this.a.getAsDict(PdfName.RESOURCES);
                    this.d.a(pdfDictionary, this.f.namePtr);
                }
                this.b = new StampContent(this.f, this.d);
            }
            return this.b;
        }

        public PdfContentByte getOverContent() {
            if (this.c == null) {
                if (this.d == null) {
                    this.d = new e();
                    PdfDictionary pdfDictionary = this.a.getAsDict(PdfName.RESOURCES);
                    this.d.a(pdfDictionary, this.f.namePtr);
                }
                this.c = new StampContent(this.f, this.d);
            }
            return this.c;
        }

        public void alterContents() {
            if (this.c == null && this.b == null) {
                return;
            }
            PdfObject pdfObject = PdfReader.getPdfObject(this.a.get(PdfName.CONTENTS), this.a);
            if (pdfObject == null) {
                pdfObject = new PdfArray();
                this.a.put(PdfName.CONTENTS, pdfObject);
            } else if (pdfObject.isArray()) {
                pdfObject = (PdfArray)pdfObject;
            } else if (pdfObject.isStream()) {
                pdfObject = new PdfArray();
                ((PdfArray)pdfObject).add(this.a.get(PdfName.CONTENTS));
                this.a.put(PdfName.CONTENTS, pdfObject);
            } else {
                pdfObject = new PdfArray();
                this.a.put(PdfName.CONTENTS, pdfObject);
            }
            ByteBuffer byteBuffer = new ByteBuffer();
            if (this.b != null) {
                byteBuffer.append(g.a);
                PageStamp pageStamp = this;
                pageStamp.a(pageStamp.a, byteBuffer);
                byteBuffer.append(this.b.getInternalBuffer());
                byteBuffer.append(g.b);
            }
            if (this.c != null) {
                byteBuffer.append(g.a);
            }
            PdfObject pdfObject2 = new PdfStream(byteBuffer.toByteArray());
            pdfObject2.flateCompress(this.f.getCompressionLevel());
            pdfObject2 = this.f.addToBody(pdfObject2).getIndirectReference();
            ((PdfArray)pdfObject).addFirst(pdfObject2);
            byteBuffer.reset();
            if (this.c != null) {
                byteBuffer.append(' ');
                byteBuffer.append(g.b);
                byteBuffer.append(g.a);
                PageStamp pageStamp = this;
                pageStamp.a(pageStamp.a, byteBuffer);
                byteBuffer.append(this.c.getInternalBuffer());
                byteBuffer.append(g.b);
                pdfObject2 = new PdfStream(byteBuffer.toByteArray());
                pdfObject2.flateCompress(this.f.getCompressionLevel());
                ((PdfArray)pdfObject).add(this.f.addToBody(pdfObject2).getIndirectReference());
            }
            this.a.put(PdfName.RESOURCES, this.d.a());
        }

        private void a(PdfDictionary object, ByteBuffer byteBuffer) {
            if (!this.f.a) {
                return;
            }
            object = this.e.getPageSizeWithRotation((PdfDictionary)object);
            int n2 = ((Rectangle)object).getRotation();
            switch (n2) {
                case 90: {
                    byteBuffer.append(g.c);
                    byteBuffer.append(((Rectangle)object).getTop());
                    byteBuffer.append(' ').append('0').append(g.f);
                    return;
                }
                case 180: {
                    byteBuffer.append(g.d);
                    byteBuffer.append(((Rectangle)object).getRight());
                    byteBuffer.append(' ');
                    byteBuffer.append(((Rectangle)object).getTop());
                    byteBuffer.append(g.f);
                    return;
                }
                case 270: {
                    byteBuffer.append(g.e);
                    byteBuffer.append('0').append(' ');
                    byteBuffer.append(((Rectangle)object).getRight());
                    byteBuffer.append(g.f);
                }
            }
        }

        private void a(PdfFormField iterator, List<PdfAnnotation> list) {
            list.add((PdfAnnotation)((Object)iterator));
            iterator = ((PdfFormField)((Object)iterator)).getKidFields();
            if (iterator != null) {
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    PdfFormField pdfFormField = (PdfFormField)iterator.next();
                    this.a(pdfFormField, list);
                }
            }
        }

        public void addAnnotation(PdfAnnotation pdfAnnotation) {
            try {
                Object object;
                Object object2 = new ArrayList<PdfAnnotation>();
                if (pdfAnnotation.isForm()) {
                    object = (PdfFormField)pdfAnnotation;
                    if (((PdfFormField)object).getParent() != null) {
                        return;
                    }
                    this.a((PdfFormField)object, (List<PdfAnnotation>)object2);
                    if (this.f.fieldTemplates == null) {
                        this.f.fieldTemplates = new HashMap();
                    }
                } else {
                    object2.add(pdfAnnotation);
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    PdfAnnotation pdfAnnotation2;
                    pdfAnnotation = (PdfAnnotation)object.next();
                    pdfAnnotation = pdfAnnotation;
                    if (pdfAnnotation2.isForm()) {
                        if (!pdfAnnotation.isUsed() && (object2 = pdfAnnotation.getTemplates()) != null) {
                            this.f.fieldTemplates.putAll((Map<PdfTemplate, Object>)object2);
                        }
                        if (((PdfFormField)(object2 = (PdfFormField)pdfAnnotation)).getParent() == null) {
                            PdfIndirectReference pdfIndirectReference = ((PdfAnnotation)object2).getIndirectReference();
                            object2 = this;
                            if (((PageStamp)object2).f.fieldArray == null) {
                                ((PageStamp)object2).f.fieldArray = new PdfArray();
                            }
                            ((PageStamp)object2).f.fieldArray.add(pdfIndirectReference);
                        }
                    }
                    if (pdfAnnotation.isAnnotation()) {
                        object2 = PdfReader.getPdfObject(this.a.get(PdfName.ANNOTS), this.a);
                        if (object2 == null || !((PdfObject)object2).isArray()) {
                            object2 = new PdfArray();
                            this.a.put(PdfName.ANNOTS, (PdfObject)object2);
                        } else {
                            object2 = (PdfArray)object2;
                        }
                        ((PdfArray)object2).add(pdfAnnotation.getIndirectReference());
                        if (!(pdfAnnotation.isUsed() || (object2 = (PdfRectangle)pdfAnnotation.get(PdfName.RECT)) == null || ((PdfRectangle)object2).left() == 0.0f && ((PdfRectangle)object2).right() == 0.0f && ((PdfRectangle)object2).top() == 0.0f && ((PdfRectangle)object2).bottom() == 0.0f)) {
                            int n2 = PdfReader.a(this.a);
                            Rectangle rectangle = this.e.getPageSizeWithRotation(this.a);
                            switch (n2) {
                                case 90: {
                                    pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.getTop() - ((PdfRectangle)object2).bottom(), ((PdfRectangle)object2).left(), rectangle.getTop() - ((PdfRectangle)object2).top(), ((PdfRectangle)object2).right()));
                                    break;
                                }
                                case 180: {
                                    pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.getRight() - ((PdfRectangle)object2).left(), rectangle.getTop() - ((PdfRectangle)object2).bottom(), rectangle.getRight() - ((PdfRectangle)object2).right(), rectangle.getTop() - ((PdfRectangle)object2).top()));
                                    break;
                                }
                                case 270: {
                                    pdfAnnotation.put(PdfName.RECT, new PdfRectangle(((PdfRectangle)object2).bottom(), rectangle.getRight() - ((PdfRectangle)object2).left(), ((PdfRectangle)object2).top(), rectangle.getRight() - ((PdfRectangle)object2).right()));
                                }
                            }
                        }
                    }
                    if (pdfAnnotation.isUsed()) continue;
                    pdfAnnotation.setUsed();
                    PdfAnnotation pdfAnnotation3 = pdfAnnotation;
                    this.f.addToBody((PdfObject)pdfAnnotation3, pdfAnnotation3.getIndirectReference());
                }
                return;
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
    }

    protected static class RefKey {
        private int a;
        private int b;

        RefKey(PRIndirectReference pRIndirectReference) {
            this.a = pRIndirectReference.getNumber();
            this.b = pRIndirectReference.getGeneration();
        }

        public int hashCode() {
            return (this.b << 16) + this.a;
        }

        public boolean equals(Object object) {
            if (!(object instanceof RefKey)) {
                return false;
            }
            object = (RefKey)object;
            return this.b == ((RefKey)object).b && this.a == ((RefKey)object).a;
        }

        public String toString() {
            return Integer.toString(this.a) + ' ' + this.b;
        }
    }

    static final class a {
        PdfIndirectReference a;
        boolean b;

        a(PdfIndirectReference pdfIndirectReference) {
            this.a = pdfIndirectReference;
            this.b = false;
        }
    }
}

